/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNodeGen;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class TruffleStringConverterNode
extends ArgumentCastNode {
    private final String builtinName;

    public TruffleStringConverterNode(String builtinName) {
        this.builtinName = builtinName;
    }

    @Specialization
    static Object doString(TruffleString value) {
        return value;
    }

    @Specialization(guards={"!shouldUseDefaultValue(value)"}, replaces={"doString"})
    Object doOthers(Object value, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PRaiseNode raiseNode) {
        try {
            return castToStringNode.execute(inliningTarget, value);
        }
        catch (CannotCastException ex) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_S_NOT_P, this.builtinName, "str", value);
        }
    }

    protected boolean shouldUseDefaultValue(Object value) {
        return false;
    }

    @ClinicConverterFactory
    @NeverDefault
    public static TruffleStringConverterNode create(@ClinicConverterFactory.BuiltinName String builtinName) {
        return TruffleStringConverterNodeGen.create(builtinName);
    }
}

