/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ShardingDriverExtension;
import oracle.jdbc.driver.ShardingKeyInfo;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={OracleStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingStatement {
    protected OracleDataSource ods;
    protected Properties stmtProps;
    protected int userResultSetType = -1;
    protected int userResultSetConcur = -1;
    private String currentSQL;
    ConcurrentHashMap<String, SetterCallHistoryEntry> setterStmtMap = new ConcurrentHashMap();
    boolean closed;
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    int statementType = 0;
    boolean isCloseOnCompletion = false;
    AbstractShardingResultSet currentResultSet;
    static int NON_CACHED;
    boolean lastStatementExecutionOnDirectShard = false;
    Vector<String> m_batchItems = null;
    protected CallHistoryEntry head;
    protected CallHistoryEntry tail;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract Statement getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    void initialize(AbstractShardingConnection connection, @Blind(value=PropertiesBlinder.class) Properties stmtProps) throws SQLException {
        this.ods = new oracle.jdbc.pool.OracleDataSource();
        this.stmtProps = stmtProps;
        if (stmtProps != null) {
            String tProp = stmtProps.getProperty("result_set_type");
            if (tProp != null) {
                this.userResultSetType = Integer.parseInt(tProp);
            }
            if ((tProp = stmtProps.getProperty("result_set_concurrency")) != null) {
                this.userResultSetConcur = Integer.parseInt(tProp);
            }
        }
        this.currentSQL = null;
        this.closed = false;
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m2, Object receiver, Object ... args) {
        try {
            ((AbstractShardingConnection)this.getCreator()).acquireConnectionLock();
            this.ensureOpen();
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            this.closeDatabaseStatementWithSetterReplay();
            this.currentSQL = (String)args[0];
            OracleStatement databaseStatement = this.checkForKeyTokensAndGetUCPStatement(this.currentSQL);
            this.delegatesBeforeExecuteCalls(databaseStatement);
        }
        catch (SQLException ex) {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m2, ResultSet result) {
        try {
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            result = this.createResultSetProxy(result);
            this.currentResultSet = (AbstractShardingResultSet)((Object)result);
            this.setShardingKeyRpnTokens(databaseStatement, this.currentSQL);
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)databaseStatement.getConnection());
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m2, Object result) {
        try {
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            this.setShardingKeyRpnTokens(databaseStatement, this.currentSQL);
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)databaseStatement.getConnection());
            Object object = result;
            return object;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
    }

    @OnError(value=SQLException.class)
    protected Object onErrorStmt(Method m2, SQLException e2) throws SQLException {
        this.currentSQL = null;
        ((AbstractShardingConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw e2;
    }

    public void close() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.closeDatabaseStatementWithSetterReplay();
            this.purgeCallEntries();
            applicationConnection.removeStatement(this);
            this.closed = true;
        }
    }

    public void clearDefines() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearDefines();
            } else {
                Class[] argsType = new Class[]{};
                Object[] args = new Object[]{};
                CallHistoryEntry entry = new CallHistoryEntry("clearDefines", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int column_index, int type) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(column_index, type);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{column_index, type};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int typeCode, String typeName) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, typeCode, typeName);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
                Object[] args = new Object[]{ccolumnIndex, typeCode, typeName};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, type, lobPrefetchSize, formOfUse);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize, formOfUse};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnTypeBytes(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnTypeBytes(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnTypeBytes", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnTypeChars(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnTypeChars(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnTypeChars", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setDatabaseChangeRegistration(registration);
            } else {
                Class[] argsType = new Class[]{DatabaseChangeRegistration.class};
                Object[] args = new Object[]{registration};
                CallHistoryEntry entry = new CallHistoryEntry("setDatabaseChangeRegistration", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setSnapshotSCN(long scn) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setSnapshotSCN(scn);
            } else {
                Class[] argsType = new Class[]{Long.TYPE};
                Object[] args = new Object[]{scn};
                CallHistoryEntry entry = new CallHistoryEntry("setSnapshotSCN", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void registerBindChecksumListener(OracleStatement.BindChecksumListener listener) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.registerBindChecksumListener(listener);
            } else {
                Class[] argsType = new Class[]{OracleStatement.BindChecksumListener.class};
                Object[] args = new Object[]{listener};
                CallHistoryEntry entry = new CallHistoryEntry("registerBindChecksumListener", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setEscapeProcessing(enable);
            } else {
                Class[] argsType = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{enable};
                CallHistoryEntry entry = new CallHistoryEntry("setEscapeProcessing", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearWarnings();
            } else {
                Class[] argsType = new Class[]{};
                Object[] args = new Object[]{};
                CallHistoryEntry entry = new CallHistoryEntry("clearWarnings", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowPrefetch(int value) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setRowPrefetch";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{value};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setRowPrefetch(value);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getRowPrefetch();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("RowPrefetch", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getRowPrefetch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLobPrefetchSize(int value) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setLobPrefetchSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{value};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setLobPrefetchSize(value);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getLobPrefetchSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("LobPrefetchSize", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getLobPrefetchSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFetchDirection";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{direction};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFetchDirection(direction);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getFetchDirection();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FetchDirection", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getFetchDirection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFetchSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{rows};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFetchSize(rows);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getFetchSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FetchSize", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getFetchSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int max) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setQueryTimeout";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setQueryTimeout(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getQueryTimeout();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("QueryTimeout", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getQueryTimeout() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int max) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setMaxRows";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setMaxRows(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getMaxRows();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("MaxRows", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getMaxRows() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int max) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setMaxFieldSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setMaxFieldSize(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getMaxFieldSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("MaxFieldSize", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getMaxFieldSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedString(boolean fixedString) throws SQLException {
        block19: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block20: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFixedString";
                        Class[] argsType = new Class[]{Boolean.TYPE};
                        Object[] args = new Object[]{fixedString};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFixedString(fixedString);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Boolean originalVal = databaseStatement.getFixedString();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FixedString", entry);
                        }
                    }
                    if (!newStatement) break block19;
                    if (databaseStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean getFixedString() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeWithKey(String key) throws SQLException {
    }

    public int getcacheState() {
        return NON_CACHED;
    }

    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        return false;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m2, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.getCreator();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet result;
        block15: {
            result = null;
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
                if (databaseStatement != null) {
                    result = databaseStatement.getGeneratedKeys();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        if (this.currentResultSet == null) {
                            this.currentResultSet = (AbstractShardingResultSet)((Object)result);
                        }
                    }
                    break block15;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet result;
        block14: {
            result = null;
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
                if (databaseStatement != null) {
                    result = databaseStatement.getResultSet();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        this.currentResultSet = (AbstractShardingResultSet)((Object)result);
                    }
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public boolean getMoreResults() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getMoreResults();
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getMoreResults(current);
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean isNCHAR(int columnIndex) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.isNCHAR(columnIndex);
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String[] getRegisteredTableNames() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                String[] stringArray = databaseStatement.getRegisteredTableNames();
                return stringArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public long getRegisteredQueryId() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l2 = databaseStatement.getRegisteredQueryId();
                return l2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public int getUpdateCount() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                int n2 = databaseStatement.getUpdateCount();
                return n2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public long getQueryId() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l2 = databaseStatement.getQueryId();
                return l2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte[] getCompileKey() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte[] byArray = databaseStatement.getCompileKey();
                return byArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public long getChecksum() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l2 = databaseStatement.getChecksum();
                return l2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                OracleStatement.SqlKind sqlKind = databaseStatement.getSqlKind();
                return sqlKind;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                SQLWarning sQLWarning = databaseStatement.getWarnings();
                return sQLWarning;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.userResultSetConcur;
    }

    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.userResultSetType;
    }

    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    public int getstatementType() {
        return this.statementType;
    }

    public void cancel() throws SQLException {
        OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
        if (databaseStatement != null) {
            databaseStatement.cancel();
        }
    }

    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.isCloseOnCompletion = true;
    }

    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    public int sendBatch() throws SQLException {
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.ensureOpen();
            this.addBatchItem(sql);
        }
    }

    public void clearBatch() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearBatch();
            } else {
                this.clearBatchCritical();
            }
        }
    }

    /*
     * Loose catch block
     */
    public int[] executeBatch() throws SQLException {
        Object object;
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        OracleConnection databaseConnection = null;
        OracleStatement databaseStatement = null;
        Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();
        Throwable throwable = null;
        databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
        databaseStatement = this.createDatabaseStatement(databaseConnection);
        this.setDelegate(databaseStatement);
        if (this.m_batchItems != null) {
            object = this.m_batchItems.iterator();
            while (object.hasNext()) {
                String sql = (String)object.next();
                databaseStatement.addBatch(sql);
            }
        }
        object = databaseStatement.executeBatch();
        this.clearBatchItems();
        applicationConnection.closeDatabaseConnection(databaseConnection);
        return object;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    this.clearBatchItems();
                    applicationConnection.closeDatabaseConnection(databaseConnection);
                    throw throwable4;
                }
            }
        }
    }

    void closeDatabaseStatement() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Statement databaseStatement = this.getDelegate();
        if (databaseStatement != null && !databaseStatement.isClosed()) {
            OracleConnection databaseConnection = (OracleConnection)databaseStatement.getConnection();
            databaseStatement.close();
            applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
            this.setDelegate(null);
        }
    }

    void closeDatabaseStatementWithSetterReplay() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Statement databaseStatement = this.getDelegate();
        if (databaseStatement != null && !databaseStatement.isClosed()) {
            OracleConnection databaseConnection = (OracleConnection)databaseStatement.getConnection();
            this.delegatesStmtSetterCalls((OracleStatement)databaseStatement, false);
            databaseStatement.close();
            applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
            this.setDelegate(null);
        }
    }

    protected OracleConnection checkForKeyTokensAndGetUCPConnection(String sql) throws SQLException {
        OracleConnection databaseConnection = null;
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        if (applicationConnection.getStickyDatabaseConnection() != null) {
            databaseConnection = applicationConnection.getStickyDatabaseConnection();
        } else if (!applicationConnection.allowSingleShardTransaction() && !applicationConnection.getAutoCommit() && applicationConnection.inTransaction()) {
            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnectionWithSetterReplay();
            this.lastStatementExecutionOnDirectShard = false;
        } else {
            try {
                OracleShardingKey shardingKey = null;
                OracleShardingKey superShardingKey = null;
                OracleStatement.SqlKind sqlkind = OracleStatement.SqlKind.UNINITIALIZED;
                ShardingKeyInfo.KeyTokenInfo keyTokenInfo = ShardingKeyInfo.getKeyRpnTokens(sql, applicationConnection.gsmServiceName(), applicationConnection.userName(), applicationConnection.schemaName());
                if (keyTokenInfo != null) {
                    byte[] keyRpnTokens = keyTokenInfo.getKeyTokens();
                    sqlkind = keyTokenInfo.getSqlKind();
                    if (keyRpnTokens != null) {
                        OracleShardingKey[] shardingKeys = new ShardingKeyInfo().getShardingKeys((OracleStatement)((Object)this), keyRpnTokens, this.ods, ((AbstractShardingConnection)this.getCreator()).getDbCharSet());
                        shardingKey = shardingKeys[0];
                        superShardingKey = shardingKeys[1];
                    }
                }
                if (shardingKey != null && (applicationConnection.getAutoCommit() || sqlkind == OracleStatement.SqlKind.SELECT || applicationConnection.allowSingleShardTransaction())) {
                    databaseConnection = (OracleConnection)applicationConnection.getShardConnectionWithSetterReplay(shardingKey, superShardingKey);
                    this.lastStatementExecutionOnDirectShard = true;
                } else {
                    databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnectionWithSetterReplay();
                    this.lastStatementExecutionOnDirectShard = false;
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
        return databaseConnection;
    }

    private OracleStatement checkForKeyTokensAndGetUCPStatement(String sql) throws SQLException {
        OracleStatement databaseStatement = null;
        OracleConnection databaseConnection = this.checkForKeyTokensAndGetUCPConnection(sql);
        databaseStatement = this.createDatabaseStatement(databaseConnection);
        this.setDelegate(databaseStatement);
        return databaseStatement;
    }

    protected void setShardingKeyRpnTokens(OracleStatement databaseStatement, String sql) throws SQLException {
        byte[] shardingKeyRpnTokens = databaseStatement.getShardingKeyRpnTokens();
        if (shardingKeyRpnTokens != null) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            ShardingKeyInfo.putKeyRpnTokens(sql, applicationConnection.gsmServiceName(), applicationConnection.userName(), applicationConnection.schemaName(), shardingKeyRpnTokens, databaseStatement.getSqlKind());
            databaseStatement.setShardingKeyRpnTokens(null);
        }
    }

    protected void makeDatabaseConnectionSticky(AbstractShardingConnection appConnection, OracleConnection databaseConnection) throws SQLException {
        appConnection.makeDatabaseConnectionSticky(databaseConnection);
    }

    protected ResultSet createResultSetProxy(ResultSet rs) throws SQLException {
        return ShardingDriverExtension.PROXY_FACTORY.proxyForCreate(rs, this);
    }

    protected OracleStatement createDatabaseStatement(OracleConnection databaseConnection) throws SQLException {
        return (OracleStatement)databaseConnection.createStatement(this.userResultSetType, this.userResultSetConcur);
    }

    protected OracleStatement createDatabaseStatementWithReplay(OracleConnection databaseConnection) throws SQLException {
        OracleStatement databaseStatement = (OracleStatement)databaseConnection.createStatement(this.userResultSetType, this.userResultSetConcur);
        if (databaseStatement != null) {
            this.delegatesStmtSetterCalls(databaseStatement, true);
        }
        return databaseStatement;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.getCreator();
    }

    final void ensureOpen() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        if (applicationConnection.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    void addBatchItem(String sql) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(sql);
    }

    void clearBatchCritical() throws SQLException {
        this.ensureOpen();
        this.clearBatchItems();
    }

    void clearBatchItems() {
        if (this.m_batchItems != null) {
            this.m_batchItems.removeAllElements();
        }
    }

    protected void appendCallEntry(CallHistoryEntry entry) {
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
    }

    protected void removeCallEntry(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
    }

    protected void purgeCallEntries() {
        this.head = null;
        this.tail = null;
        this.setterStmtMap = null;
    }

    void delegatesBeforeExecuteCalls(OracleStatement databaseStatement) throws SQLException {
        try {
            CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                Method m2 = databaseStatement.getClass().getMethod(entry.methodName, entry.argsType);
                m2.invoke((Object)databaseStatement, entry.args);
                entry = entry.nextEntry;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    void delegatesStmtSetterCalls(OracleStatement databaseStatement, boolean newVal) throws SQLException {
        try {
            for (SetterCallHistoryEntry entry : this.setterStmtMap.values()) {
                CallHistoryEntry callEntry = entry.callHistoryEnrty;
                Method m2 = databaseStatement.getClass().getMethod(callEntry.methodName, callEntry.argsType);
                if (newVal) {
                    m2.invoke((Object)databaseStatement, callEntry.args);
                    continue;
                }
                m2.invoke((Object)databaseStatement, entry.originalValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    boolean closeByDependent(OracleConnection databaseConnection) throws SQLException {
        if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
            Statement databaseStatement = this.getDelegate();
            if (databaseStatement != null && !databaseStatement.isClosed()) {
                this.close();
            } else {
                AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
                applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
                this.setDelegate(null);
                this.purgeCallEntries();
                applicationConnection.removeStatement(this);
                this.closed = true;
            }
            return true;
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$87 = AbstractShardingStatement.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = AbstractShardingStatement.class.getDeclaredMethod("closeByDependent", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = AbstractShardingStatement.class.getDeclaredMethod("delegatesStmtSetterCalls", OracleStatement.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = AbstractShardingStatement.class.getDeclaredMethod("delegatesBeforeExecuteCalls", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = AbstractShardingStatement.class.getDeclaredMethod("purgeCallEntries", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = AbstractShardingStatement.class.getDeclaredMethod("removeCallEntry", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = AbstractShardingStatement.class.getDeclaredMethod("appendCallEntry", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = AbstractShardingStatement.class.getDeclaredMethod("clearBatchItems", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = AbstractShardingStatement.class.getDeclaredMethod("clearBatchCritical", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = AbstractShardingStatement.class.getDeclaredMethod("addBatchItem", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = AbstractShardingStatement.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = AbstractShardingStatement.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = AbstractShardingStatement.class.getDeclaredMethod("createDatabaseStatementWithReplay", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = AbstractShardingStatement.class.getDeclaredMethod("createDatabaseStatement", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = AbstractShardingStatement.class.getDeclaredMethod("createResultSetProxy", ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = AbstractShardingStatement.class.getDeclaredMethod("makeDatabaseConnectionSticky", AbstractShardingConnection.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = AbstractShardingStatement.class.getDeclaredMethod("setShardingKeyRpnTokens", OracleStatement.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = AbstractShardingStatement.class.getDeclaredMethod("checkForKeyTokensAndGetUCPStatement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = AbstractShardingStatement.class.getDeclaredMethod("checkForKeyTokensAndGetUCPConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = AbstractShardingStatement.class.getDeclaredMethod("closeDatabaseStatementWithSetterReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = AbstractShardingStatement.class.getDeclaredMethod("closeDatabaseStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = AbstractShardingStatement.class.getDeclaredMethod("executeBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = AbstractShardingStatement.class.getDeclaredMethod("clearBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = AbstractShardingStatement.class.getDeclaredMethod("addBatch", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = AbstractShardingStatement.class.getDeclaredMethod("sendBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = AbstractShardingStatement.class.getDeclaredMethod("isCloseOnCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = AbstractShardingStatement.class.getDeclaredMethod("closeOnCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = AbstractShardingStatement.class.getDeclaredMethod("cancel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = AbstractShardingStatement.class.getDeclaredMethod("getstatementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = AbstractShardingStatement.class.getDeclaredMethod("getResultSetHoldability", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = AbstractShardingStatement.class.getDeclaredMethod("getResultSetType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = AbstractShardingStatement.class.getDeclaredMethod("getResultSetConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = AbstractShardingStatement.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = AbstractShardingStatement.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = AbstractShardingStatement.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = AbstractShardingStatement.class.getDeclaredMethod("getWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = AbstractShardingStatement.class.getDeclaredMethod("getSqlKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = AbstractShardingStatement.class.getDeclaredMethod("getChecksum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = AbstractShardingStatement.class.getDeclaredMethod("getCompileKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = AbstractShardingStatement.class.getDeclaredMethod("getQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = AbstractShardingStatement.class.getDeclaredMethod("getUpdateCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = AbstractShardingStatement.class.getDeclaredMethod("getRegisteredQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = AbstractShardingStatement.class.getDeclaredMethod("getRegisteredTableNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = AbstractShardingStatement.class.getDeclaredMethod("isNCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = AbstractShardingStatement.class.getDeclaredMethod("getMoreResults", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = AbstractShardingStatement.class.getDeclaredMethod("getMoreResults", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = AbstractShardingStatement.class.getDeclaredMethod("getResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = AbstractShardingStatement.class.getDeclaredMethod("getGeneratedKeys", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = AbstractShardingStatement.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = AbstractShardingStatement.class.getDeclaredMethod("preUnsupportedStatementMethods", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = AbstractShardingStatement.class.getDeclaredMethod("setPoolable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = AbstractShardingStatement.class.getDeclaredMethod("isPoolable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = AbstractShardingStatement.class.getDeclaredMethod("getcacheState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = AbstractShardingStatement.class.getDeclaredMethod("closeWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = AbstractShardingStatement.class.getDeclaredMethod("getFixedString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = AbstractShardingStatement.class.getDeclaredMethod("setFixedString", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = AbstractShardingStatement.class.getDeclaredMethod("getMaxFieldSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = AbstractShardingStatement.class.getDeclaredMethod("setMaxFieldSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = AbstractShardingStatement.class.getDeclaredMethod("getMaxRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = AbstractShardingStatement.class.getDeclaredMethod("setMaxRows", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = AbstractShardingStatement.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = AbstractShardingStatement.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AbstractShardingStatement.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AbstractShardingStatement.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AbstractShardingStatement.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AbstractShardingStatement.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AbstractShardingStatement.class.getDeclaredMethod("getLobPrefetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AbstractShardingStatement.class.getDeclaredMethod("setLobPrefetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AbstractShardingStatement.class.getDeclaredMethod("getRowPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AbstractShardingStatement.class.getDeclaredMethod("setRowPrefetch", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AbstractShardingStatement.class.getDeclaredMethod("clearWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AbstractShardingStatement.class.getDeclaredMethod("setEscapeProcessing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AbstractShardingStatement.class.getDeclaredMethod("registerBindChecksumListener", OracleStatement.BindChecksumListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AbstractShardingStatement.class.getDeclaredMethod("setSnapshotSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AbstractShardingStatement.class.getDeclaredMethod("setDatabaseChangeRegistration", DatabaseChangeRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnTypeChars", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnTypeBytes", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AbstractShardingStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AbstractShardingStatement.class.getDeclaredMethod("clearDefines", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AbstractShardingStatement.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AbstractShardingStatement.class.getDeclaredMethod("onErrorStmt", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AbstractShardingStatement.class.getDeclaredMethod("postStmtExecuteUpdate", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AbstractShardingStatement.class.getDeclaredMethod("postStmtExecuteQuery", Method.class, ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AbstractShardingStatement.class.getDeclaredMethod("preStmtExecuteQuery", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AbstractShardingStatement.class.getDeclaredMethod("initialize", AbstractShardingConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NON_CACHED = 3;
    }

    static class SetterCallHistoryEntry {
        CallHistoryEntry callHistoryEnrty;
        Object originalValue;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        SetterCallHistoryEntry(Object originalValue, String methodName, Class<?>[] argsType, Object[] args) {
            this.originalValue = originalValue;
            this.callHistoryEnrty = new CallHistoryEntry(methodName, argsType, args);
        }

        static {
            try {
                $$$methodRef$$$0 = SetterCallHistoryEntry.class.getDeclaredConstructor(Object.class, String.class, Class[].class, Object[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    static class CallHistoryEntry {
        String methodName;
        Class<?>[] argsType;
        Object[] args;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(String methodName, Class<?>[] argsType, Object[] args) {
            this.methodName = methodName;
            this.argsType = argsType;
            this.args = args;
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(String.class, Class[].class, Object[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

