/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.bean;

import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.NameTransformer;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase delegate, SettableBeanProperty[] ordered) {
        super(delegate);
        this._delegate = delegate;
        this._orderedProperties = ordered;
    }

    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer unwrapper) {
        return this._delegate.unwrappingDeserializer(ctxt, unwrapper);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(oir), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BeanAsArrayDeserializer(this._delegate.withByNameInclusion(ignorableProps, includableProps), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnoreAllUnknown(ignoreUnknown), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BeanAsArrayDeserializer(this._delegate.withBeanProperties(props), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    protected void initNameMatcher(DeserializationContext ctxt) {
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        SettableBeanProperty prop;
        if (!p.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(p, ctxt);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (i + 3 < propCount) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            prop = props[i];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            prop = props[i + 1];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            prop = props[i + 2];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            prop = props[i + 3];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            i += 4;
        }
        switch (propCount - i) {
            case 3: {
                if (p.nextToken() == JsonToken.END_ARRAY) {
                    return bean;
                }
                if ((prop = props[i++]) != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                } else {
                    p.skipChildren();
                }
            }
            case 2: {
                if (p.nextToken() == JsonToken.END_ARRAY) {
                    return bean;
                }
                if ((prop = props[i++]) != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                } else {
                    p.skipChildren();
                }
            }
            case 1: {
                if (p.nextToken() == JsonToken.END_ARRAY) {
                    return bean;
                }
                prop = props[i];
                if (prop != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                    break;
                }
                p.skipChildren();
            }
        }
        if (p.nextToken() != JsonToken.END_ARRAY) {
            if (!this._ignoreAllUnknown && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
            }
            do {
                p.skipChildren();
            } while (p.nextToken() != JsonToken.END_ARRAY);
        }
        return bean;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        p.assignCurrentValue(bean);
        if (!p.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(p, ctxt);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props[i];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            ++i;
        }
        if (!this._ignoreAllUnknown && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p.skipChildren();
        } while (p.nextToken() != JsonToken.END_ARRAY);
        return bean;
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._deserializeFromNonArray(p, ctxt);
    }

    protected Object _deserializeNonVanilla(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props[i];
            ++i;
            if (prop != null && (activeView == null || prop.visibleInView(activeView))) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            }
            p.skipChildren();
        }
        if (!this._ignoreAllUnknown && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p.skipChildren();
        } while (p.nextToken() != JsonToken.END_ARRAY);
        return bean;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Class<?> activeView;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        SettableBeanProperty[] props = this._orderedProperties;
        int propCount = props.length;
        int i = 0;
        Object bean = null;
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            SettableBeanProperty prop;
            SettableBeanProperty settableBeanProperty = prop = i < propCount ? props[i] : null;
            if (prop == null) {
                p.skipChildren();
            } else if (activeView != null && !prop.visibleInView(activeView)) {
                p.skipChildren();
            } else {
                if (bean != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
                String propName = prop.getName();
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (!buffer.readIdProperty(propName) || creatorProp != null) {
                    if (creatorProp != null) {
                        if (creatorProp.isInjectionOnly()) {
                            p.skipChildren();
                        } else if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                            try {
                                bean = creator.build(ctxt, buffer);
                            }
                            catch (Exception e) {
                                throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                            }
                            p.assignCurrentValue(bean);
                            if (bean.getClass() != this._beanType.getRawClass()) {
                                ctxt.reportBadDefinition(this._beanType, String.format("Cannot support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", ClassUtil.getTypeDescription(this._beanType), ClassUtil.getClassDescription(bean)));
                            }
                        }
                    } else {
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    }
                }
            }
            ++i;
        }
        if (bean == null) {
            try {
                bean = creator.build(ctxt, buffer);
            }
            catch (Exception e) {
                return this.wrapInstantiationProblem(ctxt, e);
            }
        }
        return bean;
    }

    protected Object _deserializeFromNonArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p.currentToken(), p, "Cannot deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array", ClassUtil.getTypeDescription(this._beanType), p.currentToken());
    }
}

