/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.api.NativePointerLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativePointerLibrary.class, useForAOT=true, useForAOTPriority=1)})
final class NFIPointer
implements TruffleObject {
    final long raw;
    private static final NFIPointer NULL = new NFIPointer(0L);

    public static NFIPointer nullPtr() {
        return NULL;
    }

    public static NFIPointer create(long raw) {
        return new NFIPointer(raw);
    }

    private NFIPointer(long raw) {
        this.raw = raw;
    }

    @ExportMessage
    boolean isNull() {
        return this.raw == 0L;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.raw;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String toDisplayString(boolean allowSideEffects) {
        if (this.isNull()) {
            return "NULL";
        }
        return String.format("0x%08x", this.raw);
    }
}

