/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ResourceModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="resource")
public final class ResourceModuleBuiltins
extends PythonBuiltins {
    static int RLIMIT_CPU = 0;
    static int RLIMIT_FSIZE = 1;
    static int RLIMIT_DATA = 2;
    static int RLIMIT_STACK = 3;
    static int RLIMIT_CORE = 4;
    static int RLIMIT_AS = 5;
    static int RLIMIT_RSS = 5;
    static int RLIMIT_MEMLOCK = 6;
    static int RLIMIT_NPROC = 7;
    static int RLIMIT_NOFILE = 8;
    static long RLIM_INFINITY = Long.MAX_VALUE;
    static final StructSequence.BuiltinTypeDescriptor STRUCT_RUSAGE_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStructRusage, 16, new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"}, new String[]{"user time used", "system time used", "max. resident set size", "shared memory size", "unshared data size", "unshared stack size", "page faults not requiring I/O", "page faults requiring I/O", "number of swap outs", "block input operations", "block output operations", "IPC messages sent", "IPC messages received", "signals received", "voluntary context switches", "involuntary context switches"});

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ResourceModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("error", (Object)PythonBuiltinClassType.OSError);
        if (PosixConstants.RUSAGE_CHILDREN.defined) {
            this.addBuiltinConstant("RUSAGE_CHILDREN", (Object)PosixConstants.RUSAGE_CHILDREN.getValueIfDefined());
        }
        this.addBuiltinConstant("RUSAGE_SELF", (Object)PosixConstants.RUSAGE_SELF.value);
        if (PosixConstants.RUSAGE_THREAD.defined) {
            this.addBuiltinConstant("RUSAGE_THREAD", (Object)PosixConstants.RUSAGE_THREAD.getValueIfDefined());
        }
        this.addBuiltinConstant("RLIMIT_CPU", (Object)RLIMIT_CPU);
        this.addBuiltinConstant("RLIMIT_FSIZE", (Object)RLIMIT_FSIZE);
        this.addBuiltinConstant("RLIMIT_DATA", (Object)RLIMIT_DATA);
        this.addBuiltinConstant("RLIMIT_STACK", (Object)RLIMIT_STACK);
        this.addBuiltinConstant("RLIMIT_CORE", (Object)RLIMIT_CORE);
        this.addBuiltinConstant("RLIMIT_AS", (Object)RLIMIT_AS);
        this.addBuiltinConstant("RLIMIT_RSS", (Object)RLIMIT_RSS);
        this.addBuiltinConstant("RLIMIT_MEMLOCK", (Object)RLIMIT_MEMLOCK);
        this.addBuiltinConstant("RLIMIT_NPROC", (Object)RLIMIT_NPROC);
        this.addBuiltinConstant("RLIMIT_NOFILE", (Object)RLIMIT_NOFILE);
        this.addBuiltinConstant("RLIM_INFINITY", (Object)RLIM_INFINITY);
        StructSequence.initType(core, STRUCT_RUSAGE_DESC);
    }

    @Builtin(name="getrlimit", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetRLimitNode
    extends PythonBuiltinNode {
        GetRLimitNode() {
        }

        @Specialization
        static PTuple getPageSize(int which, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, new Object[]{RLIM_INFINITY, RLIM_INFINITY});
        }
    }

    @Builtin(name="getpagesize", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetPageSizeNode
    extends PythonBuiltinNode {
        GetPageSizeNode() {
        }

        @Specialization
        static int getPageSize() {
            return 4096;
        }
    }

    @Builtin(name="getrusage", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={ResourceModuleBuiltins.class})
    static abstract class GetRuUsageNode
    extends PythonBuiltinNode {
        GetRuUsageNode() {
        }

        @Specialization
        static PTuple getruusage(VirtualFrame frame, int who, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            PosixSupportLibrary.RusageResult rusage;
            PosixSupport posixSupport = context.getPosixSupport();
            try {
                rusage = posixLib.getrusage(posixSupport, who);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EINVAL.getNumber()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.RUSAGE_INVALID_WHO);
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PFactory.createStructSeq(context.getLanguage(inliningTarget), STRUCT_RUSAGE_DESC, rusage.ru_utime(), rusage.ru_stime(), rusage.ru_maxrss(), rusage.ru_ixrss(), rusage.ru_idrss(), rusage.ru_isrss(), rusage.ru_minflt(), rusage.ru_majflt(), rusage.ru_nswap(), rusage.ru_inblock(), rusage.ru_oublock(), rusage.ru_msgsnd(), rusage.ru_msgrcv(), rusage.ru_nsignals(), rusage.ru_nvcsw(), rusage.ru_nivcsw());
        }
    }
}

