/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstImportedNameDefiner;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstTargetExpression;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstImportElement
extends PyAstElement,
PyAstImportedNameDefiner {
    @Nullable
    default public String getName() {
        return this.getVisibleName();
    }

    @Nullable
    default public PyAstReferenceExpression getImportReferenceExpression() {
        ASTNode node = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens());
        return node == null ? null : (PyAstReferenceExpression)node.getPsi();
    }

    @Nullable
    default public QualifiedName getImportedQName() {
        PyAstReferenceExpression importReference = this.getImportReferenceExpression();
        return importReference != null ? importReference.asQualifiedName() : null;
    }

    @Nullable
    default public PyAstTargetExpression getAsNameElement() {
        return (PyAstTargetExpression)PyAstElementKt.findChildByType((PsiElement)this, PyElementTypes.TARGET_EXPRESSION);
    }

    @Nullable
    default public String getAsName() {
        PyAstTargetExpression element = this.getAsNameElement();
        return element != null ? element.getName() : null;
    }

    @Nullable
    default public String getVisibleName() {
        PyAstTargetExpression asNameElement = this.getAsNameElement();
        if (asNameElement != null) {
            return asNameElement.getName();
        }
        QualifiedName importedName = this.getImportedQName();
        if (importedName != null && importedName.getComponentCount() > 0) {
            return (String)importedName.getComponents().get(0);
        }
        return null;
    }

    default public PyAstStatement getContainingImportStatement() {
        PsiElement parent = this.getParent();
        return parent instanceof PyAstStatement ? (PyAstStatement)parent : null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyImportElement(this);
    }
}

