/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.MultiRoutingWatchServiceDelegate;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiRoutingFileSystem
extends DelegatingFileSystem<MultiRoutingFileSystemProvider> {
    private final MultiRoutingFileSystemProvider myProvider;
    private final FileSystem myLocalFS;
    private static final BiFunction<@NotNull FileSystem, @NotNull String, @NotNull FileSystem> NO_OP_COMPUTE_FN = (localFS, path) -> localFS;
    @NotNull
    private volatile @NotNull BiFunction<@NotNull FileSystem, @NotNull String, @NotNull FileSystem> myComputeFn = NO_OP_COMPUTE_FN;
    public static final Function<@NotNull FileSystem, @NotNull Collection<@NotNull Path>> NO_OP_GET_CUSTOM_ROOT_PATH = ignored -> Collections.emptyList();
    @NotNull
    private volatile @NotNull Function<@NotNull FileSystem, @NotNull Collection<@NotNull Path>> myGetCustomRootsFn = NO_OP_GET_CUSTOM_ROOT_PATH;
    public static final Function<@NotNull FileSystem, @NotNull Collection<@NotNull FileStore>> NO_OP_GET_CUSTOM_FILE_STORES_FN = ignored -> Collections.emptyList();
    @NotNull
    private volatile @NotNull Function<@NotNull FileSystem, @NotNull Collection<@NotNull FileStore>> myGetCustomFileStoresFn = NO_OP_GET_CUSTOM_FILE_STORES_FN;

    public MultiRoutingFileSystem(MultiRoutingFileSystemProvider provider, FileSystem localFS) {
        this.myProvider = provider;
        this.myLocalFS = localFS;
    }

    public void setBackendProvider(@Nullable BiFunction<@NotNull FileSystem, @NotNull String, @NotNull FileSystem> computeFn, @Nullable Function<@NotNull FileSystem, @NotNull Collection<@NotNull Path>> getCustomRootsFn, @Nullable Function<@NotNull FileSystem, @NotNull Collection<@NotNull FileStore>> getCustomFileStoresFn) {
        this.myComputeFn = computeFn != null ? computeFn : NO_OP_COMPUTE_FN;
        this.myGetCustomRootsFn = getCustomRootsFn != null ? getCustomRootsFn : NO_OP_GET_CUSTOM_ROOT_PATH;
        this.myGetCustomFileStoresFn = getCustomFileStoresFn != null ? getCustomFileStoresFn : NO_OP_GET_CUSTOM_FILE_STORES_FN;
    }

    @Override
    @NotNull
    public MultiRoutingFileSystemProvider provider() {
        MultiRoutingFileSystemProvider multiRoutingFileSystemProvider = this.myProvider;
        if (multiRoutingFileSystemProvider == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(0);
        }
        return multiRoutingFileSystemProvider;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate() {
        FileSystem fileSystem = this.myLocalFS;
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(1);
        }
        return fileSystem;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate(@NotNull String root) {
        FileSystem result;
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(2);
        }
        if (MultiRoutingFileSystemProvider.ourForceDefaultFs) {
            FileSystem fileSystem = this.myLocalFS;
            if (fileSystem == null) {
                MultiRoutingFileSystem.$$$reportNull$$$0(3);
            }
            return fileSystem;
        }
        FileSystem fileSystem = result = this.getBackend(root);
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(4);
        }
        return fileSystem;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        LinkedHashMap<String, MultiRoutingFsPath> rootDirectories = new LinkedHashMap<String, MultiRoutingFsPath>();
        for (Path root : this.myLocalFS.getRootDirectories()) {
            rootDirectories.put(root.toString(), new MultiRoutingFsPath(this, root));
        }
        for (Path root : this.myGetCustomRootsFn.apply(this.myLocalFS)) {
            rootDirectories.put(root.toString(), new MultiRoutingFsPath(this, root));
        }
        return rootDirectories.values();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        LinkedHashSet<FileStore> result = new LinkedHashSet<FileStore>();
        for (FileStore fileStore : this.myLocalFS.getFileStores()) {
            result.add(fileStore);
        }
        result.addAll(this.myGetCustomFileStoresFn.apply(this.myLocalFS));
        return result;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.myLocalFS.supportedFileAttributeViews();
    }

    @NotNull
    public FileSystem getBackend(@NotNull String path) {
        if (path == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(5);
        }
        FileSystem fileSystem = this.myComputeFn.apply(this.myLocalFS, MultiRoutingFileSystem.sanitizeRoot(path));
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(6);
        }
        return fileSystem;
    }

    public boolean isRoutable(@NotNull Path path) {
        Path root;
        if (path == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(7);
        }
        if ((root = path.getRoot()) == null) {
            return false;
        }
        return this.getBackend(root.toString()) != this.myLocalFS;
    }

    @NotNull
    public static String sanitizeRoot(@NotNull String root) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(8);
        }
        root = root.replace(File.separatorChar, '/');
        String string = root = root.substring(0, MultiRoutingFileSystem.trimEndSlashes(root));
        if (string == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static int trimEndSlashes(@NotNull String root) {
        int i;
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(10);
        }
        for (i = root.length() - 1; i >= 0 && root.charAt(i) == '/'; --i) {
        }
        return i + 1;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new MultiRoutingWatchServiceDelegate(super.newWatchService(), this.myProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 7, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "provider";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackend";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBackend";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRoutable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trimEndSlashes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5, 7, 8, 10 -> new IllegalArgumentException(string);
        };
    }
}

