/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.VerticalBox;

public class BigOperatorAtom
extends Atom {
    private Atom under = null;
    private Atom over = null;
    protected Atom base = null;
    private boolean limitsSet = false;
    private boolean limits = false;

    public BigOperatorAtom(Atom base, Atom under, Atom over) {
        this.base = base;
        this.under = under;
        this.over = over;
        this.type = 1;
    }

    public BigOperatorAtom(Atom base, Atom under, Atom over, boolean limits) {
        this(base, under, over);
        this.limits = limits;
        this.limitsSet = true;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        float delta;
        Box y;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        RowAtom bbase = null;
        Atom Base = this.base;
        if (this.base instanceof TypedAtom) {
            Atom at = ((TypedAtom)this.base).getBase();
            if (at instanceof RowAtom && ((RowAtom)at).lookAtLastAtom && this.base.type_limits != 2) {
                this.base = ((RowAtom)at).getLastAtom();
                bbase = (RowAtom)at;
            } else {
                this.base = at;
            }
        }
        if (this.limitsSet && !this.limits || !this.limitsSet && style >= 2 || this.base.type_limits == 1 || this.base.type_limits == 0 && style >= 2) {
            if (bbase != null) {
                bbase.add(new ScriptsAtom(this.base, this.under, this.over));
                Box b = bbase.createBox(env);
                bbase.getLastAtom();
                bbase.add(this.base);
                this.base = Base;
                return b;
            }
            return new ScriptsAtom(this.base, this.under, this.over).createBox(env);
        }
        if (this.base instanceof SymbolAtom && this.base.type == 1) {
            Char c = tf.getChar(((SymbolAtom)this.base).getName(), style);
            y = this.base.createBox(env);
            delta = c.getItalic();
        } else {
            delta = 0.0f;
            y = new HorizontalBox(this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(env));
        }
        Box x = null;
        Box z = null;
        if (this.over != null) {
            x = this.over.createBox(env.supStyle());
        }
        if (this.under != null) {
            z = this.under.createBox(env.subStyle());
        }
        float maxWidth = Math.max(Math.max(x == null ? 0.0f : x.getWidth(), y.getWidth()), z == null ? 0.0f : z.getWidth());
        x = BigOperatorAtom.changeWidth(x, maxWidth);
        y = BigOperatorAtom.changeWidth(y, maxWidth);
        z = BigOperatorAtom.changeWidth(z, maxWidth);
        VerticalBox vBox = new VerticalBox();
        float bigop5 = tf.getBigOpSpacing5(style);
        float kern = 0.0f;
        float xh = 0.0f;
        if (this.over != null) {
            vBox.add(new StrutBox(0.0f, bigop5, 0.0f, 0.0f));
            x.setShift(delta / 2.0f);
            vBox.add(x);
            kern = Math.max(tf.getBigOpSpacing1(style), tf.getBigOpSpacing3(style) - x.getDepth());
            vBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
            xh = vBox.getHeight() + vBox.getDepth();
        }
        vBox.add(y);
        if (this.under != null) {
            float k = Math.max(tf.getBigOpSpacing2(style), tf.getBigOpSpacing4(style) - z.getHeight());
            vBox.add(new StrutBox(0.0f, k, 0.0f, 0.0f));
            z.setShift(-delta / 2.0f);
            vBox.add(z);
            vBox.add(new StrutBox(0.0f, bigop5, 0.0f, 0.0f));
        }
        float h = y.getHeight();
        float total = vBox.getHeight() + vBox.getDepth();
        if (x != null) {
            h += bigop5 + kern + x.getHeight() + x.getDepth();
        }
        vBox.setHeight(h);
        vBox.setDepth(total - h);
        if (bbase != null) {
            HorizontalBox hb = new HorizontalBox(bbase.createBox(env));
            bbase.add(this.base);
            hb.add(vBox);
            this.base = Base;
            return hb;
        }
        return vBox;
    }

    private static Box changeWidth(Box b, float maxWidth) {
        if (b != null && Math.abs(maxWidth - b.getWidth()) > 1.0E-7f) {
            return new HorizontalBox(b, maxWidth, 2);
        }
        return b;
    }
}

