/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.lcov;

import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LcovCoverageReport {
    private final Map<String, List<LineHits>> myInfo = new HashMap<String, List<LineHits>>();

    @NotNull
    public Map<String, List<LineHits>> getInfo() {
        Map<String, List<LineHits>> map = this.myInfo;
        if (map == null) {
            LcovCoverageReport.$$$reportNull$$$0(0);
        }
        return map;
    }

    public void mergeFileReport(@NotNull String filePath, @NotNull List<LineHits> report) {
        if (filePath == null) {
            LcovCoverageReport.$$$reportNull$$$0(1);
        }
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(2);
        }
        LcovCoverageReport.normalizeLineHitsList(report);
        List<LineHits> result = report;
        List<LineHits> old = this.myInfo.get(filePath);
        if (old != null) {
            result = LcovCoverageReport.doMerge(old, report);
        }
        this.myInfo.put(filePath, result);
    }

    @NotNull
    private static List<LineHits> doMerge(@NotNull List<LineHits> aList, @NotNull List<LineHits> bList) {
        if (aList == null) {
            LcovCoverageReport.$$$reportNull$$$0(3);
        }
        if (bList == null) {
            LcovCoverageReport.$$$reportNull$$$0(4);
        }
        PeekableIteratorWrapper ai = new PeekableIteratorWrapper(aList.iterator());
        PeekableIteratorWrapper bi = new PeekableIteratorWrapper(bList.iterator());
        ArrayList<LineHits> out = new ArrayList<LineHits>();
        while (ai.hasNext() && bi.hasNext()) {
            LineHits x;
            LineHits a = (LineHits)ai.peek();
            LineHits b = (LineHits)bi.peek();
            if (a.getLineNumber() < b.getLineNumber()) {
                x = (LineHits)ai.next();
            } else if (a.getLineNumber() > b.getLineNumber()) {
                x = (LineHits)bi.next();
            } else {
                a.addHits(b.getHits());
                x = a;
                ai.next();
                bi.next();
            }
            out.add(x);
        }
        LcovCoverageReport.addRestItems(out, ai);
        LcovCoverageReport.addRestItems(out, bi);
        ArrayList<LineHits> arrayList = out;
        if (arrayList == null) {
            LcovCoverageReport.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static <T> void addRestItems(@NotNull List<T> out, Iterator<T> iterator) {
        if (out == null) {
            LcovCoverageReport.$$$reportNull$$$0(6);
        }
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
    }

    private static void normalizeLineHitsList(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            LcovCoverageReport.$$$reportNull$$$0(7);
        }
        LcovCoverageReport.makeSortedByLineNumber(lineHitsList);
        LcovCoverageReport.makeUniqueByLineNumber(lineHitsList);
    }

    private static void makeSortedByLineNumber(@NotNull List<LineHits> report) {
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(8);
        }
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() > cur.getLineNumber()) {
                Collections.sort(report);
                return;
            }
            prev = cur;
        }
    }

    private static void makeUniqueByLineNumber(@NotNull List<LineHits> report) {
        boolean unique;
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(9);
        }
        if (unique = LcovCoverageReport.checkForLineUniqueness(report)) {
            return;
        }
        ArrayList<LineHits> out = new ArrayList<LineHits>(report.size());
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                prev.addHits(cur.getHits());
                continue;
            }
            out.add(cur);
            prev = cur;
        }
        report.clear();
        report.addAll(out);
    }

    private static boolean checkForLineUniqueness(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            LcovCoverageReport.$$$reportNull$$$0(10);
        }
        LineHits prev = null;
        for (LineHits cur : lineHitsList) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                return false;
            }
            prev = cur;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/lcov/LcovCoverageReport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineHitsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/lcov/LcovCoverageReport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doMerge";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mergeFileReport";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRestItems";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalizeLineHitsList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeSortedByLineNumber";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeUniqueByLineNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkForLineUniqueness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    public static class LineHits
    implements Comparable<LineHits> {
        private final int myLineNumber;
        private final String myFunctionName;
        private int myHits;

        public LineHits(int lineNumber, int hits, String functionName) {
            this.myLineNumber = lineNumber;
            this.myHits = hits;
            this.myFunctionName = functionName;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getHits() {
            return this.myHits;
        }

        public String getFunctionName() {
            return this.myFunctionName;
        }

        @Override
        public int compareTo(LineHits o) {
            return this.myLineNumber - o.myLineNumber;
        }

        public void addHits(int hitCount) {
            this.myHits += hitCount;
        }

        public String toString() {
            return "{line=" + this.myLineNumber + ", hits=" + this.myHits + ", method='" + this.myFunctionName + "'}";
        }
    }
}

