/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.text

/**
 * Defines names for Unicode symbols used in proper Typography.
 */
public object Typography {
    /** The character &#x22; – quotation mark */
    public const val quote: Char = '\u0022'
    /** The character &#x24; – dollar sign */
    public const val dollar: Char = '\u0024'
    /** The character &#x26; – ampersand */
    public const val amp: Char = '\u0026'
    /** The character &#x3C; – less-than sign */
    public const val less: Char = '\u003C'
    /** The character &#x3E; – greater-than sign */
    public const val greater: Char = '\u003E'
    /** The non-breaking space character */
    public const val nbsp: Char = '\u00A0'
    /** The character &#xD7; */
    public const val times: Char = '\u00D7'
    /** The character &#xA2; */
    public const val cent: Char = '\u00A2'
    /** The character &#xA3; */
    public const val pound: Char = '\u00A3'
    /** The character &#xA7; */
    public const val section: Char = '\u00A7'
    /** The character &#xA9; */
    public const val copyright: Char = '\u00A9'
    /** The character &#xAB; */
    @SinceKotlin("1.6")
    public const val leftGuillemet: Char = '\u00AB'
    /** The character &#xBB; */
    @SinceKotlin("1.6")
    public const val rightGuillemet: Char = '\u00BB'
    /** The character &#xAE; */
    public const val registered: Char = '\u00AE'
    /** The character &#xB0; */
    public const val degree: Char = '\u00B0'
    /** The character &#xB1; */
    public const val plusMinus: Char = '\u00B1'
    /** The character &#xB6; */
    public const val paragraph: Char = '\u00B6'
    /** The character &#xB7; */
    public const val middleDot: Char = '\u00B7'
    /** The character &#xBD; */
    public const val half: Char = '\u00BD'
    /** The character &#x2013; */
    public const val ndash: Char = '\u2013'
    /** The character &#x2014; */
    public const val mdash: Char = '\u2014'
    /** The character &#x2018; */
    public const val leftSingleQuote: Char = '\u2018'
    /** The character &#x2019; */
    public const val rightSingleQuote: Char = '\u2019'
    /** The character &#x201A; */
    public const val lowSingleQuote: Char = '\u201A'
    /** The character &#x201C; */
    public const val leftDoubleQuote: Char = '\u201C'
    /** The character &#x201D; */
    public const val rightDoubleQuote: Char = '\u201D'
    /** The character &#x201E; */
    public const val lowDoubleQuote: Char = '\u201E'
    /** The character &#x2020; */
    public const val dagger: Char = '\u2020'
    /** The character &#x2021; */
    public const val doubleDagger: Char = '\u2021'
    /** The character &#x2022; */
    public const val bullet: Char = '\u2022'
    /** The character &#x2026; */
    public const val ellipsis: Char = '\u2026'
    /** The character &#x2032; */
    public const val prime: Char = '\u2032'
    /** The character &#x2033; */
    public const val doublePrime: Char = '\u2033'
    /** The character &#x20AC; */
    public const val euro: Char = '\u20AC'
    /** The character &#x2122; */
    public const val tm: Char = '\u2122'
    /** The character &#x2248; */
    public const val almostEqual: Char = '\u2248'
    /** The character &#x2260; */
    public const val notEqual: Char = '\u2260'
    /** The character &#x2264; */
    public const val lessOrEqual: Char = '\u2264'
    /** The character &#x2265; */
    public const val greaterOrEqual: Char = '\u2265'

    /** The character &#xAB; */
    @Deprecated("This constant has a typo in the name. Use leftGuillemet instead.", ReplaceWith("Typography.leftGuillemet"))
    @DeprecatedSinceKotlin("1.6")
    public const val leftGuillemete: Char = '\u00AB'

    /** The character &#xBB; */
    @Deprecated("This constant has a typo in the name. Use rightGuillemet instead.", ReplaceWith("Typography.rightGuillemet"))
    @DeprecatedSinceKotlin("1.6")
    public const val rightGuillemete: Char = '\u00BB'
}