---
stage: Tenant Scale
group: Organizations
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: 'チュートリアル: パーソナルプロジェクトをグループに移動する'
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

[個人ネームスペース](../../user/namespace/_index.md)でプロジェクトを作成した場合、イシュー、マージリクエスト、ソース管理、CI/CDの管理などの一般的なタスクを実行できます。

ただし、パーソナルプロジェクトが大きくなり、プロジェクトをグループネームスペースに移動した方がよい場合があります。グループネームスペースでは、次のことを行うことができます。

- ユーザーを1人ずつ追加するのではなく、ユーザーのグループにプロジェクトへのアクセス権を付与する。
- グループ内のすべてのプロジェクトのイシューとマージリクエストをすべて表示する。
- すべてのプロジェクトを対象に、グループネームスペース内の一意のユーザーをすべて表示する。
- 使用量割り当てを管理する。
- トライアルを開始するか、有料のサブスクリプションプランにアップグレードする。このオプションは、[ユーザー制限の変更](https://about.gitlab.com/blog/2022/03/24/efficient-free-tier/)の影響を受けており、より多くのユーザーが必要な場合に重要です。

このチュートリアルでは、プロジェクトを個人ネームスペースからグループネームスペースに移動する方法について説明します。

## ステップ

手順の概要は次のとおりです。

1. [グループを作成する](#create-a-group)。
1. [プロジェクトをグループに移動する](#move-your-project-to-a-group)。
1. [グループで作業する](#work-with-your-group)。

### グループを作成する

まず、プロジェクトの移動先として適切なグループがあることを確認してください。グループはプロジェクトの作成を許可する必要があり、ユーザーはグループのメンテナーロール以上を持っている必要があります。

グループがない場合は、次の手順で作成します。

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規グループ**を選択します。
1. **グループ名**に、グループの名前を入力します。
1. **グループURL**に、グループのパスを入力します。これは、ネームスペースとして使用されます。
1. [表示レベル](../../user/public_access.md)を選択します。
1. オプション。情報を入力して、エクスペリエンスをパーソナライズします。
1. **グループを作成**を選択します。

### プロジェクトをグループに移動する

プロジェクトをグループに移動する前に:

- プロジェクトのオーナーロールを持っている必要があります。
- [コンテナイメージ](../../user/packages/container_registry/_index.md#move-or-rename-container-registry-repositories)を削除します。
- NPMパッケージを削除します。プロジェクトを別のルートネームスペースに転送する場合、プロジェクトにNPMパッケージを含めることはできません。ユーザーまたはグループのパスを更新する、またはサブグループまたはプロジェクトを転送する場合は、最初にNPMパッケージを削除する必要があります。NPMパッケージを含むプロジェクトのルートネームスペースを更新することはできません。必ず、命名規則に従うように.npmrcファイルを更新し、必要に応じてnpm publishを実行してください。

これで、プロジェクトを移動する準備ができました。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **設定 > 一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトの転送**で、プロジェクトの転送先のグループを選択します。
1. **プロジェクトの転送**を選択します。
1. プロジェクトの名前を入力し、**確認**を選択します。

プロジェクトの新しいページにリダイレクトされます。複数のパーソナルプロジェクトがある場合は、プロジェクトごとにこれらの手順を繰り返すことができます。

{{< alert type="note" >}}

これらの移行手順の詳細については、[プロジェクトを別のネームスペースに転送する](../../user/project/settings/migrate_projects.md#transfer-a-project-to-another-namespace)を参照してください。移行の結果、ウェブサイトやパッケージマネージャーなどの関連するリソースやツールでプロジェクトパスを更新するフォローアップ作業が発生する可能性があります。

{{< /alert >}}

### グループで作業する

これで、グループでプロジェクトを表示できます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **サブグループとプロジェクト**でプロジェクトを探します。

グループの利点を活用しましょう。たとえば、グループオーナーとして、ネームスペース内の一意のすべてのユーザーをすばやく表示できます。

1. グループで、**設定 > 使用量割り当て**を選択します。
1. **シート**タブには、グループ内のすべてのプロジェクトを対象にすべてのユーザーが表示されます。
