/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.plan.OracleExecutionPlan;
import org.jkiss.dbeaver.ext.oracle.model.plan.OraclePlanNode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class OracleQueryPlanner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private static final String FORMAT_VERSION = "1";
    private final OracleDataSource dataSource;

    public OracleQueryPlanner(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public OracleDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        OracleExecutionPlan plan = new OracleExecutionPlan(this.dataSource, (JDBCSession)session, query);
        plan.explain();
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    private JsonObject createAttr(String key, String value) {
        JsonObject attr = new JsonObject();
        attr.add(key, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)value)));
        return attr;
    }

    private JsonObject createAttr(String key, long value) {
        JsonObject attr = new JsonObject();
        attr.add(key, (JsonElement)new JsonPrimitive((Number)value));
        return attr;
    }

    private JsonObject createAttr(String key, Timestamp value) {
        JsonObject attr = new JsonObject();
        attr.add(key, (JsonElement)new JsonPrimitive((Number)value.toInstant().toEpochMilli()));
        return attr;
    }

    public void serialize(Writer planData, DBCPlan plan) throws IOException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return OracleQueryPlanner.FORMAT_VERSION;
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonArray attributes = new JsonArray();
                if (node instanceof OraclePlanNode) {
                    OraclePlanNode oraNode = (OraclePlanNode)node;
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("statement_id", oraNode.getStatementId()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("plan_id", oraNode.getPlanId()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("timestamp", oraNode.getTimestamp()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("remarks", oraNode.getRemarks()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("operation", oraNode.getOperation()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("options", oraNode.getOptions()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_node", oraNode.getObjectNode()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_owner", oraNode.getObjectOwner()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_name", oraNode.getObjectName()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_alias", oraNode.getObjectAlias()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_instance", oraNode.getObjectInstance()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("object_type", oraNode.getObjectType()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("optimizer", oraNode.getOptimizer()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("search_columns", oraNode.getSearchColumns()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("id", oraNode.getId()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("depth", oraNode.getDepth()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("position", oraNode.getPosition()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("cost", oraNode.getCost()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("cardinality", oraNode.getCardinality()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("bytes", oraNode.getBytes()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("other_tag", oraNode.getOtherTag()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("partition_start", oraNode.getPartitionStart()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("partition_stop", oraNode.getPartitionStop()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("partition_id", oraNode.getPartitionId()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("other", oraNode.getOther()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("distribution", oraNode.getDistribution()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("cpu_cost", oraNode.getCpuCost()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("io_cost", oraNode.getIoCost()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("temp_space", oraNode.getTempSpace()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("access_predicates", oraNode.getAccessPredicates()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("filter_predicates", oraNode.getFilterPredicates()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("projection", oraNode.getProjection()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("time", oraNode.getTime()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("qblock_name", oraNode.getQblockName()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("other_xml", oraNode.getOtherXml()));
                    attributes.add((JsonElement)OracleQueryPlanner.this.createAttr("parent_id", oraNode.getParentId()));
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws IOException, InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            String query = this.getQuery(jo);
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            IntKeyMap allNodes = new IntKeyMap();
            List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> {
                OraclePlanNode nodeOra = new OraclePlanNode(this.dataSource, (IntKeyMap<OraclePlanNode>)allNodes, this.getNodeAttributes(node));
                allNodes.put(nodeOra.getId(), (Object)nodeOra);
                return nodeOra;
            });
            return new OracleExecutionPlan(query, rootNodes);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

