/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.editors.DB2TableTablespaceListProvider;
import org.jkiss.dbeaver.ext.db2.model.DB2ColumnMask;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraint;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TablePartition;
import org.jkiss.dbeaver.ext.db2.model.DB2TablePeriod;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableTriggerCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableAccessMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableCompressionMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableDropRule;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableLockSize;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableOrganizationMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablePartitionMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableStatus;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableTemporalType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DB2Table
extends DB2TableBase
implements DBPRefreshableObject,
DB2SourceObject,
DBDPseudoAttributeContainer,
DBSPartitionContainer,
DBSEntityConstrainable {
    protected static final Log log = Log.getLog(DB2Table.class);
    private static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    private static final String C_PT = "SELECT * FROM SYSCAT.DATAPARTITIONS WHERE TABSCHEMA = ? AND TABNAME = ? ORDER BY SEQNO WITH UR";
    private static final String C_PE = "SELECT * FROM SYSCAT.PERIODS WHERE TABSCHEMA = ? AND TABNAME = ? ORDER BY PERIODNAME WITH UR";
    private static final DBDPseudoAttribute[] PRESENTED_PSEUDO_ATTRS = new DBDPseudoAttribute[]{new DBDPseudoAttribute(DBDPseudoAttributeType.OTHER, "DATASLICEID", null, null, DB2Messages.pseudo_column_datasliceid_description, true, DBDPseudoAttribute.PropagationPolicy.TABLE_NORMAL)};
    private DB2TableTriggerCache tableTriggerCache = new DB2TableTriggerCache();
    private DBSObjectCache<DB2Table, DB2TablePartition> partitionCache;
    private DBSObjectCache<DB2Table, DB2TablePeriod> periodCache;
    private volatile List<DB2TableForeignKey> referenceCache = null;
    private ColumnMaskCache columnMaskCache = new ColumnMaskCache();
    private DB2TableStatus status;
    private DB2TableType type;
    private Object tablespace;
    private Object indexTablespace;
    private Object longTablespace;
    private String dataCapture;
    private String constChecked;
    private DB2TablePartitionMode partitionMode;
    private Boolean append;
    private DB2TableLockSize lockSize;
    private String volatileMode;
    private DB2TableCompressionMode compression;
    private DB2TableAccessMode accessMode;
    private DB2TableOrganizationMode organizationMode;
    private Boolean mdcClustered;
    private DB2TableDropRule dropRule;
    private DB2TableTemporalType temporalType;
    private Timestamp alterTime;
    private Timestamp invalidateTime;
    private Timestamp lastRegenTime;
    private Timestamp statsTime;
    private Long card;
    private Long nPages;
    private Long fPages;
    private Long overFLow;

    public DB2Table(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) throws DBException {
        super(monitor, schema, dbResult);
        String lockSizeString;
        this.status = (DB2TableStatus)CommonUtils.valueOf(DB2TableStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.type = (DB2TableType)CommonUtils.valueOf(DB2TableType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE"));
        this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_TIME");
        this.dataCapture = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATACAPTURE");
        this.constChecked = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONST_CHECKED");
        this.partitionMode = (DB2TablePartitionMode)CommonUtils.valueOf(DB2TablePartitionMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_MODE"));
        this.append = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"APPEND_MODE", (String)DB2YesNo.Y.name());
        this.volatileMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VOLATILE");
        this.compression = (DB2TableCompressionMode)CommonUtils.valueOf(DB2TableCompressionMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPRESSION"));
        this.accessMode = (DB2TableAccessMode)CommonUtils.valueOf(DB2TableAccessMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACCESS_MODE"));
        this.organizationMode = (DB2TableOrganizationMode)CommonUtils.valueOf(DB2TableOrganizationMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLEORG"));
        this.mdcClustered = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CLUSTERED", (String)DB2YesNo.Y.name());
        this.dropRule = (DB2TableDropRule)CommonUtils.valueOf(DB2TableDropRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DROPRULE"));
        this.card = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"CARD");
        this.nPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"NPAGES");
        this.fPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"FPAGES");
        this.overFLow = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"OVERFLOW");
        this.invalidateTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"INVALIDATE_TIME");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        if (((DB2DataSource)this.getDataSource()).isAtLeastV9_5()) {
            this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        }
        if (((DB2DataSource)this.getDataSource()).isAtLeastV10_1()) {
            this.temporalType = (DB2TableTemporalType)CommonUtils.valueOf(DB2TableTemporalType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEMPORALTYPE"));
        }
        if (CommonUtils.isNotEmpty((String)(lockSizeString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOCKSIZE")))) {
            this.lockSize = (DB2TableLockSize)CommonUtils.valueOf(DB2TableLockSize.class, (String)lockSizeString);
        }
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TBSPACE");
        this.indexTablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TBSPACE");
        this.longTablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LONG_TBSPACE");
        this.partitionCache = new JDBCObjectSimpleCache(DB2TablePartition.class, C_PT, new Object[]{schema.getName(), this.getName()});
        this.periodCache = new JDBCObjectSimpleCache(DB2TablePeriod.class, C_PE, new Object[]{schema.getName(), this.getName()});
    }

    public DB2Table(DB2Schema schema, String name) {
        super(schema, name, false);
        this.type = DB2TableType.T;
        this.status = DB2TableStatus.N;
    }

    public boolean isView() {
        return false;
    }

    public JDBCStructCache<DB2Schema, DB2Table, DB2TableColumn> getCache() {
        return ((DB2Schema)this.getContainer()).getTableCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((DB2Schema)this.getContainer()).getConstraintCache().clearObjectCache(this);
        ((DB2Schema)this.getContainer()).getAssociationCache().clearObjectCache(this);
        ((DB2Schema)this.getContainer()).getReferenceCache().clearObjectCache(this);
        this.referenceCache = null;
        super.refreshObject(monitor);
        return ((DB2Schema)this.getContainer()).getTableCache().refreshObject(monitor, (DB2Schema)this.getContainer(), this);
    }

    @Override
    public DB2TableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DB2TableColumn)((DB2Schema)this.getContainer()).getTableCache().getChild(monitor, (DB2Schema)this.getContainer(), this, attributeName);
    }

    public List<DB2TableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getTableCache().getChildren(monitor, (DB2Schema)this.getContainer(), this);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.status.getState();
    }

    @Override
    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        boolean includeViews = CommonUtils.getOption(options, (String)"script.include.views");
        return DB2Utils.generateDDLforTable(monitor, LINE_SEPARATOR, (DB2DataSource)this.getDataSource(), this, includeViews);
    }

    @Nullable
    @Association
    public List<DB2Trigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableTriggerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<DB2TablePartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionCache == null) {
            return null;
        }
        return this.partitionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DB2TablePeriod> getPeriods(DBRProgressMonitor monitor) throws DBException {
        if (this.periodCache == null) {
            return null;
        }
        return this.periodCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    @Nullable
    @Association
    public Collection<DB2TableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getConstraintCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DB2TableUniqueKey getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DB2TableUniqueKey)((DB2Schema)this.getContainer()).getConstraintCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<DB2TableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getAssociationCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DB2TableForeignKey getAssociation(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DB2TableForeignKey)((DB2Schema)this.getContainer()).getAssociationCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Association
    public List<DB2TableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.referenceCache != null) {
            return new ArrayList<DB2TableForeignKey>(this.referenceCache);
        }
        if (monitor == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Find table references");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT R.* FROM SYSCAT.REFERENCES R\nWHERE R.REFTABSCHEMA = ? AND R.REFTABNAME = ?\nORDER BY R.REFKEYNAME\nWITH UR");){
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        ArrayList<DB2TableForeignKey> result = new ArrayList<DB2TableForeignKey>();
                        while (dbResult.nextRow()) {
                            String ownerSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABSCHEMA");
                            String ownerTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME");
                            String fkName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"CONSTNAME");
                            DB2Table ownerTable = DB2Utils.findTableBySchemaNameAndName(session.getProgressMonitor(), (DB2DataSource)this.getDataSource(), ownerSchemaName, ownerTableName);
                            if (ownerTable == null) {
                                log.error((Object)("Cannot find reference owner table " + ownerSchemaName + "." + ownerTableName));
                                continue;
                            }
                            DB2TableForeignKey fk = ownerTable.getAssociation(monitor, fkName);
                            result.add(fk);
                        }
                        this.referenceCache = result;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading table references", (Throwable)e);
        }
        return this.referenceCache;
    }

    @Association
    public Collection<DB2TableCheckConstraint> getCheckConstraints(DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getCheckCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DB2TableCheckConstraint getCheckConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DB2TableCheckConstraint)((DB2Schema)this.getContainer()).getCheckCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Association
    public Collection<DB2ColumnMask> getColumnMasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.columnMaskCache.getAllObjects(monitor, this);
    }

    @Association
    public DB2ColumnMask getColumnMask(@NotNull DBRProgressMonitor monitor, @NotNull String maskName) throws DBException {
        return (DB2ColumnMask)this.columnMaskCache.getObject(monitor, this, maskName);
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=3, category="Statistics")
    public Long getCard() {
        return this.card;
    }

    @Property(viewable=true, editable=false, order=4)
    public DB2TableStatus getStatus() {
        return this.status;
    }

    @Property(viewable=true, editable=false, order=5)
    public DB2TableType getType() {
        return this.type;
    }

    @Property(viewable=true, editable=true, order=10, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.tablespace);
    }

    public void setTablespace(DB2Tablespace tablespace) {
        this.tablespace = tablespace;
    }

    @Property(viewable=false, editable=true, order=11, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getIndexTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.indexTablespace);
    }

    public void setIndexTablespace(DB2Tablespace indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Property(viewable=false, editable=true, order=12, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getLongTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.longTablespace);
    }

    public void setLongTablespace(DB2Tablespace longTablespace) {
        this.longTablespace = longTablespace;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getnPages() {
        return this.nPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getfPages() {
        return this.fPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getOverFLow() {
        return this.overFLow;
    }

    @Property(viewable=false, editable=false, order=100)
    public Boolean getAppend() {
        return this.append;
    }

    @Property(viewable=false, editable=false, specific=true, order=101)
    public String getVolatileMode() {
        return this.volatileMode;
    }

    @Property(viewable=false, editable=false, specific=true, order=104)
    public DB2TableLockSize getLockSize() {
        return this.lockSize;
    }

    @Property(viewable=false, editable=false, specific=true, order=105)
    public DB2TableCompressionMode getCompression() {
        return this.compression;
    }

    @Property(viewable=false, editable=false, specific=true, order=106)
    public DB2TableAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Property(specific=true, order=107)
    public DB2TableOrganizationMode getOrganizationMode() {
        return this.organizationMode;
    }

    @Property(viewable=false, editable=false, order=108)
    public Boolean getMdcClustered() {
        return this.mdcClustered;
    }

    @Property(viewable=false, editable=false, order=109)
    public DB2TableDropRule getDropRule() {
        return this.dropRule;
    }

    @Property(viewable=false, editable=false, specific=true, order=110)
    public String getDataCapture() {
        return this.dataCapture;
    }

    @Property(viewable=false, editable=false, specific=true, order=111)
    public DB2TablePartitionMode getPartitionMode() {
        return this.partitionMode;
    }

    @Property(viewable=false, editable=false, order=112)
    public String getConstChecked() {
        return this.constChecked;
    }

    @Property(viewable=false, editable=false, order=120, category="Temporal")
    public DB2TableTemporalType getTemporalType() {
        return this.temporalType;
    }

    @Property(viewable=false, editable=false, order=101, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, editable=false, order=102, category="Date & Time")
    public Timestamp getInvalidateTime() {
        return this.invalidateTime;
    }

    @Property(viewable=false, editable=false, order=103, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (((DB2DataSource)this.getDataSource()).isAtLeastV9_5() && !((DB2DataSource)this.getDataSource()).isBigSQL()) {
            return new DBDPseudoAttribute[]{DB2Constants.PSEUDO_ATTR_RID_BIT};
        }
        return null;
    }

    public DBDPseudoAttribute[] getAllPseudoAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PRESENTED_PSEUDO_ATTRS;
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, DB2TableUniqueKey.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, DB2TableUniqueKey.class));
    }

    public class ColumnMaskCache
    extends JDBCObjectLookupCache<DB2Table, DB2ColumnMask> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull DB2Table db2Table, @Nullable DB2ColumnMask object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM SYSCAT.CONTROLS\nWHERE CONTROLTYPE = 'C' AND TABSCHEMA = ? AND TABNAME = ?" + (object != null || objectName != null ? " AND CONTROLNAME = ?" : "");
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, db2Table.getSchema().getName());
            statement.setString(2, db2Table.getName());
            if (object != null || objectName != null) {
                statement.setString(3, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected DB2ColumnMask fetchObject(@NotNull JDBCSession session, @NotNull DB2Table db2Table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String maskName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CONTROLNAME");
            if (CommonUtils.isEmpty((String)maskName)) {
                log.debug((Object)("Skip column mask without name in table " + db2Table.getName()));
                return null;
            }
            String colName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"COLNAME");
            if (CommonUtils.isEmpty((String)colName)) {
                log.debug((Object)("Skip column mask without column name in table " + db2Table.getName()));
                return null;
            }
            DB2TableColumn attribute = db2Table.getAttribute(session.getProgressMonitor(), colName);
            if (attribute == null) {
                log.debug((Object)("Can't find column " + colName + " in table " + db2Table.getName()));
                return null;
            }
            return new DB2ColumnMask(db2Table, attribute, maskName, resultSet);
        }
    }
}

