﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/Omics_EXPORTS.h>
#include <aws/omics/model/ReferenceItem.h>
#include <aws/omics/model/StoreFormat.h>
#include <aws/omics/model/StoreOptions.h>
#include <aws/omics/model/StoreStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Omics {
namespace Model {
class CreateAnnotationStoreResult {
 public:
  AWS_OMICS_API CreateAnnotationStoreResult() = default;
  AWS_OMICS_API CreateAnnotationStoreResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OMICS_API CreateAnnotationStoreResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The store's ID.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateAnnotationStoreResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The store's genome reference. Required for all stores except TSV format with
   * generic annotations.</p>
   */
  inline const ReferenceItem& GetReference() const { return m_reference; }
  template <typename ReferenceT = ReferenceItem>
  void SetReference(ReferenceT&& value) {
    m_referenceHasBeenSet = true;
    m_reference = std::forward<ReferenceT>(value);
  }
  template <typename ReferenceT = ReferenceItem>
  CreateAnnotationStoreResult& WithReference(ReferenceT&& value) {
    SetReference(std::forward<ReferenceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The annotation file format of the store.</p>
   */
  inline StoreFormat GetStoreFormat() const { return m_storeFormat; }
  inline void SetStoreFormat(StoreFormat value) {
    m_storeFormatHasBeenSet = true;
    m_storeFormat = value;
  }
  inline CreateAnnotationStoreResult& WithStoreFormat(StoreFormat value) {
    SetStoreFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The store's file parsing options.</p>
   */
  inline const StoreOptions& GetStoreOptions() const { return m_storeOptions; }
  template <typename StoreOptionsT = StoreOptions>
  void SetStoreOptions(StoreOptionsT&& value) {
    m_storeOptionsHasBeenSet = true;
    m_storeOptions = std::forward<StoreOptionsT>(value);
  }
  template <typename StoreOptionsT = StoreOptions>
  CreateAnnotationStoreResult& WithStoreOptions(StoreOptionsT&& value) {
    SetStoreOptions(std::forward<StoreOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The store's status.</p>
   */
  inline StoreStatus GetStatus() const { return m_status; }
  inline void SetStatus(StoreStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CreateAnnotationStoreResult& WithStatus(StoreStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The store's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateAnnotationStoreResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name given to an annotation store version to distinguish it from other
   * versions. </p>
   */
  inline const Aws::String& GetVersionName() const { return m_versionName; }
  template <typename VersionNameT = Aws::String>
  void SetVersionName(VersionNameT&& value) {
    m_versionNameHasBeenSet = true;
    m_versionName = std::forward<VersionNameT>(value);
  }
  template <typename VersionNameT = Aws::String>
  CreateAnnotationStoreResult& WithVersionName(VersionNameT&& value) {
    SetVersionName(std::forward<VersionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the store was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  CreateAnnotationStoreResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateAnnotationStoreResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  ReferenceItem m_reference;

  StoreFormat m_storeFormat{StoreFormat::NOT_SET};

  StoreOptions m_storeOptions;

  StoreStatus m_status{StoreStatus::NOT_SET};

  Aws::String m_name;

  Aws::String m_versionName;

  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_referenceHasBeenSet = false;
  bool m_storeFormatHasBeenSet = false;
  bool m_storeOptionsHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_versionNameHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Omics
}  // namespace Aws
