﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/InferenceComponentStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>A summary of the properties of an inference component.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/InferenceComponentSummary">AWS
 * API Reference</a></p>
 */
class InferenceComponentSummary {
 public:
  AWS_SAGEMAKER_API InferenceComponentSummary() = default;
  AWS_SAGEMAKER_API InferenceComponentSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API InferenceComponentSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The time when the inference component was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  InferenceComponentSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the inference component.</p>
   */
  inline const Aws::String& GetInferenceComponentArn() const { return m_inferenceComponentArn; }
  inline bool InferenceComponentArnHasBeenSet() const { return m_inferenceComponentArnHasBeenSet; }
  template <typename InferenceComponentArnT = Aws::String>
  void SetInferenceComponentArn(InferenceComponentArnT&& value) {
    m_inferenceComponentArnHasBeenSet = true;
    m_inferenceComponentArn = std::forward<InferenceComponentArnT>(value);
  }
  template <typename InferenceComponentArnT = Aws::String>
  InferenceComponentSummary& WithInferenceComponentArn(InferenceComponentArnT&& value) {
    SetInferenceComponentArn(std::forward<InferenceComponentArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the inference component.</p>
   */
  inline const Aws::String& GetInferenceComponentName() const { return m_inferenceComponentName; }
  inline bool InferenceComponentNameHasBeenSet() const { return m_inferenceComponentNameHasBeenSet; }
  template <typename InferenceComponentNameT = Aws::String>
  void SetInferenceComponentName(InferenceComponentNameT&& value) {
    m_inferenceComponentNameHasBeenSet = true;
    m_inferenceComponentName = std::forward<InferenceComponentNameT>(value);
  }
  template <typename InferenceComponentNameT = Aws::String>
  InferenceComponentSummary& WithInferenceComponentName(InferenceComponentNameT&& value) {
    SetInferenceComponentName(std::forward<InferenceComponentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the endpoint that hosts the inference
   * component.</p>
   */
  inline const Aws::String& GetEndpointArn() const { return m_endpointArn; }
  inline bool EndpointArnHasBeenSet() const { return m_endpointArnHasBeenSet; }
  template <typename EndpointArnT = Aws::String>
  void SetEndpointArn(EndpointArnT&& value) {
    m_endpointArnHasBeenSet = true;
    m_endpointArn = std::forward<EndpointArnT>(value);
  }
  template <typename EndpointArnT = Aws::String>
  InferenceComponentSummary& WithEndpointArn(EndpointArnT&& value) {
    SetEndpointArn(std::forward<EndpointArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the endpoint that hosts the inference component.</p>
   */
  inline const Aws::String& GetEndpointName() const { return m_endpointName; }
  inline bool EndpointNameHasBeenSet() const { return m_endpointNameHasBeenSet; }
  template <typename EndpointNameT = Aws::String>
  void SetEndpointName(EndpointNameT&& value) {
    m_endpointNameHasBeenSet = true;
    m_endpointName = std::forward<EndpointNameT>(value);
  }
  template <typename EndpointNameT = Aws::String>
  InferenceComponentSummary& WithEndpointName(EndpointNameT&& value) {
    SetEndpointName(std::forward<EndpointNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the production variant that hosts the inference component.</p>
   */
  inline const Aws::String& GetVariantName() const { return m_variantName; }
  inline bool VariantNameHasBeenSet() const { return m_variantNameHasBeenSet; }
  template <typename VariantNameT = Aws::String>
  void SetVariantName(VariantNameT&& value) {
    m_variantNameHasBeenSet = true;
    m_variantName = std::forward<VariantNameT>(value);
  }
  template <typename VariantNameT = Aws::String>
  InferenceComponentSummary& WithVariantName(VariantNameT&& value) {
    SetVariantName(std::forward<VariantNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the inference component.</p>
   */
  inline InferenceComponentStatus GetInferenceComponentStatus() const { return m_inferenceComponentStatus; }
  inline bool InferenceComponentStatusHasBeenSet() const { return m_inferenceComponentStatusHasBeenSet; }
  inline void SetInferenceComponentStatus(InferenceComponentStatus value) {
    m_inferenceComponentStatusHasBeenSet = true;
    m_inferenceComponentStatus = value;
  }
  inline InferenceComponentSummary& WithInferenceComponentStatus(InferenceComponentStatus value) {
    SetInferenceComponentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the inference component was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  InferenceComponentSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::String m_inferenceComponentArn;
  bool m_inferenceComponentArnHasBeenSet = false;

  Aws::String m_inferenceComponentName;
  bool m_inferenceComponentNameHasBeenSet = false;

  Aws::String m_endpointArn;
  bool m_endpointArnHasBeenSet = false;

  Aws::String m_endpointName;
  bool m_endpointNameHasBeenSet = false;

  Aws::String m_variantName;
  bool m_variantNameHasBeenSet = false;

  InferenceComponentStatus m_inferenceComponentStatus{InferenceComponentStatus::NOT_SET};
  bool m_inferenceComponentStatusHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
