﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/ContextSource.h>
#include <aws/sagemaker/model/UserContext.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class DescribeContextResult {
 public:
  AWS_SAGEMAKER_API DescribeContextResult() = default;
  AWS_SAGEMAKER_API DescribeContextResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API DescribeContextResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the context.</p>
   */
  inline const Aws::String& GetContextName() const { return m_contextName; }
  template <typename ContextNameT = Aws::String>
  void SetContextName(ContextNameT&& value) {
    m_contextNameHasBeenSet = true;
    m_contextName = std::forward<ContextNameT>(value);
  }
  template <typename ContextNameT = Aws::String>
  DescribeContextResult& WithContextName(ContextNameT&& value) {
    SetContextName(std::forward<ContextNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the context.</p>
   */
  inline const Aws::String& GetContextArn() const { return m_contextArn; }
  template <typename ContextArnT = Aws::String>
  void SetContextArn(ContextArnT&& value) {
    m_contextArnHasBeenSet = true;
    m_contextArn = std::forward<ContextArnT>(value);
  }
  template <typename ContextArnT = Aws::String>
  DescribeContextResult& WithContextArn(ContextArnT&& value) {
    SetContextArn(std::forward<ContextArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source of the context.</p>
   */
  inline const ContextSource& GetSource() const { return m_source; }
  template <typename SourceT = ContextSource>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = ContextSource>
  DescribeContextResult& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the context.</p>
   */
  inline const Aws::String& GetContextType() const { return m_contextType; }
  template <typename ContextTypeT = Aws::String>
  void SetContextType(ContextTypeT&& value) {
    m_contextTypeHasBeenSet = true;
    m_contextType = std::forward<ContextTypeT>(value);
  }
  template <typename ContextTypeT = Aws::String>
  DescribeContextResult& WithContextType(ContextTypeT&& value) {
    SetContextType(std::forward<ContextTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the context.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeContextResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of the context's properties.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetProperties() const { return m_properties; }
  template <typename PropertiesT = Aws::Map<Aws::String, Aws::String>>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::Map<Aws::String, Aws::String>>
  DescribeContextResult& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  template <typename PropertiesKeyT = Aws::String, typename PropertiesValueT = Aws::String>
  DescribeContextResult& AddProperties(PropertiesKeyT&& key, PropertiesValueT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties.emplace(std::forward<PropertiesKeyT>(key), std::forward<PropertiesValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the context was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeContextResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const UserContext& GetCreatedBy() const { return m_createdBy; }
  template <typename CreatedByT = UserContext>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = UserContext>
  DescribeContextResult& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the context was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeContextResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const UserContext& GetLastModifiedBy() const { return m_lastModifiedBy; }
  template <typename LastModifiedByT = UserContext>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = UserContext>
  DescribeContextResult& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the lineage group.</p>
   */
  inline const Aws::String& GetLineageGroupArn() const { return m_lineageGroupArn; }
  template <typename LineageGroupArnT = Aws::String>
  void SetLineageGroupArn(LineageGroupArnT&& value) {
    m_lineageGroupArnHasBeenSet = true;
    m_lineageGroupArn = std::forward<LineageGroupArnT>(value);
  }
  template <typename LineageGroupArnT = Aws::String>
  DescribeContextResult& WithLineageGroupArn(LineageGroupArnT&& value) {
    SetLineageGroupArn(std::forward<LineageGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeContextResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_contextName;
  bool m_contextNameHasBeenSet = false;

  Aws::String m_contextArn;
  bool m_contextArnHasBeenSet = false;

  ContextSource m_source;
  bool m_sourceHasBeenSet = false;

  Aws::String m_contextType;
  bool m_contextTypeHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_properties;
  bool m_propertiesHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  UserContext m_createdBy;
  bool m_createdByHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  UserContext m_lastModifiedBy;
  bool m_lastModifiedByHasBeenSet = false;

  Aws::String m_lineageGroupArn;
  bool m_lineageGroupArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
