/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRouterCondition.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSFetchRequestDestination.h"
#include "JSFetchRequestMode.h"
#include "JSRunningStatus.h"
#include "JSURLPattern.h"
#include "JSURLPatternInit.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<RouterCondition>> convertDictionary<RouterCondition>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    RouterCondition result;
    JSValue _orValue;
    if (isNullOrUndefined)
        _orValue = jsUndefined();
    else {
        _orValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "_or"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!_orValue.isUndefined()) {
        auto orConditionsConversionResult = convert<IDLSequence<IDLDictionary<RouterCondition::Condition>>>(lexicalGlobalObject, _orValue);
        if (orConditionsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.orConditions = orConditionsConversionResult.releaseReturnValue();
    }
    JSValue notValue;
    if (isNullOrUndefined)
        notValue = jsUndefined();
    else {
        notValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "not"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!notValue.isUndefined()) {
        auto notConditionConversionResult = convert<IDLDictionary<RouterCondition::Condition>>(lexicalGlobalObject, notValue);
        if (notConditionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.notCondition = notConditionConversionResult.releaseReturnValue();
    }
    JSValue requestDestinationValue;
    if (isNullOrUndefined)
        requestDestinationValue = jsUndefined();
    else {
        requestDestinationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestDestination"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!requestDestinationValue.isUndefined()) {
        auto requestDestinationConversionResult = convert<IDLEnumeration<FetchRequestDestination>>(lexicalGlobalObject, requestDestinationValue);
        if (requestDestinationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.requestDestination = requestDestinationConversionResult.releaseReturnValue();
    }
    JSValue requestMethodValue;
    if (isNullOrUndefined)
        requestMethodValue = jsUndefined();
    else {
        requestMethodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestMethod"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!requestMethodValue.isUndefined()) {
        auto requestMethodConversionResult = convert<IDLByteString>(lexicalGlobalObject, requestMethodValue);
        if (requestMethodConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.requestMethod = requestMethodConversionResult.releaseReturnValue();
    }
    JSValue requestModeValue;
    if (isNullOrUndefined)
        requestModeValue = jsUndefined();
    else {
        requestModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!requestModeValue.isUndefined()) {
        auto requestModeConversionResult = convert<IDLEnumeration<FetchRequestMode>>(lexicalGlobalObject, requestModeValue);
        if (requestModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.requestMode = requestModeConversionResult.releaseReturnValue();
    }
    JSValue runningStatusValue;
    if (isNullOrUndefined)
        runningStatusValue = jsUndefined();
    else {
        runningStatusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "runningStatus"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!runningStatusValue.isUndefined()) {
        auto runningStatusConversionResult = convert<IDLEnumeration<RunningStatus>>(lexicalGlobalObject, runningStatusValue);
        if (runningStatusConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.runningStatus = runningStatusConversionResult.releaseReturnValue();
    }
    JSValue urlPatternValue;
    if (isNullOrUndefined)
        urlPatternValue = jsUndefined();
    else {
        urlPatternValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "urlPattern"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!urlPatternValue.isUndefined()) {
        auto urlPatternConversionResult = convert<IDLUnion<IDLUSVString, IDLDictionary<URLPatternInit>, IDLInterface<URLPattern>>>(lexicalGlobalObject, urlPatternValue);
        if (urlPatternConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.urlPattern = urlPatternConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

