/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)

#include "JSMediaStreamAudioSourceNode.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAudioContext.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStream.h"
#include "JSMediaStreamAudioSourceOptions.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamAudioSourceNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamAudioSourceNode_mediaStream);

class JSMediaStreamAudioSourceNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamAudioSourceNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamAudioSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamAudioSourceNodePrototype>(vm)) JSMediaStreamAudioSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamAudioSourceNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamAudioSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamAudioSourceNodePrototype, JSMediaStreamAudioSourceNodePrototype::Base);

using JSMediaStreamAudioSourceNodeDOMConstructor = JSDOMConstructor<JSMediaStreamAudioSourceNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaStreamAudioSourceNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaStreamAudioSourceNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().webAudioEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextConversionResult = convert<IDLInterface<AudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context"_s, "MediaStreamAudioSourceNode"_s, nullptr, "AudioContext"_s); });
    if (contextConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto optionsConversionResult = convert<IDLDictionary<MediaStreamAudioSourceOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = MediaStreamAudioSourceNode::create(*contextConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaStreamAudioSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaStreamAudioSourceNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaStreamAudioSourceNodeDOMConstructorConstruct, JSMediaStreamAudioSourceNodeDOMConstructor::construct);

template<> const ClassInfo JSMediaStreamAudioSourceNodeDOMConstructor::s_info = { "MediaStreamAudioSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioSourceNodeDOMConstructor) };

template<> JSValue JSMediaStreamAudioSourceNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSMediaStreamAudioSourceNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaStreamAudioSourceNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaStreamAudioSourceNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSMediaStreamAudioSourceNodePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamAudioSourceNodeConstructor, 0 } },
    HashTableValue { "mediaStream"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamAudioSourceNode_mediaStream, 0 } },
};

const ClassInfo JSMediaStreamAudioSourceNodePrototype::s_info = { "MediaStreamAudioSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioSourceNodePrototype) };

void JSMediaStreamAudioSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStreamAudioSourceNode::info(), JSMediaStreamAudioSourceNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaStreamAudioSourceNode::s_info = { "MediaStreamAudioSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioSourceNode) };

JSMediaStreamAudioSourceNode::JSMediaStreamAudioSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStreamAudioSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaStreamAudioSourceNode> JSMediaStreamAudioSourceNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaStreamAudioSourceNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaStreamAudioSourceNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaStreamAudioSourceNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaStreamAudioSourceNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaStreamAudioSourceNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStreamAudioSourceNode>(vm, globalObject);
}

JSValue JSMediaStreamAudioSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamAudioSourceNodeDOMConstructor, DOMConstructorID::MediaStreamAudioSourceNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamAudioSourceNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamAudioSourceNodePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStreamAudioSourceNode::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaStreamAudioSourceNode_mediaStreamGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamAudioSourceNode& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mediaStream())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamAudioSourceNode_mediaStream, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamAudioSourceNode>::get<jsMediaStreamAudioSourceNode_mediaStreamGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSMediaStreamAudioSourceNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaStreamAudioSourceNode, UseCustomHeapCellType::No>(vm, "JSMediaStreamAudioSourceNode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaStreamAudioSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaStreamAudioSourceNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaStreamAudioSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaStreamAudioSourceNode = std::forward<decltype(space)>(space); }
    );
}

void JSMediaStreamAudioSourceNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStreamAudioSourceNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaStreamAudioSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26MediaStreamAudioSourceNodeE[]; }
#endif
template<std::same_as<MediaStreamAudioSourceNode> T>
static inline void verifyVTable(MediaStreamAudioSourceNode* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaStreamAudioSourceNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26MediaStreamAudioSourceNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaStreamAudioSourceNode has subclasses. If MediaStreamAudioSourceNode has subclasses that get passed
        // to toJS() we currently require MediaStreamAudioSourceNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaStreamAudioSourceNode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaStreamAudioSourceNode>(impl.ptr());
#endif
    return createWrapper<MediaStreamAudioSourceNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaStreamAudioSourceNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
