/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUMapMode.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "GPUMapMode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotCallable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectPrototype.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>

namespace WebCore {
using namespace JSC;

using JSGPUMapModeDOMConstructor = JSDOMConstructorNotCallable<JSGPUMapMode>;

/* Hash table for constructor */

static const std::array<HashTableValue, 2> JSGPUMapModeConstructorTableValues {
    HashTableValue { "READ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
    HashTableValue { "WRITE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
};

static_assert(GPUMapMode::READ == 0x0001, "READ in GPUMapMode does not match value from IDL");
static_assert(GPUMapMode::WRITE == 0x0002, "WRITE in GPUMapMode does not match value from IDL");

template<> const ClassInfo JSGPUMapModeDOMConstructor::s_info = { "GPUMapMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUMapModeDOMConstructor) };

template<> JSValue JSGPUMapModeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.objectPrototype();
}

template<> void JSGPUMapModeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
    reifyStaticProperties(vm, JSGPUMapMode::info(), JSGPUMapModeConstructorTableValues, *this);
    UNUSED_PARAM(globalObject);
}

const ClassInfo JSGPUMapMode::s_info = { "GPUMapMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUMapMode) };

JSGPUMapMode::JSGPUMapMode(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

static_assert(!std::is_base_of<ActiveDOMObject, GPUMapMode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSValue JSGPUMapMode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUMapModeDOMConstructor, DOMConstructorID::GPUMapMode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUMapMode::destroy(JSC::JSCell* cell)
{
    JSGPUMapMode* thisObject = static_cast<JSGPUMapMode*>(cell);
    thisObject->JSGPUMapMode::~JSGPUMapMode();
}

JSC::GCClient::IsoSubspace* JSGPUMapMode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUMapMode, UseCustomHeapCellType::No>(vm, "JSGPUMapMode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUMapMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUMapMode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUMapMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUMapMode = std::forward<decltype(space)>(space); }
    );
}


}
