/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupEntry.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUBufferBinding.h"
#include "JSGPUExternalTexture.h"
#include "JSGPUSampler.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBindGroupEntry>> convertDictionary<GPUBindGroupEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBindGroupEntry result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bindingValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding"_s, "GPUBindGroupEntry"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto bindingConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, bindingValue);
    if (bindingConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.binding = bindingConversionResult.releaseReturnValue();
    JSValue resourceValue;
    if (isNullOrUndefined)
        resourceValue = jsUndefined();
    else {
        resourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resource"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (resourceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "resource"_s, "GPUBindGroupEntry"_s, "(GPUSampler or GPUTextureView or GPUBufferBinding or GPUExternalTexture)"_s);
        return ConversionResultException { };
    }
    auto resourceConversionResult = convert<IDLUnion<IDLInterface<GPUSampler>, IDLInterface<GPUTextureView>, IDLDictionary<GPUBufferBinding>, IDLInterface<GPUExternalTexture>>>(lexicalGlobalObject, resourceValue);
    if (resourceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.resource = resourceConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

