/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCharacterData.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_substringData);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_appendData);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_insertData);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_deleteData);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_replaceData);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_before);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_after);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_replaceWith);
static JSC_DECLARE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_remove);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCharacterDataConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCharacterData_data);
static JSC_DECLARE_CUSTOM_SETTER(setJSCharacterData_data);
static JSC_DECLARE_CUSTOM_GETTER(jsCharacterData_length);
static JSC_DECLARE_CUSTOM_GETTER(jsCharacterData_previousElementSibling);
static JSC_DECLARE_CUSTOM_GETTER(jsCharacterData_nextElementSibling);

class JSCharacterDataPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCharacterDataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCharacterDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSCharacterDataPrototype>(vm)) JSCharacterDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCharacterDataPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCharacterDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCharacterDataPrototype, JSCharacterDataPrototype::Base);

using JSCharacterDataDOMConstructor = JSDOMConstructorNotConstructable<JSCharacterData>;

template<> const ClassInfo JSCharacterDataDOMConstructor::s_info = { "CharacterData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCharacterDataDOMConstructor) };

template<> JSValue JSCharacterDataDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSCharacterDataDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CharacterData"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCharacterData::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 14> JSCharacterDataPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCharacterDataConstructor, 0 } },
    HashTableValue { "data"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCharacterData_data, setJSCharacterData_data } },
    HashTableValue { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCharacterData_length, 0 } },
    HashTableValue { "previousElementSibling"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCharacterData_previousElementSibling, 0 } },
    HashTableValue { "nextElementSibling"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCharacterData_nextElementSibling, 0 } },
    HashTableValue { "substringData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_substringData, 2 } },
    HashTableValue { "appendData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_appendData, 1 } },
    HashTableValue { "insertData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_insertData, 2 } },
    HashTableValue { "deleteData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_deleteData, 2 } },
    HashTableValue { "replaceData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_replaceData, 3 } },
    HashTableValue { "before"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_before, 0 } },
    HashTableValue { "after"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_after, 0 } },
    HashTableValue { "replaceWith"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_replaceWith, 0 } },
    HashTableValue { "remove"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCharacterDataPrototypeFunction_remove, 0 } },
};

const ClassInfo JSCharacterDataPrototype::s_info = { "CharacterData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCharacterDataPrototype) };

void JSCharacterDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCharacterData::info(), JSCharacterDataPrototypeTableValues, *this);
    JSObject& unscopables = *constructEmptyObject(globalObject()->vm(), globalObject()->nullPrototypeObjectStructure());
    unscopables.putDirect(vm, Identifier::fromString(vm, "before"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "after"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "replaceWith"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "remove"_s), jsBoolean(true));
    putDirectWithoutTransition(vm, vm.propertyNames->unscopablesSymbol, &unscopables, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCharacterData::s_info = { "CharacterData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCharacterData) };

JSCharacterData::JSCharacterData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CharacterData>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

Ref<CharacterData> JSCharacterData::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSCharacterData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCharacterDataPrototype::createStructure(vm, &globalObject, JSNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCharacterDataPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCharacterData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCharacterData>(vm, globalObject);
}

JSValue JSCharacterData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCharacterDataDOMConstructor, DOMConstructorID::CharacterData>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCharacterDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCharacterDataPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCharacterData::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCharacterData_dataGetter(JSGlobalObject& lexicalGlobalObject, JSCharacterData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.data())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCharacterData_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCharacterData>::get<jsCharacterData_dataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCharacterData_dataSetter(JSGlobalObject& lexicalGlobalObject, JSCharacterData& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setData(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCharacterData_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCharacterData>::set<setJSCharacterData_dataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCharacterData_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSCharacterData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCharacterData_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCharacterData>::get<jsCharacterData_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCharacterData_previousElementSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSCharacterData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.previousElementSibling())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCharacterData_previousElementSibling, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCharacterData>::get<jsCharacterData_previousElementSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCharacterData_nextElementSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSCharacterData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nextElementSibling())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCharacterData_nextElementSibling, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCharacterData>::get<jsCharacterData_nextElementSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_substringDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.substringData(offsetConversionResult.releaseReturnValue(), countConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_substringData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_substringDataBody>(*lexicalGlobalObject, *callFrame, "substringData");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_appendDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.appendData(dataConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_appendData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_appendDataBody>(*lexicalGlobalObject, *callFrame, "appendData");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_insertDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.insertData(offsetConversionResult.releaseReturnValue(), dataConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_insertData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_insertDataBody>(*lexicalGlobalObject, *callFrame, "insertData");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_deleteDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteData(offsetConversionResult.releaseReturnValue(), countConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_deleteData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_deleteDataBody>(*lexicalGlobalObject, *callFrame, "deleteData");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_replaceDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceData(offsetConversionResult.releaseReturnValue(), countConversionResult.releaseReturnValue(), dataConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_replaceData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_replaceDataBody>(*lexicalGlobalObject, *callFrame, "replaceData");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_beforeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.before(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_before, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_beforeBody>(*lexicalGlobalObject, *callFrame, "before");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_afterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.after(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_after, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_afterBody>(*lexicalGlobalObject, *callFrame, "after");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_replaceWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceWith(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_replaceWith, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_replaceWithBody>(*lexicalGlobalObject, *callFrame, "replaceWith");
}

static inline JSC::EncodedJSValue jsCharacterDataPrototypeFunction_removeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCharacterData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.remove(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCharacterDataPrototypeFunction_remove, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCharacterData>::call<jsCharacterDataPrototypeFunction_removeBody>(*lexicalGlobalObject, *callFrame, "remove");
}

JSC::GCClient::IsoSubspace* JSCharacterData::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCharacterData, UseCustomHeapCellType::No>(vm, "JSCharacterData"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCharacterData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCharacterData = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCharacterData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCharacterData = std::forward<decltype(space)>(space); }
    );
}

void JSCharacterData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCharacterData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
