/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSFontPaletteValuesRule.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontPaletteValuesRuleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_name);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_fontFamily);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_basePalette);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_overrideColors);

class JSCSSFontPaletteValuesRulePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSFontPaletteValuesRulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSFontPaletteValuesRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSFontPaletteValuesRulePrototype>(vm)) JSCSSFontPaletteValuesRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontPaletteValuesRulePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSFontPaletteValuesRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontPaletteValuesRulePrototype, JSCSSFontPaletteValuesRulePrototype::Base);

using JSCSSFontPaletteValuesRuleDOMConstructor = JSDOMConstructorNotConstructable<JSCSSFontPaletteValuesRule>;

template<> const ClassInfo JSCSSFontPaletteValuesRuleDOMConstructor::s_info = { "CSSFontPaletteValuesRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontPaletteValuesRuleDOMConstructor) };

template<> JSValue JSCSSFontPaletteValuesRuleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSFontPaletteValuesRuleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSFontPaletteValuesRule"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSFontPaletteValuesRule::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSCSSFontPaletteValuesRulePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontPaletteValuesRuleConstructor, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontPaletteValuesRule_name, 0 } },
    HashTableValue { "fontFamily"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontPaletteValuesRule_fontFamily, 0 } },
    HashTableValue { "basePalette"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontPaletteValuesRule_basePalette, 0 } },
    HashTableValue { "overrideColors"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontPaletteValuesRule_overrideColors, 0 } },
};

const ClassInfo JSCSSFontPaletteValuesRulePrototype::s_info = { "CSSFontPaletteValuesRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontPaletteValuesRulePrototype) };

void JSCSSFontPaletteValuesRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSFontPaletteValuesRule::info(), JSCSSFontPaletteValuesRulePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSFontPaletteValuesRule::s_info = { "CSSFontPaletteValuesRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontPaletteValuesRule) };

JSCSSFontPaletteValuesRule::JSCSSFontPaletteValuesRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSFontPaletteValuesRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSFontPaletteValuesRule> JSCSSFontPaletteValuesRule::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSFontPaletteValuesRule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSFontPaletteValuesRule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSFontPaletteValuesRulePrototype::createStructure(vm, &globalObject, JSCSSRule::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSFontPaletteValuesRulePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSFontPaletteValuesRule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSFontPaletteValuesRule>(vm, globalObject);
}

JSValue JSCSSFontPaletteValuesRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSFontPaletteValuesRuleDOMConstructor, DOMConstructorID::CSSFontPaletteValuesRule>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontPaletteValuesRuleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSFontPaletteValuesRulePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSFontPaletteValuesRule::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSFontPaletteValuesRule_nameGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontPaletteValuesRule& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontPaletteValuesRule>::get<jsCSSFontPaletteValuesRule_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSFontPaletteValuesRule_fontFamilyGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontPaletteValuesRule& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.fontFamily())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_fontFamily, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontPaletteValuesRule>::get<jsCSSFontPaletteValuesRule_fontFamilyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSFontPaletteValuesRule_basePaletteGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontPaletteValuesRule& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.basePalette())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_basePalette, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontPaletteValuesRule>::get<jsCSSFontPaletteValuesRule_basePaletteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSFontPaletteValuesRule_overrideColorsGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontPaletteValuesRule& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.overrideColors())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontPaletteValuesRule_overrideColors, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontPaletteValuesRule>::get<jsCSSFontPaletteValuesRule_overrideColorsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSFontPaletteValuesRule::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSFontPaletteValuesRule, UseCustomHeapCellType::No>(vm, "JSCSSFontPaletteValuesRule"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSFontPaletteValuesRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSFontPaletteValuesRule = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSFontPaletteValuesRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSFontPaletteValuesRule = std::forward<decltype(space)>(space); }
    );
}

void JSCSSFontPaletteValuesRule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSFontPaletteValuesRule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
