//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/primvarsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrimvarsSchemaTokens,
    HD_PRIMVARS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

TfTokenVector
HdPrimvarsSchema::GetPrimvarNames() const
{
    if (_container) {
        return _container->GetNames();
    } else {
        return {};
    }
}

HdPrimvarSchema
HdPrimvarsSchema::GetPrimvar(const TfToken &name) const
{
    return HdPrimvarSchema(
        _GetTypedDataSource<HdContainerDataSource>(name));
}

/*static*/
HdContainerDataSourceHandle
HdPrimvarsSchema::BuildRetained(
    const size_t count,
    const TfToken * const names,
    const HdDataSourceBaseHandle * const values)
{
    return HdRetainedContainerDataSource::New(count, names, values);
}

/*static*/
HdPrimvarsSchema
HdPrimvarsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPrimvarsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPrimvarsSchemaTokens->primvars))
        : nullptr);
}

/*static*/
const TfToken &
HdPrimvarsSchema::GetSchemaToken()
{
    return HdPrimvarsSchemaTokens->primvars;
}

/*static*/
const HdDataSourceLocator &
HdPrimvarsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrimvarsSchema::GetPointsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrimvarsSchemaTokens->points);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrimvarsSchema::GetNormalsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrimvarsSchemaTokens->normals);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdPrimvarsSchema::GetWidthsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdPrimvarsSchemaTokens->widths);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE