//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/basisCurvesSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdBasisCurvesSchemaTokens,
    HD_BASIS_CURVES_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdBasisCurvesTopologySchema
HdBasisCurvesSchema::GetTopology() const
{
    return HdBasisCurvesTopologySchema(_GetTypedDataSource<HdContainerDataSource>(
        HdBasisCurvesSchemaTokens->topology));
}

/*static*/
HdContainerDataSourceHandle
HdBasisCurvesSchema::BuildRetained(
        const HdContainerDataSourceHandle &topology
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (topology) {
        _names[_count] = HdBasisCurvesSchemaTokens->topology;
        _values[_count++] = topology;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdBasisCurvesSchema::Builder &
HdBasisCurvesSchema::Builder::SetTopology(
    const HdContainerDataSourceHandle &topology)
{
    _topology = topology;
    return *this;
}

HdContainerDataSourceHandle
HdBasisCurvesSchema::Builder::Build()
{
    return HdBasisCurvesSchema::BuildRetained(
        _topology
    );
}

/*static*/
HdBasisCurvesSchema
HdBasisCurvesSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdBasisCurvesSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdBasisCurvesSchemaTokens->basisCurves))
        : nullptr);
}

/*static*/
const TfToken &
HdBasisCurvesSchema::GetSchemaToken()
{
    return HdBasisCurvesSchemaTokens->basisCurves;
}

/*static*/
const HdDataSourceLocator &
HdBasisCurvesSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdBasisCurvesSchema::GetTopologyLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdBasisCurvesSchemaTokens->topology);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE