//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// range.template.cpp file to make changes.

#include "pxr/base/gf/range1d.h"
#include "pxr/base/gf/range1f.h"

#include "pxr/base/gf/math.h"
#include "pxr/base/gf/ostreamHelpers.h"
#include "pxr/base/tf/type.h"

#include <cfloat>
#include <ostream>

PXR_NAMESPACE_OPEN_SCOPE

TF_REGISTRY_FUNCTION(TfType) {
    TfType::Define<GfRange1d>();
}

std::ostream& 
operator<<(std::ostream &out, GfRange1d const &r)
{
    return out << '[' 
               << Gf_OstreamHelperP(r.GetMin()) << "..." 
               << Gf_OstreamHelperP(r.GetMax())
               << ']';
}

GfRange1d::GfRange1d(class GfRange1f const &other)
    : _min( (other.GetMin()))
    , _max( (other.GetMax()))
{
}

double
GfRange1d::GetDistanceSquared(double p) const
{
    double dist = 0.0;

    if (p < _min) {
	// p is left of box
	dist += GfSqr(_min - p);
    }
    else if (p > _max) {
	// p is right of box
	dist += GfSqr(p - _max);
    }

    return dist;
}

PXR_NAMESPACE_CLOSE_SCOPE
