//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/collectionsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdCollectionsSchemaTokens,
    HD_COLLECTIONS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

TfTokenVector
HdCollectionsSchema::GetCollectionNames() const
{
    if (_container) {
        return _container->GetNames();
    } else {
        return {};
    }
}

HdCollectionSchema
HdCollectionsSchema::GetCollection(const TfToken &name) const
{
    return HdCollectionSchema(
        _GetTypedDataSource<HdContainerDataSource>(name));
}

/*static*/
HdContainerDataSourceHandle
HdCollectionsSchema::BuildRetained(
    const size_t count,
    const TfToken * const names,
    const HdDataSourceBaseHandle * const values)
{
    return HdRetainedContainerDataSource::New(count, names, values);
}

/*static*/
HdCollectionsSchema
HdCollectionsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdCollectionsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdCollectionsSchemaTokens->collections))
        : nullptr);
}

/*static*/
const TfToken &
HdCollectionsSchema::GetSchemaToken()
{
    return HdCollectionsSchemaTokens->collections;
}

/*static*/
const HdDataSourceLocator &
HdCollectionsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE