/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_output_manager_v1 The treeland_output_manager_v1 protocol
 * @section page_ifaces_treeland_output_manager_v1 Interfaces
 * - @subpage page_iface_treeland_output_manager_v1 - expose which is the primary display
 * - @subpage page_iface_treeland_output_color_control_v1 - Color control interface for output.
 * @section page_copyright_treeland_output_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024-2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_output_color_control_v1;
struct treeland_output_manager_v1;
struct wl_output;

#ifndef TREELAND_OUTPUT_MANAGER_V1_INTERFACE
#define TREELAND_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_output_manager_v1 treeland_output_manager_v1
 * @section page_iface_treeland_output_manager_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 * @section page_iface_treeland_output_manager_v1_api API
 * See @ref iface_treeland_output_manager_v1.
 */
/**
 * @defgroup iface_treeland_output_manager_v1 The treeland_output_manager_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 */
extern const struct wl_interface treeland_output_manager_v1_interface;
#endif
#ifndef TREELAND_OUTPUT_COLOR_CONTROL_V1_INTERFACE
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_INTERFACE
/**
 * @page page_iface_treeland_output_color_control_v1 treeland_output_color_control_v1
 * @section page_iface_treeland_output_color_control_v1_desc Description
 *
 * Protocol for controlling color temperature and brightness settings of a specific output.
 * @section page_iface_treeland_output_color_control_v1_api API
 * See @ref iface_treeland_output_color_control_v1.
 */
/**
 * @defgroup iface_treeland_output_color_control_v1 The treeland_output_color_control_v1 interface
 *
 * Protocol for controlling color temperature and brightness settings of a specific output.
 */
extern const struct wl_interface treeland_output_color_control_v1_interface;
#endif

/**
 * @ingroup iface_treeland_output_manager_v1
 * @struct treeland_output_manager_v1_interface
 */
struct treeland_output_manager_v1_interface {
	/**
	 * Select which primary output to use
	 *
	 * 
	 */
	void (*set_primary_output)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *output);
	/**
	 * Get color control interface for output.
	 *
	 * 
	 * @since 2
	 */
	void (*get_color_control)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *output);
	/**
	 * Destroy the primary output notifier.
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT 0

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_GET_COLOR_CONTROL_SINCE_VERSION 2
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 * Sends an primary_output event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output_name the name of the output
 */
static inline void
treeland_output_manager_v1_send_primary_output(struct wl_resource *resource_, const char *output_name)
{
	wl_resource_post_event(resource_, TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT, output_name);
}

#ifndef TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM
enum treeland_output_color_control_v1_error {
	/**
	 * Invalid color temperature value provided.
	 */
	TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_COLOR_TEMPERATURE = 1,
	/**
	 * Invalid brightness value provided.
	 */
	TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_BRIGHTNESS = 2,
};
#endif /* TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM */

#ifndef TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM_IS_VALID
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_output_color_control_v1
 * Validate a treeland_output_color_control_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_output_color_control_v1_error
 */
static inline bool
treeland_output_color_control_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_COLOR_TEMPERATURE:
		return version >= 1;
	case TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_BRIGHTNESS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_output_color_control_v1
 * @struct treeland_output_color_control_v1_interface
 */
struct treeland_output_color_control_v1_interface {
	/**
	 * Set color temperature for output
	 *
	 * Color temperature settings are applied only after a commit
	 * request is made. Setting a value outside the range [1000, 20000]
	 * is a protocol error.
	 * @param temperature color temperature in Kelvin
	 */
	void (*set_color_temperature)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t temperature);
	/**
	 * Set brightness for output.
	 *
	 * Brightness settings are applied only after a commit request is
	 * made. Setting a value outside the range [0.0, 100.0] is a
	 * protocol error.
	 * @param brightness brightness level (in range [0.0, 100.0])
	 */
	void (*set_brightness)(struct wl_client *client,
			       struct wl_resource *resource,
			       wl_fixed_t brightness);
	/**
	 * Commit the pending color settings changes for output.
	 *
	 * 
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * Destroy the color control interface.
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_OUTPUT_COLOR_CONTROL_V1_RESULT 0
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COLOR_TEMPERATURE 1
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_BRIGHTNESS 2

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_RESULT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COLOR_TEMPERATURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_BRIGHTNESS_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_COLOR_TEMPERATURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_BRIGHTNESS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_color_control_v1
 * Sends an result event to the client owning the resource.
 * @param resource_ The client's resource
 * @param success 1 if the commit was successful, 0 otherwise.
 */
static inline void
treeland_output_color_control_v1_send_result(struct wl_resource *resource_, uint32_t success)
{
	wl_resource_post_event(resource_, TREELAND_OUTPUT_COLOR_CONTROL_V1_RESULT, success);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 * Sends an color_temperature event to the client owning the resource.
 * @param resource_ The client's resource
 * @param temperature current color temperature in Kelvin
 */
static inline void
treeland_output_color_control_v1_send_color_temperature(struct wl_resource *resource_, uint32_t temperature)
{
	wl_resource_post_event(resource_, TREELAND_OUTPUT_COLOR_CONTROL_V1_COLOR_TEMPERATURE, temperature);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 * Sends an brightness event to the client owning the resource.
 * @param resource_ The client's resource
 * @param brightness current brightness level (in range [0.0, 100.0])
 */
static inline void
treeland_output_color_control_v1_send_brightness(struct wl_resource *resource_, wl_fixed_t brightness)
{
	wl_resource_post_event(resource_, TREELAND_OUTPUT_COLOR_CONTROL_V1_BRIGHTNESS, brightness);
}

#ifdef  __cplusplus
}
#endif

#endif
