/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_SERVER_PROTOCOL_H
#define TREELAND_WINDOW_MANAGEMENT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_window_management_v1 The treeland_window_management_v1 protocol
 * @section page_ifaces_treeland_window_management_v1 Interfaces
 * - @subpage page_iface_treeland_window_management_v1 - application windows management
 * @section page_copyright_treeland_window_management_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_window_management_v1;

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_INTERFACE
#define TREELAND_WINDOW_MANAGEMENT_V1_INTERFACE
/**
 * @page page_iface_treeland_window_management_v1 treeland_window_management_v1
 * @section page_iface_treeland_window_management_v1_desc Description
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_treeland_window_management_v1_api API
 * See @ref iface_treeland_window_management_v1.
 */
/**
 * @defgroup iface_treeland_window_management_v1 The treeland_window_management_v1 interface
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface treeland_window_management_v1_interface;
#endif

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM
#define TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM
enum treeland_window_management_v1_desktop_state {
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_NORMAL = 0,
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_SHOW = 1,
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_PREVIEW_SHOW = 2,
};
#endif /* TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM */

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM_IS_VALID
#define TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_window_management_v1
 * Validate a treeland_window_management_v1 desktop_state value.
 *
 * @return true on success, false on error.
 * @ref treeland_window_management_v1_desktop_state
 */
static inline bool
treeland_window_management_v1_desktop_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_NORMAL:
		return version >= 1;
	case TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_SHOW:
		return version >= 1;
	case TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_PREVIEW_SHOW:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_window_management_v1
 * @struct treeland_window_management_v1_interface
 */
struct treeland_window_management_v1_interface {
	/**
	 * show/hide the desktop
	 *
	 * Tell the compositor to show/hide the desktop.
	 * @param state requested state
	 */
	void (*set_desktop)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t state);
	/**
	 * destroy the window manager object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_WINDOW_MANAGEMENT_V1_SHOW_DESKTOP 0

/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_SHOW_DESKTOP_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_SET_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_management_v1
 * Sends an show_desktop event to the client owning the resource.
 * @param resource_ The client's resource
 * @param state new state
 */
static inline void
treeland_window_management_v1_send_show_desktop(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, TREELAND_WINDOW_MANAGEMENT_V1_SHOW_DESKTOP, state);
}

#ifdef  __cplusplus
}
#endif

#endif
