// python wrapper for ttkTableDataSelector
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTableDataSelector.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTableDataSelector(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTableDataSelector_ClassNew(); }


static PyObject *
PyttkTableDataSelector_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTableDataSelector::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTableDataSelector::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTableDataSelector *tempr = ttkTableDataSelector::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTableDataSelector *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTableDataSelector::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTableDataSelector::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTableDataSelector::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkTableDataSelector::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_GetRangeId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetRangeId() :
      op->ttkTableDataSelector::GetRangeId());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_SetRangeId_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetRangeId(temp0, temp1);
    }
    else
    {
      op->ttkTableDataSelector::SetRangeId(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkTableDataSelector_SetRangeId_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetRangeId(temp0);
    }
    else
    {
      op->ttkTableDataSelector::SetRangeId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkTableDataSelector_SetRangeId(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyttkTableDataSelector_SetRangeId_s1(self, args);
    case 1:
      return PyttkTableDataSelector_SetRangeId_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetRangeId");
  return nullptr;
}


static PyObject *
PyttkTableDataSelector_AddCol(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddCol");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddCol(temp0);
    }
    else
    {
      op->ttkTableDataSelector::AddCol(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_ClearCols(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearCols");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearCols();
    }
    else
    {
      op->ttkTableDataSelector::ClearCols();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDataSelector_GetRangeIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDataSelector *op = static_cast<ttkTableDataSelector *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetRangeIds() :
      op->ttkTableDataSelector::GetRangeIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTableDataSelector_Methods[] = {
  {"IsTypeOf", PyttkTableDataSelector_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTableDataSelector_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTableDataSelector_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTableDataSelector\nC++: static ttkTableDataSelector *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTableDataSelector_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTableDataSelector\nC++: ttkTableDataSelector *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTableDataSelector_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTableDataSelector_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRegexpString", PyttkTableDataSelector_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRangeId", PyttkTableDataSelector_GetRangeId, METH_VARARGS,
   "GetRangeId(self) -> (int, int)\nC++: virtual int *GetRangeId()\n\n"},
  {"SetRangeId", PyttkTableDataSelector_SetRangeId, METH_VARARGS,
   "SetRangeId(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetRangeId(int _arg1, int _arg2)\nSetRangeId(self, _arg:(int, int)) -> None\nC++: void SetRangeId(const int _arg[2])\n\n"},
  {"AddCol", PyttkTableDataSelector_AddCol, METH_VARARGS,
   "AddCol(self, s:str) -> None\nC++: void AddCol(const std::string &s)\n\n"},
  {"ClearCols", PyttkTableDataSelector_ClearCols, METH_VARARGS,
   "ClearCols(self) -> None\nC++: void ClearCols()\n\n"},
  {"GetRangeIds", PyttkTableDataSelector_GetRangeIds, METH_VARARGS,
   "GetRangeIds(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetRangeIds()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTableDataSelector_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDataSelector_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDataSelector_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTableDataSelector_GetRangeId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDataSelector_SetRangeId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDataSelector_SetRangeId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRangeId/SetRangeId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTableDataSelector_GetRangeIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRangeIds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTableDataSelector_Doc =
  "ttkTableDataSelector - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\date\n"
  "September 2018\n\n"
  "TTK VTK-filter that selects scalar fields on input with shallow copy.\n\n"
  "\\param Input Input scalar field (vtkTable)\n"
  "\\param Output Output scalar field (vtkTable)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTableDataSelector_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTableDataSelector.ttkTableDataSelector", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTableDataSelector_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTableDataSelector_StaticNew()
{
  return ttkTableDataSelector::New();
}

PyObject *PyttkTableDataSelector_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTableDataSelector_Type, PyttkTableDataSelector_Methods,
    "ttkTableDataSelector",
 &PyttkTableDataSelector_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTableDataSelector_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTableDataSelector(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTableDataSelector_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTableDataSelector", o) != 0)
  {
    Py_DECREF(o);
  }

}

