//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gfx/PVRManagerChild.h"
#include "VRManagerChild.h"
#include "VRManagerParent.h"
#include "VRMessageUtils.h"
#include "gfxVR.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/GamepadMessageUtils.h"
#include "mozilla/gfx/2D.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "nsPoint.h"
#include "nsRect.h"

#include "mozilla/gfx/PVRLayerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gfx {


auto PVRManagerChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PVRManagerChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PVRManagerChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PVRManagerChild::PVRManagerChild() :
    mozilla::ipc::IToplevelProtocol("PVRManagerChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PVRManagerChild);
}

PVRManagerChild::~PVRManagerChild()
{
    MOZ_COUNT_DTOR(PVRManagerChild);
}

auto PVRManagerChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PVRManagerChild'");
    AddRef();
}

auto PVRManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PVRManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PVRManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PVRManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PVRManagerChild::ManagedPVRLayerChild(nsTArray<PVRLayerChild*>& aArr) const -> void
{
    mManagedPVRLayerChild.ToArray(aArr);
}

auto PVRManagerChild::ManagedPVRLayerChild() const -> const ManagedContainer<PVRLayerChild>&
{
    return mManagedPVRLayerChild;
}

auto PVRManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PVRLayerMsgStart
    };
    return sIds;
}

auto PVRManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PVRLayerMsgStart:
        return (&(mManagedPVRLayerChild));
    default:
        return nullptr;
    }
}

auto PVRManagerChild::OpenPVRLayerEndpoint(PVRLayerChild* aActor) -> ManagedEndpoint<PVRLayerParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PVRLayerChild actor");
        return ManagedEndpoint<PVRLayerParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PVRLayerChild actor");
        return ManagedEndpoint<PVRLayerParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PVRLayerParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PVRManagerChild::BindPVRLayerEndpoint(
        ManagedEndpoint<PVRLayerChild> aEndpoint,
        PVRLayerChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PVRManagerChild::SendPVRLayerConstructor(
        const uint32_t& aDisplayID,
        const uint32_t& aGroup) -> PVRLayerChild*
{
    PVRLayerChild* actor = (static_cast<VRManagerChild*>(this))->AllocPVRLayerChild(aDisplayID, aGroup);
    return SendPVRLayerConstructor(std::move(actor), std::move(aDisplayID), std::move(aGroup));
}

auto PVRManagerChild::SendPVRLayerConstructor(
        PVRLayerChild* actor,
        const uint32_t& aDisplayID,
        const uint32_t& aGroup) -> PVRLayerChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PVRLayerChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PVRLayerChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_PVRLayerConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aDisplayID);
    // Sentinel = 'aDisplayID'
    ((&(writer__)))->WriteSentinel(354812869);
    IPC::WriteParam((&(writer__)), aGroup);
    // Sentinel = 'aGroup'
    ((&(writer__)))->WriteSentinel(136184431);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_PVRLayerConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PVRLayerChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PVRManagerChild::SendDetectRuntimes() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_DetectRuntimes(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_DetectRuntimes", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendRefreshDisplays() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_RefreshDisplays(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_RefreshDisplays", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendSetGroupMask(
        const uint32_t& aDisplayID,
        const uint32_t& aGroupMask) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_SetGroupMask(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDisplayID);
    // Sentinel = 'aDisplayID'
    ((&(writer__)))->WriteSentinel(354812869);
    IPC::WriteParam((&(writer__)), aGroupMask);
    // Sentinel = 'aGroupMask'
    ((&(writer__)))->WriteSentinel(360842235);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_SetGroupMask", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendSetHaveEventListener(const bool& aHaveEventListener) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_SetHaveEventListener(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aHaveEventListener);
    // Sentinel = 'aHaveEventListener'
    ((&(writer__)))->WriteSentinel(1111164718);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_SetHaveEventListener", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendControllerListenerAdded() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_ControllerListenerAdded(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_ControllerListenerAdded", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendControllerListenerRemoved() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_ControllerListenerRemoved(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_ControllerListenerRemoved", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendVibrateHaptic(
        const GamepadHandle& aGamepadHandle,
        const uint32_t& aHapticIndex,
        const double& aIntensity,
        const double& aDuration,
        const uint32_t& aPromiseID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_VibrateHaptic(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aGamepadHandle);
    // Sentinel = 'aGamepadHandle'
    ((&(writer__)))->WriteSentinel(663618909);
    IPC::WriteParam((&(writer__)), aHapticIndex);
    // Sentinel = 'aHapticIndex'
    ((&(writer__)))->WriteSentinel(500040883);
    IPC::WriteParam((&(writer__)), aIntensity);
    // Sentinel = 'aIntensity'
    ((&(writer__)))->WriteSentinel(367854633);
    IPC::WriteParam((&(writer__)), aDuration);
    // Sentinel = 'aDuration'
    ((&(writer__)))->WriteSentinel(296551336);
    IPC::WriteParam((&(writer__)), aPromiseID);
    // Sentinel = 'aPromiseID'
    ((&(writer__)))->WriteSentinel(363398094);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_VibrateHaptic", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendStopVibrateHaptic(const GamepadHandle& aGamepadHandle) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_StopVibrateHaptic(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aGamepadHandle);
    // Sentinel = 'aGamepadHandle'
    ((&(writer__)))->WriteSentinel(663618909);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_StopVibrateHaptic", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendStartVRNavigation(const uint32_t& aDeviceID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_StartVRNavigation(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceID);
    // Sentinel = 'aDeviceID'
    ((&(writer__)))->WriteSentinel(280429375);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_StartVRNavigation", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendStopVRNavigation(
        const uint32_t& aDeviceID,
        const TimeDuration& aDuration) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_StopVRNavigation(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceID);
    // Sentinel = 'aDeviceID'
    ((&(writer__)))->WriteSentinel(280429375);
    IPC::WriteParam((&(writer__)), aDuration);
    // Sentinel = 'aDuration'
    ((&(writer__)))->WriteSentinel(296551336);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_StopVRNavigation", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendStartActivity() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_StartActivity(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_StartActivity", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendStopActivity() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_StopActivity(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_StopActivity", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendRunPuppet(mozilla::Span<uint64_t const> buffer) -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_RunPuppet(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), buffer);
    // Sentinel = 'buffer'
    ((&(writer__)))->WriteSentinel(144769659);


    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_RunPuppet", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::SendResetPuppet() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVRManager::Msg_ResetPuppet(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRManager::Msg_ResetPuppet", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVRManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PVRLayerMsgStart:
        static_cast<VRManagerChild*>(this)->DeallocPVRLayerChild(static_cast<PVRLayerChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PVRManagerChild::OnMessageReceived(const Message& msg__) -> PVRManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PVRManager::Reply_PVRLayerConstructor__ID:
        {
            return MsgProcessed;
        }
    case PVRManager::Msg_UpdateDisplayInfo__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRManager::Msg_UpdateDisplayInfo", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDisplayInfo = IPC::ReadParam<VRDisplayInfo>((&(reader__)));
            if (!maybe__aDisplayInfo) {
                FatalError("Error deserializing 'VRDisplayInfo'");
                return MsgValueError;

            }
            auto& aDisplayInfo = *maybe__aDisplayInfo;
            // Sentinel = 'aDisplayInfo'
            if ((!(((&(reader__)))->ReadSentinel(510198980)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VRDisplayInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<VRManagerChild*>(this))->RecvUpdateDisplayInfo(std::move(aDisplayInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRManager::Msg_UpdateRuntimeCapabilities__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRManager::Msg_UpdateRuntimeCapabilities", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aCapabilities = IPC::ReadParam<VRDisplayCapabilityFlags>((&(reader__)));
            if (!maybe__aCapabilities) {
                FatalError("Error deserializing 'VRDisplayCapabilityFlags'");
                return MsgValueError;

            }
            auto& aCapabilities = *maybe__aCapabilities;
            // Sentinel = 'aCapabilities'
            if ((!(((&(reader__)))->ReadSentinel(584975660)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VRDisplayCapabilityFlags'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<VRManagerChild*>(this))->RecvUpdateRuntimeCapabilities(std::move(aCapabilities));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRManager::Msg_ReplyGamepadVibrateHaptic__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRManager::Msg_ReplyGamepadVibrateHaptic", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseID = *maybe__aPromiseID;
            // Sentinel = 'aPromiseID'
            if ((!(((&(reader__)))->ReadSentinel(363398094)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<VRManagerChild*>(this))->RecvReplyGamepadVibrateHaptic(std::move(aPromiseID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRManager::Msg_NotifyPuppetCommandBufferCompleted__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRManager::Msg_NotifyPuppetCommandBufferCompleted", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSuccess = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aSuccess) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSuccess = *maybe__aSuccess;
            // Sentinel = 'aSuccess'
            if ((!(((&(reader__)))->ReadSentinel(236323643)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<VRManagerChild*>(this))->RecvNotifyPuppetCommandBufferCompleted(std::move(aSuccess));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRManager::Msg_NotifyPuppetResetComplete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRManager::Msg_NotifyPuppetResetComplete", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<VRManagerChild*>(this))->RecvNotifyPuppetResetComplete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PVRManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PVRManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace gfx
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gfx::PVRManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PVRManager'
    (aWriter)->WriteSentinel(322700212);
}

auto ParamTraits<::mozilla::gfx::PVRManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PVRManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PVRManager'
    if ((!((aReader)->ReadSentinel(322700212)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PVRManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PVRManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PVRManager)");

        return {};
    }
    return static_cast<::mozilla::gfx::PVRManagerChild*>(actor);
}

} // namespace IPC
