/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM MediaStreamTrackEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "MediaStreamTrackEvent.h"
#include "MediaStreamTrackEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/MediaStreamTrack.h"
#include "mozilla/dom/MediaStreamTrackEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(MediaStreamTrackEvent)

NS_IMPL_ADDREF_INHERITED(MediaStreamTrackEvent, Event)
NS_IMPL_RELEASE_INHERITED(MediaStreamTrackEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(MediaStreamTrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTrack)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(MediaStreamTrackEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(MediaStreamTrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTrack)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(MediaStreamTrackEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

MediaStreamTrackEvent::MediaStreamTrackEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

MediaStreamTrackEvent::~MediaStreamTrackEvent()
{
}

MediaStreamTrackEvent*
MediaStreamTrackEvent::AsMediaStreamTrackEvent()
{
  return this;
}

JSObject*
MediaStreamTrackEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return MediaStreamTrackEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<MediaStreamTrackEvent>
MediaStreamTrackEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const MediaStreamTrackEventInit& aEventInitDict)
{
  RefPtr<MediaStreamTrackEvent> e = new MediaStreamTrackEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mTrack = aEventInitDict.mTrack;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<MediaStreamTrackEvent>
MediaStreamTrackEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const MediaStreamTrackEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

MediaStreamTrack*
MediaStreamTrackEvent::Track() const
{
  return mTrack;
}


} // namespace mozilla::dom
