
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "cutterplugin_wrapper.h"

// Wrappers providing overrides
#include "cutterplugin_wrapper.h"

// Argument includes
#include <MainWindow.h>
#include <QString>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_CutterPlugin_Type = nullptr;
static PyTypeObject *Sbk_CutterPlugin_TypeF(void)
{
    return _Sbk_CutterPlugin_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void CutterPluginWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

CutterPluginWrapper::CutterPluginWrapper()
{
}

::QString CutterPluginWrapper::getAuthor() const
{
    static const char *funcName = "getAuthor";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        // Begin code injection
        // TEMPLATE - plugin_meta_get - START
        Shiboken::GilState cutterGil;
        SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
        PyObject *classObject = PyObject_GetAttrString(reinterpret_cast<PyObject *>(wrapper), "__class__");
        if (!classObject) {
        PyErr_Print();
        return QString();
        }
        PyObject *pyResult = PyObject_GetAttrString(classObject, "author");
        if (!pyResult) {
        PyErr_Print();
        return QString();
        }
        auto converter = Shiboken::Conversions::getConverter("str");
        if (!converter) {
            Shiboken::warning(PyExc_RuntimeWarning, 0, "Can't find converter for str.");
            return ::QString();
        }
        PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(converter, pyResult);
        if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 1, "Invalid return value for plugin metadata author, expected str, got %s.", Py_TYPE(pyResult)->tp_name);
        return ::QString();
        }
        QString cppResult;
        pythonToCpp(pyResult, &cppResult);
        return cppResult;
        // TEMPLATE - plugin_meta_get - END
        // End of code injection

        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getAuthor");
        return ::QString();
    }
    return sbk_o_getAuthor("CutterPlugin", funcName, gil, pyOverride);
}

::QString CutterPluginWrapper::sbk_o_getAuthor(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

::QString CutterPluginWrapper::getDescription() const
{
    static const char *funcName = "getDescription";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        // Begin code injection
        // TEMPLATE - plugin_meta_get - START
        Shiboken::GilState cutterGil;
        SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
        PyObject *classObject = PyObject_GetAttrString(reinterpret_cast<PyObject *>(wrapper), "__class__");
        if (!classObject) {
        PyErr_Print();
        return QString();
        }
        PyObject *pyResult = PyObject_GetAttrString(classObject, "description");
        if (!pyResult) {
        PyErr_Print();
        return QString();
        }
        auto converter = Shiboken::Conversions::getConverter("str");
        if (!converter) {
            Shiboken::warning(PyExc_RuntimeWarning, 0, "Can't find converter for str.");
            return ::QString();
        }
        PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(converter, pyResult);
        if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 1, "Invalid return value for plugin metadata description, expected str, got %s.", Py_TYPE(pyResult)->tp_name);
        return ::QString();
        }
        QString cppResult;
        pythonToCpp(pyResult, &cppResult);
        return cppResult;
        // TEMPLATE - plugin_meta_get - END
        // End of code injection

        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getDescription");
        return ::QString();
    }
    return sbk_o_getDescription("CutterPlugin", funcName, gil, pyOverride);
}

::QString CutterPluginWrapper::sbk_o_getDescription(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

::QString CutterPluginWrapper::getName() const
{
    static const char *funcName = "getName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        // Begin code injection
        // TEMPLATE - plugin_meta_get - START
        Shiboken::GilState cutterGil;
        SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
        PyObject *classObject = PyObject_GetAttrString(reinterpret_cast<PyObject *>(wrapper), "__class__");
        if (!classObject) {
        PyErr_Print();
        return QString();
        }
        PyObject *pyResult = PyObject_GetAttrString(classObject, "name");
        if (!pyResult) {
        PyErr_Print();
        return QString();
        }
        auto converter = Shiboken::Conversions::getConverter("str");
        if (!converter) {
            Shiboken::warning(PyExc_RuntimeWarning, 0, "Can't find converter for str.");
            return ::QString();
        }
        PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(converter, pyResult);
        if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 1, "Invalid return value for plugin metadata name, expected str, got %s.", Py_TYPE(pyResult)->tp_name);
        return ::QString();
        }
        QString cppResult;
        pythonToCpp(pyResult, &cppResult);
        return cppResult;
        // TEMPLATE - plugin_meta_get - END
        // End of code injection

        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getName");
        return ::QString();
    }
    return sbk_o_getName("CutterPlugin", funcName, gil, pyOverride);
}

::QString CutterPluginWrapper::sbk_o_getName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

::QString CutterPluginWrapper::getVersion() const
{
    static const char *funcName = "getVersion";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        // Begin code injection
        // TEMPLATE - plugin_meta_get - START
        Shiboken::GilState cutterGil;
        SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
        PyObject *classObject = PyObject_GetAttrString(reinterpret_cast<PyObject *>(wrapper), "__class__");
        if (!classObject) {
        PyErr_Print();
        return QString();
        }
        PyObject *pyResult = PyObject_GetAttrString(classObject, "version");
        if (!pyResult) {
        PyErr_Print();
        return QString();
        }
        auto converter = Shiboken::Conversions::getConverter("str");
        if (!converter) {
            Shiboken::warning(PyExc_RuntimeWarning, 0, "Can't find converter for str.");
            return ::QString();
        }
        PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(converter, pyResult);
        if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 1, "Invalid return value for plugin metadata version, expected str, got %s.", Py_TYPE(pyResult)->tp_name);
        return ::QString();
        }
        QString cppResult;
        pythonToCpp(pyResult, &cppResult);
        return cppResult;
        // TEMPLATE - plugin_meta_get - END
        // End of code injection

        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getVersion");
        return ::QString();
    }
    return sbk_o_getVersion("CutterPlugin", funcName, gil, pyOverride);
}

::QString CutterPluginWrapper::sbk_o_getVersion(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

void CutterPluginWrapper::registerDecompilers()
{
    static const char *funcName = "registerDecompilers";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::CutterPlugin::registerDecompilers();
    }
    sbk_o_registerDecompilers("CutterPlugin", funcName, gil, pyOverride);
}

void CutterPluginWrapper::sbk_o_registerDecompilers(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void CutterPluginWrapper::setupInterface(::MainWindow * main)
{
    static const char *funcName = "setupInterface";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.setupInterface");
        return;
    }
    sbk_o_setupInterface("CutterPlugin", funcName, gil, pyOverride, main);
}

void CutterPluginWrapper::sbk_o_setupInterface(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::MainWindow * main)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_MainWindow_IDX]), main)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_MainWindow_IDX]), main)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void CutterPluginWrapper::setupPlugin()
{
    static const char *funcName = "setupPlugin";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.setupPlugin");
        return;
    }
    CutterPluginWrapper::sbk_o_registerDecompilers("CutterPlugin", funcName, gil, pyOverride);
}

void CutterPluginWrapper::terminate()
{
    static const char *funcName = "terminate";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterPlugin_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::CutterPlugin::terminate();
    }
    CutterPluginWrapper::sbk_o_registerDecompilers("CutterPlugin", funcName, gil, pyOverride);
}

CutterPluginWrapper::~CutterPluginWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_CutterPlugin_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_CutterPlugin_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("CutterPlugin");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::CutterPlugin >()))
        return -1;

    CutterPluginWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // CutterPlugin()
        cptr = new CutterPluginWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< CutterPlugin >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_CutterPluginFunc_getAuthor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAuthor()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getAuthor");
            return {};
        }
        QString cppResult = const_cast<const ::CutterPlugin *>(cppSelf)->getAuthor();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterPluginFunc_getDescription(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getDescription()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getDescription");
            return {};
        }
        QString cppResult = const_cast<const ::CutterPlugin *>(cppSelf)->getDescription();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterPluginFunc_getName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getName()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getName");
            return {};
        }
        QString cppResult = const_cast<const ::CutterPlugin *>(cppSelf)->getName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterPluginFunc_getVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getVersion()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.getVersion");
            return {};
        }
        QString cppResult = const_cast<const ::CutterPlugin *>(cppSelf)->getVersion();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterPluginFunc_registerDecompilers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // registerDecompilers()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::CutterPlugin::registerDecompilers()
            : cppSelf->registerDecompilers();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterPluginFunc_setupInterface(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterPlugin::setupInterface(MainWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_MainWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setupInterface(MainWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setupInterface", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::MainWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setupInterface(MainWindow*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.setupInterface");
                return {};
            }
            cppSelf->setupInterface(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterPluginFunc_setupPlugin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setupPlugin()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("CutterPlugin.setupPlugin");
            return {};
        }
        cppSelf->setupPlugin();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterPluginFunc_terminate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // terminate()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::CutterPlugin::terminate()
            : cppSelf->terminate();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_CutterPlugin_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_CutterPlugin_methods[] = {
    {"getAuthor", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_getAuthor), METH_NOARGS, nullptr},
    {"getDescription", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_getDescription), METH_NOARGS, nullptr},
    {"getName", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_getName), METH_NOARGS, nullptr},
    {"getVersion", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_getVersion), METH_NOARGS, nullptr},
    {"registerDecompilers", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_registerDecompilers), METH_NOARGS, nullptr},
    {"setupInterface", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_setupInterface), METH_O, nullptr},
    {"setupPlugin", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_setupPlugin), METH_NOARGS, nullptr},
    {"terminate", reinterpret_cast<PyCFunction>(Sbk_CutterPluginFunc_terminate), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_CutterPlugin_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::CutterPlugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<CutterPluginWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_CutterPlugin_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_CutterPlugin_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_CutterPlugin_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_CutterPlugin_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_CutterPlugin_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_CutterPlugin_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_CutterPlugin_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_CutterPlugin_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_CutterPlugin_spec = {
    "1:CutterBindings.CutterPlugin",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_CutterPlugin_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void CutterPlugin_PythonToCpp_CutterPlugin_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_CutterPlugin_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_CutterPlugin_PythonToCpp_CutterPlugin_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_CutterPlugin_TypeF()))
        return CutterPlugin_PythonToCpp_CutterPlugin_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *CutterPlugin_PTR_CppToPython_CutterPlugin(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_CutterPlugin_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::CutterPlugin *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_CutterPlugin_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *CutterPlugin_SignatureStrings[] = {
    "CutterBindings.CutterPlugin(self)",
    "CutterBindings.CutterPlugin.getAuthor(self)->QString",
    "CutterBindings.CutterPlugin.getDescription(self)->QString",
    "CutterBindings.CutterPlugin.getName(self)->QString",
    "CutterBindings.CutterPlugin.getVersion(self)->QString",
    "CutterBindings.CutterPlugin.registerDecompilers(self)",
    "CutterBindings.CutterPlugin.setupInterface(self,main:CutterBindings.MainWindow)",
    "CutterBindings.CutterPlugin.setupPlugin(self)",
    "CutterBindings.CutterPlugin.terminate(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t CutterPlugin_SignatureByteSize = 151;
static constexpr uint8_t CutterPlugin_SignatureBytes[151] = {
    0x78, 0xda, 0x95, 0x51, 0x41, 0x0a, 0x02, 0x31, 0x0c, 0xbc, 0xef, 0x4b, 0x14, 0x74, 0x1f, 0xe0,
    0x41, 0xd0, 0xee, 0xc5, 0x83, 0xb2, 0x22, 0xe8, 0xb9, 0xd4, 0x6c, 0x0d, 0xb4, 0x69, 0x69, 0x53,
    0xfc, 0xbe, 0xc1, 0xf5, 0x24, 0x88, 0xed, 0x2d, 0x33, 0xcc, 0x4c, 0xc2, 0x44, 0x15, 0x66, 0x48,
    0x7b, 0xa4, 0x3b, 0x92, 0xcd, 0xbd, 0x7a, 0xc3, 0xd1, 0x15, 0x8b, 0xb4, 0xc8, 0xe0, 0xa6, 0x65,
    0xa7, 0x7e, 0x2b, 0x7a, 0x0b, 0xbc, 0x2b, 0xfc, 0x08, 0x69, 0xd6, 0xae, 0xb7, 0xe7, 0x0b, 0x27,
    0x91, 0xfd, 0x33, 0x0d, 0x90, 0x4d, 0xc2, 0xc8, 0x18, 0xa8, 0xd1, 0x79, 0xd2, 0x1e, 0x1a, 0x2d,
    0x57, 0x48, 0xb9, 0x71, 0x51, 0x02, 0x8b, 0x59, 0xe0, 0x00, 0x26, 0xf8, 0x88, 0x4e, 0x12, 0x2a,
    0xda, 0xc8, 0xc0, 0x25, 0x1e, 0x48, 0x88, 0x49, 0x9b, 0xf9, 0xca, 0x95, 0xd7, 0x48, 0x9b, 0x2f,
    0xd3, 0x51, 0xb8, 0x9b, 0x80, 0xf0, 0xac, 0xc8, 0xab, 0xfe, 0x85, 0x4c, 0x1e, 0x49, 0xf3, 0xa7,
    0x9e, 0xee, 0x05, 0x21, 0xc4, 0xb3, 0x2b
};
#endif

PyTypeObject *init_CutterPlugin(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX].type;

    Shiboken::AutoDecRef Sbk_CutterPlugin_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_CutterPlugin_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "CutterPlugin",
        "CutterPlugin*",
        &Sbk_CutterPlugin_spec,
        &Shiboken::callCppDestructor< CutterPlugin >,
        Sbk_CutterPlugin_Type_bases.object(),
        0);
    auto *pyType = _Sbk_CutterPlugin_Type; // references _Sbk_CutterPlugin_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, CutterPlugin_SignatureStrings);
#else
    InitSignatureBytes(pyType, CutterPlugin_SignatureBytes, CutterPlugin_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_CutterPlugin_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_CutterPlugin_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        CutterPlugin_PythonToCpp_CutterPlugin_PTR,
        is_CutterPlugin_PythonToCpp_CutterPlugin_PTR_Convertible,
        CutterPlugin_PTR_CppToPython_CutterPlugin);

    Shiboken::Conversions::registerConverterName(converter, "CutterPlugin");
    Shiboken::Conversions::registerConverterName(converter, "CutterPlugin*");
    Shiboken::Conversions::registerConverterName(converter, "CutterPlugin&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::CutterPlugin).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(CutterPluginWrapper).name());

    qRegisterMetaType< ::CutterPlugin *>();

    return pyType;
}
