/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextctrl.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextctrl.h>
        #include <wx/menu.h>


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_Init, "Init() -> None\n"
"\n"
"Initialisation.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Init(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_Init, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddItem, "AddItem(label, obj) -> bool\n"
"\n"
"Adds an item.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* label;
        int labelState = 0;
        ::wxRichTextObject* obj;
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J8", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxString, &label, &labelState, sipType_wxRichTextObject, &obj))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddItem(*label, obj);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(label), sipType_wxString, labelState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddItem, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddMenuItems, "AddMenuItems(menu, startCmd=ID_RICHTEXT_PROPERTIES1) -> int\n"
"\n"
"Returns the number of menu items that were added.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxMenu* menu;
        int startCmd = wxID_RICHTEXT_PROPERTIES1;
        const ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
            sipName_startCmd,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|i", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxMenu, &menu, &startCmd))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddMenuItems(menu, startCmd);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddMenuItems, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_AddItems, "AddItems(ctrl, container, obj) -> int\n"
"\n"
"Adds appropriate menu items for the current container and clicked on\n"
"object (and container's parent, if appropriate).");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItems(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_AddItems(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextCtrl* ctrl;
        ::wxRichTextObject* container;
        ::wxRichTextObject* obj;
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ctrl,
            sipName_container,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J8", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, sipType_wxRichTextCtrl, &ctrl, sipType_wxRichTextObject, &container, sipType_wxRichTextObject, &obj))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddItems(ctrl, container, obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_AddItems, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_Clear, "Clear() -> None\n"
"\n"
"Clears the items.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetLabel, "GetLabel(n) -> str\n"
"\n"
"Returns the nth label.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        const ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, &n))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetLabel(n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetObject, "GetObject(n) -> RichTextObject\n"
"\n"
"Returns the nth object.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int n;
        const ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp, &n))
        {
            ::wxRichTextObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetObject(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxRichTextObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetObjects, "GetObjects() -> RichTextObjectPtrArray\n"
"\n"
"Returns the array of objects.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObjects(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetObjects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            ::wxRichTextObjectPtrArray*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetObjects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxRichTextObjectPtrArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetObjects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetLabels, "GetLabels() -> List[str]\n"
"\n"
"Returns the array of labels.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabels(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetLabels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLabels();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetLabels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo_GetCount, "GetCount() -> int\n"
"\n"
"Returns the number of items.");

extern "C" {static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextContextMenuPropertiesInfo_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextContextMenuPropertiesInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextContextMenuPropertiesInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextContextMenuPropertiesInfo, sipName_GetCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextContextMenuPropertiesInfo(void *, int);}
static void release_wxRichTextContextMenuPropertiesInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextContextMenuPropertiesInfo(Py_ssize_t);}
static void *array_wxRichTextContextMenuPropertiesInfo(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextContextMenuPropertiesInfo[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextContextMenuPropertiesInfo(void *);}
static void array_delete_wxRichTextContextMenuPropertiesInfo(void *sipCpp)
{
    delete[] reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipCpp);
}


extern "C" {static void assign_wxRichTextContextMenuPropertiesInfo(void *, Py_ssize_t, void *);}
static void assign_wxRichTextContextMenuPropertiesInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextContextMenuPropertiesInfo(const void *, Py_ssize_t);}
static void *copy_wxRichTextContextMenuPropertiesInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextContextMenuPropertiesInfo(reinterpret_cast<const ::wxRichTextContextMenuPropertiesInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *);}
static void dealloc_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextContextMenuPropertiesInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextContextMenuPropertiesInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxRichTextContextMenuPropertiesInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextContextMenuPropertiesInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxRichTextContextMenuPropertiesInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxRichTextContextMenuPropertiesInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextContextMenuPropertiesInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxRichTextContextMenuPropertiesInfo[] = {
    {sipName_AddItem, SIP_MLMETH_CAST(meth_wxRichTextContextMenuPropertiesInfo_AddItem), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextContextMenuPropertiesInfo_AddItem},
    {sipName_AddItems, SIP_MLMETH_CAST(meth_wxRichTextContextMenuPropertiesInfo_AddItems), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextContextMenuPropertiesInfo_AddItems},
    {sipName_AddMenuItems, SIP_MLMETH_CAST(meth_wxRichTextContextMenuPropertiesInfo_AddMenuItems), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextContextMenuPropertiesInfo_AddMenuItems},
    {sipName_Clear, meth_wxRichTextContextMenuPropertiesInfo_Clear, METH_VARARGS, doc_wxRichTextContextMenuPropertiesInfo_Clear},
    {sipName_GetCount, meth_wxRichTextContextMenuPropertiesInfo_GetCount, METH_VARARGS, doc_wxRichTextContextMenuPropertiesInfo_GetCount},
    {sipName_GetLabel, SIP_MLMETH_CAST(meth_wxRichTextContextMenuPropertiesInfo_GetLabel), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextContextMenuPropertiesInfo_GetLabel},
    {sipName_GetLabels, meth_wxRichTextContextMenuPropertiesInfo_GetLabels, METH_VARARGS, doc_wxRichTextContextMenuPropertiesInfo_GetLabels},
    {sipName_GetObject, SIP_MLMETH_CAST(meth_wxRichTextContextMenuPropertiesInfo_GetObject), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextContextMenuPropertiesInfo_GetObject},
    {sipName_GetObjects, meth_wxRichTextContextMenuPropertiesInfo_GetObjects, METH_VARARGS, doc_wxRichTextContextMenuPropertiesInfo_GetObjects},
    {sipName_Init, meth_wxRichTextContextMenuPropertiesInfo_Init, METH_VARARGS, doc_wxRichTextContextMenuPropertiesInfo_Init}
};


extern "C" {static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_labels(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_labels(void *sipSelf, PyObject *, PyObject *)
{
    ::wxArrayString*sipVal;
    ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    sipVal = &sipCpp->m_labels;

    return sipConvertFromType(sipVal, sipType_wxArrayString, SIP_NULLPTR);
}


extern "C" {static int varset_wxRichTextContextMenuPropertiesInfo_m_labels(void *, PyObject *, PyObject *);}
static int varset_wxRichTextContextMenuPropertiesInfo_m_labels(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxArrayString*sipVal;
    ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast<::wxArrayString *>(sipForceConvertToType(sipPy, sipType_wxArrayString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_labels = *sipVal;

    sipReleaseType(sipVal, sipType_wxArrayString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_objects(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRichTextContextMenuPropertiesInfo_m_objects(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
    ::wxRichTextObjectPtrArray*sipVal;
    ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -2);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_objects;

    sipPy = sipConvertFromType(sipVal, sipType_wxRichTextObjectPtrArray, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -1, sipPySelf);
        sipKeepReference(sipPySelf, -2, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxRichTextContextMenuPropertiesInfo_m_objects(void *, PyObject *, PyObject *);}
static int varset_wxRichTextContextMenuPropertiesInfo_m_objects(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxRichTextObjectPtrArray*sipVal;
    ::wxRichTextContextMenuPropertiesInfo *sipCpp = reinterpret_cast<::wxRichTextContextMenuPropertiesInfo *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast<::wxRichTextObjectPtrArray *>(sipForceConvertToType(sipPy, sipType_wxRichTextObjectPtrArray, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_objects = *sipVal;

    return 0;
}

sipVariableDef variables_wxRichTextContextMenuPropertiesInfo[] = {
    {PropertyVariable, sipName_Objects, &methods_wxRichTextContextMenuPropertiesInfo[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Labels, &methods_wxRichTextContextMenuPropertiesInfo[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Count, &methods_wxRichTextContextMenuPropertiesInfo[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_labels, (PyMethodDef *)varget_wxRichTextContextMenuPropertiesInfo_m_labels, (PyMethodDef *)varset_wxRichTextContextMenuPropertiesInfo_m_labels, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_objects, (PyMethodDef *)varget_wxRichTextContextMenuPropertiesInfo_m_objects, (PyMethodDef *)varset_wxRichTextContextMenuPropertiesInfo_m_objects, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextContextMenuPropertiesInfo, "RichTextContextMenuPropertiesInfo() -> None\n"
"\n"
"wxRichTextContextMenuPropertiesInfo keeps track of objects that appear\n"
"in the context menu, whose properties are available to be edited.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextContextMenuPropertiesInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextContextMenuPropertiesInfo,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextContextMenuPropertiesInfo,
        {0, 0, 1},
        10, methods_wxRichTextContextMenuPropertiesInfo,
        0, SIP_NULLPTR,
        5, variables_wxRichTextContextMenuPropertiesInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextContextMenuPropertiesInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxRichTextContextMenuPropertiesInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextContextMenuPropertiesInfo,
    assign_wxRichTextContextMenuPropertiesInfo,
    array_wxRichTextContextMenuPropertiesInfo,
    copy_wxRichTextContextMenuPropertiesInfo,
    release_wxRichTextContextMenuPropertiesInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextContextMenuPropertiesInfo,
    sizeof (::wxRichTextContextMenuPropertiesInfo),
};
