// python wrapper for vtkSMTimeKeeper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMTimeKeeper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTimeKeeper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTimeKeeper_ClassNew(); }


static PyObject *
PyvtkSMTimeKeeper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTimeKeeper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTimeKeeper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTimeKeeper *tempr = vtkSMTimeKeeper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTimeKeeper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTimeKeeper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTimeKeeper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTimeKeeper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_SetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTime(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::SetTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_GetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTime() :
      op->vtkSMTimeKeeper::GetTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_AddView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->AddView(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::AddView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_RemoveView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveView(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::RemoveView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_RemoveAllViews(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllViews();
    }
    else
    {
      op->vtkSMTimeKeeper::RemoveAllViews();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_AddTimeSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    if (ap.IsBound())
    {
      op->AddTimeSource(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::AddTimeSource(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_RemoveTimeSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTimeSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveTimeSource(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::RemoveTimeSource(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_RemoveAllTimeSources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllTimeSources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllTimeSources();
    }
    else
    {
      op->vtkSMTimeKeeper::RemoveAllTimeSources();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_AddSuppressedTimeSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddSuppressedTimeSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    if (ap.IsBound())
    {
      op->AddSuppressedTimeSource(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::AddSuppressedTimeSource(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_RemoveSuppressedTimeSource(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveSuppressedTimeSource");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveSuppressedTimeSource(temp0);
    }
    else
    {
      op->vtkSMTimeKeeper::RemoveSuppressedTimeSource(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTimeKeeper_UpdateTimeInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateTimeInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTimeKeeper *op = static_cast<vtkSMTimeKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateTimeInformation();
    }
    else
    {
      op->vtkSMTimeKeeper::UpdateTimeInformation();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTimeKeeper_Methods[] = {
  {"IsTypeOf", PyvtkSMTimeKeeper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTimeKeeper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTimeKeeper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTimeKeeper\nC++: static vtkSMTimeKeeper *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTimeKeeper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTimeKeeper\nC++: vtkSMTimeKeeper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTimeKeeper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTimeKeeper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTime", PyvtkSMTimeKeeper_SetTime, METH_VARARGS,
   "SetTime(self, time:float) -> None\nC++: void SetTime(double time)\n\nGet/Set the pipeline time.\n"},
  {"GetTime", PyvtkSMTimeKeeper_GetTime, METH_VARARGS,
   "GetTime(self) -> float\nC++: virtual double GetTime()\n\n"},
  {"AddView", PyvtkSMTimeKeeper_AddView, METH_VARARGS,
   "AddView(self, __a:vtkSMProxy) -> None\nC++: void AddView(vtkSMProxy *)\n\nAdd/Remove view proxy linked to this time keeper.\n"},
  {"RemoveView", PyvtkSMTimeKeeper_RemoveView, METH_VARARGS,
   "RemoveView(self, __a:vtkSMProxy) -> None\nC++: void RemoveView(vtkSMProxy *)\n\n"},
  {"RemoveAllViews", PyvtkSMTimeKeeper_RemoveAllViews, METH_VARARGS,
   "RemoveAllViews(self) -> None\nC++: void RemoveAllViews()\n\n"},
  {"AddTimeSource", PyvtkSMTimeKeeper_AddTimeSource, METH_VARARGS,
   "AddTimeSource(self, __a:vtkSMSourceProxy) -> None\nC++: void AddTimeSource(vtkSMSourceProxy *)\n\nList of proxies that provide time. TimestepValues property has a\nset of timesteps provided by all the sources added to this\nproperty alone.\n"},
  {"RemoveTimeSource", PyvtkSMTimeKeeper_RemoveTimeSource, METH_VARARGS,
   "RemoveTimeSource(self, __a:vtkSMSourceProxy) -> None\nC++: void RemoveTimeSource(vtkSMSourceProxy *)\n\n"},
  {"RemoveAllTimeSources", PyvtkSMTimeKeeper_RemoveAllTimeSources, METH_VARARGS,
   "RemoveAllTimeSources(self) -> None\nC++: void RemoveAllTimeSources()\n\n"},
  {"AddSuppressedTimeSource", PyvtkSMTimeKeeper_AddSuppressedTimeSource, METH_VARARGS,
   "AddSuppressedTimeSource(self, __a:vtkSMSourceProxy) -> None\nC++: void AddSuppressedTimeSource(vtkSMSourceProxy *)\n\nList of proxies that provide time. TimestepValues property has a\nset of timesteps provided by all the sources added to this\nproperty alone.\n"},
  {"RemoveSuppressedTimeSource", PyvtkSMTimeKeeper_RemoveSuppressedTimeSource, METH_VARARGS,
   "RemoveSuppressedTimeSource(self, __a:vtkSMSourceProxy) -> None\nC++: void RemoveSuppressedTimeSource(vtkSMSourceProxy *)\n\n"},
  {"UpdateTimeInformation", PyvtkSMTimeKeeper_UpdateTimeInformation, METH_VARARGS,
   "UpdateTimeInformation(self) -> None\nC++: void UpdateTimeInformation()\n\nIterates over all sources providing time and calls\n`vtkSMSourceProxy::UpdatePipelineInformation` on them. That\nensures that timekeeper is using the latest time information\navailable to it.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTimeKeeper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTimeKeeper_GetTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTimeKeeper_SetTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTimeKeeper_SetTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTime/SetTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTimeKeeper_Doc =
  "vtkSMTimeKeeper - a time keeper is used to keep track of the pipeline\ntime.\n\n"
  "Superclass: vtkObject\n\n"
  "TimeKeeper can be thought of as a application wide clock. In\n"
  "ParaView, all views are registered with the TimeKeeper (using\n"
  "AddView()) so that all the views render data at the same global time.\n\n"
  "TimeKeeper also keeps track of time steps and continuous time ranges\n"
  "provided by sources/readers/filters. This expects that the readers\n"
  "have a \"TimestepValues\" and/or \"TimeRange\" properties from which the\n"
  "time steps and time ranges provided by the reader can be obtained.\n"
  "All sources whose time steps/time ranges must be noted by the time\n"
  "keeper need to be registered with the time keeper using\n"
  "AddTimeSource(). ParaView automatically registers all created\n"
  "sources/filters/readers with the time keeper. The time steps and time\n"
  "ranges are made accessible by two information properties\n"
  "\"TimestepValues\" and \"TimeRange\" on the TimeKeeper proxy.\n\n"
  "To change the time shown by all the views, simply change the \"Time\"\n"
  "property on the time keeper proxy (don't directly call SetTime()\n"
  "since otherwise undo/redo, state etc. will not work as expected).\n\n"
  "This proxy has no VTK objects that it creates on the server.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTimeKeeper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMTimeKeeper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTimeKeeper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTimeKeeper_StaticNew()
{
  return vtkSMTimeKeeper::New();
}

PyObject *PyvtkSMTimeKeeper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTimeKeeper_Type, PyvtkSMTimeKeeper_Methods,
    "vtkSMTimeKeeper",
 &PyvtkSMTimeKeeper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTimeKeeper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTimeKeeper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTimeKeeper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTimeKeeper", o) != 0)
  {
    Py_DECREF(o);
  }

}

