#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkDistributedPointCloudFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPExtractGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPExtractRectilinearGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPExtractVOI_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredImplicitConnectivity_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersParallelMPICS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkDistributedPointCloudFilter_Init(csi);
  vtkPExtractGrid_Init(csi);
  vtkPExtractRectilinearGrid_Init(csi);
  vtkPExtractVOI_Init(csi);
  vtkStructuredImplicitConnectivity_Init(csi);
}
