/* App.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from App.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2013-2014 Akshay Shekher
 *           2011-2012 Giulio Collura
 *           2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <granite.h>

#define SLINGSHOT_BACKEND_APP_ACTION_PREFIX SLINGSHOT_BACKEND_APP_ACTION_GROUP_PREFIX "."
#define SLINGSHOT_BACKEND_APP_APP_ACTION "action.%s"
#define SLINGSHOT_BACKEND_APP_PINNED_ACTION "pinned"
#define SLINGSHOT_BACKEND_APP_SWITCHEROO_ACTION "switcheroo"
#define SLINGSHOT_BACKEND_APP_UNINSTALL_ACTION "uninstall"
#define SLINGSHOT_BACKEND_APP_VIEW_ACTION "view-in-appcenter"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_APP_0_PROPERTY,
	SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY,
	SLINGSHOT_BACKEND_APP_NAME_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY,
	SLINGSHOT_BACKEND_APP_EXEC_PROPERTY,
	SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY,
	SLINGSHOT_BACKEND_APP_ICON_PROPERTY,
	SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY,
	SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY,
	SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY,
	SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY,
	SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY,
	SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY,
	SLINGSHOT_BACKEND_APP_MATCH_PROPERTY,
	SLINGSHOT_BACKEND_APP_TARGET_PROPERTY,
	SLINGSHOT_BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _SlingshotBackendAppOnAppcenterDbusChangedData SlingshotBackendAppOnAppcenterDbusChangedData;
enum  {
	SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_BACKEND_APP_START_SEARCH_SIGNAL,
	SLINGSHOT_BACKEND_APP_NUM_SIGNALS
};
static guint slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_NUM_SIGNALS] = {0};

struct _SlingshotBackendAppPrivate {
	GSimpleActionGroup* _action_group;
	gchar* _name;
	gchar* _description;
	gchar* _desktop_id;
	gchar* _exec;
	gchar** _keywords;
	gint _keywords_length1;
	gint __keywords_size_;
	GIcon* _icon;
	gdouble _popularity;
	gchar* _desktop_path;
	gchar* _categories;
	gchar* _generic_name;
	gboolean _prefers_default_gpu;
	SlingshotBackendAppAppType _app_type;
	gchar* unity_sender_name;
	gboolean _count_visible;
	gint64 _current_count;
	SynapseMatch* _match;
	SynapseMatch* _target;
	SlingshotBackendSwitcherooControl* switcheroo_control;
	GSimpleAction* pinned_action;
	GSimpleAction* uninstall_action;
	GSimpleAction* view_action;
	gboolean has_system_item;
	gchar* appstream_comp_id;
};

struct _Block3Data {
	int _ref_count_;
	SlingshotBackendApp* self;
	GDesktopAppInfo* app_info;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	const gchar* action;
};

struct _Block5Data {
	int _ref_count_;
	Block3Data * _data3_;
	gboolean prefers_non_default_gpu;
};

struct _Block6Data {
	int _ref_count_;
	Block3Data * _data3_;
	SlingshotBackendDock* dock;
};

struct _Block7Data {
	int _ref_count_;
	Block3Data * _data3_;
	SlingshotBackendAppCenter* appcenter;
};

struct _Block8Data {
	int _ref_count_;
	SlingshotBackendApp* self;
	SlingshotBackendAppCenter* appcenter;
};

struct _SlingshotBackendAppOnAppcenterDbusChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotBackendApp* self;
	SlingshotBackendAppCenter* appcenter;
	AppCenterDBus* _tmp0_;
	AppCenterDBus* _tmp1_;
	gchar* _tmp2_;
	AppCenterDBus* _tmp3_;
	AppCenterDBus* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* e;
	gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GSimpleAction* _tmp12_;
	const gchar* _tmp13_;
	GSimpleAction* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

static gint SlingshotBackendApp_private_offset;
static gpointer slingshot_backend_app_parent_class = NULL;

static void slingshot_backend_app_set_app_type (SlingshotBackendApp* self,
                                         SlingshotBackendAppAppType value);
static void slingshot_backend_app_set_description (SlingshotBackendApp* self,
                                            const gchar* value);
static void slingshot_backend_app_set_exec (SlingshotBackendApp* self,
                                     const gchar* value);
static void slingshot_backend_app_set_desktop_path (SlingshotBackendApp* self,
                                             const gchar* value);
static void slingshot_backend_app_set_keywords (SlingshotBackendApp* self,
                                         gchar** value,
                                         gint value_length1);
static void slingshot_backend_app_set_categories (SlingshotBackendApp* self,
                                           const gchar* value);
static void slingshot_backend_app_set_generic_name (SlingshotBackendApp* self,
                                             const gchar* value);
static void slingshot_backend_app_set_prefers_default_gpu (SlingshotBackendApp* self,
                                                    gboolean value);
static void slingshot_backend_app_set_icon (SlingshotBackendApp* self,
                                     GIcon* value);
static void slingshot_backend_app_set_match (SlingshotBackendApp* self,
                                      SynapseMatch* value);
static void slingshot_backend_app_set_target (SlingshotBackendApp* self,
                                       SynapseMatch* value);
static void slingshot_backend_app_set_current_count (SlingshotBackendApp* self,
                                              gint64 value);
static void slingshot_backend_app_set_count_visible (SlingshotBackendApp* self,
                                              gboolean value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void slingshot_backend_app_set_action_group (SlingshotBackendApp* self,
                                             GSimpleActionGroup* value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda23_ (Block4Data* _data4_);
static void _____lambda23__g_simple_action_activate (GSimpleAction* _sender,
                                              GVariant* parameter,
                                              gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda24_ (Block5Data* _data5_);
static void ____lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void slingshot_backend_app_pinned_action_change_state (SlingshotBackendApp* self,
                                                       GVariant* value);
static void _slingshot_backend_app_pinned_action_change_state_g_simple_action_change_state (GSimpleAction* _sender,
                                                                                     GVariant* value,
                                                                                     gpointer self);
static void ___lambda29_ (Block6Data* _data6_);
static void slingshot_backend_app_on_dock_dbus_changed (SlingshotBackendApp* self,
                                                 SlingshotBackendDock* dock);
static void ____lambda29__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void slingshot_backend_app_action_uninstall (SlingshotBackendApp* self);
static void _slingshot_backend_app_action_uninstall_g_simple_action_activate (GSimpleAction* _sender,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void slingshot_backend_app_open_in_appcenter (SlingshotBackendApp* self);
static void _slingshot_backend_app_open_in_appcenter_g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void ___lambda35_ (Block7Data* _data7_);
static void slingshot_backend_app_on_appcenter_dbus_changed (SlingshotBackendApp* self,
                                                      SlingshotBackendAppCenter* appcenter,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void slingshot_backend_app_on_appcenter_dbus_changed_finish (SlingshotBackendApp* self,
                                                             GAsyncResult* _res_);
static void ____lambda35__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda33_ (Block8Data* _data8_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda34_ (SlingshotBackendApp* self,
                  GObject* obj,
                  GAsyncResult* res);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ___lambda34__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_backend_app_on_appcenter_dbus_changed_data_free (gpointer _data);
static gboolean slingshot_backend_app_on_appcenter_dbus_changed_co (SlingshotBackendAppOnAppcenterDbusChangedData* _data_);
static void slingshot_backend_app_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * slingshot_backend_app_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void slingshot_backend_app_finalize (GObject * obj);
static GType slingshot_backend_app_get_type_once (void);
static void _vala_slingshot_backend_app_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_slingshot_backend_app_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_backend_app_get_instance_private (SlingshotBackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendApp_private_offset);
}

static GType
slingshot_backend_app_app_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SLINGSHOT_BACKEND_APP_APP_TYPE_APP, "SLINGSHOT_BACKEND_APP_APP_TYPE_APP", "app"}, {SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND, "SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND", "command"}, {SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE, "SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE", "synapse"}, {0, NULL, NULL}};
	GType slingshot_backend_app_app_type_type_id;
	slingshot_backend_app_app_type_type_id = g_enum_register_static ("SlingshotBackendAppAppType", values);
	return slingshot_backend_app_app_type_type_id;
}

GType
slingshot_backend_app_app_type_get_type (void)
{
	static volatile gsize slingshot_backend_app_app_type_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_app_app_type_type_id__once)) {
		GType slingshot_backend_app_app_type_type_id;
		slingshot_backend_app_app_type_type_id = slingshot_backend_app_app_type_get_type_once ();
		g_once_init_leave (&slingshot_backend_app_app_type_type_id__once, slingshot_backend_app_app_type_type_id);
	}
	return slingshot_backend_app_app_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SlingshotBackendApp*
slingshot_backend_app_construct (GType object_type,
                                 GDesktopAppInfo* info)
{
	SlingshotBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GIcon* desktop_icon = NULL;
	GIcon* _tmp11_;
	GIcon* _tmp12_;
	GIcon* _tmp13_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_APP);
	_tmp0_ = g_app_info_get_display_name ((GAppInfo*) info);
	slingshot_backend_app_set_name (self, _tmp0_);
	_tmp2_ = g_app_info_get_description ((GAppInfo*) info);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_name;
		_tmp1_ = _tmp3_;
	}
	slingshot_backend_app_set_description (self, _tmp1_);
	_tmp4_ = g_app_info_get_commandline ((GAppInfo*) info);
	slingshot_backend_app_set_exec (self, _tmp4_);
	_tmp5_ = g_app_info_get_id ((GAppInfo*) info);
	slingshot_backend_app_set_desktop_id (self, _tmp5_);
	_tmp6_ = g_desktop_app_info_get_filename (info);
	slingshot_backend_app_set_desktop_path (self, _tmp6_);
	_tmp8_ = _tmp7_ = g_desktop_app_info_get_keywords (info);
	slingshot_backend_app_set_keywords (self, _tmp8_, _vala_array_length (_tmp7_));
	_tmp9_ = g_desktop_app_info_get_categories (info);
	slingshot_backend_app_set_categories (self, _tmp9_);
	_tmp10_ = g_desktop_app_info_get_generic_name (info);
	slingshot_backend_app_set_generic_name (self, _tmp10_);
	slingshot_backend_app_set_prefers_default_gpu (self, !g_desktop_app_info_get_boolean (info, "PrefersNonDefaultGPU"));
	_tmp11_ = g_app_info_get_icon ((GAppInfo*) info);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	desktop_icon = _tmp12_;
	_tmp13_ = desktop_icon;
	if (_tmp13_ != NULL) {
		GIcon* _tmp14_;
		_tmp14_ = desktop_icon;
		slingshot_backend_app_set_icon (self, _tmp14_);
	}
	_g_object_unref0 (desktop_icon);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new (GDesktopAppInfo* info)
{
	return slingshot_backend_app_construct (SLINGSHOT_BACKEND_TYPE_APP, info);
}

SlingshotBackendApp*
slingshot_backend_app_construct_from_command (GType object_type,
                                              const gchar* command)
{
	SlingshotBackendApp * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	g_return_val_if_fail (command != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND);
	slingshot_backend_app_set_name (self, command);
	slingshot_backend_app_set_description (self, _ ("Run this command…"));
	slingshot_backend_app_set_exec (self, command);
	slingshot_backend_app_set_desktop_id (self, command);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-run");
	_tmp1_ = _tmp0_;
	slingshot_backend_app_set_icon (self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new_from_command (const gchar* command)
{
	return slingshot_backend_app_construct_from_command (SLINGSHOT_BACKEND_TYPE_APP, command);
}

SlingshotBackendApp*
slingshot_backend_app_construct_from_synapse_match (GType object_type,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SlingshotBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	SynapseMatchType _tmp5_;
	SynapseMatchType _tmp6_;
	g_return_val_if_fail (match != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE);
	_tmp0_ = synapse_match_get_title (match);
	_tmp1_ = _tmp0_;
	slingshot_backend_app_set_name (self, _tmp1_);
	_tmp2_ = synapse_match_get_description (match);
	_tmp3_ = _tmp2_;
	slingshot_backend_app_set_description (self, _tmp3_);
	_tmp5_ = synapse_match_get_match_type (match);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == SYNAPSE_MATCH_TYPE_CONTACT) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = synapse_match_get_has_thumbnail (match);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GFile* file = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFileIcon* _tmp13_;
		GFileIcon* _tmp14_;
		_tmp9_ = synapse_match_get_thumbnail_path (match);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_new_for_path (_tmp10_);
		file = _tmp11_;
		_tmp12_ = file;
		_tmp13_ = (GFileIcon*) g_file_icon_new (_tmp12_);
		_tmp14_ = _tmp13_;
		slingshot_backend_app_set_icon (self, (GIcon*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (file);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = synapse_match_get_icon_name (match);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			_tmp17_ = synapse_match_get_icon_name (match);
			_tmp18_ = _tmp17_;
			_tmp19_ = (GThemedIcon*) g_themed_icon_new (_tmp18_);
			_tmp20_ = _tmp19_;
			slingshot_backend_app_set_icon (self, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
	}
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp21_;
		GAppInfo* app_info = NULL;
		SynapseApplicationMatch* _tmp22_;
		GAppInfo* _tmp23_;
		GAppInfo* _tmp24_;
		GAppInfo* _tmp25_;
		GAppInfo* _tmp26_;
		const gchar* _tmp27_;
		GAppInfo* _tmp28_;
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch));
		app_match = _tmp21_;
		_tmp22_ = app_match;
		_tmp23_ = synapse_application_match_get_app_info (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		app_info = _tmp25_;
		_tmp26_ = app_info;
		_tmp27_ = g_app_info_get_id (_tmp26_);
		slingshot_backend_app_set_desktop_id (self, _tmp27_);
		_tmp28_ = app_info;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, G_TYPE_DESKTOP_APP_INFO)) {
			GDesktopAppInfo* desktop_app_info = NULL;
			GAppInfo* _tmp29_;
			GDesktopAppInfo* _tmp30_;
			GDesktopAppInfo* _tmp31_;
			const gchar* _tmp32_;
			GDesktopAppInfo* _tmp33_;
			_tmp29_ = app_info;
			_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
			desktop_app_info = _tmp30_;
			_tmp31_ = desktop_app_info;
			_tmp32_ = g_desktop_app_info_get_filename (_tmp31_);
			slingshot_backend_app_set_desktop_path (self, _tmp32_);
			_tmp33_ = desktop_app_info;
			slingshot_backend_app_set_prefers_default_gpu (self, !g_desktop_app_info_get_boolean (_tmp33_, "PrefersNonDefaultGPU"));
			_g_object_unref0 (desktop_app_info);
		}
		_g_object_unref0 (app_info);
		_g_object_unref0 (app_match);
	}
	slingshot_backend_app_set_match (self, match);
	slingshot_backend_app_set_target (self, target);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new_from_synapse_match (SynapseMatch* match,
                                              SynapseMatch* target)
{
	return slingshot_backend_app_construct_from_synapse_match (SLINGSHOT_BACKEND_TYPE_APP, match, target);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
slingshot_backend_app_launch (SlingshotBackendApp* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		SlingshotBackendAppAppType _tmp0_;
		_tmp0_ = self->priv->_app_type;
		switch (_tmp0_) {
			case SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND:
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp1_ = self->priv->_name;
				_tmp2_ = string_to_string (_tmp1_);
				_tmp3_ = g_strconcat ("Launching command: ", _tmp2_, NULL);
				_tmp4_ = _tmp3_;
				g_debug ("App.vala:138: %s", _tmp4_);
				_g_free0 (_tmp4_);
				_tmp5_ = self->priv->_exec;
				g_spawn_command_line_async (_tmp5_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case SLINGSHOT_BACKEND_APP_APP_TYPE_APP:
			{
				GdkAppLaunchContext* context = NULL;
				GdkDisplay* _tmp6_;
				GdkAppLaunchContext* _tmp7_;
				GdkAppLaunchContext* _tmp8_;
				SlingshotBackendSwitcherooControl* _tmp9_;
				GdkAppLaunchContext* _tmp10_;
				gboolean _tmp11_;
				const gchar* _tmp12_;
				GDesktopAppInfo* _tmp13_;
				GDesktopAppInfo* _tmp14_;
				GdkAppLaunchContext* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
				_tmp6_ = gdk_display_get_default ();
				_tmp7_ = gdk_display_get_app_launch_context (_tmp6_);
				context = _tmp7_;
				_tmp8_ = context;
				gdk_app_launch_context_set_timestamp (_tmp8_, gtk_get_current_event_time ());
				_tmp9_ = self->priv->switcheroo_control;
				_tmp10_ = context;
				_tmp11_ = self->priv->_prefers_default_gpu;
				slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp9_, (GAppLaunchContext*) _tmp10_, _tmp11_);
				_tmp12_ = self->priv->_desktop_id;
				_tmp13_ = g_desktop_app_info_new (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = context;
				g_app_info_launch ((GAppInfo*) _tmp14_, NULL, (GAppLaunchContext*) _tmp15_, &_inner_error0_);
				_g_object_unref0 (_tmp14_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (context);
					goto __catch0_g_error;
				}
				_tmp16_ = self->priv->_name;
				_tmp17_ = string_to_string (_tmp16_);
				_tmp18_ = g_strconcat ("Launching application: ", _tmp17_, NULL);
				_tmp19_ = _tmp18_;
				g_debug ("App.vala:150: %s", _tmp19_);
				_g_free0 (_tmp19_);
				_g_object_unref0 (context);
				break;
			}
			case SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE:
			{
				SynapseMatch* _tmp20_;
				SynapseMatchType _tmp21_;
				SynapseMatchType _tmp22_;
				_tmp20_ = self->priv->_match;
				_tmp21_ = synapse_match_get_match_type (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == SYNAPSE_MATCH_TYPE_SEARCH) {
					SynapseMatch* _tmp23_;
					SynapseMatch* _tmp24_;
					_tmp23_ = self->priv->_match;
					_tmp24_ = self->priv->_target;
					g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_START_SEARCH_SIGNAL], 0, SYNAPSE_IS_SEARCH_MATCH (_tmp23_) ? ((SynapseSearchMatch*) _tmp23_) : NULL, _tmp24_);
					result = FALSE;
					return result;
				} else {
					SynapseMatch* _tmp25_;
					_tmp25_ = self->priv->_target;
					if (_tmp25_ == NULL) {
						SynapseMatch* _tmp26_;
						GeeList* _tmp27_;
						GeeList* _tmp28_;
						gpointer _tmp29_;
						SynapseMatch* _tmp30_;
						SynapseMatch* _tmp31_;
						_tmp26_ = self->priv->_match;
						_tmp27_ = slingshot_backend_synapse_search_find_actions_for_match (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = gee_list_get (_tmp28_, 0);
						_tmp30_ = (SynapseMatch*) _tmp29_;
						_tmp31_ = self->priv->_match;
						synapse_match_execute_with_target (_tmp30_, _tmp31_, NULL);
						_g_object_unref0 (_tmp30_);
						_g_object_unref0 (_tmp28_);
					} else {
						SynapseMatch* _tmp32_;
						SynapseMatch* _tmp33_;
						_tmp32_ = self->priv->_match;
						_tmp33_ = self->priv->_target;
						synapse_match_execute_with_target (_tmp32_, _tmp33_, NULL);
					}
				}
				break;
			}
			default:
			break;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		g_clear_error (&_inner_error0_);
		_tmp34_ = self->priv->_name;
		_tmp35_ = self->priv->_exec;
		g_warning ("App.vala:165: Failed to launch %s: %s", _tmp34_, _tmp35_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp36_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp36_;
	}
	result = TRUE;
	return result;
}

void
slingshot_backend_app_perform_unity_update (SlingshotBackendApp* self,
                                            const gchar* sender_name,
                                            GVariantIter* prop_iter)
{
	gchar* _tmp0_;
	gchar* prop_key = NULL;
	GVariant* prop_value = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (prop_iter != NULL);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (self->priv->unity_sender_name);
	self->priv->unity_sender_name = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_variant_iter_next (prop_iter, "{sv}", &_tmp1_, &_tmp2_, NULL);
		_g_free0 (prop_key);
		prop_key = _tmp1_;
		_g_variant_unref0 (prop_value);
		prop_value = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = prop_key;
		if (g_strcmp0 (_tmp4_, "count") == 0) {
			GVariant* _tmp5_;
			_tmp5_ = prop_value;
			slingshot_backend_app_set_current_count (self, g_variant_get_int64 (_tmp5_));
		} else {
			const gchar* _tmp6_;
			_tmp6_ = prop_key;
			if (g_strcmp0 (_tmp6_, "count-visible") == 0) {
				GVariant* _tmp7_;
				_tmp7_ = prop_value;
				slingshot_backend_app_set_count_visible (self, g_variant_get_boolean (_tmp7_));
			}
		}
	}
	_g_variant_unref0 (prop_value);
	_g_free0 (prop_key);
}

void
slingshot_backend_app_remove_launcher_entry (SlingshotBackendApp* self,
                                             const gchar* sender_name)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	_tmp0_ = self->priv->unity_sender_name;
	if (g_strcmp0 (_tmp0_, sender_name) == 0) {
		_g_free0 (self->priv->unity_sender_name);
		self->priv->unity_sender_name = NULL;
		slingshot_backend_app_set_count_visible (self, FALSE);
		slingshot_backend_app_set_current_count (self, (gint64) 0);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->app_info);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data4_->_data3_->self;
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda23_ (Block4Data* _data4_)
{
	Block3Data* _data3_;
	SlingshotBackendApp* self;
	GdkAppLaunchContext* context = NULL;
	GdkDisplay* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	const gchar* _tmp3_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	context = _tmp1_;
	gdk_app_launch_context_set_timestamp (context, (guint32) GDK_CURRENT_TIME);
	_tmp2_ = _data3_->app_info;
	_tmp3_ = _data4_->action;
	g_desktop_app_info_launch_action (_tmp2_, _tmp3_, (GAppLaunchContext*) context);
	g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
	_g_object_unref0 (context);
}

static void
_____lambda23__g_simple_action_activate (GSimpleAction* _sender,
                                         GVariant* parameter,
                                         gpointer self)
{
	____lambda23_ (self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data5_->_data3_->self;
		block3_data_unref (_data5_->_data3_);
		_data5_->_data3_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda24_ (Block5Data* _data5_)
{
	Block3Data* _data3_;
	SlingshotBackendApp* self;
	GError* _inner_error0_ = NULL;
	_data3_ = _data5_->_data3_;
	self = _data3_->self;
	{
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp0_;
		GdkAppLaunchContext* _tmp1_;
		SlingshotBackendSwitcherooControl* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		_tmp0_ = gdk_display_get_default ();
		_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
		context = _tmp1_;
		gdk_app_launch_context_set_timestamp (context, (guint32) GDK_CURRENT_TIME);
		_tmp2_ = self->priv->switcheroo_control;
		slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp2_, (GAppLaunchContext*) context, _data5_->prefers_non_default_gpu);
		_tmp3_ = _data3_->app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, (GAppLaunchContext*) context, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			goto __catch0_g_error;
		}
		g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
		_g_object_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = self->priv->_name;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("App.vala:231: Failed to launch %s: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	___lambda24_ (self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data6_->_data3_->self;
		_g_object_unref0 (_data6_->dock);
		block3_data_unref (_data6_->_data3_);
		_data6_->_data3_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_slingshot_backend_app_pinned_action_change_state_g_simple_action_change_state (GSimpleAction* _sender,
                                                                                GVariant* value,
                                                                                gpointer self)
{
	slingshot_backend_app_pinned_action_change_state ((SlingshotBackendApp*) self, value);
}

static void
___lambda29_ (Block6Data* _data6_)
{
	Block3Data* _data3_;
	SlingshotBackendApp* self;
	SlingshotBackendDock* _tmp0_;
	_data3_ = _data6_->_data3_;
	self = _data3_->self;
	_tmp0_ = _data6_->dock;
	slingshot_backend_app_on_dock_dbus_changed (self, _tmp0_);
}

static void
____lambda29__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda29_ (self);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data7_->_data3_->self;
		_g_object_unref0 (_data7_->appcenter);
		block3_data_unref (_data7_->_data3_);
		_data7_->_data3_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_slingshot_backend_app_action_uninstall_g_simple_action_activate (GSimpleAction* _sender,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	slingshot_backend_app_action_uninstall ((SlingshotBackendApp*) self);
}

static void
_slingshot_backend_app_open_in_appcenter_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	slingshot_backend_app_open_in_appcenter ((SlingshotBackendApp*) self);
}

static void
___lambda35_ (Block7Data* _data7_)
{
	Block3Data* _data3_;
	SlingshotBackendApp* self;
	SlingshotBackendAppCenter* _tmp0_;
	_data3_ = _data7_->_data3_;
	self = _data3_->self;
	_tmp0_ = _data7_->appcenter;
	slingshot_backend_app_on_appcenter_dbus_changed (self, _tmp0_, NULL, NULL);
}

static void
____lambda35__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda35_ (self);
}

GMenu*
slingshot_backend_app_get_menu_model (SlingshotBackendApp* self)
{
	Block3Data* _data3_;
	GMenu* actions_section = NULL;
	GMenu* _tmp0_;
	GMenu* shell_section = NULL;
	GMenu* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	const gchar* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gboolean _tmp27_ = FALSE;
	SlingshotBackendSwitcherooControl* _tmp28_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gboolean _tmp45_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_;
	GMenu* model = NULL;
	GMenu* _tmp84_;
	GMenu* _tmp85_;
	GMenu* _tmp86_;
	GError* _inner_error0_ = NULL;
	GMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_menu_new ();
	actions_section = _tmp0_;
	_tmp1_ = g_menu_new ();
	shell_section = _tmp1_;
	_tmp2_ = g_simple_action_group_new ();
	_tmp3_ = _tmp2_;
	slingshot_backend_app_set_action_group (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_desktop_id;
	_tmp5_ = g_desktop_app_info_new (_tmp4_);
	_data3_->app_info = _tmp5_;
	_tmp6_ = _data3_->app_info;
	_tmp8_ = _tmp7_ = g_desktop_app_info_list_actions (_tmp6_);
	{
		gchar** action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = _tmp8_;
		action_collection_length1 = _vala_array_length (_tmp7_);
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			const gchar* action = NULL;
			action = action_collection[action_it];
			{
				Block4Data* _data4_;
				GSimpleAction* simple_action = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GSimpleAction* _tmp12_;
				GSimpleAction* _tmp13_;
				GSimpleAction* _tmp14_;
				GSimpleActionGroup* _tmp15_;
				GSimpleAction* _tmp16_;
				GMenu* _tmp17_;
				GDesktopAppInfo* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->_data3_ = block3_data_ref (_data3_);
				_data4_->action = action;
				_tmp9_ = _data4_->action;
				_tmp10_ = g_strdup_printf (SLINGSHOT_BACKEND_APP_APP_ACTION, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_simple_action_new (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				simple_action = _tmp13_;
				_tmp14_ = simple_action;
				g_signal_connect_data (_tmp14_, "activate", (GCallback) _____lambda23__g_simple_action_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp15_ = self->priv->_action_group;
				_tmp16_ = simple_action;
				g_action_map_add_action ((GActionMap*) _tmp15_, (GAction*) _tmp16_);
				_tmp17_ = actions_section;
				_tmp18_ = _data3_->app_info;
				_tmp19_ = _data4_->action;
				_tmp20_ = g_desktop_app_info_get_action_name (_tmp18_, _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = _data4_->action;
				_tmp23_ = g_strdup_printf (SLINGSHOT_BACKEND_APP_APP_ACTION, _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (SLINGSHOT_BACKEND_APP_ACTION_PREFIX, _tmp24_, NULL);
				_tmp26_ = _tmp25_;
				g_menu_append (_tmp17_, _tmp21_, _tmp26_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp21_);
				_g_object_unref0 (simple_action);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp28_ = self->priv->switcheroo_control;
	if (_tmp28_ != NULL) {
		SlingshotBackendSwitcherooControl* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp29_ = self->priv->switcheroo_control;
		_tmp30_ = slingshot_backend_switcheroo_control_get_has_dual_gpu (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp27_ = _tmp31_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		Block5Data* _data5_;
		GDesktopAppInfo* _tmp32_;
		GSimpleAction* switcheroo_action = NULL;
		GSimpleAction* _tmp33_;
		GSimpleAction* _tmp34_;
		GSimpleActionGroup* _tmp35_;
		GSimpleAction* _tmp36_;
		GMenu* _tmp37_;
		SlingshotBackendSwitcherooControl* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data3_ = block3_data_ref (_data3_);
		_tmp32_ = _data3_->app_info;
		_data5_->prefers_non_default_gpu = g_desktop_app_info_get_boolean (_tmp32_, "PrefersNonDefaultGPU");
		_tmp33_ = g_simple_action_new (SLINGSHOT_BACKEND_APP_SWITCHEROO_ACTION, NULL);
		switcheroo_action = _tmp33_;
		_tmp34_ = switcheroo_action;
		g_signal_connect_data (_tmp34_, "activate", (GCallback) ____lambda24__g_simple_action_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_tmp35_ = self->priv->_action_group;
		_tmp36_ = switcheroo_action;
		g_action_map_add_action ((GActionMap*) _tmp35_, (GAction*) _tmp36_);
		_tmp37_ = actions_section;
		_tmp38_ = self->priv->switcheroo_control;
		_tmp39_ = slingshot_backend_switcheroo_control_get_gpu_name (_tmp38_, _data5_->prefers_non_default_gpu);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf (_ ("Open with %s Graphics"), _tmp40_);
		_tmp42_ = _tmp41_;
		g_menu_append (_tmp37_, _tmp42_, SLINGSHOT_BACKEND_APP_ACTION_PREFIX SLINGSHOT_BACKEND_APP_SWITCHEROO_ACTION);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		_g_object_unref0 (switcheroo_action);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_tmp43_ = g_find_program_in_path ("io.elementary.dock");
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_ != NULL;
	_g_free0 (_tmp44_);
	if (_tmp45_) {
		Block6Data* _data6_;
		SlingshotBackendDock* _tmp46_;
		SlingshotBackendDock* _tmp47_;
		GVariant* pinned_variant = NULL;
		GVariant* _tmp48_;
		GVariant* _tmp59_;
		GSimpleAction* _tmp60_;
		GSimpleAction* _tmp61_;
		GSimpleActionGroup* _tmp62_;
		GSimpleAction* _tmp63_;
		GMenu* _tmp64_;
		SlingshotBackendDock* _tmp65_;
		SlingshotBackendDock* _tmp66_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data3_ = block3_data_ref (_data3_);
		self->priv->has_system_item = TRUE;
		_tmp46_ = slingshot_backend_dock_get_default ();
		_tmp47_ = _g_object_ref0 (_tmp46_);
		_data6_->dock = _tmp47_;
		_tmp48_ = g_variant_new_boolean (FALSE);
		g_variant_ref_sink (_tmp48_);
		pinned_variant = _tmp48_;
		{
			gchar** _tmp49_ = NULL;
			SlingshotBackendDock* _tmp50_;
			DockDBus* _tmp51_;
			DockDBus* _tmp52_;
			gint _tmp53_ = 0;
			gchar** _tmp54_;
			gint _tmp49__length1;
			gint __tmp49__size_;
			const gchar* _tmp55_;
			GVariant* _tmp56_;
			_tmp50_ = _data6_->dock;
			_tmp51_ = slingshot_backend_dock_get_dbus (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp54_ = dock_dbus_list_launchers (_tmp52_, &_tmp53_, &_inner_error0_);
			_tmp49_ = _tmp54_;
			_tmp49__length1 = _tmp53_;
			__tmp49__size_ = _tmp49__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp55_ = self->priv->_desktop_id;
			_tmp56_ = g_variant_new_boolean (_vala_string_array_contains (_tmp49_, _tmp49__length1, _tmp55_));
			g_variant_ref_sink (_tmp56_);
			_g_variant_unref0 (pinned_variant);
			pinned_variant = _tmp56_;
			_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp57_;
			const gchar* _tmp58_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			g_critical ("App.vala:250: %s", _tmp58_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_variant_unref0 (pinned_variant);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			_g_object_unref0 (shell_section);
			_g_object_unref0 (actions_section);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp59_ = pinned_variant;
		_tmp60_ = g_simple_action_new_stateful (SLINGSHOT_BACKEND_APP_PINNED_ACTION, NULL, _tmp59_);
		_g_object_unref0 (self->priv->pinned_action);
		self->priv->pinned_action = _tmp60_;
		_tmp61_ = self->priv->pinned_action;
		g_signal_connect_object (_tmp61_, "change-state", (GCallback) _slingshot_backend_app_pinned_action_change_state_g_simple_action_change_state, self, 0);
		_tmp62_ = self->priv->_action_group;
		_tmp63_ = self->priv->pinned_action;
		g_action_map_add_action ((GActionMap*) _tmp62_, (GAction*) _tmp63_);
		_tmp64_ = shell_section;
		g_menu_append (_tmp64_, _ ("Keep in _Dock"), SLINGSHOT_BACKEND_APP_ACTION_PREFIX SLINGSHOT_BACKEND_APP_PINNED_ACTION);
		_tmp65_ = _data6_->dock;
		g_signal_connect_data ((GObject*) _tmp65_, "notify::dbus", (GCallback) ____lambda29__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp66_ = _data6_->dock;
		slingshot_backend_app_on_dock_dbus_changed (self, _tmp66_);
		_g_variant_unref0 (pinned_variant);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	_tmp67_ = g_find_program_in_path ("io.elementary.appcenter");
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp68_ != NULL;
	_g_free0 (_tmp68_);
	if (_tmp69_) {
		Block7Data* _data7_;
		GSimpleAction* _tmp70_;
		GSimpleAction* _tmp71_;
		GSimpleAction* _tmp72_;
		GSimpleAction* _tmp73_;
		GSimpleActionGroup* _tmp74_;
		GSimpleAction* _tmp75_;
		GSimpleActionGroup* _tmp76_;
		GSimpleAction* _tmp77_;
		GMenu* _tmp78_;
		GMenu* _tmp79_;
		SlingshotBackendAppCenter* _tmp80_;
		SlingshotBackendAppCenter* _tmp81_;
		SlingshotBackendAppCenter* _tmp82_;
		SlingshotBackendAppCenter* _tmp83_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data3_ = block3_data_ref (_data3_);
		_tmp70_ = g_simple_action_new (SLINGSHOT_BACKEND_APP_UNINSTALL_ACTION, NULL);
		_g_object_unref0 (self->priv->uninstall_action);
		self->priv->uninstall_action = _tmp70_;
		_tmp71_ = self->priv->uninstall_action;
		g_signal_connect_object (_tmp71_, "activate", (GCallback) _slingshot_backend_app_action_uninstall_g_simple_action_activate, self, 0);
		_tmp72_ = g_simple_action_new (SLINGSHOT_BACKEND_APP_VIEW_ACTION, NULL);
		_g_object_unref0 (self->priv->view_action);
		self->priv->view_action = _tmp72_;
		_tmp73_ = self->priv->view_action;
		g_signal_connect_object (_tmp73_, "activate", (GCallback) _slingshot_backend_app_open_in_appcenter_g_simple_action_activate, self, 0);
		_tmp74_ = self->priv->_action_group;
		_tmp75_ = self->priv->uninstall_action;
		g_action_map_add_action ((GActionMap*) _tmp74_, (GAction*) _tmp75_);
		_tmp76_ = self->priv->_action_group;
		_tmp77_ = self->priv->view_action;
		g_action_map_add_action ((GActionMap*) _tmp76_, (GAction*) _tmp77_);
		_tmp78_ = shell_section;
		g_menu_append (_tmp78_, _ ("Uninstall"), SLINGSHOT_BACKEND_APP_ACTION_PREFIX SLINGSHOT_BACKEND_APP_UNINSTALL_ACTION);
		_tmp79_ = shell_section;
		g_menu_append (_tmp79_, _ ("View in AppCenter"), SLINGSHOT_BACKEND_APP_ACTION_PREFIX SLINGSHOT_BACKEND_APP_VIEW_ACTION);
		_tmp80_ = slingshot_backend_app_center_get_default ();
		_tmp81_ = _g_object_ref0 (_tmp80_);
		_data7_->appcenter = _tmp81_;
		_tmp82_ = _data7_->appcenter;
		g_signal_connect_data ((GObject*) _tmp82_, "notify::dbus", (GCallback) ____lambda35__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp83_ = _data7_->appcenter;
		slingshot_backend_app_on_appcenter_dbus_changed (self, _tmp83_, NULL, NULL);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_tmp84_ = g_menu_new ();
	model = _tmp84_;
	_tmp85_ = actions_section;
	g_menu_append_section (model, NULL, (GMenuModel*) _tmp85_);
	_tmp86_ = shell_section;
	g_menu_append_section (model, NULL, (GMenuModel*) _tmp86_);
	result = model;
	_g_object_unref0 (shell_section);
	_g_object_unref0 (actions_section);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SlingshotBackendApp* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->appcenter);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda33_ (Block8Data* _data8_,
             GObject* obj,
             GAsyncResult* res)
{
	SlingshotBackendApp* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		SlingshotBackendAppCenter* _tmp0_;
		AppCenterDBus* _tmp1_;
		AppCenterDBus* _tmp2_;
		_tmp0_ = _data8_->appcenter;
		_tmp1_ = slingshot_backend_app_center_get_dbus (_tmp0_);
		_tmp2_ = _tmp1_;
		app_center_dbus_uninstall_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("App.vala:311: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ (self, source_object, res);
	block8_data_unref (self);
}

static void
slingshot_backend_app_action_uninstall (SlingshotBackendApp* self)
{
	Block8Data* _data8_;
	SlingshotBackendAppCenter* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	gboolean _tmp2_ = FALSE;
	SlingshotBackendAppCenter* _tmp3_;
	AppCenterDBus* _tmp4_;
	AppCenterDBus* _tmp5_;
	SlingshotBackendAppCenter* _tmp7_;
	AppCenterDBus* _tmp8_;
	AppCenterDBus* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = slingshot_backend_app_center_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data8_->appcenter = _tmp1_;
	_tmp3_ = _data8_->appcenter;
	_tmp4_ = slingshot_backend_app_center_get_dbus (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->appstream_comp_id;
		_tmp2_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp2_) {
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
	_tmp7_ = _data8_->appcenter;
	_tmp8_ = slingshot_backend_app_center_get_dbus (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->appstream_comp_id;
	app_center_dbus_uninstall (_tmp9_, _tmp10_, ___lambda33__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__lambda34_ (SlingshotBackendApp* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		g_app_info_launch_default_for_uri_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GDesktopAppInfo* app_info = NULL;
		const gchar* _tmp0_;
		GDesktopAppInfo* _tmp1_;
		GraniteMessageDialog* message_dialog = NULL;
		GDesktopAppInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GraniteMessageDialog* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = self->priv->_desktop_id;
		_tmp1_ = g_desktop_app_info_new (_tmp0_);
		app_info = _tmp1_;
		_tmp2_ = app_info;
		_tmp3_ = g_app_info_get_display_name ((GAppInfo*) _tmp2_);
		_tmp4_ = g_strdup_printf ("Unable to open %s in AppCenter", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = granite_message_dialog_new_with_image_from_icon_name (_tmp5_, "", "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		message_dialog = _tmp7_;
		_tmp8_ = message_dialog;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		granite_message_dialog_show_error_details (_tmp8_, _tmp10_);
		_tmp11_ = message_dialog;
		_tmp12_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp11_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp12_, 0);
		_tmp13_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp13_);
		_g_object_unref0 (message_dialog);
		_g_object_unref0 (app_info);
		_g_error_free0 (_error_);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda34__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda34_ ((SlingshotBackendApp*) self, source_object, res);
	g_object_unref (self);
}

static void
slingshot_backend_app_open_in_appcenter (SlingshotBackendApp* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->appstream_comp_id;
	_tmp1_ = g_strconcat ("appstream://", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_app_info_launch_default_for_uri_async (_tmp2_, NULL, NULL, ___lambda34__gasync_ready_callback, g_object_ref (self));
	_g_free0 (_tmp2_);
}

static void
slingshot_backend_app_on_appcenter_dbus_changed_data_free (gpointer _data)
{
	SlingshotBackendAppOnAppcenterDbusChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->appcenter);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotBackendAppOnAppcenterDbusChangedData, _data_);
}

static void
slingshot_backend_app_on_appcenter_dbus_changed (SlingshotBackendApp* self,
                                                 SlingshotBackendAppCenter* appcenter,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SlingshotBackendAppOnAppcenterDbusChangedData* _data_;
	SlingshotBackendApp* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appcenter != NULL);
	_data_ = g_slice_new0 (SlingshotBackendAppOnAppcenterDbusChangedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_backend_app_on_appcenter_dbus_changed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (appcenter);
	_g_object_unref0 (_data_->appcenter);
	_data_->appcenter = _tmp1_;
	slingshot_backend_app_on_appcenter_dbus_changed_co (_data_);
}

static void
slingshot_backend_app_on_appcenter_dbus_changed_finish (SlingshotBackendApp* self,
                                                        GAsyncResult* _res_)
{
	SlingshotBackendAppOnAppcenterDbusChangedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
slingshot_backend_app_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	SlingshotBackendAppOnAppcenterDbusChangedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_backend_app_on_appcenter_dbus_changed_co (_data_);
}

static gboolean
slingshot_backend_app_on_appcenter_dbus_changed_co (SlingshotBackendAppOnAppcenterDbusChangedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		{
			_data_->_tmp3_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = _data_->self->priv->_desktop_id;
			_data_->_state_ = 1;
			app_center_dbus_get_component_from_desktop_id (_data_->_tmp4_, _data_->_tmp5_, slingshot_backend_app_on_appcenter_dbus_changed_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = app_center_dbus_get_component_from_desktop_id_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp2_;
			_data_->_tmp2_ = NULL;
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp7_;
			_g_free0 (_data_->_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = g_strdup ("");
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_warning ("App.vala:343: %s", _data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp11_ = g_strdup ("");
		_g_free0 (_data_->self->priv->appstream_comp_id);
		_data_->self->priv->appstream_comp_id = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _data_->self->priv->uninstall_action;
	_data_->_tmp13_ = _data_->self->priv->appstream_comp_id;
	g_simple_action_set_enabled (_data_->_tmp12_, g_strcmp0 (_data_->_tmp13_, "") != 0);
	_data_->_tmp14_ = _data_->self->priv->view_action;
	_data_->_tmp15_ = _data_->self->priv->appstream_comp_id;
	g_simple_action_set_enabled (_data_->_tmp14_, g_strcmp0 (_data_->_tmp15_, "") != 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
slingshot_backend_app_on_dock_dbus_changed (SlingshotBackendApp* self,
                                            SlingshotBackendDock* dock)
{
	GSimpleAction* _tmp0_;
	DockDBus* _tmp1_;
	DockDBus* _tmp2_;
	DockDBus* _tmp3_;
	DockDBus* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dock != NULL);
	_tmp0_ = self->priv->pinned_action;
	_tmp1_ = slingshot_backend_dock_get_dbus (dock);
	_tmp2_ = _tmp1_;
	g_simple_action_set_enabled (_tmp0_, _tmp2_ != NULL);
	_tmp3_ = slingshot_backend_dock_get_dbus (dock);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		return;
	}
	{
		gchar** _tmp5_ = NULL;
		DockDBus* _tmp6_;
		DockDBus* _tmp7_;
		gint _tmp8_ = 0;
		gchar** _tmp9_;
		gint _tmp5__length1;
		gint __tmp5__size_;
		GSimpleAction* _tmp10_;
		const gchar* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		_tmp6_ = slingshot_backend_dock_get_dbus (dock);
		_tmp7_ = _tmp6_;
		_tmp9_ = dock_dbus_list_launchers (_tmp7_, &_tmp8_, &_inner_error0_);
		_tmp5_ = _tmp9_;
		_tmp5__length1 = _tmp8_;
		__tmp5__size_ = _tmp5__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->pinned_action;
		_tmp11_ = self->priv->_desktop_id;
		_tmp12_ = g_variant_new_boolean (_vala_string_array_contains (_tmp5_, _tmp5__length1, _tmp11_));
		g_variant_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		g_signal_emit_by_name (_tmp10_, "change-state", _tmp13_);
		_g_variant_unref0 (_tmp13_);
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("App.vala:363: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
slingshot_backend_app_pinned_action_change_state (SlingshotBackendApp* self,
                                                  GVariant* value)
{
	GSimpleAction* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pinned_action;
	g_simple_action_set_state (_tmp0_, value);
	{
		SlingshotBackendDock* dock = NULL;
		SlingshotBackendDock* _tmp1_;
		SlingshotBackendDock* _tmp2_;
		_tmp1_ = slingshot_backend_dock_get_default ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		dock = _tmp2_;
		if (g_variant_get_boolean (value)) {
			SlingshotBackendDock* _tmp3_;
			DockDBus* _tmp4_;
			DockDBus* _tmp5_;
			const gchar* _tmp6_;
			_tmp3_ = dock;
			_tmp4_ = slingshot_backend_dock_get_dbus (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->_desktop_id;
			dock_dbus_add_launcher (_tmp5_, _tmp6_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dock);
				goto __catch0_g_error;
			}
		} else {
			SlingshotBackendDock* _tmp7_;
			DockDBus* _tmp8_;
			DockDBus* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = dock;
			_tmp8_ = slingshot_backend_dock_get_dbus (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->_desktop_id;
			dock_dbus_remove_launcher (_tmp9_, _tmp10_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dock);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (dock);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("App.vala:378: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GSimpleActionGroup*
slingshot_backend_app_get_action_group (SlingshotBackendApp* self)
{
	GSimpleActionGroup* result;
	GSimpleActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_group;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_action_group (SlingshotBackendApp* self,
                                        GSimpleActionGroup* value)
{
	GSimpleActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_action_group (self);
	if (old_value != value) {
		GSimpleActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_group);
		self->priv->_action_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_name (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
slingshot_backend_app_set_name (SlingshotBackendApp* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NAME_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_description (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_description (SlingshotBackendApp* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_desktop_id (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

void
slingshot_backend_app_set_desktop_id (SlingshotBackendApp* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_exec (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_exec (SlingshotBackendApp* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_exec (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_EXEC_PROPERTY]);
	}
}

gchar**
slingshot_backend_app_get_keywords (SlingshotBackendApp* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keywords;
	_tmp0__length1 = self->priv->_keywords_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
slingshot_backend_app_set_keywords (SlingshotBackendApp* self,
                                    gchar** value,
                                    gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_keywords (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_keywords = _tmp0_;
		self->priv->_keywords_length1 = _tmp0__length1;
		self->priv->__keywords_size_ = self->priv->_keywords_length1;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY]);
	}
}

GIcon*
slingshot_backend_app_get_icon (SlingshotBackendApp* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_icon (SlingshotBackendApp* self,
                                GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ICON_PROPERTY]);
	}
}

gdouble
slingshot_backend_app_get_popularity (SlingshotBackendApp* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_popularity;
	return result;
}

void
slingshot_backend_app_set_popularity (SlingshotBackendApp* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_popularity (self);
	if (old_value != value) {
		self->priv->_popularity = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_desktop_path (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_desktop_path (SlingshotBackendApp* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_categories (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_categories;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_categories (SlingshotBackendApp* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_categories (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_categories);
		self->priv->_categories = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_generic_name (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_generic_name (SlingshotBackendApp* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_generic_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY]);
	}
}

gboolean
slingshot_backend_app_get_prefers_default_gpu (SlingshotBackendApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prefers_default_gpu;
	return result;
}

static void
slingshot_backend_app_set_prefers_default_gpu (SlingshotBackendApp* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_prefers_default_gpu (self);
	if (old_value != value) {
		self->priv->_prefers_default_gpu = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY]);
	}
}

SlingshotBackendAppAppType
slingshot_backend_app_get_app_type (SlingshotBackendApp* self)
{
	SlingshotBackendAppAppType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_app_type;
	return result;
}

static void
slingshot_backend_app_set_app_type (SlingshotBackendApp* self,
                                    SlingshotBackendAppAppType value)
{
	SlingshotBackendAppAppType old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_app_type (self);
	if (old_value != value) {
		self->priv->_app_type = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY]);
	}
}

gboolean
slingshot_backend_app_get_count_visible (SlingshotBackendApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_count_visible;
	return result;
}

static void
slingshot_backend_app_set_count_visible (SlingshotBackendApp* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_count_visible (self);
	if (old_value != value) {
		self->priv->_count_visible = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY]);
	}
}

gint64
slingshot_backend_app_get_current_count (SlingshotBackendApp* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_current_count;
	return result;
}

static void
slingshot_backend_app_set_current_count (SlingshotBackendApp* self,
                                         gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_current_count (self);
	if (old_value != value) {
		self->priv->_current_count = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY]);
	}
}

SynapseMatch*
slingshot_backend_app_get_match (SlingshotBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_match;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_match (SlingshotBackendApp* self,
                                 SynapseMatch* value)
{
	SynapseMatch* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_match (self);
	if (old_value != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_match);
		self->priv->_match = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_MATCH_PROPERTY]);
	}
}

SynapseMatch*
slingshot_backend_app_get_target (SlingshotBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_target (SlingshotBackendApp* self,
                                  SynapseMatch* value)
{
	SynapseMatch* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_target (self);
	if (old_value != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_target);
		self->priv->_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TARGET_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static GObject *
slingshot_backend_app_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendApp * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	return obj;
}

static void
slingshot_backend_app_class_init (SlingshotBackendAppClass * klass,
                                  gpointer klass_data)
{
	slingshot_backend_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY] = g_param_spec_object ("action-group", "action-group", "action-group", g_simple_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_NAME_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_EXEC_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY] = g_param_spec_boxed ("keywords", "keywords", "keywords", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_ICON_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY] = g_param_spec_double ("popularity", "popularity", "popularity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY] = g_param_spec_string ("categories", "categories", "categories", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY] = g_param_spec_boolean ("prefers-default-gpu", "prefers-default-gpu", "prefers-default-gpu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY] = g_param_spec_enum ("app-type", "app-type", "app-type", SLINGSHOT_BACKEND_APP_TYPE_APP_TYPE, SLINGSHOT_BACKEND_APP_APP_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY] = g_param_spec_boolean ("count-visible", "count-visible", "count-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY] = g_param_spec_int64 ("current-count", "current-count", "current-count", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_MATCH_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_MATCH_PROPERTY] = g_param_spec_object ("match", "match", "match", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_TARGET_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL] = g_signal_new ("launched", SLINGSHOT_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SLINGSHOT_BACKEND_TYPE_APP);
	slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_START_SEARCH_SIGNAL] = g_signal_new ("start-search", SLINGSHOT_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SYNAPSE_TYPE_SEARCH_MATCH, SYNAPSE_TYPE_MATCH);
}

static void
slingshot_backend_app_instance_init (SlingshotBackendApp * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = slingshot_backend_app_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
	self->priv->_icon = (GIcon*) _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_generic_name = _tmp2_;
	self->priv->_prefers_default_gpu = FALSE;
	self->priv->_app_type = SLINGSHOT_BACKEND_APP_APP_TYPE_APP;
	self->priv->unity_sender_name = NULL;
	self->priv->_count_visible = FALSE;
	self->priv->_current_count = (gint64) 0;
	self->priv->_match = NULL;
	self->priv->_target = NULL;
	self->priv->has_system_item = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->appstream_comp_id = _tmp3_;
}

static void
slingshot_backend_app_finalize (GObject * obj)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	_g_object_unref0 (self->priv->_action_group);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_desktop_path);
	_g_free0 (self->priv->_categories);
	_g_free0 (self->priv->_generic_name);
	_g_free0 (self->priv->unity_sender_name);
	_g_object_unref0 (self->priv->_match);
	_g_object_unref0 (self->priv->_target);
	_g_object_unref0 (self->priv->switcheroo_control);
	_g_object_unref0 (self->priv->pinned_action);
	_g_object_unref0 (self->priv->uninstall_action);
	_g_object_unref0 (self->priv->view_action);
	_g_free0 (self->priv->appstream_comp_id);
	G_OBJECT_CLASS (slingshot_backend_app_parent_class)->finalize (obj);
}

static GType
slingshot_backend_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendApp), 0, (GInstanceInitFunc) slingshot_backend_app_instance_init, NULL };
	GType slingshot_backend_app_type_id;
	slingshot_backend_app_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendApp", &g_define_type_info, 0);
	SlingshotBackendApp_private_offset = g_type_add_instance_private (slingshot_backend_app_type_id, sizeof (SlingshotBackendAppPrivate));
	return slingshot_backend_app_type_id;
}

GType
slingshot_backend_app_get_type (void)
{
	static volatile gsize slingshot_backend_app_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_app_type_id__once)) {
		GType slingshot_backend_app_type_id;
		slingshot_backend_app_type_id = slingshot_backend_app_get_type_once ();
		g_once_init_leave (&slingshot_backend_app_type_id__once, slingshot_backend_app_type_id);
	}
	return slingshot_backend_app_type_id__once;
}

static void
_vala_slingshot_backend_app_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_action_group (self));
		break;
		case SLINGSHOT_BACKEND_APP_NAME_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_name (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_description (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_desktop_id (self));
		break;
		case SLINGSHOT_BACKEND_APP_EXEC_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_exec (self));
		break;
		case SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, slingshot_backend_app_get_keywords (self, &length));
		}
		break;
		case SLINGSHOT_BACKEND_APP_ICON_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_icon (self));
		break;
		case SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY:
		g_value_set_double (value, slingshot_backend_app_get_popularity (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_desktop_path (self));
		break;
		case SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_categories (self));
		break;
		case SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_generic_name (self));
		break;
		case SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_app_get_prefers_default_gpu (self));
		break;
		case SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY:
		g_value_set_enum (value, slingshot_backend_app_get_app_type (self));
		break;
		case SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_app_get_count_visible (self));
		break;
		case SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY:
		g_value_set_int64 (value, slingshot_backend_app_get_current_count (self));
		break;
		case SLINGSHOT_BACKEND_APP_MATCH_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_match (self));
		break;
		case SLINGSHOT_BACKEND_APP_TARGET_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_target (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_app_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_ACTION_GROUP_PROPERTY:
		slingshot_backend_app_set_action_group (self, g_value_get_object (value));
		break;
		case SLINGSHOT_BACKEND_APP_NAME_PROPERTY:
		slingshot_backend_app_set_name (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY:
		slingshot_backend_app_set_description (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY:
		slingshot_backend_app_set_desktop_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_EXEC_PROPERTY:
		slingshot_backend_app_set_exec (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			slingshot_backend_app_set_keywords (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case SLINGSHOT_BACKEND_APP_ICON_PROPERTY:
		slingshot_backend_app_set_icon (self, g_value_get_object (value));
		break;
		case SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY:
		slingshot_backend_app_set_popularity (self, g_value_get_double (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		slingshot_backend_app_set_desktop_path (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY:
		slingshot_backend_app_set_categories (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY:
		slingshot_backend_app_set_generic_name (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY:
		slingshot_backend_app_set_prefers_default_gpu (self, g_value_get_boolean (value));
		break;
		case SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY:
		slingshot_backend_app_set_app_type (self, g_value_get_enum (value));
		break;
		case SLINGSHOT_BACKEND_APP_COUNT_VISIBLE_PROPERTY:
		slingshot_backend_app_set_count_visible (self, g_value_get_boolean (value));
		break;
		case SLINGSHOT_BACKEND_APP_CURRENT_COUNT_PROPERTY:
		slingshot_backend_app_set_current_count (self, g_value_get_int64 (value));
		break;
		case SLINGSHOT_BACKEND_APP_MATCH_PROPERTY:
		slingshot_backend_app_set_match (self, g_value_get_object (value));
		break;
		case SLINGSHOT_BACKEND_APP_TARGET_PROPERTY:
		slingshot_backend_app_set_target (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

