/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#include <algorithm>
#include <unordered_map>
#include <string_view>
#include <miopen/filesystem.hpp>
#include <miopen/kernel.hpp>

#ifndef MIOPEN_USE_CLANG_TIDY // Huge generated source
// clang-format off
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_CONVOLUTION_COMMON_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_CONVOLUTION_COMMON_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_FP16_BFP16_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_FP16_BFP16_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_REDUCTION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_REDUCTION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_FUNCTIONS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_FUNCTIONS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_KERNEL_SIMPLE_CONFIGURATOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_KERNEL_SIMPLE_CONFIGURATOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTMATRIXDESCRIPTOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTMATRIXDESCRIPTOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTTENSORDESCRIPTOR_DEPRECATED_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTTENSORDESCRIPTOR_DEPRECATED_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_DIMENSION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_DIMENSION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_COORDINATE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_COORDINATE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_FP16_BFP16_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_FP16_BFP16_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_XDLOPS_FP16_BFP16_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_XDLOPS_FP16_BFP16_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INLINE_ASM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INLINE_ASM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_AMD_INLINE_ASM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_AMD_INLINE_ASM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INLINE_ASM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INLINE_ASM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_ARRAY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_ARRAY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_CK_UTILS_TYPE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_CK_UTILS_TYPE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_COMMON_HEADER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_COMMON_HEADER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_CONFIG_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_CONFIG_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_FLOAT_TYPE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_FLOAT_TYPE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL4_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL4_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_IN_MEMORY_OPERATION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_IN_MEMORY_OPERATION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_INTEGRAL_CONSTANT_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_INTEGRAL_CONSTANT_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_MATH_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_MATH_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_NUMBER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_NUMBER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_COMMON_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_COMMON_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_OPERATOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_OPERATOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_SEQUENCE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_SEQUENCE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_SYNCHRONIZATION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_SYNCHRONIZATION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_TUPLE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_TUPLE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_UTILITY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_UTILITY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_OPERATION_WRAPPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_OPERATION_WRAPPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1_NHWC_KYXC_NHWK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1_NHWC_KYXC_NHWK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1R2_NHWC_KYXC_NHWK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1R2_NHWC_KYXC_NHWK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NHWC_KYXC_NHWK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NHWC_KYXC_NHWK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NHWC_KYXC_NHWK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NHWC_KYXC_NHWK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R4_NHWC_KYXC_NHWK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R4_NHWC_KYXC_NHWK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V6R1_NCHW_KCYX_NKHW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V6R1_NCHW_KCYX_NKHW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CLUSTER_DESCRIPTOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CLUSTER_DESCRIPTOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TENSOR_ADAPTOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TENSOR_ADAPTOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TENSOR_DESCRIPTOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TENSOR_DESCRIPTOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_CONTRACTION_DLOPS_V1R2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_CONTRACTION_DLOPS_V1R2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GEMM_XDLOPS_V2R3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GEMM_XDLOPS_V2R3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BLOCKWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BLOCKWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_FUNCTIONS_THREADWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_FUNCTIONS_THREADWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_FUNCTIONS_WARPWISE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_FUNCTIONS_WARPWISE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_THREADWISE_CONTRACTION_DLOPS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_THREADWISE_CONTRACTION_DLOPS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_THREADWISE_GEMM_DLOPS_V3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_THREADWISE_GEMM_DLOPS_V3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_SET_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_SET_INCLUDE[];
extern const size_t MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_XDLOPS_GEMM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_XDLOPS_GEMM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_AMD_ADDRESS_SPACE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_AMD_ADDRESS_SPACE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE[];
extern const size_t MIOPEN_KERNEL_AMD_INLINE_ASM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_AMD_INLINE_ASM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_AMD_LLVM_INTRINSIC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_AMD_LLVM_INTRINSIC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_AMD_XDLOPS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_AMD_XDLOPS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_ARRAY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_ARRAY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_ARRAY_MULTI_INDEX_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_ARRAY_MULTI_INDEX_INCLUDE[];
extern const size_t MIOPEN_KERNEL_C_STYLE_POINTER_CAST_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_C_STYLE_POINTER_CAST_INCLUDE[];
extern const size_t MIOPEN_KERNEL_COMMON_HEADER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_COMMON_HEADER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONFIG_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONFIG_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONTAINER_ELEMENT_PICKER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONTAINER_ELEMENT_PICKER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONTAINER_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONTAINER_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_DATA_TYPE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_DATA_TYPE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_DATA_TYPE_ENUM_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_DATA_TYPE_ENUM_INCLUDE[];
extern const size_t MIOPEN_KERNEL_DATA_TYPE_ENUM_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_DATA_TYPE_ENUM_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_DYNAMIC_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_DYNAMIC_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_ENABLE_IF_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_ENABLE_IF_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FUNCTIONAL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FUNCTIONAL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FUNCTIONAL2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FUNCTIONAL2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FUNCTIONAL3_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FUNCTIONAL3_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FUNCTIONAL4_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FUNCTIONAL4_INCLUDE[];
extern const size_t MIOPEN_KERNEL_INNER_PRODUCT_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_INNER_PRODUCT_INCLUDE[];
extern const size_t MIOPEN_KERNEL_INTEGRAL_CONSTANT_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_INTEGRAL_CONSTANT_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MAGIC_DIVISION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MAGIC_DIVISION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MATH_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MATH_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MULTI_INDEX_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MULTI_INDEX_INCLUDE[];
extern const size_t MIOPEN_KERNEL_NUMBER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_NUMBER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_PRINT_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_PRINT_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_COMMON_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_COMMON_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_ENUMS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_ENUMS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BINOP_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BINOP_INCLUDE[];
extern const size_t MIOPEN_KERNEL_REDUCTION_OPERATOR_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_REDUCTION_OPERATOR_INCLUDE[];
extern const size_t MIOPEN_KERNEL_SEQUENCE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_SEQUENCE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_SEQUENCE_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_SEQUENCE_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATIC_BUFFER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATIC_BUFFER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_MULTI_INDEX_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_MULTI_INDEX_INCLUDE[];
extern const size_t MIOPEN_KERNEL_SYNCHRONIZATION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_SYNCHRONIZATION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TUPLE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TUPLE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TUPLE_HELPER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TUPLE_HELPER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TYPE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TYPE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_UTILITY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_UTILITY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_BF16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP16_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP32_UTILS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GENERAL_TENSOR_REORDER_KERNEL_UTIL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GENERAL_TENSOR_REORDER_KERNEL_UTIL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_IMPLICITGEMM_PARAMS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_IMPLICITGEMM_PARAMS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_ACTIVATION_FUNCTIONS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_ACTIVATION_FUNCTIONS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FP8_KERN_TYPES_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FP8_KERN_TYPES_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DEC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DEC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DIL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DIL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DEC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DEC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DIL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DIL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_STRIDE_2_DEC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_STRIDE_2_DEC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_EPILOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_EPILOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_PROLOGUE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_PROLOGUE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DIL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DIL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DEC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DEC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DIL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DIL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DEC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DEC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_METADATA_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_METADATA_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_DILATION2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_DILATION2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_METADATA_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_METADATA_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPENREDUCECALCULATION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPENREDUCECALCULATION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPENREDUCEEXTREME_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPENREDUCEEXTREME_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BFLOAT16_DEV_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BFLOAT16_DEV_INCLUDE[];
extern const size_t MIOPEN_KERNEL_BLOCK_REDUCE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_BLOCK_REDUCE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_COMMON_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_COMMON_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_SIZES_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_SIZES_INCLUDE[];
extern const size_t MIOPEN_KERNEL_FLOAT_TYPES_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_FLOAT_TYPES_INCLUDE[];
extern const size_t MIOPEN_KERNEL_GPR_ALLOC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_GPR_ALLOC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_HIP_ATOMIC_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_HIP_ATOMIC_INCLUDE[];
extern const size_t MIOPEN_KERNEL_HIP_F8_IMPL_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_HIP_F8_IMPL_INCLUDE[];
extern const size_t MIOPEN_KERNEL_HIP_FLOAT8_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_HIP_FLOAT8_INCLUDE[];
extern const size_t MIOPEN_KERNEL_INST_WRAPPERS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_INST_WRAPPERS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPEN_CSTDINT_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPEN_CSTDINT_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPEN_LIMITS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPEN_LIMITS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPEN_ROCRAND_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPEN_ROCRAND_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPEN_TYPE_TRAITS_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPEN_TYPE_TRAITS_INCLUDE[];
extern const size_t MIOPEN_KERNEL_MIOPEN_UTILITY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_MIOPEN_UTILITY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_NEURON_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_NEURON_INCLUDE[];
extern const size_t MIOPEN_KERNEL_RADIX_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_RADIX_INCLUDE[];
extern const size_t MIOPEN_KERNEL_ROCM_VERSION_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_ROCM_VERSION_INCLUDE[];
extern const size_t MIOPEN_KERNEL_STRIDE_ARRAY_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_STRIDE_ARRAY_INCLUDE[];
extern const size_t MIOPEN_KERNEL_TENSOR_VIEW_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_TENSOR_VIEW_INCLUDE[];
extern const size_t MIOPEN_KERNEL_UTILITIES_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_UTILITIES_INCLUDE[];
extern const size_t MIOPEN_KERNEL_WARP_REDUCE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_WARP_REDUCE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C32_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C32_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1024VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1024VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE[];
extern const size_t MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_METADATA_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_METADATA_INCLUDE[];
extern const size_t MIOPEN_KERNEL_WORKAROUND_ISSUE_1431_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_WORKAROUND_ISSUE_1431_INCLUDE[];
extern const size_t MIOPEN_KERNEL_XFORM_BIDIRECT_WINOGRAD_CODE_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_XFORM_BIDIRECT_WINOGRAD_CODE_INCLUDE[];
extern const size_t MIOPEN_KERNEL_XFORM_DATA_FILTER_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_XFORM_DATA_FILTER_INCLUDE[];
extern const size_t MIOPEN_KERNEL_XFORM_KD_COV2_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_XFORM_KD_COV2_INCLUDE[];
extern const size_t MIOPEN_KERNEL_XFORM_METADATA_INCLUDE_SIZE;
extern const char MIOPEN_KERNEL_XFORM_METADATA_INCLUDE[];

// clang-format on
#endif

namespace miopen {

const std::unordered_map<fs::path, std::string_view, FsPathHash>& kernel_includes()
{
    static const std::unordered_map<fs::path, std::string_view, FsPathHash> data{
#ifndef MIOPEN_USE_CLANG_TIDY // Huge generated source
            { "static_kernel_convolution_common.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_CONVOLUTION_COMMON_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_CONVOLUTION_COMMON_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v1r1_fp16_bfp16_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_FP16_BFP16_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_FP16_BFP16_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v1r1_ncdhw_kczyx_nkdhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v1r1_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v1r1_xdlops_gnchw_gkcyx_gnkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v4r1_ncdhw_kczyx_nkdhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v4r1_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_data_implicit_gemm_v4r1_xdlops_gnchw_gkcyx_gnkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_GNCHW_GKCYX_GNKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_weights_implicit_gemm_v4r4_ncdhw_kczyx_nkdhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_weights_implicit_gemm_v4r4_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_weights_implicit_gemm_v4r4_xdlops_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_backward_weights_implicit_gemm_v4r4_xdlops_nchw_kcyx_nkhw_padded_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_forward_implicit_gemm_v4r4_xdlops_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_forward_implicit_gemm_v4r4_xdlops_nchw_kcyx_nkhw_padded_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_forward_implicit_gemm_v4r5_xdlops_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r1_fp16_bfp16_gnchw_gkcyx_gnkhw_lds_double_buffer.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r1_fp16_bfp16_nchw_kcyx_nkhw_lds_double_buffer.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_FP16_BFP16_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r1_gnchw_gkcyx_gnkhw_lds_double_buffer.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r1_nchw_kcyx_nkhw_lds_double_buffer.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r4_ncdhw_kczyx_nkdhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_convolution_implicit_gemm_v4r4_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "static_kernel_gridwise_generic_2d_reduction_blockwise.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE_SIZE } },
    { "static_kernel_gridwise_generic_2d_reduction_direct_threadwise.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE_SIZE } },
    { "static_kernel_gridwise_generic_2d_reduction_direct_warpwise.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE_SIZE } },
    { "static_kernel_gridwise_generic_2d_reduction_multiblock.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE_SIZE } },
    { "static_kernel_gridwise_generic_reduction.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_REDUCTION_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GENERIC_REDUCTION_INCLUDE_SIZE } },
    { "static_kernel_reduction_functions.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_FUNCTIONS_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_FUNCTIONS_INCLUDE_SIZE } },
    { "static_kernel_reduction_kernel_simple_configurator.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_KERNEL_SIMPLE_CONFIGURATOR_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_KERNEL_SIMPLE_CONFIGURATOR_INCLUDE_SIZE } },
    { "static_kernel_ConstantMatrixDescriptor.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTMATRIXDESCRIPTOR_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTMATRIXDESCRIPTOR_INCLUDE_SIZE } },
    { "static_kernel_ConstantTensorDescriptor_deprecated.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTTENSORDESCRIPTOR_DEPRECATED_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_CONSTANTTENSORDESCRIPTOR_DEPRECATED_INCLUDE_SIZE } },
    { "static_kernel_dimension.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_DIMENSION_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_DIMENSION_INCLUDE_SIZE } },
    { "static_kernel_multi_index_transform.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE_SIZE } },
    { "static_kernel_tensor_coordinate.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_COORDINATE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_COORDINATE_INCLUDE_SIZE } },
    { "static_kernel_tensor_descriptor.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_INCLUDE_SIZE } },
    { "static_kernel_tensor_descriptor_helper.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE_SIZE } },
    { "static_kernel_blockwise_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_INCLUDE_SIZE } },
    { "static_kernel_blockwise_gemm_xdlops.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE_SIZE } },
    { "static_kernel_blockwise_generic_tensor_slice_copy.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_BLOCKWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE_SIZE } },
    { "static_kernel_gridwise_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_INCLUDE_SIZE } },
    { "static_kernel_gridwise_gemm_fp16_bfp16.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_FP16_BFP16_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_FP16_BFP16_INCLUDE_SIZE } },
    { "static_kernel_gridwise_gemm_xdlops_fp16_bfp16.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_XDLOPS_FP16_BFP16_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_GEMM_XDLOPS_FP16_BFP16_INCLUDE_SIZE } },
    { "static_kernel_threadwise_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GEMM_INCLUDE_SIZE } },
    { "static_kernel_threadwise_generic_tensor_slice_copy.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_THREADWISE_GENERIC_TENSOR_SLICE_COPY_INCLUDE_SIZE } },
    { "static_kernel_xdlops_gemm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INCLUDE_SIZE } },
    { "static_kernel_xdlops_gemm_inline_asm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INLINE_ASM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_XDLOPS_GEMM_INLINE_ASM_INCLUDE_SIZE } },
    { "static_kernel_amd_buffer_addressing.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE_SIZE } },
    { "static_kernel_amd_inline_asm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_AMD_INLINE_ASM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_AMD_INLINE_ASM_INCLUDE_SIZE } },
    { "static_kernel_amd_xdlops.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INCLUDE_SIZE } },
    { "static_kernel_amd_xdlops_inline_asm.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INLINE_ASM_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_AMD_XDLOPS_INLINE_ASM_INCLUDE_SIZE } },
    { "static_kernel_array.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_ARRAY_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_ARRAY_INCLUDE_SIZE } },
    { "static_kernel_ck_utils_type.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_CK_UTILS_TYPE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_CK_UTILS_TYPE_INCLUDE_SIZE } },
    { "static_kernel_common_header.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_COMMON_HEADER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_COMMON_HEADER_INCLUDE_SIZE } },
    { "static_kernel_config.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_CONFIG_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_CONFIG_INCLUDE_SIZE } },
    { "static_kernel_float_type.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_FLOAT_TYPE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_FLOAT_TYPE_INCLUDE_SIZE } },
    { "static_kernel_functional.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL_INCLUDE_SIZE } },
    { "static_kernel_functional2.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL2_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL2_INCLUDE_SIZE } },
    { "static_kernel_functional3.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL3_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL3_INCLUDE_SIZE } },
    { "static_kernel_functional4.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL4_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_FUNCTIONAL4_INCLUDE_SIZE } },
    { "static_kernel_in_memory_operation.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_IN_MEMORY_OPERATION_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_IN_MEMORY_OPERATION_INCLUDE_SIZE } },
    { "static_kernel_integral_constant.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_INTEGRAL_CONSTANT_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_INTEGRAL_CONSTANT_INCLUDE_SIZE } },
    { "static_kernel_math.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_MATH_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_MATH_INCLUDE_SIZE } },
    { "static_kernel_number.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_NUMBER_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_NUMBER_INCLUDE_SIZE } },
    { "static_kernel_reduction_common.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_COMMON_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_COMMON_INCLUDE_SIZE } },
    { "static_kernel_reduction_operator.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_OPERATOR_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_REDUCTION_OPERATOR_INCLUDE_SIZE } },
    { "static_kernel_sequence.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_SEQUENCE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_SEQUENCE_INCLUDE_SIZE } },
    { "static_kernel_synchronization.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_SYNCHRONIZATION_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_SYNCHRONIZATION_INCLUDE_SIZE } },
    { "static_kernel_tuple.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_TUPLE_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_TUPLE_INCLUDE_SIZE } },
    { "static_kernel_utility.hpp", { MIOPEN_KERNEL_STATIC_KERNEL_UTILITY_INCLUDE, MIOPEN_KERNEL_STATIC_KERNEL_UTILITY_INCLUDE_SIZE } },
    { "gridwise_operation_wrapper.hpp", { MIOPEN_KERNEL_GRIDWISE_OPERATION_WRAPPER_INCLUDE, MIOPEN_KERNEL_GRIDWISE_OPERATION_WRAPPER_INCLUDE_SIZE } },
    { "transform_backward_data_convolution_into_gemm_v4r1_nhwc_kyxc_nhwk.hpp", { MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1_NHWC_KYXC_NHWK_INCLUDE, MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1_NHWC_KYXC_NHWK_INCLUDE_SIZE } },
    { "transform_backward_data_convolution_into_gemm_v4r1r2_nhwc_kyxc_nhwk.hpp", { MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1R2_NHWC_KYXC_NHWK_INCLUDE, MIOPEN_KERNEL_TRANSFORM_BACKWARD_DATA_CONVOLUTION_INTO_GEMM_V4R1R2_NHWC_KYXC_NHWK_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v4r4_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v4r4_nhwc_kyxc_nhwk.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NHWC_KYXC_NHWK_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4_NHWC_KYXC_NHWK_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v4r4r2_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v4r4r2_nhwc_kyxc_nhwk.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NHWC_KYXC_NHWK_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R2_NHWC_KYXC_NHWK_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v4r4r4_nhwc_kyxc_nhwk.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R4_NHWC_KYXC_NHWK_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V4R4R4_NHWC_KYXC_NHWK_INCLUDE_SIZE } },
    { "transform_forward_convolution_into_gemm_v6r1_nchw_kcyx_nkhw.hpp", { MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V6R1_NCHW_KCYX_NKHW_INCLUDE, MIOPEN_KERNEL_TRANSFORM_FORWARD_CONVOLUTION_INTO_GEMM_V6R1_NCHW_KCYX_NKHW_INCLUDE_SIZE } },
    { "cluster_descriptor.hpp", { MIOPEN_KERNEL_CLUSTER_DESCRIPTOR_INCLUDE, MIOPEN_KERNEL_CLUSTER_DESCRIPTOR_INCLUDE_SIZE } },
    { "multi_index_transform.hpp", { MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE, MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_INCLUDE_SIZE } },
    { "multi_index_transform_helper.hpp", { MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_HELPER_INCLUDE, MIOPEN_KERNEL_MULTI_INDEX_TRANSFORM_HELPER_INCLUDE_SIZE } },
    { "tensor_adaptor.hpp", { MIOPEN_KERNEL_TENSOR_ADAPTOR_INCLUDE, MIOPEN_KERNEL_TENSOR_ADAPTOR_INCLUDE_SIZE } },
    { "tensor_descriptor.hpp", { MIOPEN_KERNEL_TENSOR_DESCRIPTOR_INCLUDE, MIOPEN_KERNEL_TENSOR_DESCRIPTOR_INCLUDE_SIZE } },
    { "tensor_descriptor_helper.hpp", { MIOPEN_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE, MIOPEN_KERNEL_TENSOR_DESCRIPTOR_HELPER_INCLUDE_SIZE } },
    { "blockwise_gemm_dlops_v2r2.hpp", { MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R2_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R2_INCLUDE_SIZE } },
    { "blockwise_gemm_dlops_v2r3.hpp", { MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R3_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V2R3_INCLUDE_SIZE } },
    { "blockwise_gemm_dlops_v3.hpp", { MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V3_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_GEMM_DLOPS_V3_INCLUDE_SIZE } },
    { "blockwise_gemm_xdlops.hpp", { MIOPEN_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_GEMM_XDLOPS_INCLUDE_SIZE } },
    { "blockwise_tensor_slice_transfer.hpp", { MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_INCLUDE_SIZE } },
    { "blockwise_tensor_slice_transfer_v2.hpp", { MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE, MIOPEN_KERNEL_BLOCKWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE_SIZE } },
    { "gridwise_contraction_dlops_v1r2.hpp", { MIOPEN_KERNEL_GRIDWISE_CONTRACTION_DLOPS_V1R2_INCLUDE, MIOPEN_KERNEL_GRIDWISE_CONTRACTION_DLOPS_V1R2_INCLUDE_SIZE } },
    { "gridwise_gemm_dlops_v1r2.hpp", { MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R2_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R2_INCLUDE_SIZE } },
    { "gridwise_gemm_dlops_v1r3.hpp", { MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R3_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V1R3_INCLUDE_SIZE } },
    { "gridwise_gemm_dlops_v2.hpp", { MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V2_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GEMM_DLOPS_V2_INCLUDE_SIZE } },
    { "gridwise_gemm_xdlops_v2r3.hpp", { MIOPEN_KERNEL_GRIDWISE_GEMM_XDLOPS_V2R3_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GEMM_XDLOPS_V2R3_INCLUDE_SIZE } },
    { "gridwise_generic_2d_reduction_blockwise.hpp", { MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_BLOCKWISE_INCLUDE_SIZE } },
    { "gridwise_generic_2d_reduction_direct_threadwise.hpp", { MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_THREADWISE_INCLUDE_SIZE } },
    { "gridwise_generic_2d_reduction_direct_warpwise.hpp", { MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_DIRECT_WARPWISE_INCLUDE_SIZE } },
    { "gridwise_generic_2d_reduction_multiblock.hpp", { MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE, MIOPEN_KERNEL_GRIDWISE_GENERIC_2D_REDUCTION_MULTIBLOCK_INCLUDE_SIZE } },
    { "reduction_functions_blockwise.hpp", { MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BLOCKWISE_INCLUDE, MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BLOCKWISE_INCLUDE_SIZE } },
    { "reduction_functions_threadwise.hpp", { MIOPEN_KERNEL_REDUCTION_FUNCTIONS_THREADWISE_INCLUDE, MIOPEN_KERNEL_REDUCTION_FUNCTIONS_THREADWISE_INCLUDE_SIZE } },
    { "reduction_functions_warpwise.hpp", { MIOPEN_KERNEL_REDUCTION_FUNCTIONS_WARPWISE_INCLUDE, MIOPEN_KERNEL_REDUCTION_FUNCTIONS_WARPWISE_INCLUDE_SIZE } },
    { "threadwise_contraction_dlops.hpp", { MIOPEN_KERNEL_THREADWISE_CONTRACTION_DLOPS_INCLUDE, MIOPEN_KERNEL_THREADWISE_CONTRACTION_DLOPS_INCLUDE_SIZE } },
    { "threadwise_gemm_dlops_v3.hpp", { MIOPEN_KERNEL_THREADWISE_GEMM_DLOPS_V3_INCLUDE, MIOPEN_KERNEL_THREADWISE_GEMM_DLOPS_V3_INCLUDE_SIZE } },
    { "threadwise_tensor_slice_set.hpp", { MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_SET_INCLUDE, MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_SET_INCLUDE_SIZE } },
    { "threadwise_tensor_slice_transfer.hpp", { MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_INCLUDE, MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_INCLUDE_SIZE } },
    { "threadwise_tensor_slice_transfer_v2.hpp", { MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE, MIOPEN_KERNEL_THREADWISE_TENSOR_SLICE_TRANSFER_V2_INCLUDE_SIZE } },
    { "xdlops_gemm.hpp", { MIOPEN_KERNEL_XDLOPS_GEMM_INCLUDE, MIOPEN_KERNEL_XDLOPS_GEMM_INCLUDE_SIZE } },
    { "amd_address_space.hpp", { MIOPEN_KERNEL_AMD_ADDRESS_SPACE_INCLUDE, MIOPEN_KERNEL_AMD_ADDRESS_SPACE_INCLUDE_SIZE } },
    { "amd_buffer_addressing.hpp", { MIOPEN_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE, MIOPEN_KERNEL_AMD_BUFFER_ADDRESSING_INCLUDE_SIZE } },
    { "amd_inline_asm.hpp", { MIOPEN_KERNEL_AMD_INLINE_ASM_INCLUDE, MIOPEN_KERNEL_AMD_INLINE_ASM_INCLUDE_SIZE } },
    { "amd_llvm_intrinsic.hpp", { MIOPEN_KERNEL_AMD_LLVM_INTRINSIC_INCLUDE, MIOPEN_KERNEL_AMD_LLVM_INTRINSIC_INCLUDE_SIZE } },
    { "amd_xdlops.hpp", { MIOPEN_KERNEL_AMD_XDLOPS_INCLUDE, MIOPEN_KERNEL_AMD_XDLOPS_INCLUDE_SIZE } },
    { "array.hpp", { MIOPEN_KERNEL_ARRAY_INCLUDE, MIOPEN_KERNEL_ARRAY_INCLUDE_SIZE } },
    { "array_multi_index.hpp", { MIOPEN_KERNEL_ARRAY_MULTI_INDEX_INCLUDE, MIOPEN_KERNEL_ARRAY_MULTI_INDEX_INCLUDE_SIZE } },
    { "c_style_pointer_cast.hpp", { MIOPEN_KERNEL_C_STYLE_POINTER_CAST_INCLUDE, MIOPEN_KERNEL_C_STYLE_POINTER_CAST_INCLUDE_SIZE } },
    { "common_header.hpp", { MIOPEN_KERNEL_COMMON_HEADER_INCLUDE, MIOPEN_KERNEL_COMMON_HEADER_INCLUDE_SIZE } },
    { "config.hpp", { MIOPEN_KERNEL_CONFIG_INCLUDE, MIOPEN_KERNEL_CONFIG_INCLUDE_SIZE } },
    { "container_element_picker.hpp", { MIOPEN_KERNEL_CONTAINER_ELEMENT_PICKER_INCLUDE, MIOPEN_KERNEL_CONTAINER_ELEMENT_PICKER_INCLUDE_SIZE } },
    { "container_helper.hpp", { MIOPEN_KERNEL_CONTAINER_HELPER_INCLUDE, MIOPEN_KERNEL_CONTAINER_HELPER_INCLUDE_SIZE } },
    { "data_type.hpp", { MIOPEN_KERNEL_DATA_TYPE_INCLUDE, MIOPEN_KERNEL_DATA_TYPE_INCLUDE_SIZE } },
    { "data_type_enum.hpp", { MIOPEN_KERNEL_DATA_TYPE_ENUM_INCLUDE, MIOPEN_KERNEL_DATA_TYPE_ENUM_INCLUDE_SIZE } },
    { "data_type_enum_helper.hpp", { MIOPEN_KERNEL_DATA_TYPE_ENUM_HELPER_INCLUDE, MIOPEN_KERNEL_DATA_TYPE_ENUM_HELPER_INCLUDE_SIZE } },
    { "dynamic_buffer.hpp", { MIOPEN_KERNEL_DYNAMIC_BUFFER_INCLUDE, MIOPEN_KERNEL_DYNAMIC_BUFFER_INCLUDE_SIZE } },
    { "enable_if.hpp", { MIOPEN_KERNEL_ENABLE_IF_INCLUDE, MIOPEN_KERNEL_ENABLE_IF_INCLUDE_SIZE } },
    { "functional.hpp", { MIOPEN_KERNEL_FUNCTIONAL_INCLUDE, MIOPEN_KERNEL_FUNCTIONAL_INCLUDE_SIZE } },
    { "functional2.hpp", { MIOPEN_KERNEL_FUNCTIONAL2_INCLUDE, MIOPEN_KERNEL_FUNCTIONAL2_INCLUDE_SIZE } },
    { "functional3.hpp", { MIOPEN_KERNEL_FUNCTIONAL3_INCLUDE, MIOPEN_KERNEL_FUNCTIONAL3_INCLUDE_SIZE } },
    { "functional4.hpp", { MIOPEN_KERNEL_FUNCTIONAL4_INCLUDE, MIOPEN_KERNEL_FUNCTIONAL4_INCLUDE_SIZE } },
    { "inner_product.hpp", { MIOPEN_KERNEL_INNER_PRODUCT_INCLUDE, MIOPEN_KERNEL_INNER_PRODUCT_INCLUDE_SIZE } },
    { "integral_constant.hpp", { MIOPEN_KERNEL_INTEGRAL_CONSTANT_INCLUDE, MIOPEN_KERNEL_INTEGRAL_CONSTANT_INCLUDE_SIZE } },
    { "magic_division.hpp", { MIOPEN_KERNEL_MAGIC_DIVISION_INCLUDE, MIOPEN_KERNEL_MAGIC_DIVISION_INCLUDE_SIZE } },
    { "math.hpp", { MIOPEN_KERNEL_MATH_INCLUDE, MIOPEN_KERNEL_MATH_INCLUDE_SIZE } },
    { "multi_index.hpp", { MIOPEN_KERNEL_MULTI_INDEX_INCLUDE, MIOPEN_KERNEL_MULTI_INDEX_INCLUDE_SIZE } },
    { "number.hpp", { MIOPEN_KERNEL_NUMBER_INCLUDE, MIOPEN_KERNEL_NUMBER_INCLUDE_SIZE } },
    { "print.hpp", { MIOPEN_KERNEL_PRINT_INCLUDE, MIOPEN_KERNEL_PRINT_INCLUDE_SIZE } },
    { "reduction_common.hpp", { MIOPEN_KERNEL_REDUCTION_COMMON_INCLUDE, MIOPEN_KERNEL_REDUCTION_COMMON_INCLUDE_SIZE } },
    { "reduction_enums.hpp", { MIOPEN_KERNEL_REDUCTION_ENUMS_INCLUDE, MIOPEN_KERNEL_REDUCTION_ENUMS_INCLUDE_SIZE } },
    { "reduction_functions_binop.hpp", { MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BINOP_INCLUDE, MIOPEN_KERNEL_REDUCTION_FUNCTIONS_BINOP_INCLUDE_SIZE } },
    { "reduction_operator.hpp", { MIOPEN_KERNEL_REDUCTION_OPERATOR_INCLUDE, MIOPEN_KERNEL_REDUCTION_OPERATOR_INCLUDE_SIZE } },
    { "sequence.hpp", { MIOPEN_KERNEL_SEQUENCE_INCLUDE, MIOPEN_KERNEL_SEQUENCE_INCLUDE_SIZE } },
    { "sequence_helper.hpp", { MIOPEN_KERNEL_SEQUENCE_HELPER_INCLUDE, MIOPEN_KERNEL_SEQUENCE_HELPER_INCLUDE_SIZE } },
    { "static_buffer.hpp", { MIOPEN_KERNEL_STATIC_BUFFER_INCLUDE, MIOPEN_KERNEL_STATIC_BUFFER_INCLUDE_SIZE } },
    { "statically_indexed_array.hpp", { MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_INCLUDE, MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_INCLUDE_SIZE } },
    { "statically_indexed_array_multi_index.hpp", { MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_MULTI_INDEX_INCLUDE, MIOPEN_KERNEL_STATICALLY_INDEXED_ARRAY_MULTI_INDEX_INCLUDE_SIZE } },
    { "synchronization.hpp", { MIOPEN_KERNEL_SYNCHRONIZATION_INCLUDE, MIOPEN_KERNEL_SYNCHRONIZATION_INCLUDE_SIZE } },
    { "tuple.hpp", { MIOPEN_KERNEL_TUPLE_INCLUDE, MIOPEN_KERNEL_TUPLE_INCLUDE_SIZE } },
    { "tuple_helper.hpp", { MIOPEN_KERNEL_TUPLE_HELPER_INCLUDE, MIOPEN_KERNEL_TUPLE_HELPER_INCLUDE_SIZE } },
    { "type.hpp", { MIOPEN_KERNEL_TYPE_INCLUDE, MIOPEN_KERNEL_TYPE_INCLUDE_SIZE } },
    { "utility.hpp", { MIOPEN_KERNEL_UTILITY_INCLUDE, MIOPEN_KERNEL_UTILITY_INCLUDE_SIZE } },
    { "igemm_fwd_gtcn2_nchwc_cyxkc_fp16x4_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcn2_nchwc_cyxkc_fp16x8_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx2_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx2_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx2_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx2_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx2_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx2_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx2_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx2_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX2_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx3_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx3_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_bwd_gtcx3_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_BWD_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx3_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx3_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_fwd_gtcx3_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_FWD_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx3_nhwc_bf16_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_BF16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_BF16_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx3_nhwc_fp16_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP16_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP16_UTILS_INCLUDE_SIZE } },
    { "igemm_wrw_gtcx3_nhwc_fp32_utils.inc", { MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP32_UTILS_INCLUDE, MIOPEN_KERNEL_IGEMM_WRW_GTCX3_NHWC_FP32_UTILS_INCLUDE_SIZE } },
    { "general_tensor_reorder_kernel_util.hpp", { MIOPEN_KERNEL_GENERAL_TENSOR_REORDER_KERNEL_UTIL_INCLUDE, MIOPEN_KERNEL_GENERAL_TENSOR_REORDER_KERNEL_UTIL_INCLUDE_SIZE } },
    { "implicitgemm_params.hpp", { MIOPEN_KERNEL_IMPLICITGEMM_PARAMS_INCLUDE, MIOPEN_KERNEL_IMPLICITGEMM_PARAMS_INCLUDE_SIZE } },
    { "activation_functions.hpp", { MIOPEN_KERNEL_ACTIVATION_FUNCTIONS_INCLUDE, MIOPEN_KERNEL_ACTIVATION_FUNCTIONS_INCLUDE_SIZE } },
    { "fp8_kern_types.h", { MIOPEN_KERNEL_FP8_KERN_TYPES_INCLUDE, MIOPEN_KERNEL_FP8_KERN_TYPES_INCLUDE_SIZE } },
    { "Conv_Winograd_v13_3_12_fp16dot_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v13_3_12_fp16dot_stride2_dec.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DEC_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DEC_INCLUDE_SIZE } },
    { "Conv_Winograd_v13_3_12_fp16dot_stride2_dil.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DIL_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_FP16DOT_STRIDE2_DIL_INCLUDE_SIZE } },
    { "Conv_Winograd_v14_3_3_fp16dot_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v14_3_3_fp16dot_stride2_dec.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DEC_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DEC_INCLUDE_SIZE } },
    { "Conv_Winograd_v14_3_3_fp16dot_stride2_dil.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DIL_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V14_3_3_FP16DOT_STRIDE2_DIL_INCLUDE_SIZE } },
    { "Conv_Winograd_v13_3_12_epilogue.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_EPILOGUE_INCLUDE_SIZE } },
    { "Conv_Winograd_v13_3_12_prologue.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V13_3_12_PROLOGUE_INCLUDE_SIZE } },
    { "Conv_Winograd_v16_5_0_epilogue.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_EPILOGUE_INCLUDE_SIZE } },
    { "Conv_Winograd_v16_5_0_prologue.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_PROLOGUE_INCLUDE_SIZE } },
    { "Conv_Winograd_v16_5_0_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V16_5_0_STRIDE1_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_2_7_epilogue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_EPILOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_2_7_prologue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_PROLOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_2_7_gfx8_stride_2_dec.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_STRIDE_2_DEC_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_STRIDE_2_DEC_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_2_7_gfx8.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_2_7_GFX8_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v3_0b_epilogue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_EPILOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v3_0b_prologue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_PROLOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v3_0b.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V3_0B_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v7_0_3b_epilogue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_EPILOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v7_0_3b_prologue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_PROLOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v7_0_3b.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V7_0_3B_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_epilogue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_EPILOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_EPILOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_prologue.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_PROLOGUE_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_PROLOGUE_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx8_stride_2_dil.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DIL_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DIL_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx8_stride_2_dec.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DEC_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_STRIDE_2_DEC_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx8.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX8_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx9_stride_2_dil.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DIL_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DIL_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx9_stride_2_dec.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DEC_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_STRIDE_2_DEC_INCLUDE_SIZE } },
    { "conv_3x3_wheel_alpha_v9_0_15_gfx9.inc", { MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_INCLUDE, MIOPEN_KERNEL_CONV_3X3_WHEEL_ALPHA_V9_0_15_GFX9_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp16_dot2_edc_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp16_dot2_edc_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp16_dot2_edc_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp16_dot2_edc_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp32_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp32_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp32_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_gfx9_fp32_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_GFX9_FP32_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v21_1_3_metadata.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_METADATA_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V21_1_3_METADATA_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f2x3_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f2x3_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f2x3_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F2X3_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp16_dot2_edc_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx94x_fp32_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX94X_FP32_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp16_dot2_edc_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP16_DOT2_EDC_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx9_fp32_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX9_FP32_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp16_dot2_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP16_DOT2_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx10_fp32_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX10_FP32_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp16_dot2_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP16_DOT2_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f3x2_dilation2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_DILATION2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_DILATION2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f3x2_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_gfx11_fp32_f3x2_stride2.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE2_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_GFX11_FP32_F3X2_STRIDE2_INCLUDE_SIZE } },
    { "Conv_Winograd_v30_3_1_metadata.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_METADATA_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_V30_3_1_METADATA_INCLUDE_SIZE } },
    { "MIOpenReduceCalculation.hpp", { MIOPEN_KERNEL_MIOPENREDUCECALCULATION_INCLUDE, MIOPEN_KERNEL_MIOPENREDUCECALCULATION_INCLUDE_SIZE } },
    { "MIOpenReduceExtreme.hpp", { MIOPEN_KERNEL_MIOPENREDUCEEXTREME_INCLUDE, MIOPEN_KERNEL_MIOPENREDUCEEXTREME_INCLUDE_SIZE } },
    { "bfloat16_dev.hpp", { MIOPEN_KERNEL_BFLOAT16_DEV_INCLUDE, MIOPEN_KERNEL_BFLOAT16_DEV_INCLUDE_SIZE } },
    { "block_reduce.hpp", { MIOPEN_KERNEL_BLOCK_REDUCE_INCLUDE, MIOPEN_KERNEL_BLOCK_REDUCE_INCLUDE_SIZE } },
    { "conv_common.inc", { MIOPEN_KERNEL_CONV_COMMON_INCLUDE, MIOPEN_KERNEL_CONV_COMMON_INCLUDE_SIZE } },
    { "conv_sizes.inc", { MIOPEN_KERNEL_CONV_SIZES_INCLUDE, MIOPEN_KERNEL_CONV_SIZES_INCLUDE_SIZE } },
    { "float_types.h", { MIOPEN_KERNEL_FLOAT_TYPES_INCLUDE, MIOPEN_KERNEL_FLOAT_TYPES_INCLUDE_SIZE } },
    { "gpr_alloc.inc", { MIOPEN_KERNEL_GPR_ALLOC_INCLUDE, MIOPEN_KERNEL_GPR_ALLOC_INCLUDE_SIZE } },
    { "hip_atomic.hpp", { MIOPEN_KERNEL_HIP_ATOMIC_INCLUDE, MIOPEN_KERNEL_HIP_ATOMIC_INCLUDE_SIZE } },
    { "hip_f8_impl.hpp", { MIOPEN_KERNEL_HIP_F8_IMPL_INCLUDE, MIOPEN_KERNEL_HIP_F8_IMPL_INCLUDE_SIZE } },
    { "hip_float8.hpp", { MIOPEN_KERNEL_HIP_FLOAT8_INCLUDE, MIOPEN_KERNEL_HIP_FLOAT8_INCLUDE_SIZE } },
    { "inst_wrappers.inc", { MIOPEN_KERNEL_INST_WRAPPERS_INCLUDE, MIOPEN_KERNEL_INST_WRAPPERS_INCLUDE_SIZE } },
    { "miopen_cstdint.hpp", { MIOPEN_KERNEL_MIOPEN_CSTDINT_INCLUDE, MIOPEN_KERNEL_MIOPEN_CSTDINT_INCLUDE_SIZE } },
    { "miopen_limits.hpp", { MIOPEN_KERNEL_MIOPEN_LIMITS_INCLUDE, MIOPEN_KERNEL_MIOPEN_LIMITS_INCLUDE_SIZE } },
    { "miopen_rocrand.hpp", { MIOPEN_KERNEL_MIOPEN_ROCRAND_INCLUDE, MIOPEN_KERNEL_MIOPEN_ROCRAND_INCLUDE_SIZE } },
    { "miopen_type_traits.hpp", { MIOPEN_KERNEL_MIOPEN_TYPE_TRAITS_INCLUDE, MIOPEN_KERNEL_MIOPEN_TYPE_TRAITS_INCLUDE_SIZE } },
    { "miopen_utility.hpp", { MIOPEN_KERNEL_MIOPEN_UTILITY_INCLUDE, MIOPEN_KERNEL_MIOPEN_UTILITY_INCLUDE_SIZE } },
    { "neuron.inc", { MIOPEN_KERNEL_NEURON_INCLUDE, MIOPEN_KERNEL_NEURON_INCLUDE_SIZE } },
    { "radix.hpp", { MIOPEN_KERNEL_RADIX_INCLUDE, MIOPEN_KERNEL_RADIX_INCLUDE_SIZE } },
    { "rocm_version.inc", { MIOPEN_KERNEL_ROCM_VERSION_INCLUDE, MIOPEN_KERNEL_ROCM_VERSION_INCLUDE_SIZE } },
    { "stride_array.hpp", { MIOPEN_KERNEL_STRIDE_ARRAY_INCLUDE, MIOPEN_KERNEL_STRIDE_ARRAY_INCLUDE_SIZE } },
    { "tensor_view.hpp", { MIOPEN_KERNEL_TENSOR_VIEW_INCLUDE, MIOPEN_KERNEL_TENSOR_VIEW_INCLUDE_SIZE } },
    { "utilities.inc", { MIOPEN_KERNEL_UTILITIES_INCLUDE, MIOPEN_KERNEL_UTILITIES_INCLUDE_SIZE } },
    { "warp_reduce.hpp", { MIOPEN_KERNEL_WARP_REDUCE_INCLUDE, MIOPEN_KERNEL_WARP_REDUCE_INCLUDE_SIZE } },
    { "Conv_Winograd_Fury_v2_4_1_gfx11_1536vgprs_fp16_fp16acc_f2x3_c16_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_Fury_v2_4_1_gfx11_1536vgprs_fp16_fp16acc_f2x3_c32_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C32_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1536VGPRS_FP16_FP16ACC_F2X3_C32_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_Fury_v2_4_1_gfx11_1024vgprs_fp16_fp16acc_f2x3_c16_stride1.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1024VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_GFX11_1024VGPRS_FP16_FP16ACC_F2X3_C16_STRIDE1_INCLUDE_SIZE } },
    { "Conv_Winograd_Fury_v2_4_1_metadata.inc", { MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_METADATA_INCLUDE, MIOPEN_KERNEL_CONV_WINOGRAD_FURY_V2_4_1_METADATA_INCLUDE_SIZE } },
    { "workaround_issue_1431.hpp", { MIOPEN_KERNEL_WORKAROUND_ISSUE_1431_INCLUDE, MIOPEN_KERNEL_WORKAROUND_ISSUE_1431_INCLUDE_SIZE } },
    { "xform_bidirect_winograd_code.inc", { MIOPEN_KERNEL_XFORM_BIDIRECT_WINOGRAD_CODE_INCLUDE, MIOPEN_KERNEL_XFORM_BIDIRECT_WINOGRAD_CODE_INCLUDE_SIZE } },
    { "xform_data_filter.inc", { MIOPEN_KERNEL_XFORM_DATA_FILTER_INCLUDE, MIOPEN_KERNEL_XFORM_DATA_FILTER_INCLUDE_SIZE } },
    { "xform_kd_cov2.inc", { MIOPEN_KERNEL_XFORM_KD_COV2_INCLUDE, MIOPEN_KERNEL_XFORM_KD_COV2_INCLUDE_SIZE } },
    { "xform_metadata.inc", { MIOPEN_KERNEL_XFORM_METADATA_INCLUDE, MIOPEN_KERNEL_XFORM_METADATA_INCLUDE_SIZE } }
#endif
    };
    return data;
}

std::string_view GetKernelInc(const fs::path& name)
{
    auto it = kernel_includes().find(name.filename());
    if(it == kernel_includes().end())
        MIOPEN_THROW("Failed to load kernel source: " + name.filename());

    return it->second;
}

const std::vector<std::reference_wrapper<const fs::path>>& GetKernelIncList()
{
    static const std::vector<std::reference_wrapper<const fs::path>> keys{[]() {
        std::vector<std::reference_wrapper<const fs::path>> ref_keys;
        for(const auto& m : kernel_includes())
        {
            if(m.first.extension() == ".hpp" || m.first.extension() == ".h")
                ref_keys.emplace_back(std::cref(m.first));
        }
        return ref_keys;
    }()};
    return keys;
}

} // namespace miopen
