
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kxmlguiclient_wrapper.h"

// Wrappers providing overrides
#include "kxmlguiclient_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <kactioncollection.h>
#include <kxmlguibuilder.h>
#include <kxmlguiclient.h>
#include <kxmlguifactory.h>
#include <qaction.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KXMLGUIClient_Type = nullptr;
static PyTypeObject *Sbk_KXMLGUIClient_TypeF(void)
{
    return _Sbk_KXMLGUIClient_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KXMLGUIClientWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KXMLGUIClientWrapper::KXMLGUIClientWrapper()
{
}

KXMLGUIClientWrapper::KXMLGUIClientWrapper(::KXMLGUIClient * parent) : KXMLGUIClient(parent)
{
}

::KActionCollection * KXMLGUIClientWrapper::actionCollection() const
{
    static const char *funcName = "actionCollection";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::actionCollection();
    }
    return sbk_o_actionCollection("KXMLGUIClient", funcName, gil, pyOverride);
}

::KActionCollection * KXMLGUIClientWrapper::sbk_o_actionCollection(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< KActionCollection >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::KActionCollection *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString KXMLGUIClientWrapper::componentName() const
{
    static const char *funcName = "componentName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::componentName();
    }
    return sbk_o_componentName("KXMLGUIClient", funcName, gil, pyOverride);
}

::QString KXMLGUIClientWrapper::sbk_o_componentName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString KXMLGUIClientWrapper::localXMLFile() const
{
    static const char *funcName = "localXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::localXMLFile();
    }
    return KXMLGUIClientWrapper::sbk_o_componentName("KXMLGUIClient", funcName, gil, pyOverride);
}

void KXMLGUIClientWrapper::setComponentName(const ::QString & componentName, const ::QString & componentDisplayName)
{
    static const char *funcName = "setComponentName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setComponentName(componentName, componentDisplayName);
    }
    sbk_o_setComponentName("KXMLGUIClient", funcName, gil, pyOverride, componentName, componentDisplayName);
}

void KXMLGUIClientWrapper::sbk_o_setComponentName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & componentName, const ::QString & componentDisplayName)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &componentName),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &componentDisplayName)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &componentName),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &componentDisplayName)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIClientWrapper::setLocalXMLFile(const ::QString & file)
{
    static const char *funcName = "setLocalXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setLocalXMLFile(file);
    }
    sbk_o_setLocalXMLFile("KXMLGUIClient", funcName, gil, pyOverride, file);
}

void KXMLGUIClientWrapper::sbk_o_setLocalXMLFile(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & file)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &file)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &file)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIClientWrapper::setXML(const ::QString & document, bool merge)
{
    static const char *funcName = "setXML";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setXML(document, merge);
    }
    sbk_o_setXML("KXMLGUIClient", funcName, gil, pyOverride, document, merge);
}

void KXMLGUIClientWrapper::sbk_o_setXML(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & document, bool merge)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &document),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &merge)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &document),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &merge)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIClientWrapper::setXMLFile(const ::QString & file, bool merge, bool setXMLDoc)
{
    static const char *funcName = "setXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setXMLFile(file, merge, setXMLDoc);
    }
    sbk_o_setXMLFile("KXMLGUIClient", funcName, gil, pyOverride, file, merge, setXMLDoc);
}

void KXMLGUIClientWrapper::sbk_o_setXMLFile(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & file, bool merge, bool setXMLDoc)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &file),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &merge),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &setXMLDoc)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &file),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &merge),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &setXMLDoc)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIClientWrapper::stateChanged(const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse)
{
    static const char *funcName = "stateChanged";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::stateChanged(newstate, reverse);
    }
    sbk_o_stateChanged("KXMLGUIClient", funcName, gil, pyOverride, newstate, reverse);
}

void KXMLGUIClientWrapper::sbk_o_stateChanged(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &newstate),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX])))->converter, &reverse)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &newstate),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX])))->converter, &reverse)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QString KXMLGUIClientWrapper::xmlFile() const
{
    static const char *funcName = "xmlFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIClient_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::xmlFile();
    }
    return KXMLGUIClientWrapper::sbk_o_componentName("KXMLGUIClient", funcName, gil, pyOverride);
}

KXMLGUIClientWrapper::~KXMLGUIClientWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KXMLGUIClient_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KXMLGUIClient_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KXMLGUIClient >()))
        return -1;

    KXMLGUIClientWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KXMLGUIClient", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KXMLGUIClient::KXMLGUIClient()
    // 1: KXMLGUIClient::KXMLGUIClient(KXMLGUIClient*)
    if (numArgs == 0) {
        overloadId = 0; // KXMLGUIClient()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KXMLGUIClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KXMLGUIClient()
        {

            // KXMLGUIClient()
            cptr = new KXMLGUIClientWrapper();
            break;
        }
        case 1: // KXMLGUIClient(KXMLGUIClient *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KXMLGUIClient *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KXMLGUIClient(KXMLGUIClient*)
                cptr = new KXMLGUIClientWrapper(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KXMLGUIClient >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KXMLGUIClientFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::action(QString)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // action(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "action", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // action(QString)const
            QAction * cppResult = const_cast<const ::KXMLGUIClient *>(cppSelf)->action(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_actionCollection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actionCollection()const
        KActionCollection * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIClient *>(cppSelf)->::KXMLGUIClient::actionCollection()
            : const_cast<const ::KXMLGUIClient *>(cppSelf)->actionCollection();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_addStateActionDisabled(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addStateActionDisabled", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::addStateActionDisabled(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // addStateActionDisabled(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addStateActionDisabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addStateActionDisabled(QString,QString)
            cppSelf->addStateActionDisabled(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_addStateActionEnabled(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addStateActionEnabled", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::addStateActionEnabled(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // addStateActionEnabled(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addStateActionEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addStateActionEnabled(QString,QString)
            cppSelf->addStateActionEnabled(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_beginXMLPlug(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::beginXMLPlug(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // beginXMLPlug(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "beginXMLPlug", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // beginXMLPlug(QWidget*)
            cppSelf->beginXMLPlug(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_childClients(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // childClients()
        QList<KXMLGUIClient*> cppResult = cppSelf->childClients();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KXMLGUIClientPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_clientBuilder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clientBuilder()const
        KXMLGUIBuilder * cppResult = const_cast<const ::KXMLGUIClient *>(cppSelf)->clientBuilder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_componentName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // componentName()const
        QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIClient *>(cppSelf)->::KXMLGUIClient::componentName()
            : const_cast<const ::KXMLGUIClient *>(cppSelf)->componentName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_endXMLPlug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // endXMLPlug()
        cppSelf->endXMLPlug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_factory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // factory()const
        KXMLGUIFactory * cppResult = const_cast<const ::KXMLGUIClient *>(cppSelf)->factory();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_findMostRecentXMLFile(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "findMostRecentXMLFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KXMLGUIClient::findMostRecentXMLFile(QStringList,QString&)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // findMostRecentXMLFile(QStringList,QString&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "findMostRecentXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // findMostRecentXMLFile(QStringList,QString&)
            QString cppResult = ::KXMLGUIClient::findMostRecentXMLFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_findVersionNumber(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KXMLGUIClient::findVersionNumber(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // findVersionNumber(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "findVersionNumber", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // findVersionNumber(QString)
            QString cppResult = ::KXMLGUIClient::findVersionNumber(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_insertChildClient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::insertChildClient(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // insertChildClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "insertChildClient", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertChildClient(KXMLGUIClient*)
            cppSelf->insertChildClient(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_loadStandardsXmlFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadStandardsXmlFile()
        cppSelf->loadStandardsXmlFile();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_localXMLFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // localXMLFile()const
        QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIClient *>(cppSelf)->::KXMLGUIClient::localXMLFile()
            : const_cast<const ::KXMLGUIClient *>(cppSelf)->localXMLFile();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_parentClient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // parentClient()const
        KXMLGUIClient * cppResult = const_cast<const ::KXMLGUIClient *>(cppSelf)->parentClient();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_plugActionList(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "plugActionList", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::plugActionList(QString,QList<QAction*>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], (pyArgs[1])))) {
        overloadId = 0; // plugActionList(QString,QList<QAction*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "plugActionList", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QList<QAction*> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // plugActionList(QString,QList<QAction*>)
            cppSelf->plugActionList(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_prepareXMLUnplug(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::prepareXMLUnplug(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // prepareXMLUnplug(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "prepareXMLUnplug", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // prepareXMLUnplug(QWidget*)
            cppSelf->prepareXMLUnplug(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_reloadXML(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reloadXML()
        cppSelf->reloadXML();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_removeChildClient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::removeChildClient(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // removeChildClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeChildClient", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeChildClient(KXMLGUIClient*)
            cppSelf->removeChildClient(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_replaceXMLFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "replaceXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:replaceXMLFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::replaceXMLFile(QString,QString,bool=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // replaceXMLFile(QString,QString,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // replaceXMLFile(QString,QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "replaceXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"merge", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "replaceXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // replaceXMLFile(QString,QString,bool)
            cppSelf->replaceXMLFile(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setClientBuilder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::setClientBuilder(KXMLGUIBuilder*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), (pyArg)))) {
        overloadId = 0; // setClientBuilder(KXMLGUIBuilder*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setClientBuilder", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIBuilder *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setClientBuilder(KXMLGUIBuilder*)
            cppSelf->setClientBuilder(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setComponentName(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setComponentName", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::setComponentName(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setComponentName(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setComponentName", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentName(QString,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIClient::setComponentName(cppArg0, cppArg1)
                : cppSelf->setComponentName(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setFactory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::setFactory(KXMLGUIFactory*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), (pyArg)))) {
        overloadId = 0; // setFactory(KXMLGUIFactory*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFactory", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIFactory *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFactory(KXMLGUIFactory*)
            cppSelf->setFactory(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setLocalXMLFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::setLocalXMLFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLocalXMLFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLocalXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLocalXMLFile(QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIClient::setLocalXMLFile(cppArg0)
                : cppSelf->setLocalXMLFile(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setXML(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setXML", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setXML", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::setXML(QString,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setXML(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setXML(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setXML", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"merge", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setXML", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setXML(QString,bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIClient::setXML(cppArg0, cppArg1)
                : cppSelf->setXML(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_setXMLFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setXMLFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::setXMLFile(QString,bool=,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setXMLFile(QString,bool,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setXMLFile(QString,bool,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 0; // setXMLFile(QString,bool,bool)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"merge", 1}, {"setXMLDoc", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setXMLFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = true;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setXMLFile(QString,bool,bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIClient::setXMLFile(cppArg0, cppArg1, cppArg2)
                : cppSelf->setXMLFile(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_standardsXmlFileLocation(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // standardsXmlFileLocation()
        QString cppResult = ::KXMLGUIClient::standardsXmlFileLocation();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIClientFunc_stateChanged(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "stateChanged", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    if (PyArg_ParseTuple(args, "|OO:stateChanged", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIClient::stateChanged(QString,KXMLGUIClient::ReverseStateChange=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // stateChanged(QString,KXMLGUIClient::ReverseStateChange)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // stateChanged(QString,KXMLGUIClient::ReverseStateChange)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "stateChanged", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"reverse", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX])))->converter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "stateChanged", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KXMLGUIClient::ReverseStateChange cppArg1(KXMLGUIClient::ReverseStateChange::StateNoReverse);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // stateChanged(QString,KXMLGUIClient::ReverseStateChange)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIClient::stateChanged(cppArg0, cppArg1)
                : cppSelf->stateChanged(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_unplugActionList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIClient::unplugActionList(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // unplugActionList(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unplugActionList", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unplugActionList(QString)
            cppSelf->unplugActionList(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIClientFunc_xmlFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // xmlFile()const
        QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIClient *>(cppSelf)->::KXMLGUIClient::xmlFile()
            : const_cast<const ::KXMLGUIClient *>(cppSelf)->xmlFile();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KXMLGUIClient_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KXMLGUIClient_EnumFlagInfo[] = {
    "ReverseStateChange:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KXMLGUIClient_methods[] = {
    {"action", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_action), METH_O, nullptr},
    {"actionCollection", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_actionCollection), METH_NOARGS, nullptr},
    {"addStateActionDisabled", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_addStateActionDisabled), METH_VARARGS, nullptr},
    {"addStateActionEnabled", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_addStateActionEnabled), METH_VARARGS, nullptr},
    {"beginXMLPlug", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_beginXMLPlug), METH_O, nullptr},
    {"childClients", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_childClients), METH_NOARGS, nullptr},
    {"clientBuilder", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_clientBuilder), METH_NOARGS, nullptr},
    {"componentName", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_componentName), METH_NOARGS, nullptr},
    {"endXMLPlug", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_endXMLPlug), METH_NOARGS, nullptr},
    {"factory", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_factory), METH_NOARGS, nullptr},
    {"findMostRecentXMLFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_findMostRecentXMLFile), METH_VARARGS|METH_STATIC, nullptr},
    {"findVersionNumber", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_findVersionNumber), METH_O|METH_STATIC, nullptr},
    {"insertChildClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_insertChildClient), METH_O, nullptr},
    {"loadStandardsXmlFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_loadStandardsXmlFile), METH_NOARGS, nullptr},
    {"localXMLFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_localXMLFile), METH_NOARGS, nullptr},
    {"parentClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_parentClient), METH_NOARGS, nullptr},
    {"plugActionList", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_plugActionList), METH_VARARGS, nullptr},
    {"prepareXMLUnplug", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_prepareXMLUnplug), METH_O, nullptr},
    {"reloadXML", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_reloadXML), METH_NOARGS, nullptr},
    {"removeChildClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_removeChildClient), METH_O, nullptr},
    {"replaceXMLFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_replaceXMLFile), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setClientBuilder", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setClientBuilder), METH_O, nullptr},
    {"setComponentName", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setComponentName), METH_VARARGS, nullptr},
    {"setFactory", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setFactory), METH_O, nullptr},
    {"setLocalXMLFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setLocalXMLFile), METH_O, nullptr},
    {"setXML", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setXML), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setXMLFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_setXMLFile), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"standardsXmlFileLocation", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_standardsXmlFileLocation), METH_NOARGS|METH_STATIC, nullptr},
    {"stateChanged", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_stateChanged), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"unplugActionList", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_unplugActionList), METH_O, nullptr},
    {"xmlFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIClientFunc_xmlFile), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KXMLGUIClient_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KXMLGUIClient *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KXMLGUIClientWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KXMLGUIClient_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KXMLGUIClient_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KXMLGUIClient_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KXMLGUIClient_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KXMLGUIClient_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KXMLGUIClient_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KXMLGUIClient_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KXMLGUIClient_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KXMLGUIClient_spec = {
    "1:KXmlGui.KXMLGUIClient",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KXMLGUIClient_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KXMLGUIClient_ReverseStateChange(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KXMLGUIClient::ReverseStateChange>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KXMLGUIClient::ReverseStateChange *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KXMLGUIClient_ReverseStateChange_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX])))
        return Enum_PythonToCpp_KXMLGUIClient_ReverseStateChange;
    return {};
}

static PyObject *KXMLGUIClient_ReverseStateChange_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KXMLGUIClient::ReverseStateChange>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KXMLGUIClient::ReverseStateChange *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KXMLGUIClient_PythonToCpp_KXMLGUIClient_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KXMLGUIClient_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KXMLGUIClient_PythonToCpp_KXMLGUIClient_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KXMLGUIClient_TypeF()))
        return KXMLGUIClient_PythonToCpp_KXMLGUIClient_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KXMLGUIClient_PTR_CppToPython_KXMLGUIClient(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KXMLGUIClient_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KXMLGUIClient *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KXMLGUIClient_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KXMLGUIClient_SignatureStrings[] = {
    "1:KXmlGui.KXMLGUIClient(self)",
    "0:KXmlGui.KXMLGUIClient(self,parent:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIClient.action(self,name:QString)->PySide6.QtGui.QAction",
    "KXmlGui.KXMLGUIClient.actionCollection(self)->KXmlGui.KActionCollection",
    "KXmlGui.KXMLGUIClient.addStateActionDisabled(self,state:QString,action:QString)",
    "KXmlGui.KXMLGUIClient.addStateActionEnabled(self,state:QString,action:QString)",
    "KXmlGui.KXMLGUIClient.beginXMLPlug(self,arg__1:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KXMLGUIClient.childClients(self)->QList[KXmlGui.KXMLGUIClient]",
    "KXmlGui.KXMLGUIClient.clientBuilder(self)->KXmlGui.KXMLGUIBuilder",
    "KXmlGui.KXMLGUIClient.componentName(self)->QString",
    "KXmlGui.KXMLGUIClient.endXMLPlug(self)",
    "KXmlGui.KXMLGUIClient.factory(self)->KXmlGui.KXMLGUIFactory",
    "KXmlGui.KXMLGUIClient.findMostRecentXMLFile(files:QStringList,doc:QString)->QString",
    "KXmlGui.KXMLGUIClient.findVersionNumber(xml:QString)->QString",
    "KXmlGui.KXMLGUIClient.insertChildClient(self,child:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIClient.loadStandardsXmlFile(self)",
    "KXmlGui.KXMLGUIClient.localXMLFile(self)->QString",
    "KXmlGui.KXMLGUIClient.parentClient(self)->KXmlGui.KXMLGUIClient",
    "KXmlGui.KXMLGUIClient.plugActionList(self,name:QString,actionList:QList[PySide6.QtGui.QAction])",
    "KXmlGui.KXMLGUIClient.prepareXMLUnplug(self,arg__1:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KXMLGUIClient.reloadXML(self)",
    "KXmlGui.KXMLGUIClient.removeChildClient(self,child:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIClient.replaceXMLFile(self,xmlfile:QString,localxmlfile:QString,merge:bool=false)",
    "KXmlGui.KXMLGUIClient.setClientBuilder(self,builder:KXmlGui.KXMLGUIBuilder)",
    "KXmlGui.KXMLGUIClient.setComponentName(self,componentName:QString,componentDisplayName:QString)",
    "KXmlGui.KXMLGUIClient.setFactory(self,factory:KXmlGui.KXMLGUIFactory)",
    "KXmlGui.KXMLGUIClient.setLocalXMLFile(self,file:QString)",
    "KXmlGui.KXMLGUIClient.setXML(self,document:QString,merge:bool=false)",
    "KXmlGui.KXMLGUIClient.setXMLFile(self,file:QString,merge:bool=false,setXMLDoc:bool=true)",
    "KXmlGui.KXMLGUIClient.standardsXmlFileLocation()->QString",
    "KXmlGui.KXMLGUIClient.stateChanged(self,newstate:QString,reverse:KXmlGui.KXMLGUIClient.ReverseStateChange=KXMLGUIClient.ReverseStateChange.StateNoReverse)",
    "KXmlGui.KXMLGUIClient.unplugActionList(self,name:QString)",
    "KXmlGui.KXMLGUIClient.xmlFile(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KXMLGUIClient_SignatureByteSize = 564;
static constexpr uint8_t KXMLGUIClient_SignatureBytes[564] = {
    0x78, 0xda, 0xad, 0x55, 0x5b, 0x4f, 0xdb, 0x30, 0x14, 0x7e, 0xe7, 0x97, 0x50, 0x29, 0x8b, 0xc6,
    0xcb, 0x1e, 0x22, 0x31, 0x89, 0x95, 0x15, 0x4d, 0x94, 0x8a, 0x50, 0xb1, 0x21, 0x21, 0x84, 0x9c,
    0xf8, 0x34, 0x58, 0x72, 0xec, 0xca, 0x76, 0x18, 0xfd, 0xf7, 0x3b, 0x8e, 0x73, 0xa3, 0x89, 0xdd,
    0x6e, 0xec, 0xa5, 0x75, 0xce, 0xe5, 0xf3, 0x39, 0xdf, 0xb9, 0xf8, 0x2c, 0xb9, 0x7e, 0x28, 0xf9,
    0x55, 0xc5, 0xe2, 0xeb, 0x87, 0x9b, 0xe5, 0xd5, 0xfd, 0x8f, 0x39, 0x67, 0x20, 0xcc, 0xa9, 0x06,
    0xbe, 0x99, 0x9d, 0x7c, 0x0e, 0x68, 0xa3, 0x2d, 0x51, 0x78, 0x9e, 0xb6, 0x98, 0x9d, 0x4c, 0x8a,
    0x63, 0x92, 0x1b, 0x26, 0x85, 0xf3, 0x17, 0xa4, 0x84, 0x24, 0x5d, 0x1b, 0xc5, 0x44, 0x31, 0xfb,
    0xf4, 0xf5, 0x76, 0xb7, 0x66, 0x14, 0xbe, 0xc4, 0xa9, 0xb1, 0x6e, 0xe9, 0x45, 0x6d, 0x19, 0x84,
    0x99, 0x4b, 0xce, 0xa1, 0x07, 0x44, 0x8c, 0xce, 0xfa, 0x62, 0xcf, 0xc0, 0x87, 0x43, 0xe9, 0xda,
    0x10, 0x03, 0xce, 0xfc, 0x92, 0x69, 0x92, 0x71, 0xa0, 0x2e, 0x3c, 0x6d, 0x15, 0x6d, 0x7c, 0x91,
    0xbb, 0xb1, 0x0b, 0xf7, 0x28, 0xbc, 0xef, 0xe2, 0x83, 0x70, 0x19, 0x14, 0x4c, 0xa0, 0xe4, 0x96,
    0x57, 0x85, 0x43, 0x21, 0xaa, 0x78, 0x7e, 0x3e, 0x4b, 0x7a, 0xae, 0x7e, 0x31, 0x5a, 0x80, 0xd1,
    0x71, 0xea, 0x0e, 0x3e, 0xa4, 0xfc, 0x85, 0x71, 0xea, 0xce, 0xba, 0x25, 0x2b, 0x5d, 0x32, 0x6d,
    0x1e, 0x27, 0xed, 0x9f, 0x7c, 0x30, 0xf5, 0xdf, 0xb7, 0x0a, 0xc1, 0x40, 0x8d, 0x48, 0x77, 0xa6,
    0x8d, 0xd6, 0x87, 0x20, 0xcb, 0xad, 0x14, 0x78, 0x5a, 0x61, 0xf5, 0xbb, 0x48, 0x1c, 0x0d, 0x1e,
    0x17, 0x10, 0x74, 0xc8, 0x81, 0x2f, 0xc5, 0x0d, 0x72, 0x2a, 0xd5, 0xce, 0x13, 0xd5, 0xc2, 0x69,
    0x7d, 0xbe, 0x4c, 0xd0, 0x1b, 0xa9, 0xcd, 0x1d, 0xe4, 0xf8, 0x89, 0xaa, 0x05, 0xe3, 0x70, 0xba,
    0xc1, 0x1f, 0xdd, 0xd6, 0xc8, 0x92, 0x15, 0x51, 0x99, 0x0f, 0x3a, 0x36, 0x1c, 0xb6, 0xc5, 0xfc,
    0x09, 0x4a, 0x63, 0x9d, 0x57, 0x55, 0x99, 0x21, 0x5f, 0x6f, 0x25, 0x3f, 0xda, 0x9b, 0x09, 0x0d,
    0xca, 0xcc, 0xfb, 0xb2, 0xb9, 0xfa, 0xd7, 0x75, 0xfc, 0xbb, 0x91, 0xe3, 0x92, 0xd8, 0xa6, 0x14,
    0x94, 0x28, 0xaa, 0xd1, 0xa2, 0x4e, 0x2d, 0x44, 0x24, 0x97, 0x39, 0xe1, 0x2d, 0x07, 0x47, 0x55,
    0xc8, 0x6d, 0x82, 0xe1, 0xe6, 0x18, 0xf1, 0xef, 0x94, 0x3e, 0x7f, 0xac, 0xad, 0x1b, 0x19, 0xcb,
    0xf2, 0x78, 0x3b, 0x34, 0xe3, 0x62, 0x95, 0x89, 0xeb, 0xda, 0xc9, 0x65, 0xf1, 0xe4, 0xcb, 0x68,
    0xab, 0xc0, 0x86, 0x88, 0xb2, 0x7b, 0xb1, 0xfd, 0xf0, 0x2c, 0x29, 0xb0, 0x94, 0xa2, 0x28, 0xc8,
    0xa2, 0x82, 0x52, 0xbe, 0xc2, 0xff, 0x28, 0x20, 0x06, 0xcf, 0x49, 0x0e, 0xc3, 0x8a, 0x44, 0xd8,
    0x4a, 0xb6, 0x3b, 0x3b, 0x82, 0xea, 0x9a, 0xed, 0x0b, 0x4b, 0x50, 0x05, 0x24, 0x99, 0x94, 0xfc,
    0x7c, 0x43, 0xb8, 0x06, 0xdf, 0x05, 0x1a, 0x9a, 0xda, 0x0d, 0x07, 0x3b, 0xca, 0xdc, 0x47, 0x32,
    0x3d, 0xde, 0x21, 0xac, 0xd1, 0x88, 0x47, 0xef, 0xa6, 0xbe, 0x8b, 0xaf, 0x93, 0xe2, 0xe2, 0xc5,
    0x14, 0x77, 0x43, 0x65, 0x00, 0x7f, 0x31, 0x18, 0xf4, 0xa8, 0x99, 0xfa, 0x64, 0x7a, 0xdc, 0x03,
    0x28, 0xcb, 0xfd, 0x2e, 0x8f, 0x86, 0xdc, 0x05, 0x1c, 0xdb, 0xc2, 0xdb, 0x65, 0x50, 0x95, 0xf6,
    0x05, 0xfc, 0x07, 0xbe, 0xbd, 0x17, 0x8f, 0x40, 0x22, 0x67, 0x7d, 0x89, 0x9b, 0xa7, 0x16, 0x1a,
    0x55, 0xf9, 0x81, 0xf7, 0xc6, 0xdc, 0xe6, 0x58, 0x3f, 0x8f, 0x07, 0x27, 0xb8, 0x7e, 0x9d, 0xe6,
    0x2f, 0x44, 0x14, 0xed, 0x7b, 0x25, 0xe0, 0xf7, 0xfb, 0x27, 0x4b, 0xc1, 0x2b, 0x6e, 0x33, 0x98,
    0xee, 0xdd, 0xf8, 0xce, 0x69, 0xd7, 0x3d, 0xce, 0xf9, 0x21, 0x83, 0xb8, 0x3e, 0xaf, 0x64, 0xa3,
    0xf1, 0x25, 0x55, 0x89, 0x43, 0xeb, 0xc1, 0xe7, 0xf9, 0x36, 0x5c, 0x76, 0x3d, 0x03, 0x7f, 0x00,
    0x7a, 0x78, 0x2d, 0xf2
};
#endif

PyTypeObject *init_KXMLGUIClient(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX].type;

    Shiboken::AutoDecRef Sbk_KXMLGUIClient_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KXMLGUIClient_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KXMLGUIClient",
        "KXMLGUIClient*",
        &Sbk_KXMLGUIClient_spec,
        &Shiboken::callCppDestructor< KXMLGUIClient >,
        Sbk_KXMLGUIClient_Type_bases.object(),
        0);
    auto *pyType = Sbk_KXMLGUIClient_TypeF(); // references _Sbk_KXMLGUIClient_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KXMLGUIClient_SignatureStrings);
#else
    InitSignatureBytes(pyType, KXMLGUIClient_SignatureBytes, KXMLGUIClient_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KXMLGUIClient_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KXMLGUIClient_PythonToCpp_KXMLGUIClient_PTR,
        is_KXMLGUIClient_PythonToCpp_KXMLGUIClient_PTR_Convertible,
        KXMLGUIClient_PTR_CppToPython_KXMLGUIClient);

    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIClient");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIClient*");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIClient&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KXMLGUIClient).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KXMLGUIClientWrapper).name());

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KXMLGUIClient_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ReverseStateChange'.
    const char *ReverseStateChange_Initializer[] = {
        "StateNoReverse",
        "StateReverse",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ReverseStateChange_InitializerValues[] = {
        uint8_t(KXMLGUIClient::ReverseStateChange::StateNoReverse), //  0x00  0
        uint8_t(KXMLGUIClient::ReverseStateChange::StateReverse)    //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KXMLGUIClient_TypeF(),
        "1:KXmlGui.KXMLGUIClient.ReverseStateChange",
        ReverseStateChange_Initializer, ReverseStateChange_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_ReverseStateChange_IDX].type = EType;
    // Register converter for enum 'KXMLGUIClient::ReverseStateChange'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KXMLGUIClient_ReverseStateChange_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KXMLGUIClient_ReverseStateChange,
            is_Enum_PythonToCpp_KXMLGUIClient_ReverseStateChange_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KXMLGUIClient::ReverseStateChange");
        Shiboken::Conversions::registerConverterAlias(converter, "ReverseStateChange");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ReverseStateChange' enum.

    qRegisterMetaType< ::KXMLGUIClient *>();
    qRegisterMetaType< ::KXMLGUIClient::ReverseStateChange >("KXMLGUIClient::ReverseStateChange");

    return pyType;
}
