// This file was generated by qtwaylandscanner
// source file is security-context-v1.xml

#ifndef QT_WAYLAND_SERVER_SECURITY_CONTEXT_V1
#define QT_WAYLAND_SERVER_SECURITY_CONTEXT_V1

#include "wayland-server-core.h"
#include "wayland-security-context-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  wp_security_context_manager_v1
    {
    public:
        wp_security_context_manager_v1(struct ::wl_client *client, int id, int version);
        wp_security_context_manager_v1(struct ::wl_display *display, int version);
        wp_security_context_manager_v1(struct ::wl_resource *resource);
        wp_security_context_manager_v1();

        virtual ~wp_security_context_manager_v1();

        class Resource
        {
        public:
            Resource() : wp_security_context_manager_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_security_context_manager_v1 *wp_security_context_manager_v1_object;
            wp_security_context_manager_v1 *object() { return wp_security_context_manager_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_invalid_listen_fd = 1, // listening socket FD is invalid
            error_nested = 2, // nested security contexts are forbidden
        };

    protected:
        virtual Resource *wp_security_context_manager_v1_allocate();

        virtual void wp_security_context_manager_v1_destroy_global();

        virtual void wp_security_context_manager_v1_bind_resource(Resource *resource);
        virtual void wp_security_context_manager_v1_destroy_resource(Resource *resource);

        virtual void wp_security_context_manager_v1_destroy(Resource *resource);
        virtual void wp_security_context_manager_v1_create_listener(Resource *resource, uint32_t id, int32_t listen_fd, int32_t close_fd);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_security_context_manager_v1_interface m_wp_security_context_manager_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_create_listener(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            int32_t listen_fd,
            int32_t close_fd);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_security_context_manager_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_security_context_v1
    {
    public:
        wp_security_context_v1(struct ::wl_client *client, int id, int version);
        wp_security_context_v1(struct ::wl_display *display, int version);
        wp_security_context_v1(struct ::wl_resource *resource);
        wp_security_context_v1();

        virtual ~wp_security_context_v1();

        class Resource
        {
        public:
            Resource() : wp_security_context_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_security_context_v1 *wp_security_context_v1_object;
            wp_security_context_v1 *object() { return wp_security_context_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_already_used = 1, // security context has already been committed
            error_already_set = 2, // metadata has already been set
            error_invalid_metadata = 3, // metadata is invalid
        };

    protected:
        virtual Resource *wp_security_context_v1_allocate();

        virtual void wp_security_context_v1_destroy_global();

        virtual void wp_security_context_v1_bind_resource(Resource *resource);
        virtual void wp_security_context_v1_destroy_resource(Resource *resource);

        virtual void wp_security_context_v1_destroy(Resource *resource);
        virtual void wp_security_context_v1_set_sandbox_engine(Resource *resource, const QString &name);
        virtual void wp_security_context_v1_set_app_id(Resource *resource, const QString &app_id);
        virtual void wp_security_context_v1_set_instance_id(Resource *resource, const QString &instance_id);
        virtual void wp_security_context_v1_commit(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_security_context_v1_interface m_wp_security_context_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_sandbox_engine(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *name);
        static void handle_set_app_id(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *app_id);
        static void handle_set_instance_id(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *instance_id);
        static void handle_commit(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_security_context_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
