#ifndef itkFunctionBaseSwigInterface_h
#define itkFunctionBaseSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkFunctionBase.h"

using itkFunctionBaseIF2D = itk::FunctionBase< itk::Image< float,2 >,double >;
using itkFunctionBaseIF2D_Pointer = itk::FunctionBase< itk::Image< float,2 >,double >::Pointer;
using itkFunctionBaseIUS2D = itk::FunctionBase< itk::Image< unsigned short,2 >,double >;
using itkFunctionBaseIUS2D_Pointer = itk::FunctionBase< itk::Image< unsigned short,2 >,double >::Pointer;
using itkFunctionBasePD2D = itk::FunctionBase< itk::Point< double,2 >, double >;
using itkFunctionBasePD2D_Pointer = itk::FunctionBase< itk::Point< double,2 >, double >::Pointer;
using itkFunctionBasePF2D = itk::FunctionBase< itk::Point< float,2 >, double >;
using itkFunctionBasePF2D_Pointer = itk::FunctionBase< itk::Point< float,2 >, double >::Pointer;
using itkFunctionBasePD2F = itk::FunctionBase< itk::Point< double,2 >, float >;
using itkFunctionBasePD2F_Pointer = itk::FunctionBase< itk::Point< double,2 >, float >::Pointer;
using itkFunctionBasePF2F = itk::FunctionBase< itk::Point< float,2 >, float >;
using itkFunctionBasePF2F_Pointer = itk::FunctionBase< itk::Point< float,2 >, float >::Pointer;
using itkFunctionBaseCIF2AD = itk::FunctionBase< itk::ContinuousIndex< float,2 > ,itk::Array< double > >;
using itkFunctionBaseCIF2AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< float,2 > ,itk::Array< double > >::Pointer;
using itkFunctionBaseCID2AD = itk::FunctionBase< itk::ContinuousIndex< double,2 > ,itk::Array< double > >;
using itkFunctionBaseCID2AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,2 > ,itk::Array< double > >::Pointer;
using itkFunctionBasePD2VD2 = itk::FunctionBase< itk::Point< double,2 >, itk::Vector< double,2 > >;
using itkFunctionBasePD2VD2_Pointer = itk::FunctionBase< itk::Point< double,2 >, itk::Vector< double,2 > >::Pointer;
using itkFunctionBasePD2CVD2 = itk::FunctionBase< itk::Point< double,2 >, itk::CovariantVector< double,2 > >;
using itkFunctionBasePD2CVD2_Pointer = itk::FunctionBase< itk::Point< double,2 >, itk::CovariantVector< double,2 > >::Pointer;
using itkFunctionBaseVF2D = itk::FunctionBase< itk::Vector< float,2 > ,double >;
using itkFunctionBaseVF2D_Pointer = itk::FunctionBase< itk::Vector< float,2 > ,double >::Pointer;
using itkFunctionBasePD2RGBUC = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< unsigned char > >;
using itkFunctionBasePD2RGBUC_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< unsigned char > >::Pointer;
using itkFunctionBasePD2RGBUS = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< unsigned short > >;
using itkFunctionBasePD2RGBUS_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< unsigned short > >::Pointer;
using itkFunctionBasePD2RGBAUC = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< unsigned char > >;
using itkFunctionBasePD2RGBAUC_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< unsigned char > >::Pointer;
using itkFunctionBasePD2RGBAUS = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< unsigned short > >;
using itkFunctionBasePD2RGBAUS_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< unsigned short > >::Pointer;
using itkFunctionBasePD2RGBD = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< double > >;
using itkFunctionBasePD2RGBD_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBPixel< double > >::Pointer;
using itkFunctionBasePD2RGBAD = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< double > >;
using itkFunctionBasePD2RGBAD_Pointer = itk::FunctionBase< itk::Point< double,2 >,itk::RGBAPixel< double > >::Pointer;
using itkFunctionBaseCID2FAD16 = itk::FunctionBase< itk::ContinuousIndex< double,2 >, itk::FixedArray< double,16 > >;
using itkFunctionBaseCID2FAD16_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,2 >, itk::FixedArray< double,16 > >::Pointer;
using itkFunctionBaseIF3D = itk::FunctionBase< itk::Image< float,3 >,double >;
using itkFunctionBaseIF3D_Pointer = itk::FunctionBase< itk::Image< float,3 >,double >::Pointer;
using itkFunctionBaseIUS3D = itk::FunctionBase< itk::Image< unsigned short,3 >,double >;
using itkFunctionBaseIUS3D_Pointer = itk::FunctionBase< itk::Image< unsigned short,3 >,double >::Pointer;
using itkFunctionBasePD3D = itk::FunctionBase< itk::Point< double,3 >, double >;
using itkFunctionBasePD3D_Pointer = itk::FunctionBase< itk::Point< double,3 >, double >::Pointer;
using itkFunctionBasePF3D = itk::FunctionBase< itk::Point< float,3 >, double >;
using itkFunctionBasePF3D_Pointer = itk::FunctionBase< itk::Point< float,3 >, double >::Pointer;
using itkFunctionBasePD3F = itk::FunctionBase< itk::Point< double,3 >, float >;
using itkFunctionBasePD3F_Pointer = itk::FunctionBase< itk::Point< double,3 >, float >::Pointer;
using itkFunctionBasePF3F = itk::FunctionBase< itk::Point< float,3 >, float >;
using itkFunctionBasePF3F_Pointer = itk::FunctionBase< itk::Point< float,3 >, float >::Pointer;
using itkFunctionBaseCIF3AD = itk::FunctionBase< itk::ContinuousIndex< float,3 > ,itk::Array< double > >;
using itkFunctionBaseCIF3AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< float,3 > ,itk::Array< double > >::Pointer;
using itkFunctionBaseCID3AD = itk::FunctionBase< itk::ContinuousIndex< double,3 > ,itk::Array< double > >;
using itkFunctionBaseCID3AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,3 > ,itk::Array< double > >::Pointer;
using itkFunctionBasePD3VD3 = itk::FunctionBase< itk::Point< double,3 >, itk::Vector< double,3 > >;
using itkFunctionBasePD3VD3_Pointer = itk::FunctionBase< itk::Point< double,3 >, itk::Vector< double,3 > >::Pointer;
using itkFunctionBasePD3CVD3 = itk::FunctionBase< itk::Point< double,3 >, itk::CovariantVector< double,3 > >;
using itkFunctionBasePD3CVD3_Pointer = itk::FunctionBase< itk::Point< double,3 >, itk::CovariantVector< double,3 > >::Pointer;
using itkFunctionBaseVF3D = itk::FunctionBase< itk::Vector< float,3 > ,double >;
using itkFunctionBaseVF3D_Pointer = itk::FunctionBase< itk::Vector< float,3 > ,double >::Pointer;
using itkFunctionBasePD3RGBUC = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< unsigned char > >;
using itkFunctionBasePD3RGBUC_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< unsigned char > >::Pointer;
using itkFunctionBasePD3RGBUS = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< unsigned short > >;
using itkFunctionBasePD3RGBUS_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< unsigned short > >::Pointer;
using itkFunctionBasePD3RGBAUC = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< unsigned char > >;
using itkFunctionBasePD3RGBAUC_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< unsigned char > >::Pointer;
using itkFunctionBasePD3RGBAUS = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< unsigned short > >;
using itkFunctionBasePD3RGBAUS_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< unsigned short > >::Pointer;
using itkFunctionBasePD3RGBD = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< double > >;
using itkFunctionBasePD3RGBD_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBPixel< double > >::Pointer;
using itkFunctionBasePD3RGBAD = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< double > >;
using itkFunctionBasePD3RGBAD_Pointer = itk::FunctionBase< itk::Point< double,3 >,itk::RGBAPixel< double > >::Pointer;
using itkFunctionBaseCID3FAD64 = itk::FunctionBase< itk::ContinuousIndex< double,3 >, itk::FixedArray< double,64 > >;
using itkFunctionBaseCID3FAD64_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,3 >, itk::FixedArray< double,64 > >::Pointer;
using itkFunctionBaseIF4D = itk::FunctionBase< itk::Image< float,4 >,double >;
using itkFunctionBaseIF4D_Pointer = itk::FunctionBase< itk::Image< float,4 >,double >::Pointer;
using itkFunctionBaseIUS4D = itk::FunctionBase< itk::Image< unsigned short,4 >,double >;
using itkFunctionBaseIUS4D_Pointer = itk::FunctionBase< itk::Image< unsigned short,4 >,double >::Pointer;
using itkFunctionBasePD4D = itk::FunctionBase< itk::Point< double,4 >, double >;
using itkFunctionBasePD4D_Pointer = itk::FunctionBase< itk::Point< double,4 >, double >::Pointer;
using itkFunctionBasePF4D = itk::FunctionBase< itk::Point< float,4 >, double >;
using itkFunctionBasePF4D_Pointer = itk::FunctionBase< itk::Point< float,4 >, double >::Pointer;
using itkFunctionBasePD4F = itk::FunctionBase< itk::Point< double,4 >, float >;
using itkFunctionBasePD4F_Pointer = itk::FunctionBase< itk::Point< double,4 >, float >::Pointer;
using itkFunctionBasePF4F = itk::FunctionBase< itk::Point< float,4 >, float >;
using itkFunctionBasePF4F_Pointer = itk::FunctionBase< itk::Point< float,4 >, float >::Pointer;
using itkFunctionBaseCIF4AD = itk::FunctionBase< itk::ContinuousIndex< float,4 > ,itk::Array< double > >;
using itkFunctionBaseCIF4AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< float,4 > ,itk::Array< double > >::Pointer;
using itkFunctionBaseCID4AD = itk::FunctionBase< itk::ContinuousIndex< double,4 > ,itk::Array< double > >;
using itkFunctionBaseCID4AD_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,4 > ,itk::Array< double > >::Pointer;
using itkFunctionBasePD4VD4 = itk::FunctionBase< itk::Point< double,4 >, itk::Vector< double,4 > >;
using itkFunctionBasePD4VD4_Pointer = itk::FunctionBase< itk::Point< double,4 >, itk::Vector< double,4 > >::Pointer;
using itkFunctionBasePD4CVD4 = itk::FunctionBase< itk::Point< double,4 >, itk::CovariantVector< double,4 > >;
using itkFunctionBasePD4CVD4_Pointer = itk::FunctionBase< itk::Point< double,4 >, itk::CovariantVector< double,4 > >::Pointer;
using itkFunctionBaseVF4D = itk::FunctionBase< itk::Vector< float,4 > ,double >;
using itkFunctionBaseVF4D_Pointer = itk::FunctionBase< itk::Vector< float,4 > ,double >::Pointer;
using itkFunctionBasePD4RGBUC = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< unsigned char > >;
using itkFunctionBasePD4RGBUC_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< unsigned char > >::Pointer;
using itkFunctionBasePD4RGBUS = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< unsigned short > >;
using itkFunctionBasePD4RGBUS_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< unsigned short > >::Pointer;
using itkFunctionBasePD4RGBAUC = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< unsigned char > >;
using itkFunctionBasePD4RGBAUC_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< unsigned char > >::Pointer;
using itkFunctionBasePD4RGBAUS = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< unsigned short > >;
using itkFunctionBasePD4RGBAUS_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< unsigned short > >::Pointer;
using itkFunctionBasePD4RGBD = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< double > >;
using itkFunctionBasePD4RGBD_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBPixel< double > >::Pointer;
using itkFunctionBasePD4RGBAD = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< double > >;
using itkFunctionBasePD4RGBAD_Pointer = itk::FunctionBase< itk::Point< double,4 >,itk::RGBAPixel< double > >::Pointer;
using itkFunctionBaseCID4FAD256 = itk::FunctionBase< itk::ContinuousIndex< double,4 >, itk::FixedArray< double,256 > >;
using itkFunctionBaseCID4FAD256_Pointer = itk::FunctionBase< itk::ContinuousIndex< double,4 >, itk::FixedArray< double,256 > >::Pointer;
using itkFunctionBaseFF = itk::FunctionBase< float,float >;
using itkFunctionBaseFF_Pointer = itk::FunctionBase< float,float >::Pointer;
using itkFunctionBaseDD = itk::FunctionBase< double,double >;
using itkFunctionBaseDD_Pointer = itk::FunctionBase< double,double >::Pointer;


#include "itkArraySwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkFixedArraySwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkFunctionBaseSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkContinuousIndexSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
