

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Callbacks
    ( 

 -- * Signals


-- ** BaseFinalizeFunc #signal:BaseFinalizeFunc#

    BaseFinalizeFunc                        ,
    C_BaseFinalizeFunc                      ,
    dynamic_BaseFinalizeFunc                ,
    genClosure_BaseFinalizeFunc             ,
    mk_BaseFinalizeFunc                     ,
    noBaseFinalizeFunc                      ,
    wrap_BaseFinalizeFunc                   ,


-- ** BaseInitFunc #signal:BaseInitFunc#

    BaseInitFunc                            ,
    C_BaseInitFunc                          ,
    dynamic_BaseInitFunc                    ,
    genClosure_BaseInitFunc                 ,
    mk_BaseInitFunc                         ,
    noBaseInitFunc                          ,
    wrap_BaseInitFunc                       ,


-- ** BindingTransformFunc #signal:BindingTransformFunc#

    BindingTransformFunc                    ,
    BindingTransformFunc_WithClosures       ,
    C_BindingTransformFunc                  ,
    drop_closures_BindingTransformFunc      ,
    dynamic_BindingTransformFunc            ,
    genClosure_BindingTransformFunc         ,
    mk_BindingTransformFunc                 ,
    noBindingTransformFunc                  ,
    noBindingTransformFunc_WithClosures     ,
    wrap_BindingTransformFunc               ,


-- ** BoxedCopyFunc #signal:BoxedCopyFunc#

    BoxedCopyFunc                           ,
    C_BoxedCopyFunc                         ,
    dynamic_BoxedCopyFunc                   ,
    genClosure_BoxedCopyFunc                ,
    mk_BoxedCopyFunc                        ,
    noBoxedCopyFunc                         ,
    wrap_BoxedCopyFunc                      ,


-- ** BoxedFreeFunc #signal:BoxedFreeFunc#

    BoxedFreeFunc                           ,
    C_BoxedFreeFunc                         ,
    dynamic_BoxedFreeFunc                   ,
    genClosure_BoxedFreeFunc                ,
    mk_BoxedFreeFunc                        ,
    noBoxedFreeFunc                         ,
    wrap_BoxedFreeFunc                      ,


-- ** Callback #signal:Callback#

    C_Callback                              ,
    Callback                                ,
    dynamic_Callback                        ,
    genClosure_Callback                     ,
    mk_Callback                             ,
    noCallback                              ,
    wrap_Callback                           ,


-- ** ClassFinalizeFunc #signal:ClassFinalizeFunc#

    C_ClassFinalizeFunc                     ,
    ClassFinalizeFunc                       ,
    dynamic_ClassFinalizeFunc               ,
    genClosure_ClassFinalizeFunc            ,
    mk_ClassFinalizeFunc                    ,
    noClassFinalizeFunc                     ,
    wrap_ClassFinalizeFunc                  ,


-- ** ClassInitFunc #signal:ClassInitFunc#

    C_ClassInitFunc                         ,
    ClassInitFunc                           ,
    dynamic_ClassInitFunc                   ,
    genClosure_ClassInitFunc                ,
    mk_ClassInitFunc                        ,
    noClassInitFunc                         ,
    wrap_ClassInitFunc                      ,


-- ** ClosureMarshal #signal:ClosureMarshal#

    C_ClosureMarshal                        ,
    ClosureMarshal                          ,
    dynamic_ClosureMarshal                  ,
    genClosure_ClosureMarshal               ,
    mk_ClosureMarshal                       ,
    noClosureMarshal                        ,
    wrap_ClosureMarshal                     ,


-- ** ClosureMarshalFieldCallback #signal:ClosureMarshalFieldCallback#

    C_ClosureMarshalFieldCallback           ,
    ClosureMarshalFieldCallback             ,
    dynamic_ClosureMarshalFieldCallback     ,
    genClosure_ClosureMarshalFieldCallback  ,
    mk_ClosureMarshalFieldCallback          ,
    noClosureMarshalFieldCallback           ,
    wrap_ClosureMarshalFieldCallback        ,


-- ** ClosureNotify #signal:ClosureNotify#

    C_ClosureNotify                         ,
    ClosureNotify                           ,
    dynamic_ClosureNotify                   ,
    genClosure_ClosureNotify                ,
    mk_ClosureNotify                        ,
    noClosureNotify                         ,
    wrap_ClosureNotify                      ,


-- ** InitiallyUnownedClassConstructedFieldCallback #signal:InitiallyUnownedClassConstructedFieldCallback#

    C_InitiallyUnownedClassConstructedFieldCallback,
    InitiallyUnownedClassConstructedFieldCallback,
    dynamic_InitiallyUnownedClassConstructedFieldCallback,
    genClosure_InitiallyUnownedClassConstructedFieldCallback,
    mk_InitiallyUnownedClassConstructedFieldCallback,
    noInitiallyUnownedClassConstructedFieldCallback,
    wrap_InitiallyUnownedClassConstructedFieldCallback,


-- ** InitiallyUnownedClassDispatchPropertiesChangedFieldCallback #signal:InitiallyUnownedClassDispatchPropertiesChangedFieldCallback#

    C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    dynamic_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    genClosure_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    mk_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    noInitiallyUnownedClassDispatchPropertiesChangedFieldCallback,
    wrap_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback,


-- ** InitiallyUnownedClassDisposeFieldCallback #signal:InitiallyUnownedClassDisposeFieldCallback#

    C_InitiallyUnownedClassDisposeFieldCallback,
    InitiallyUnownedClassDisposeFieldCallback,
    dynamic_InitiallyUnownedClassDisposeFieldCallback,
    genClosure_InitiallyUnownedClassDisposeFieldCallback,
    mk_InitiallyUnownedClassDisposeFieldCallback,
    noInitiallyUnownedClassDisposeFieldCallback,
    wrap_InitiallyUnownedClassDisposeFieldCallback,


-- ** InitiallyUnownedClassFinalizeFieldCallback #signal:InitiallyUnownedClassFinalizeFieldCallback#

    C_InitiallyUnownedClassFinalizeFieldCallback,
    InitiallyUnownedClassFinalizeFieldCallback,
    dynamic_InitiallyUnownedClassFinalizeFieldCallback,
    genClosure_InitiallyUnownedClassFinalizeFieldCallback,
    mk_InitiallyUnownedClassFinalizeFieldCallback,
    noInitiallyUnownedClassFinalizeFieldCallback,
    wrap_InitiallyUnownedClassFinalizeFieldCallback,


-- ** InitiallyUnownedClassGetPropertyFieldCallback #signal:InitiallyUnownedClassGetPropertyFieldCallback#

    C_InitiallyUnownedClassGetPropertyFieldCallback,
    InitiallyUnownedClassGetPropertyFieldCallback,
    dynamic_InitiallyUnownedClassGetPropertyFieldCallback,
    genClosure_InitiallyUnownedClassGetPropertyFieldCallback,
    mk_InitiallyUnownedClassGetPropertyFieldCallback,
    noInitiallyUnownedClassGetPropertyFieldCallback,
    wrap_InitiallyUnownedClassGetPropertyFieldCallback,


-- ** InitiallyUnownedClassNotifyFieldCallback #signal:InitiallyUnownedClassNotifyFieldCallback#

    C_InitiallyUnownedClassNotifyFieldCallback,
    InitiallyUnownedClassNotifyFieldCallback,
    dynamic_InitiallyUnownedClassNotifyFieldCallback,
    genClosure_InitiallyUnownedClassNotifyFieldCallback,
    mk_InitiallyUnownedClassNotifyFieldCallback,
    noInitiallyUnownedClassNotifyFieldCallback,
    wrap_InitiallyUnownedClassNotifyFieldCallback,


-- ** InitiallyUnownedClassSetPropertyFieldCallback #signal:InitiallyUnownedClassSetPropertyFieldCallback#

    C_InitiallyUnownedClassSetPropertyFieldCallback,
    InitiallyUnownedClassSetPropertyFieldCallback,
    dynamic_InitiallyUnownedClassSetPropertyFieldCallback,
    genClosure_InitiallyUnownedClassSetPropertyFieldCallback,
    mk_InitiallyUnownedClassSetPropertyFieldCallback,
    noInitiallyUnownedClassSetPropertyFieldCallback,
    wrap_InitiallyUnownedClassSetPropertyFieldCallback,


-- ** InstanceInitFunc #signal:InstanceInitFunc#

    C_InstanceInitFunc                      ,
    InstanceInitFunc                        ,
    dynamic_InstanceInitFunc                ,
    genClosure_InstanceInitFunc             ,
    mk_InstanceInitFunc                     ,
    noInstanceInitFunc                      ,
    wrap_InstanceInitFunc                   ,


-- ** InterfaceFinalizeFunc #signal:InterfaceFinalizeFunc#

    C_InterfaceFinalizeFunc                 ,
    InterfaceFinalizeFunc                   ,
    dynamic_InterfaceFinalizeFunc           ,
    genClosure_InterfaceFinalizeFunc        ,
    mk_InterfaceFinalizeFunc                ,
    noInterfaceFinalizeFunc                 ,
    wrap_InterfaceFinalizeFunc              ,


-- ** InterfaceInitFunc #signal:InterfaceInitFunc#

    C_InterfaceInitFunc                     ,
    InterfaceInitFunc                       ,
    dynamic_InterfaceInitFunc               ,
    genClosure_InterfaceInitFunc            ,
    mk_InterfaceInitFunc                    ,
    noInterfaceInitFunc                     ,
    wrap_InterfaceInitFunc                  ,


-- ** ObjectClassConstructedFieldCallback #signal:ObjectClassConstructedFieldCallback#

    C_ObjectClassConstructedFieldCallback   ,
    ObjectClassConstructedFieldCallback     ,
    dynamic_ObjectClassConstructedFieldCallback,
    genClosure_ObjectClassConstructedFieldCallback,
    mk_ObjectClassConstructedFieldCallback  ,
    noObjectClassConstructedFieldCallback   ,
    wrap_ObjectClassConstructedFieldCallback,


-- ** ObjectClassDispatchPropertiesChangedFieldCallback #signal:ObjectClassDispatchPropertiesChangedFieldCallback#

    C_ObjectClassDispatchPropertiesChangedFieldCallback,
    ObjectClassDispatchPropertiesChangedFieldCallback,
    dynamic_ObjectClassDispatchPropertiesChangedFieldCallback,
    genClosure_ObjectClassDispatchPropertiesChangedFieldCallback,
    mk_ObjectClassDispatchPropertiesChangedFieldCallback,
    noObjectClassDispatchPropertiesChangedFieldCallback,
    wrap_ObjectClassDispatchPropertiesChangedFieldCallback,


-- ** ObjectClassDisposeFieldCallback #signal:ObjectClassDisposeFieldCallback#

    C_ObjectClassDisposeFieldCallback       ,
    ObjectClassDisposeFieldCallback         ,
    dynamic_ObjectClassDisposeFieldCallback ,
    genClosure_ObjectClassDisposeFieldCallback,
    mk_ObjectClassDisposeFieldCallback      ,
    noObjectClassDisposeFieldCallback       ,
    wrap_ObjectClassDisposeFieldCallback    ,


-- ** ObjectClassFinalizeFieldCallback #signal:ObjectClassFinalizeFieldCallback#

    C_ObjectClassFinalizeFieldCallback      ,
    ObjectClassFinalizeFieldCallback        ,
    dynamic_ObjectClassFinalizeFieldCallback,
    genClosure_ObjectClassFinalizeFieldCallback,
    mk_ObjectClassFinalizeFieldCallback     ,
    noObjectClassFinalizeFieldCallback      ,
    wrap_ObjectClassFinalizeFieldCallback   ,


-- ** ObjectClassGetPropertyFieldCallback #signal:ObjectClassGetPropertyFieldCallback#

    C_ObjectClassGetPropertyFieldCallback   ,
    ObjectClassGetPropertyFieldCallback     ,
    dynamic_ObjectClassGetPropertyFieldCallback,
    genClosure_ObjectClassGetPropertyFieldCallback,
    mk_ObjectClassGetPropertyFieldCallback  ,
    noObjectClassGetPropertyFieldCallback   ,
    wrap_ObjectClassGetPropertyFieldCallback,


-- ** ObjectClassNotifyFieldCallback #signal:ObjectClassNotifyFieldCallback#

    C_ObjectClassNotifyFieldCallback        ,
    ObjectClassNotifyFieldCallback          ,
    dynamic_ObjectClassNotifyFieldCallback  ,
    genClosure_ObjectClassNotifyFieldCallback,
    mk_ObjectClassNotifyFieldCallback       ,
    noObjectClassNotifyFieldCallback        ,
    wrap_ObjectClassNotifyFieldCallback     ,


-- ** ObjectClassSetPropertyFieldCallback #signal:ObjectClassSetPropertyFieldCallback#

    C_ObjectClassSetPropertyFieldCallback   ,
    ObjectClassSetPropertyFieldCallback     ,
    dynamic_ObjectClassSetPropertyFieldCallback,
    genClosure_ObjectClassSetPropertyFieldCallback,
    mk_ObjectClassSetPropertyFieldCallback  ,
    noObjectClassSetPropertyFieldCallback   ,
    wrap_ObjectClassSetPropertyFieldCallback,


-- ** ObjectFinalizeFunc #signal:ObjectFinalizeFunc#

    C_ObjectFinalizeFunc                    ,
    ObjectFinalizeFunc                      ,
    dynamic_ObjectFinalizeFunc              ,
    genClosure_ObjectFinalizeFunc           ,
    mk_ObjectFinalizeFunc                   ,
    noObjectFinalizeFunc                    ,
    wrap_ObjectFinalizeFunc                 ,


-- ** ObjectGetPropertyFunc #signal:ObjectGetPropertyFunc#

    C_ObjectGetPropertyFunc                 ,
    ObjectGetPropertyFunc                   ,
    dynamic_ObjectGetPropertyFunc           ,
    genClosure_ObjectGetPropertyFunc        ,
    mk_ObjectGetPropertyFunc                ,
    noObjectGetPropertyFunc                 ,
    wrap_ObjectGetPropertyFunc              ,


-- ** ObjectSetPropertyFunc #signal:ObjectSetPropertyFunc#

    C_ObjectSetPropertyFunc                 ,
    ObjectSetPropertyFunc                   ,
    dynamic_ObjectSetPropertyFunc           ,
    genClosure_ObjectSetPropertyFunc        ,
    mk_ObjectSetPropertyFunc                ,
    noObjectSetPropertyFunc                 ,
    wrap_ObjectSetPropertyFunc              ,


-- ** ParamSpecTypeInfoFinalizeFieldCallback #signal:ParamSpecTypeInfoFinalizeFieldCallback#

    C_ParamSpecTypeInfoFinalizeFieldCallback,
    ParamSpecTypeInfoFinalizeFieldCallback  ,
    dynamic_ParamSpecTypeInfoFinalizeFieldCallback,
    genClosure_ParamSpecTypeInfoFinalizeFieldCallback,
    mk_ParamSpecTypeInfoFinalizeFieldCallback,
    noParamSpecTypeInfoFinalizeFieldCallback,
    wrap_ParamSpecTypeInfoFinalizeFieldCallback,


-- ** ParamSpecTypeInfoInstanceInitFieldCallback #signal:ParamSpecTypeInfoInstanceInitFieldCallback#

    C_ParamSpecTypeInfoInstanceInitFieldCallback,
    ParamSpecTypeInfoInstanceInitFieldCallback,
    dynamic_ParamSpecTypeInfoInstanceInitFieldCallback,
    genClosure_ParamSpecTypeInfoInstanceInitFieldCallback,
    mk_ParamSpecTypeInfoInstanceInitFieldCallback,
    noParamSpecTypeInfoInstanceInitFieldCallback,
    wrap_ParamSpecTypeInfoInstanceInitFieldCallback,


-- ** ParamSpecTypeInfoValueSetDefaultFieldCallback #signal:ParamSpecTypeInfoValueSetDefaultFieldCallback#

    C_ParamSpecTypeInfoValueSetDefaultFieldCallback,
    ParamSpecTypeInfoValueSetDefaultFieldCallback,
    dynamic_ParamSpecTypeInfoValueSetDefaultFieldCallback,
    genClosure_ParamSpecTypeInfoValueSetDefaultFieldCallback,
    mk_ParamSpecTypeInfoValueSetDefaultFieldCallback,
    noParamSpecTypeInfoValueSetDefaultFieldCallback,
    wrap_ParamSpecTypeInfoValueSetDefaultFieldCallback,


-- ** ParamSpecTypeInfoValueValidateFieldCallback #signal:ParamSpecTypeInfoValueValidateFieldCallback#

    C_ParamSpecTypeInfoValueValidateFieldCallback,
    ParamSpecTypeInfoValueValidateFieldCallback,
    dynamic_ParamSpecTypeInfoValueValidateFieldCallback,
    genClosure_ParamSpecTypeInfoValueValidateFieldCallback,
    mk_ParamSpecTypeInfoValueValidateFieldCallback,
    noParamSpecTypeInfoValueValidateFieldCallback,
    wrap_ParamSpecTypeInfoValueValidateFieldCallback,


-- ** ParamSpecTypeInfoValuesCmpFieldCallback #signal:ParamSpecTypeInfoValuesCmpFieldCallback#

    C_ParamSpecTypeInfoValuesCmpFieldCallback,
    ParamSpecTypeInfoValuesCmpFieldCallback ,
    dynamic_ParamSpecTypeInfoValuesCmpFieldCallback,
    genClosure_ParamSpecTypeInfoValuesCmpFieldCallback,
    mk_ParamSpecTypeInfoValuesCmpFieldCallback,
    noParamSpecTypeInfoValuesCmpFieldCallback,
    wrap_ParamSpecTypeInfoValuesCmpFieldCallback,


-- ** SignalAccumulator #signal:SignalAccumulator#

    C_SignalAccumulator                     ,
    SignalAccumulator                       ,
    dynamic_SignalAccumulator               ,
    genClosure_SignalAccumulator            ,
    mk_SignalAccumulator                    ,
    noSignalAccumulator                     ,
    wrap_SignalAccumulator                  ,


-- ** SignalEmissionHook #signal:SignalEmissionHook#

    C_SignalEmissionHook                    ,
    SignalEmissionHook                      ,
    dynamic_SignalEmissionHook              ,
    genClosure_SignalEmissionHook           ,
    mk_SignalEmissionHook                   ,
    noSignalEmissionHook                    ,
    wrap_SignalEmissionHook                 ,


-- ** ToggleNotify #signal:ToggleNotify#

    C_ToggleNotify                          ,
    ToggleNotify                            ,
    dynamic_ToggleNotify                    ,
    genClosure_ToggleNotify                 ,
    mk_ToggleNotify                         ,
    noToggleNotify                          ,
    wrap_ToggleNotify                       ,


-- ** TypeClassCacheFunc #signal:TypeClassCacheFunc#

    C_TypeClassCacheFunc                    ,
    TypeClassCacheFunc                      ,
    dynamic_TypeClassCacheFunc              ,
    genClosure_TypeClassCacheFunc           ,
    mk_TypeClassCacheFunc                   ,
    noTypeClassCacheFunc                    ,
    wrap_TypeClassCacheFunc                 ,


-- ** TypeInterfaceCheckFunc #signal:TypeInterfaceCheckFunc#

    C_TypeInterfaceCheckFunc                ,
    TypeInterfaceCheckFunc                  ,
    dynamic_TypeInterfaceCheckFunc          ,
    genClosure_TypeInterfaceCheckFunc       ,
    mk_TypeInterfaceCheckFunc               ,
    noTypeInterfaceCheckFunc                ,
    wrap_TypeInterfaceCheckFunc             ,


-- ** TypePluginCompleteInterfaceInfo #signal:TypePluginCompleteInterfaceInfo#

    C_TypePluginCompleteInterfaceInfo       ,
    TypePluginCompleteInterfaceInfo         ,
    dynamic_TypePluginCompleteInterfaceInfo ,
    genClosure_TypePluginCompleteInterfaceInfo,
    mk_TypePluginCompleteInterfaceInfo      ,
    noTypePluginCompleteInterfaceInfo       ,
    wrap_TypePluginCompleteInterfaceInfo    ,


-- ** TypePluginCompleteTypeInfo #signal:TypePluginCompleteTypeInfo#

    C_TypePluginCompleteTypeInfo            ,
    TypePluginCompleteTypeInfo              ,
    dynamic_TypePluginCompleteTypeInfo      ,
    genClosure_TypePluginCompleteTypeInfo   ,
    mk_TypePluginCompleteTypeInfo           ,
    noTypePluginCompleteTypeInfo            ,
    wrap_TypePluginCompleteTypeInfo         ,


-- ** TypePluginUnuse #signal:TypePluginUnuse#

    C_TypePluginUnuse                       ,
    TypePluginUnuse                         ,
    dynamic_TypePluginUnuse                 ,
    genClosure_TypePluginUnuse              ,
    mk_TypePluginUnuse                      ,
    noTypePluginUnuse                       ,
    wrap_TypePluginUnuse                    ,


-- ** TypePluginUse #signal:TypePluginUse#

    C_TypePluginUse                         ,
    TypePluginUse                           ,
    dynamic_TypePluginUse                   ,
    genClosure_TypePluginUse                ,
    mk_TypePluginUse                        ,
    noTypePluginUse                         ,
    wrap_TypePluginUse                      ,


-- ** TypeValueCollectFunc #signal:TypeValueCollectFunc#

    C_TypeValueCollectFunc                  ,
    TypeValueCollectFunc                    ,
    dynamic_TypeValueCollectFunc            ,
    genClosure_TypeValueCollectFunc         ,
    mk_TypeValueCollectFunc                 ,
    noTypeValueCollectFunc                  ,
    wrap_TypeValueCollectFunc               ,


-- ** TypeValueCopyFunc #signal:TypeValueCopyFunc#

    C_TypeValueCopyFunc                     ,
    TypeValueCopyFunc                       ,
    dynamic_TypeValueCopyFunc               ,
    genClosure_TypeValueCopyFunc            ,
    mk_TypeValueCopyFunc                    ,
    noTypeValueCopyFunc                     ,
    wrap_TypeValueCopyFunc                  ,


-- ** TypeValueFreeFunc #signal:TypeValueFreeFunc#

    C_TypeValueFreeFunc                     ,
    TypeValueFreeFunc                       ,
    dynamic_TypeValueFreeFunc               ,
    genClosure_TypeValueFreeFunc            ,
    mk_TypeValueFreeFunc                    ,
    noTypeValueFreeFunc                     ,
    wrap_TypeValueFreeFunc                  ,


-- ** TypeValueInitFunc #signal:TypeValueInitFunc#

    C_TypeValueInitFunc                     ,
    TypeValueInitFunc                       ,
    dynamic_TypeValueInitFunc               ,
    genClosure_TypeValueInitFunc            ,
    mk_TypeValueInitFunc                    ,
    noTypeValueInitFunc                     ,
    wrap_TypeValueInitFunc                  ,


-- ** TypeValueLCopyFunc #signal:TypeValueLCopyFunc#

    C_TypeValueLCopyFunc                    ,
    TypeValueLCopyFunc                      ,
    dynamic_TypeValueLCopyFunc              ,
    genClosure_TypeValueLCopyFunc           ,
    mk_TypeValueLCopyFunc                   ,
    noTypeValueLCopyFunc                    ,
    wrap_TypeValueLCopyFunc                 ,


-- ** TypeValuePeekPointerFunc #signal:TypeValuePeekPointerFunc#

    C_TypeValuePeekPointerFunc              ,
    TypeValuePeekPointerFunc                ,
    dynamic_TypeValuePeekPointerFunc        ,
    genClosure_TypeValuePeekPointerFunc     ,
    mk_TypeValuePeekPointerFunc             ,
    noTypeValuePeekPointerFunc              ,
    wrap_TypeValuePeekPointerFunc           ,


-- ** ValueTransform #signal:ValueTransform#

    C_ValueTransform                        ,
    ValueTransform                          ,
    dynamic_ValueTransform                  ,
    genClosure_ValueTransform               ,
    mk_ValueTransform                       ,
    noValueTransform                        ,
    wrap_ValueTransform                     ,


-- ** WeakNotify #signal:WeakNotify#

    C_WeakNotify                            ,
    WeakNotify                              ,
    dynamic_WeakNotify                      ,
    genClosure_WeakNotify                   ,
    mk_WeakNotify                           ,
    noWeakNotify                            ,
    wrap_WeakNotify                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalInvocationHint as GObject.SignalInvocationHint
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInstance as GObject.TypeInstance
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable
import {-# SOURCE #-} qualified GI.GObject.Unions.TypeCValue as GObject.TypeCValue

#else
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalInvocationHint as GObject.SignalInvocationHint
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInstance as GObject.TypeInstance
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable
import {-# SOURCE #-} qualified GI.GObject.Unions.TypeCValue as GObject.TypeCValue

#endif

-- callback WeakNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "data that was provided when the weak reference was established"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "where_the_object_was"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the object being disposed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GWeakNotify function can be added to an object as a callback that gets\ntriggered when the object is finalized.\n\nSince the object is already being disposed when the #GWeakNotify is called,\nthere's not much you could do with the object, apart from e.g. using its\naddress as hash-index or the like.\n\nIn particular, this means it\8217s invalid to call g_object_ref(),\ng_weak_ref_init(), g_weak_ref_set(), g_object_add_toggle_ref(),\ng_object_weak_ref(), g_object_add_weak_pointer() or any function which calls\nthem on the object from this callback."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WeakNotify =
    Ptr () ->
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "data that was provided when the weak reference was established"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where_the_object_was"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the object being disposed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WeakNotify :: FunPtr C_WeakNotify -> C_WeakNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WeakNotify ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_WeakNotify
    -> Ptr ()
    -- ^ /@data@/: data that was provided when the weak reference was established
    -> a
    -- ^ /@whereTheObjectWas@/: the object being disposed
    -> m ()
dynamic_WeakNotify __funPtr data_ whereTheObjectWas = liftIO $ do
    whereTheObjectWas' <- unsafeManagedPtrCastPtr whereTheObjectWas
    (__dynamic_C_WeakNotify __funPtr) data_ whereTheObjectWas'
    touchManagedPtr whereTheObjectWas
    return ()

-- | Generate a function pointer callable from C code, from a `C_WeakNotify`.
foreign import ccall "wrapper"
    mk_WeakNotify :: C_WeakNotify -> IO (FunPtr C_WeakNotify)

-- | A t'GI.GObject.Callbacks.WeakNotify' function can be added to an object as a callback that gets
-- triggered when the object is finalized.
-- 
-- Since the object is already being disposed when the t'GI.GObject.Callbacks.WeakNotify' is called,
-- there\'s not much you could do with the object, apart from e.g. using its
-- address as hash-index or the like.
-- 
-- In particular, this means it’s invalid to call 'GI.GObject.Objects.Object.objectRef',
-- @/g_weak_ref_init()/@, @/g_weak_ref_set()/@, @/g_object_add_toggle_ref()/@,
-- @/g_object_weak_ref()/@, @/g_object_add_weak_pointer()/@ or any function which calls
-- them on the object from this callback.
type WeakNotify =
    Ptr ()
    -- ^ /@data@/: data that was provided when the weak reference was established
    -> GObject.Object.Object
    -- ^ /@whereTheObjectWas@/: the object being disposed
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WeakNotify`@.
noWeakNotify :: Maybe WeakNotify
noWeakNotify = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WeakNotify :: MonadIO m => WeakNotify -> m (GClosure C_WeakNotify)
genClosure_WeakNotify cb = liftIO $ do
    let cb' = wrap_WeakNotify Nothing cb
    mk_WeakNotify cb' >>= B.GClosure.newGClosure


-- | Wrap a `WeakNotify` into a `C_WeakNotify`.
wrap_WeakNotify :: 
    Maybe (Ptr (FunPtr C_WeakNotify)) ->
    WeakNotify ->
    C_WeakNotify
wrap_WeakNotify gi'funptrptr gi'cb data_ whereTheObjectWas = do
    whereTheObjectWas' <- (newObject GObject.Object.Object) whereTheObjectWas
    gi'cb  data_ whereTheObjectWas'
    maybeReleaseFunPtr gi'funptrptr


-- callback ValueTransform
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "src_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "source value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "dest_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "target value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of value transformation functions which can be registered with\n[func@GObject.Value.register_transform_func].\n\n@dest_value will be initialized to the correct destination type."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ValueTransform =
    Ptr GValue ->
    Ptr GValue ->
    IO ()

-- Args: [ Arg
--           { argCName = "src_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "target value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ValueTransform :: FunPtr C_ValueTransform -> C_ValueTransform

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ValueTransform ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ValueTransform
    -> GValue
    -- ^ /@srcValue@/: source value
    -> GValue
    -- ^ /@destValue@/: target value
    -> m ()
dynamic_ValueTransform __funPtr srcValue destValue = liftIO $ do
    srcValue' <- unsafeManagedPtrGetPtr srcValue
    destValue' <- unsafeManagedPtrGetPtr destValue
    (__dynamic_C_ValueTransform __funPtr) srcValue' destValue'
    touchManagedPtr srcValue
    touchManagedPtr destValue
    return ()

-- | Generate a function pointer callable from C code, from a `C_ValueTransform`.
foreign import ccall "wrapper"
    mk_ValueTransform :: C_ValueTransform -> IO (FunPtr C_ValueTransform)

-- | The type of value transformation functions which can be registered with
-- t'GI.GObject.Structs.Value.Value'.@/register_transform_func/@().
-- 
-- /@destValue@/ will be initialized to the correct destination type.
type ValueTransform =
    GValue
    -- ^ /@srcValue@/: source value
    -> GValue
    -- ^ /@destValue@/: target value
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ValueTransform`@.
noValueTransform :: Maybe ValueTransform
noValueTransform = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ValueTransform :: MonadIO m => ValueTransform -> m (GClosure C_ValueTransform)
genClosure_ValueTransform cb = liftIO $ do
    let cb' = wrap_ValueTransform Nothing cb
    mk_ValueTransform cb' >>= B.GClosure.newGClosure


-- | Wrap a `ValueTransform` into a `C_ValueTransform`.
wrap_ValueTransform :: 
    Maybe (Ptr (FunPtr C_ValueTransform)) ->
    ValueTransform ->
    C_ValueTransform
wrap_ValueTransform gi'funptrptr gi'cb srcValue destValue = do
    srcValue' <- B.GValue.newGValueFromPtr srcValue
    destValue' <- B.GValue.newGValueFromPtr destValue
    gi'cb  srcValue' destValue'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypeValuePeekPointerFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a pointer to the value contents"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to peek" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "If the value contents fit into a pointer, such as objects or strings,\nreturn this pointer, so the caller can peek at the current contents.\n\nTo extend on our above string example:\n\n|[<!-- language=\"C\" -->\nreturn value->data[0].v_pointer;\n]|"
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValuePeekPointerFunc =
    Ptr GValue ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to peek" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValuePeekPointerFunc :: FunPtr C_TypeValuePeekPointerFunc -> C_TypeValuePeekPointerFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValuePeekPointerFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValuePeekPointerFunc
    -> GValue
    -- ^ /@value@/: the value to peek
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the value contents
dynamic_TypeValuePeekPointerFunc __funPtr value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- (__dynamic_C_TypeValuePeekPointerFunc __funPtr) value'
    touchManagedPtr value
    return result

-- | Generate a function pointer callable from C code, from a `C_TypeValuePeekPointerFunc`.
foreign import ccall "wrapper"
    mk_TypeValuePeekPointerFunc :: C_TypeValuePeekPointerFunc -> IO (FunPtr C_TypeValuePeekPointerFunc)

-- | If the value contents fit into a pointer, such as objects or strings,
-- return this pointer, so the caller can peek at the current contents.
-- 
-- To extend on our above string example:
-- 
-- 
-- === /C code/
-- >
-- >return value->data[0].v_pointer;
-- 
-- 
-- /Since: 2.78/
type TypeValuePeekPointerFunc =
    GValue
    -- ^ /@value@/: the value to peek
    -> IO (Ptr ())
    -- ^ __Returns:__ a pointer to the value contents

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValuePeekPointerFunc`@.
noTypeValuePeekPointerFunc :: Maybe TypeValuePeekPointerFunc
noTypeValuePeekPointerFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValuePeekPointerFunc :: MonadIO m => TypeValuePeekPointerFunc -> m (GClosure C_TypeValuePeekPointerFunc)
genClosure_TypeValuePeekPointerFunc cb = liftIO $ do
    let cb' = wrap_TypeValuePeekPointerFunc Nothing cb
    mk_TypeValuePeekPointerFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValuePeekPointerFunc` into a `C_TypeValuePeekPointerFunc`.
wrap_TypeValuePeekPointerFunc :: 
    Maybe (Ptr (FunPtr C_TypeValuePeekPointerFunc)) ->
    TypeValuePeekPointerFunc ->
    C_TypeValuePeekPointerFunc
wrap_TypeValuePeekPointerFunc gi'funptrptr gi'cb value = do
    value' <- B.GValue.newGValueFromPtr value
    result <- gi'cb  value'
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback TypeValueLCopyFunc
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "`NULL` on success, otherwise\n  a newly allocated error string on failure"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to lcopy" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_collect_values"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the number of collected values"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "collect_values"
          , argType =
              TCArray
                False
                (-1)
                1
                (TInterface Name { namespace = "GObject" , name = "TypeCValue" })
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the collected\n  locations for storage"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "collect_flags"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "optional flags" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This function is responsible for storing the `value`\ncontents into arguments passed through a variadic argument list which\ngot collected into `collect_values` according to `lcopy_format`.\n\nThe `n_collect_values` argument equals the string length of\n`lcopy_format`, and `collect_flags` may contain %G_VALUE_NOCOPY_CONTENTS.\n\nIn contrast to #GTypeValueCollectFunc, this function is obliged to always\nproperly support %G_VALUE_NOCOPY_CONTENTS.\n\nSimilar to #GTypeValueCollectFunc the function may prematurely abort by\nreturning a newly allocated string describing an error condition. To\ncomplete the string example:\n\n|[<!-- language=\"C\" -->\ngchar **string_p = collect_values[0].v_pointer;\ng_return_val_if_fail (string_p != NULL,\n  g_strdup (\"string location passed as NULL\"));\n\nif (collect_flags & G_VALUE_NOCOPY_CONTENTS)\n  *string_p = value->data[0].v_pointer;\nelse\n  *string_p = g_strdup (value->data[0].v_pointer);\n]|\n\nAnd an illustrative version of this function for reference-counted\ntypes:\n\n|[<!-- language=\"C\" -->\nGObject **object_p = collect_values[0].v_pointer;\ng_return_val_if_fail (object_p != NULL,\n  g_strdup (\"object location passed as NULL\"));\n\nif (value->data[0].v_pointer == NULL)\n  *object_p = NULL;\nelse if (collect_flags & G_VALUE_NOCOPY_CONTENTS) // always honour\n  *object_p = value->data[0].v_pointer;\nelse\n  *object_p = g_object_ref (value->data[0].v_pointer);\n\nreturn NULL;\n]|"
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValueLCopyFunc =
    Ptr GValue ->
    Word32 ->
    Ptr GObject.TypeCValue.TypeCValue ->
    Word32 ->
    IO CString

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to lcopy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_collect_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of collected values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collect_values"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "GObject" , name = "TypeCValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the collected\n  locations for storage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collect_flags"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional flags" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_collect_values"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of collected values"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValueLCopyFunc :: FunPtr C_TypeValueLCopyFunc -> C_TypeValueLCopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValueLCopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValueLCopyFunc
    -> GValue
    -- ^ /@value@/: the value to lcopy
    -> [GObject.TypeCValue.TypeCValue]
    -- ^ /@collectValues@/: the collected
    --   locations for storage
    -> Word32
    -- ^ /@collectFlags@/: optional flags
    -> m (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ on success, otherwise
    --   a newly allocated error string on failure
dynamic_TypeValueLCopyFunc __funPtr value collectValues collectFlags = liftIO $ do
    let nCollectValues = fromIntegral $ P.length collectValues
    value' <- unsafeManagedPtrGetPtr value
    collectValues' <- mapM unsafeManagedPtrGetPtr collectValues
    collectValues'' <- packBlockArray 8 collectValues'
    result <- (__dynamic_C_TypeValueLCopyFunc __funPtr) value' nCollectValues collectValues'' collectFlags
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr value
    mapM_ touchManagedPtr collectValues
    freeMem collectValues''
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_TypeValueLCopyFunc`.
foreign import ccall "wrapper"
    mk_TypeValueLCopyFunc :: C_TypeValueLCopyFunc -> IO (FunPtr C_TypeValueLCopyFunc)

-- | This function is responsible for storing the @value@
-- contents into arguments passed through a variadic argument list which
-- got collected into @collect_values@ according to @lcopy_format@.
-- 
-- The @n_collect_values@ argument equals the string length of
-- @lcopy_format@, and @collect_flags@ may contain 'GI.GObject.Constants.VALUE_NOCOPY_CONTENTS'.
-- 
-- In contrast to t'GI.GObject.Callbacks.TypeValueCollectFunc', this function is obliged to always
-- properly support 'GI.GObject.Constants.VALUE_NOCOPY_CONTENTS'.
-- 
-- Similar to t'GI.GObject.Callbacks.TypeValueCollectFunc' the function may prematurely abort by
-- returning a newly allocated string describing an error condition. To
-- complete the string example:
-- 
-- 
-- === /C code/
-- >
-- >gchar **string_p = collect_values[0].v_pointer;
-- >g_return_val_if_fail (string_p != NULL,
-- >  g_strdup ("string location passed as NULL"));
-- >
-- >if (collect_flags & G_VALUE_NOCOPY_CONTENTS)
-- >  *string_p = value->data[0].v_pointer;
-- >else
-- >  *string_p = g_strdup (value->data[0].v_pointer);
-- 
-- 
-- And an illustrative version of this function for reference-counted
-- types:
-- 
-- 
-- === /C code/
-- >
-- >GObject **object_p = collect_values[0].v_pointer;
-- >g_return_val_if_fail (object_p != NULL,
-- >  g_strdup ("object location passed as NULL"));
-- >
-- >if (value->data[0].v_pointer == NULL)
-- >  *object_p = NULL;
-- >else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) // always honour
-- >  *object_p = value->data[0].v_pointer;
-- >else
-- >  *object_p = g_object_ref (value->data[0].v_pointer);
-- >
-- >return NULL;
-- 
-- 
-- /Since: 2.78/
type TypeValueLCopyFunc =
    GValue
    -- ^ /@value@/: the value to lcopy
    -> [GObject.TypeCValue.TypeCValue]
    -- ^ /@collectValues@/: the collected
    --   locations for storage
    -> Word32
    -- ^ /@collectFlags@/: optional flags
    -> IO (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ on success, otherwise
    --   a newly allocated error string on failure

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValueLCopyFunc`@.
noTypeValueLCopyFunc :: Maybe TypeValueLCopyFunc
noTypeValueLCopyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValueLCopyFunc :: MonadIO m => TypeValueLCopyFunc -> m (GClosure C_TypeValueLCopyFunc)
genClosure_TypeValueLCopyFunc cb = liftIO $ do
    let cb' = wrap_TypeValueLCopyFunc Nothing cb
    mk_TypeValueLCopyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValueLCopyFunc` into a `C_TypeValueLCopyFunc`.
wrap_TypeValueLCopyFunc :: 
    Maybe (Ptr (FunPtr C_TypeValueLCopyFunc)) ->
    TypeValueLCopyFunc ->
    C_TypeValueLCopyFunc
wrap_TypeValueLCopyFunc gi'funptrptr gi'cb value nCollectValues collectValues collectFlags = do
    value' <- B.GValue.newGValueFromPtr value
    collectValues' <- (unpackBlockArrayWithLength 8 nCollectValues) collectValues
    collectValues'' <- mapM (newPtr GObject.TypeCValue.TypeCValue) collectValues'
    result <- gi'cb  value' collectValues'' collectFlags
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- textToCString result'
        return result''


-- callback TypeValueInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to initialize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Initializes the value contents by setting the fields of the `value->data`\narray.\n\nThe data array of the #GValue passed into this function was zero-filled\nwith `memset()`, so no care has to be taken to free any old contents.\nFor example, in the case of a string value that may never be %NULL, the\nimplementation might look like:\n\n|[<!-- language=\"C\" -->\nvalue->data[0].v_pointer = g_strdup (\"\");\n]|"
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValueInitFunc =
    Ptr GValue ->
    IO ()

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValueInitFunc :: FunPtr C_TypeValueInitFunc -> C_TypeValueInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValueInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValueInitFunc
    -> GValue
    -- ^ /@value@/: the value to initialize
    -> m ()
dynamic_TypeValueInitFunc __funPtr value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    (__dynamic_C_TypeValueInitFunc __funPtr) value'
    touchManagedPtr value
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypeValueInitFunc`.
foreign import ccall "wrapper"
    mk_TypeValueInitFunc :: C_TypeValueInitFunc -> IO (FunPtr C_TypeValueInitFunc)

-- | Initializes the value contents by setting the fields of the @value->data@
-- array.
-- 
-- The data array of the t'GI.GObject.Structs.Value.Value' passed into this function was zero-filled
-- with @memset()@, so no care has to be taken to free any old contents.
-- For example, in the case of a string value that may never be 'P.Nothing', the
-- implementation might look like:
-- 
-- 
-- === /C code/
-- >
-- >value->data[0].v_pointer = g_strdup ("");
-- 
-- 
-- /Since: 2.78/
type TypeValueInitFunc =
    GValue
    -- ^ /@value@/: the value to initialize
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValueInitFunc`@.
noTypeValueInitFunc :: Maybe TypeValueInitFunc
noTypeValueInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValueInitFunc :: MonadIO m => TypeValueInitFunc -> m (GClosure C_TypeValueInitFunc)
genClosure_TypeValueInitFunc cb = liftIO $ do
    let cb' = wrap_TypeValueInitFunc Nothing cb
    mk_TypeValueInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValueInitFunc` into a `C_TypeValueInitFunc`.
wrap_TypeValueInitFunc :: 
    Maybe (Ptr (FunPtr C_TypeValueInitFunc)) ->
    TypeValueInitFunc ->
    C_TypeValueInitFunc
wrap_TypeValueInitFunc gi'funptrptr gi'cb value = do
    value' <- B.GValue.newGValueFromPtr value
    gi'cb  value'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypeValueFreeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to free" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Frees any old contents that might be left in the `value->data` array of\nthe given value.\n\nNo resources may remain allocated through the #GValue contents after this\nfunction returns. E.g. for our above string type:\n\n|[<!-- language=\"C\" -->\n// only free strings without a specific flag for static storage\nif (!(value->data[1].v_uint & G_VALUE_NOCOPY_CONTENTS))\n  g_free (value->data[0].v_pointer);\n]|"
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValueFreeFunc =
    Ptr GValue ->
    IO ()

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to free" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValueFreeFunc :: FunPtr C_TypeValueFreeFunc -> C_TypeValueFreeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValueFreeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValueFreeFunc
    -> GValue
    -- ^ /@value@/: the value to free
    -> m ()
dynamic_TypeValueFreeFunc __funPtr value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    (__dynamic_C_TypeValueFreeFunc __funPtr) value'
    touchManagedPtr value
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypeValueFreeFunc`.
foreign import ccall "wrapper"
    mk_TypeValueFreeFunc :: C_TypeValueFreeFunc -> IO (FunPtr C_TypeValueFreeFunc)

-- | Frees any old contents that might be left in the @value->data@ array of
-- the given value.
-- 
-- No resources may remain allocated through the t'GI.GObject.Structs.Value.Value' contents after this
-- function returns. E.g. for our above string type:
-- 
-- 
-- === /C code/
-- >
-- >// only free strings without a specific flag for static storage
-- >if (!(value->data[1].v_uint & G_VALUE_NOCOPY_CONTENTS))
-- >  g_free (value->data[0].v_pointer);
-- 
-- 
-- /Since: 2.78/
type TypeValueFreeFunc =
    GValue
    -- ^ /@value@/: the value to free
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValueFreeFunc`@.
noTypeValueFreeFunc :: Maybe TypeValueFreeFunc
noTypeValueFreeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValueFreeFunc :: MonadIO m => TypeValueFreeFunc -> m (GClosure C_TypeValueFreeFunc)
genClosure_TypeValueFreeFunc cb = liftIO $ do
    let cb' = wrap_TypeValueFreeFunc Nothing cb
    mk_TypeValueFreeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValueFreeFunc` into a `C_TypeValueFreeFunc`.
wrap_TypeValueFreeFunc :: 
    Maybe (Ptr (FunPtr C_TypeValueFreeFunc)) ->
    TypeValueFreeFunc ->
    C_TypeValueFreeFunc
wrap_TypeValueFreeFunc gi'funptrptr gi'cb value = do
    value' <- B.GValue.newGValueFromPtr value
    gi'cb  value'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypeValueCopyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "src_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to copy" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "dest_value"
          , argType = TGValue
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the location of the copy"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = True
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Copies the content of a #GValue into another.\n\nThe @dest_value is a #GValue with zero-filled data section and @src_value\nis a properly initialized #GValue of same type, or derived type.\n\nThe purpose of this function is to copy the contents of @src_value\ninto @dest_value in a way, that even after @src_value has been freed, the\ncontents of @dest_value remain valid. String type example:\n\n|[<!-- language=\"C\" -->\ndest_value->data[0].v_pointer = g_strdup (src_value->data[0].v_pointer);\n]|"
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValueCopyFunc =
    Ptr GValue ->
    Ptr GValue ->
    IO ()

-- Args: [ Arg
--           { argCName = "src_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_value"
--           , argType = TGValue
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the location of the copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValueCopyFunc :: FunPtr C_TypeValueCopyFunc -> C_TypeValueCopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValueCopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValueCopyFunc
    -> GValue
    -- ^ /@srcValue@/: the value to copy
    -> m (GValue)
dynamic_TypeValueCopyFunc __funPtr srcValue = liftIO $ do
    srcValue' <- unsafeManagedPtrGetPtr srcValue
    destValue <- SP.callocBytes 24 :: IO (Ptr GValue)
    (__dynamic_C_TypeValueCopyFunc __funPtr) srcValue' destValue
    destValue' <- B.GValue.wrapGValuePtr destValue
    touchManagedPtr srcValue
    return destValue'

-- | Generate a function pointer callable from C code, from a `C_TypeValueCopyFunc`.
foreign import ccall "wrapper"
    mk_TypeValueCopyFunc :: C_TypeValueCopyFunc -> IO (FunPtr C_TypeValueCopyFunc)

-- | Copies the content of a t'GI.GObject.Structs.Value.Value' into another.
-- 
-- The /@destValue@/ is a t'GI.GObject.Structs.Value.Value' with zero-filled data section and /@srcValue@/
-- is a properly initialized t'GI.GObject.Structs.Value.Value' of same type, or derived type.
-- 
-- The purpose of this function is to copy the contents of /@srcValue@/
-- into /@destValue@/ in a way, that even after /@srcValue@/ has been freed, the
-- contents of /@destValue@/ remain valid. String type example:
-- 
-- 
-- === /C code/
-- >
-- >dest_value->data[0].v_pointer = g_strdup (src_value->data[0].v_pointer);
-- 
-- 
-- /Since: 2.78/
type TypeValueCopyFunc =
    GValue
    -- ^ /@srcValue@/: the value to copy
    -> IO (GValue)

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValueCopyFunc`@.
noTypeValueCopyFunc :: Maybe TypeValueCopyFunc
noTypeValueCopyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValueCopyFunc :: MonadIO m => TypeValueCopyFunc -> m (GClosure C_TypeValueCopyFunc)
genClosure_TypeValueCopyFunc cb = liftIO $ do
    let cb' = wrap_TypeValueCopyFunc Nothing cb
    mk_TypeValueCopyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValueCopyFunc` into a `C_TypeValueCopyFunc`.
wrap_TypeValueCopyFunc :: 
    Maybe (Ptr (FunPtr C_TypeValueCopyFunc)) ->
    TypeValueCopyFunc ->
    C_TypeValueCopyFunc
wrap_TypeValueCopyFunc gi'funptrptr gi'cb srcValue destValue = do
    -- XXX Could not generate callback wrapper for TypeValueCopyFunc
    -- Not implemented: Unexpected transfer type for "destValue"
    P.error "The bindings for wrap_TypeValueCopyFunc could not be generated, function unsupported."


-- callback TypeValueCollectFunc
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "`NULL` on success, otherwise a\n  newly allocated error string on failure"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the value to initialize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_collect_values"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the number of collected values"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "collect_values"
          , argType =
              TCArray
                False
                (-1)
                1
                (TInterface Name { namespace = "GObject" , name = "TypeCValue" })
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the collected values"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "collect_flags"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "optional flags" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This function is responsible for converting the values collected from\na variadic argument list into contents suitable for storage in a #GValue.\n\nThis function should setup @value similar to #GTypeValueInitFunc; e.g.\nfor a string value that does not allow `NULL` pointers, it needs to either\nemit an error, or do an implicit conversion by storing an empty string.\n\nThe @value passed in to this function has a zero-filled data array, so\njust like for #GTypeValueInitFunc it is guaranteed to not contain any old\ncontents that might need freeing.\n\nThe @n_collect_values argument is the string length of the `collect_format`\nfield of #GTypeValueTable, and `collect_values` is an array of #GTypeCValue\nwith length of @n_collect_values, containing the collected values according\nto `collect_format`.\n\nThe @collect_flags argument provided as a hint by the caller. It may\ncontain the flag %G_VALUE_NOCOPY_CONTENTS indicating that the collected\nvalue contents may be considered \8216static\8217 for the duration of the @value\nlifetime. Thus an extra copy of the contents stored in @collect_values is\nnot required for assignment to @value.\n\nFor our above string example, we continue with:\n\n|[<!-- language=\"C\" -->\nif (!collect_values[0].v_pointer)\n  value->data[0].v_pointer = g_strdup (\"\");\nelse if (collect_flags & G_VALUE_NOCOPY_CONTENTS)\n  {\n    value->data[0].v_pointer = collect_values[0].v_pointer;\n    // keep a flag for the value_free() implementation to not free this string\n    value->data[1].v_uint = G_VALUE_NOCOPY_CONTENTS;\n  }\nelse\n  value->data[0].v_pointer = g_strdup (collect_values[0].v_pointer);\nreturn NULL;\n]|\n\nIt should be noted, that it is generally a bad idea to follow the\n%G_VALUE_NOCOPY_CONTENTS hint for reference counted types. Due to\nreentrancy requirements and reference count assertions performed\nby the signal emission code, reference counts should always be\nincremented for reference counted contents stored in the `value->data`\narray. To deviate from our string example for a moment, and taking\na look at an exemplary implementation for `GTypeValueTable.collect_value()`\nof `GObject`:\n\n|[<!-- language=\"C\" -->\nGObject *object = G_OBJECT (collect_values[0].v_pointer);\ng_return_val_if_fail (object != NULL,\n   g_strdup_printf (\"Object %p passed as invalid NULL pointer\", object));\n// never honour G_VALUE_NOCOPY_CONTENTS for ref-counted types\nvalue->data[0].v_pointer = g_object_ref (object);\nreturn NULL;\n]|\n\nThe reference count for valid objects is always incremented, regardless\nof `collect_flags`. For invalid objects, the example returns a newly\nallocated string without altering `value`.\n\nUpon success, `collect_value()` needs to return `NULL`. If, however,\nan error condition occurred, `collect_value()` should return a newly\nallocated string containing an error diagnostic.\n\nThe calling code makes no assumptions about the `value` contents being\nvalid upon error returns, `value` is simply thrown away without further\nfreeing. As such, it is a good idea to not allocate `GValue` contents\nprior to returning an error; however, `collect_values()` is not obliged\nto return a correctly setup @value for error returns, simply because\nany non-`NULL` return is considered a fatal programming error, and\nfurther program behaviour is undefined."
        , sinceVersion = Just "2.78"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeValueCollectFunc =
    Ptr GValue ->
    Word32 ->
    Ptr GObject.TypeCValue.TypeCValue ->
    Word32 ->
    IO CString

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_collect_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of collected values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collect_values"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "GObject" , name = "TypeCValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the collected values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collect_flags"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional flags" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_collect_values"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of collected values"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeValueCollectFunc :: FunPtr C_TypeValueCollectFunc -> C_TypeValueCollectFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeValueCollectFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeValueCollectFunc
    -> GValue
    -- ^ /@value@/: the value to initialize
    -> [GObject.TypeCValue.TypeCValue]
    -- ^ /@collectValues@/: the collected values
    -> Word32
    -- ^ /@collectFlags@/: optional flags
    -> m (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ on success, otherwise a
    --   newly allocated error string on failure
dynamic_TypeValueCollectFunc __funPtr value collectValues collectFlags = liftIO $ do
    let nCollectValues = fromIntegral $ P.length collectValues
    value' <- unsafeManagedPtrGetPtr value
    collectValues' <- mapM unsafeManagedPtrGetPtr collectValues
    collectValues'' <- packBlockArray 8 collectValues'
    result <- (__dynamic_C_TypeValueCollectFunc __funPtr) value' nCollectValues collectValues'' collectFlags
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr value
    mapM_ touchManagedPtr collectValues
    freeMem collectValues''
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_TypeValueCollectFunc`.
foreign import ccall "wrapper"
    mk_TypeValueCollectFunc :: C_TypeValueCollectFunc -> IO (FunPtr C_TypeValueCollectFunc)

-- | This function is responsible for converting the values collected from
-- a variadic argument list into contents suitable for storage in a t'GI.GObject.Structs.Value.Value'.
-- 
-- This function should setup /@value@/ similar to t'GI.GObject.Callbacks.TypeValueInitFunc'; e.g.
-- for a string value that does not allow @NULL@ pointers, it needs to either
-- emit an error, or do an implicit conversion by storing an empty string.
-- 
-- The /@value@/ passed in to this function has a zero-filled data array, so
-- just like for t'GI.GObject.Callbacks.TypeValueInitFunc' it is guaranteed to not contain any old
-- contents that might need freeing.
-- 
-- The /@nCollectValues@/ argument is the string length of the @collect_format@
-- field of t'GI.GObject.Structs.TypeValueTable.TypeValueTable', and @collect_values@ is an array of t'GI.GObject.Unions.TypeCValue.TypeCValue'
-- with length of /@nCollectValues@/, containing the collected values according
-- to @collect_format@.
-- 
-- The /@collectFlags@/ argument provided as a hint by the caller. It may
-- contain the flag 'GI.GObject.Constants.VALUE_NOCOPY_CONTENTS' indicating that the collected
-- value contents may be considered ‘static’ for the duration of the /@value@/
-- lifetime. Thus an extra copy of the contents stored in /@collectValues@/ is
-- not required for assignment to /@value@/.
-- 
-- For our above string example, we continue with:
-- 
-- 
-- === /C code/
-- >
-- >if (!collect_values[0].v_pointer)
-- >  value->data[0].v_pointer = g_strdup ("");
-- >else if (collect_flags & G_VALUE_NOCOPY_CONTENTS)
-- >  {
-- >    value->data[0].v_pointer = collect_values[0].v_pointer;
-- >    // keep a flag for the value_free() implementation to not free this string
-- >    value->data[1].v_uint = G_VALUE_NOCOPY_CONTENTS;
-- >  }
-- >else
-- >  value->data[0].v_pointer = g_strdup (collect_values[0].v_pointer);
-- >return NULL;
-- 
-- 
-- It should be noted, that it is generally a bad idea to follow the
-- 'GI.GObject.Constants.VALUE_NOCOPY_CONTENTS' hint for reference counted types. Due to
-- reentrancy requirements and reference count assertions performed
-- by the signal emission code, reference counts should always be
-- incremented for reference counted contents stored in the @value->data@
-- array. To deviate from our string example for a moment, and taking
-- a look at an exemplary implementation for @GTypeValueTable.collect_value()@
-- of @GObject@:
-- 
-- 
-- === /C code/
-- >
-- >GObject *object = G_OBJECT (collect_values[0].v_pointer);
-- >g_return_val_if_fail (object != NULL,
-- >   g_strdup_printf ("Object %p passed as invalid NULL pointer", object));
-- >// never honour G_VALUE_NOCOPY_CONTENTS for ref-counted types
-- >value->data[0].v_pointer = g_object_ref (object);
-- >return NULL;
-- 
-- 
-- The reference count for valid objects is always incremented, regardless
-- of @collect_flags@. For invalid objects, the example returns a newly
-- allocated string without altering @value@.
-- 
-- Upon success, @collect_value()@ needs to return @NULL@. If, however,
-- an error condition occurred, @collect_value()@ should return a newly
-- allocated string containing an error diagnostic.
-- 
-- The calling code makes no assumptions about the @value@ contents being
-- valid upon error returns, @value@ is simply thrown away without further
-- freeing. As such, it is a good idea to not allocate @GValue@ contents
-- prior to returning an error; however, @collect_values()@ is not obliged
-- to return a correctly setup /@value@/ for error returns, simply because
-- any non-@NULL@ return is considered a fatal programming error, and
-- further program behaviour is undefined.
-- 
-- /Since: 2.78/
type TypeValueCollectFunc =
    GValue
    -- ^ /@value@/: the value to initialize
    -> [GObject.TypeCValue.TypeCValue]
    -- ^ /@collectValues@/: the collected values
    -> Word32
    -- ^ /@collectFlags@/: optional flags
    -> IO (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ on success, otherwise a
    --   newly allocated error string on failure

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeValueCollectFunc`@.
noTypeValueCollectFunc :: Maybe TypeValueCollectFunc
noTypeValueCollectFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeValueCollectFunc :: MonadIO m => TypeValueCollectFunc -> m (GClosure C_TypeValueCollectFunc)
genClosure_TypeValueCollectFunc cb = liftIO $ do
    let cb' = wrap_TypeValueCollectFunc Nothing cb
    mk_TypeValueCollectFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeValueCollectFunc` into a `C_TypeValueCollectFunc`.
wrap_TypeValueCollectFunc :: 
    Maybe (Ptr (FunPtr C_TypeValueCollectFunc)) ->
    TypeValueCollectFunc ->
    C_TypeValueCollectFunc
wrap_TypeValueCollectFunc gi'funptrptr gi'cb value nCollectValues collectValues collectFlags = do
    value' <- B.GValue.newGValueFromPtr value
    collectValues' <- (unpackBlockArrayWithLength 8 nCollectValues) collectValues
    collectValues'' <- mapM (newPtr GObject.TypeCValue.TypeCValue) collectValues'
    result <- gi'cb  value' collectValues'' collectFlags
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- textToCString result'
        return result''


-- callback TypePluginUse
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "plugin"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypePlugin" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GTypePlugin whose use count should be increased"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @use_plugin function of #GTypePluginClass, which gets called\nto increase the use count of @plugin."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypePluginUse =
    Ptr GObject.TypePlugin.TypePlugin ->
    IO ()

-- Args: [ Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GTypePlugin whose use count should be increased"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypePluginUse :: FunPtr C_TypePluginUse -> C_TypePluginUse

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypePluginUse ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    FunPtr C_TypePluginUse
    -> a
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' whose use count should be increased
    -> m ()
dynamic_TypePluginUse __funPtr plugin = liftIO $ do
    plugin' <- unsafeManagedPtrCastPtr plugin
    (__dynamic_C_TypePluginUse __funPtr) plugin'
    touchManagedPtr plugin
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypePluginUse`.
foreign import ccall "wrapper"
    mk_TypePluginUse :: C_TypePluginUse -> IO (FunPtr C_TypePluginUse)

-- | The type of the /@usePlugin@/ function of @/GTypePluginClass/@, which gets called
-- to increase the use count of /@plugin@/.
type TypePluginUse =
    GObject.TypePlugin.TypePlugin
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' whose use count should be increased
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypePluginUse`@.
noTypePluginUse :: Maybe TypePluginUse
noTypePluginUse = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypePluginUse :: MonadIO m => TypePluginUse -> m (GClosure C_TypePluginUse)
genClosure_TypePluginUse cb = liftIO $ do
    let cb' = wrap_TypePluginUse Nothing cb
    mk_TypePluginUse cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypePluginUse` into a `C_TypePluginUse`.
wrap_TypePluginUse :: 
    Maybe (Ptr (FunPtr C_TypePluginUse)) ->
    TypePluginUse ->
    C_TypePluginUse
wrap_TypePluginUse gi'funptrptr gi'cb plugin = do
    plugin' <- (newPtr GObject.TypePlugin.TypePlugin) plugin
    gi'cb  plugin'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypePluginUnuse
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "plugin"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypePlugin" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GTypePlugin whose use count should be decreased"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "The type of the @unuse_plugin function of #GTypePluginClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypePluginUnuse =
    Ptr GObject.TypePlugin.TypePlugin ->
    IO ()

-- Args: [ Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GTypePlugin whose use count should be decreased"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypePluginUnuse :: FunPtr C_TypePluginUnuse -> C_TypePluginUnuse

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypePluginUnuse ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    FunPtr C_TypePluginUnuse
    -> a
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' whose use count should be decreased
    -> m ()
dynamic_TypePluginUnuse __funPtr plugin = liftIO $ do
    plugin' <- unsafeManagedPtrCastPtr plugin
    (__dynamic_C_TypePluginUnuse __funPtr) plugin'
    touchManagedPtr plugin
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypePluginUnuse`.
foreign import ccall "wrapper"
    mk_TypePluginUnuse :: C_TypePluginUnuse -> IO (FunPtr C_TypePluginUnuse)

-- | The type of the /@unusePlugin@/ function of @/GTypePluginClass/@.
type TypePluginUnuse =
    GObject.TypePlugin.TypePlugin
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' whose use count should be decreased
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypePluginUnuse`@.
noTypePluginUnuse :: Maybe TypePluginUnuse
noTypePluginUnuse = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypePluginUnuse :: MonadIO m => TypePluginUnuse -> m (GClosure C_TypePluginUnuse)
genClosure_TypePluginUnuse cb = liftIO $ do
    let cb' = wrap_TypePluginUnuse Nothing cb
    mk_TypePluginUnuse cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypePluginUnuse` into a `C_TypePluginUnuse`.
wrap_TypePluginUnuse :: 
    Maybe (Ptr (FunPtr C_TypePluginUnuse)) ->
    TypePluginUnuse ->
    C_TypePluginUnuse
wrap_TypePluginUnuse gi'funptrptr gi'cb plugin = do
    plugin' <- (newPtr GObject.TypePlugin.TypePlugin) plugin
    gi'cb  plugin'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypePluginCompleteTypeInfo
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "plugin"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypePlugin" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GTypePlugin" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "g_type"
          , argType = TBasicType TGType
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GType whose info is completed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "info"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeInfo" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GTypeInfo struct to fill in"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value_table"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeValueTable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GTypeValueTable to fill in"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @complete_type_info function of #GTypePluginClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypePluginCompleteTypeInfo =
    Ptr GObject.TypePlugin.TypePlugin ->
    CGType ->
    Ptr GObject.TypeInfo.TypeInfo ->
    Ptr GObject.TypeValueTable.TypeValueTable ->
    IO ()

-- Args: [ Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypePlugin" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GType whose info is completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypeInfo struct to fill in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value_table"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeValueTable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypeValueTable to fill in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypePluginCompleteTypeInfo :: FunPtr C_TypePluginCompleteTypeInfo -> C_TypePluginCompleteTypeInfo

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypePluginCompleteTypeInfo ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    FunPtr C_TypePluginCompleteTypeInfo
    -> a
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin'
    -> GType
    -- ^ /@gType@/: the t'GType' whose info is completed
    -> GObject.TypeInfo.TypeInfo
    -- ^ /@info@/: the t'GI.GObject.Structs.TypeInfo.TypeInfo' struct to fill in
    -> GObject.TypeValueTable.TypeValueTable
    -- ^ /@valueTable@/: the t'GI.GObject.Structs.TypeValueTable.TypeValueTable' to fill in
    -> m ()
dynamic_TypePluginCompleteTypeInfo __funPtr plugin gType info valueTable = liftIO $ do
    plugin' <- unsafeManagedPtrCastPtr plugin
    let gType' = gtypeToCGType gType
    info' <- unsafeManagedPtrGetPtr info
    valueTable' <- unsafeManagedPtrGetPtr valueTable
    (__dynamic_C_TypePluginCompleteTypeInfo __funPtr) plugin' gType' info' valueTable'
    touchManagedPtr plugin
    touchManagedPtr info
    touchManagedPtr valueTable
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypePluginCompleteTypeInfo`.
foreign import ccall "wrapper"
    mk_TypePluginCompleteTypeInfo :: C_TypePluginCompleteTypeInfo -> IO (FunPtr C_TypePluginCompleteTypeInfo)

-- | The type of the /@completeTypeInfo@/ function of @/GTypePluginClass/@.
type TypePluginCompleteTypeInfo =
    GObject.TypePlugin.TypePlugin
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin'
    -> GType
    -- ^ /@gType@/: the t'GType' whose info is completed
    -> GObject.TypeInfo.TypeInfo
    -- ^ /@info@/: the t'GI.GObject.Structs.TypeInfo.TypeInfo' struct to fill in
    -> GObject.TypeValueTable.TypeValueTable
    -- ^ /@valueTable@/: the t'GI.GObject.Structs.TypeValueTable.TypeValueTable' to fill in
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypePluginCompleteTypeInfo`@.
noTypePluginCompleteTypeInfo :: Maybe TypePluginCompleteTypeInfo
noTypePluginCompleteTypeInfo = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypePluginCompleteTypeInfo :: MonadIO m => TypePluginCompleteTypeInfo -> m (GClosure C_TypePluginCompleteTypeInfo)
genClosure_TypePluginCompleteTypeInfo cb = liftIO $ do
    let cb' = wrap_TypePluginCompleteTypeInfo Nothing cb
    mk_TypePluginCompleteTypeInfo cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypePluginCompleteTypeInfo` into a `C_TypePluginCompleteTypeInfo`.
wrap_TypePluginCompleteTypeInfo :: 
    Maybe (Ptr (FunPtr C_TypePluginCompleteTypeInfo)) ->
    TypePluginCompleteTypeInfo ->
    C_TypePluginCompleteTypeInfo
wrap_TypePluginCompleteTypeInfo gi'funptrptr gi'cb plugin gType info valueTable = do
    plugin' <- (newPtr GObject.TypePlugin.TypePlugin) plugin
    let gType' = GType gType
    info' <- (newPtr GObject.TypeInfo.TypeInfo) info
    valueTable' <- (newPtr GObject.TypeValueTable.TypeValueTable) valueTable
    gi'cb  plugin' gType' info' valueTable'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypePluginCompleteInterfaceInfo
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "plugin"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypePlugin" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GTypePlugin" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "instance_type"
          , argType = TBasicType TGType
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the #GType of an instantiatable type to which the interface\n is added"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_type"
          , argType = TBasicType TGType
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GType of the interface whose info is completed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "info"
          , argType =
              TInterface Name { namespace = "GObject" , name = "InterfaceInfo" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GInterfaceInfo to fill in"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @complete_interface_info function of #GTypePluginClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypePluginCompleteInterfaceInfo =
    Ptr GObject.TypePlugin.TypePlugin ->
    CGType ->
    CGType ->
    Ptr GObject.InterfaceInfo.InterfaceInfo ->
    IO ()

-- Args: [ Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypePlugin" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GType of an instantiatable type to which the interface\n is added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GType of the interface whose info is completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "InterfaceInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GInterfaceInfo to fill in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypePluginCompleteInterfaceInfo :: FunPtr C_TypePluginCompleteInterfaceInfo -> C_TypePluginCompleteInterfaceInfo

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypePluginCompleteInterfaceInfo ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    FunPtr C_TypePluginCompleteInterfaceInfo
    -> a
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin'
    -> GType
    -- ^ /@instanceType@/: the t'GType' of an instantiatable type to which the interface
    --  is added
    -> GType
    -- ^ /@interfaceType@/: the t'GType' of the interface whose info is completed
    -> GObject.InterfaceInfo.InterfaceInfo
    -- ^ /@info@/: the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' to fill in
    -> m ()
dynamic_TypePluginCompleteInterfaceInfo __funPtr plugin instanceType interfaceType info = liftIO $ do
    plugin' <- unsafeManagedPtrCastPtr plugin
    let instanceType' = gtypeToCGType instanceType
    let interfaceType' = gtypeToCGType interfaceType
    info' <- unsafeManagedPtrGetPtr info
    (__dynamic_C_TypePluginCompleteInterfaceInfo __funPtr) plugin' instanceType' interfaceType' info'
    touchManagedPtr plugin
    touchManagedPtr info
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypePluginCompleteInterfaceInfo`.
foreign import ccall "wrapper"
    mk_TypePluginCompleteInterfaceInfo :: C_TypePluginCompleteInterfaceInfo -> IO (FunPtr C_TypePluginCompleteInterfaceInfo)

-- | The type of the /@completeInterfaceInfo@/ function of @/GTypePluginClass/@.
type TypePluginCompleteInterfaceInfo =
    GObject.TypePlugin.TypePlugin
    -- ^ /@plugin@/: the t'GI.GObject.Interfaces.TypePlugin.TypePlugin'
    -> GType
    -- ^ /@instanceType@/: the t'GType' of an instantiatable type to which the interface
    --  is added
    -> GType
    -- ^ /@interfaceType@/: the t'GType' of the interface whose info is completed
    -> GObject.InterfaceInfo.InterfaceInfo
    -- ^ /@info@/: the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' to fill in
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypePluginCompleteInterfaceInfo`@.
noTypePluginCompleteInterfaceInfo :: Maybe TypePluginCompleteInterfaceInfo
noTypePluginCompleteInterfaceInfo = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypePluginCompleteInterfaceInfo :: MonadIO m => TypePluginCompleteInterfaceInfo -> m (GClosure C_TypePluginCompleteInterfaceInfo)
genClosure_TypePluginCompleteInterfaceInfo cb = liftIO $ do
    let cb' = wrap_TypePluginCompleteInterfaceInfo Nothing cb
    mk_TypePluginCompleteInterfaceInfo cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypePluginCompleteInterfaceInfo` into a `C_TypePluginCompleteInterfaceInfo`.
wrap_TypePluginCompleteInterfaceInfo :: 
    Maybe (Ptr (FunPtr C_TypePluginCompleteInterfaceInfo)) ->
    TypePluginCompleteInterfaceInfo ->
    C_TypePluginCompleteInterfaceInfo
wrap_TypePluginCompleteInterfaceInfo gi'funptrptr gi'cb plugin instanceType interfaceType info = do
    plugin' <- (newPtr GObject.TypePlugin.TypePlugin) plugin
    let instanceType' = GType instanceType
    let interfaceType' = GType interfaceType
    info' <- (newPtr GObject.InterfaceInfo.InterfaceInfo) info
    gi'cb  plugin' instanceType' interfaceType' info'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypeInterfaceCheckFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "check_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to g_type_add_interface_check()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "g_iface"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeInterface" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the interface that has been\n   initialized"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback called after an interface vtable is initialized.\n\nSee g_type_add_interface_check()."
        , sinceVersion = Just "2.4"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeInterfaceCheckFunc =
    Ptr () ->
    Ptr GObject.TypeInterface.TypeInterface ->
    IO ()

-- Args: [ Arg
--           { argCName = "check_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to g_type_add_interface_check()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g_iface"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the interface that has been\n   initialized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeInterfaceCheckFunc :: FunPtr C_TypeInterfaceCheckFunc -> C_TypeInterfaceCheckFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeInterfaceCheckFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeInterfaceCheckFunc
    -> Ptr ()
    -- ^ /@checkData@/: data passed to @/g_type_add_interface_check()/@
    -> GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: the interface that has been
    --    initialized
    -> m ()
dynamic_TypeInterfaceCheckFunc __funPtr checkData gIface = liftIO $ do
    gIface' <- unsafeManagedPtrGetPtr gIface
    (__dynamic_C_TypeInterfaceCheckFunc __funPtr) checkData gIface'
    touchManagedPtr gIface
    return ()

-- | Generate a function pointer callable from C code, from a `C_TypeInterfaceCheckFunc`.
foreign import ccall "wrapper"
    mk_TypeInterfaceCheckFunc :: C_TypeInterfaceCheckFunc -> IO (FunPtr C_TypeInterfaceCheckFunc)

-- | A callback called after an interface vtable is initialized.
-- 
-- See @/g_type_add_interface_check()/@.
-- 
-- /Since: 2.4/
type TypeInterfaceCheckFunc =
    Ptr ()
    -- ^ /@checkData@/: data passed to @/g_type_add_interface_check()/@
    -> GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: the interface that has been
    --    initialized
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeInterfaceCheckFunc`@.
noTypeInterfaceCheckFunc :: Maybe TypeInterfaceCheckFunc
noTypeInterfaceCheckFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeInterfaceCheckFunc :: MonadIO m => TypeInterfaceCheckFunc -> m (GClosure C_TypeInterfaceCheckFunc)
genClosure_TypeInterfaceCheckFunc cb = liftIO $ do
    let cb' = wrap_TypeInterfaceCheckFunc Nothing cb
    mk_TypeInterfaceCheckFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeInterfaceCheckFunc` into a `C_TypeInterfaceCheckFunc`.
wrap_TypeInterfaceCheckFunc :: 
    Maybe (Ptr (FunPtr C_TypeInterfaceCheckFunc)) ->
    TypeInterfaceCheckFunc ->
    C_TypeInterfaceCheckFunc
wrap_TypeInterfaceCheckFunc gi'funptrptr gi'cb checkData gIface = do
    gIface' <- (newPtr GObject.TypeInterface.TypeInterface) gIface
    gi'cb  checkData gIface'
    maybeReleaseFunPtr gi'funptrptr


-- callback TypeClassCacheFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE to stop further #GTypeClassCacheFuncs from being\n called, %FALSE to continue"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "cache_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "data that was given to the g_type_add_class_cache_func() call"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The #GTypeClass structure which is\n   unreferenced"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function which is called when the reference count of a class\ndrops to zero.\n\nIt may use g_type_class_ref() to prevent the class from being freed. You\nshould not call g_type_class_unref() from a #GTypeClassCacheFunc function\nto prevent infinite recursion, use g_type_class_unref_uncached() instead.\n\nThe functions have to check the class id passed in to figure\nwhether they actually want to cache the class of this type, since all\nclasses are routed through the same #GTypeClassCacheFunc chain."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TypeClassCacheFunc =
    Ptr () ->
    Ptr GObject.TypeClass.TypeClass ->
    IO CInt

-- Args: [ Arg
--           { argCName = "cache_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "data that was given to the g_type_add_class_cache_func() call"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #GTypeClass structure which is\n   unreferenced"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TypeClassCacheFunc :: FunPtr C_TypeClassCacheFunc -> C_TypeClassCacheFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TypeClassCacheFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TypeClassCacheFunc
    -> Ptr ()
    -- ^ /@cacheData@/: data that was given to the @/g_type_add_class_cache_func()/@ call
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure which is
    --    unreferenced
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop further @/GTypeClassCacheFuncs/@ from being
    --  called, 'P.False' to continue
dynamic_TypeClassCacheFunc __funPtr cacheData gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    result <- (__dynamic_C_TypeClassCacheFunc __funPtr) cacheData gClass'
    let result' = (/= 0) result
    touchManagedPtr gClass
    return result'

-- | Generate a function pointer callable from C code, from a `C_TypeClassCacheFunc`.
foreign import ccall "wrapper"
    mk_TypeClassCacheFunc :: C_TypeClassCacheFunc -> IO (FunPtr C_TypeClassCacheFunc)

-- | A callback function which is called when the reference count of a class
-- drops to zero.
-- 
-- It may use 'GI.GObject.Functions.typeClassRef' to prevent the class from being freed. You
-- should not call 'GI.GObject.Structs.TypeClass.typeClassUnref' from a t'GI.GObject.Callbacks.TypeClassCacheFunc' function
-- to prevent infinite recursion, use @/g_type_class_unref_uncached()/@ instead.
-- 
-- The functions have to check the class id passed in to figure
-- whether they actually want to cache the class of this type, since all
-- classes are routed through the same t'GI.GObject.Callbacks.TypeClassCacheFunc' chain.
type TypeClassCacheFunc =
    Ptr ()
    -- ^ /@cacheData@/: data that was given to the @/g_type_add_class_cache_func()/@ call
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure which is
    --    unreferenced
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop further @/GTypeClassCacheFuncs/@ from being
    --  called, 'P.False' to continue

-- | A convenience synonym for @`Nothing` :: `Maybe` `TypeClassCacheFunc`@.
noTypeClassCacheFunc :: Maybe TypeClassCacheFunc
noTypeClassCacheFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TypeClassCacheFunc :: MonadIO m => TypeClassCacheFunc -> m (GClosure C_TypeClassCacheFunc)
genClosure_TypeClassCacheFunc cb = liftIO $ do
    let cb' = wrap_TypeClassCacheFunc Nothing cb
    mk_TypeClassCacheFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TypeClassCacheFunc` into a `C_TypeClassCacheFunc`.
wrap_TypeClassCacheFunc :: 
    Maybe (Ptr (FunPtr C_TypeClassCacheFunc)) ->
    TypeClassCacheFunc ->
    C_TypeClassCacheFunc
wrap_TypeClassCacheFunc gi'funptrptr gi'cb cacheData gClass = do
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    result <- gi'cb  cacheData gClass'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ToggleNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Callback data passed to g_object_add_toggle_ref()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The object on which g_object_add_toggle_ref() was called."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "is_last_ref"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "%TRUE if the toggle reference is now the\n last reference to the object. %FALSE if the toggle\n reference was the last reference and there are now other\n references."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used for notification when the state\nof a toggle reference changes.\n\nSee also: g_object_add_toggle_ref()"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ToggleNotify =
    Ptr () ->
    Ptr GObject.Object.Object ->
    CInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Callback data passed to g_object_add_toggle_ref()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object on which g_object_add_toggle_ref() was called."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_last_ref"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if the toggle reference is now the\n last reference to the object. %FALSE if the toggle\n reference was the last reference and there are now other\n references."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ToggleNotify :: FunPtr C_ToggleNotify -> C_ToggleNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ToggleNotify ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ToggleNotify
    -> Ptr ()
    -- ^ /@data@/: Callback data passed to @/g_object_add_toggle_ref()/@
    -> a
    -- ^ /@object@/: The object on which @/g_object_add_toggle_ref()/@ was called.
    -> Bool
    -- ^ /@isLastRef@/: 'P.True' if the toggle reference is now the
    --  last reference to the object. 'P.False' if the toggle
    --  reference was the last reference and there are now other
    --  references.
    -> m ()
dynamic_ToggleNotify __funPtr data_ object isLastRef = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    let isLastRef' = (P.fromIntegral . P.fromEnum) isLastRef
    (__dynamic_C_ToggleNotify __funPtr) data_ object' isLastRef'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_ToggleNotify`.
foreign import ccall "wrapper"
    mk_ToggleNotify :: C_ToggleNotify -> IO (FunPtr C_ToggleNotify)

-- | A callback function used for notification when the state
-- of a toggle reference changes.
-- 
-- See also: @/g_object_add_toggle_ref()/@
type ToggleNotify =
    Ptr ()
    -- ^ /@data@/: Callback data passed to @/g_object_add_toggle_ref()/@
    -> GObject.Object.Object
    -- ^ /@object@/: The object on which @/g_object_add_toggle_ref()/@ was called.
    -> Bool
    -- ^ /@isLastRef@/: 'P.True' if the toggle reference is now the
    --  last reference to the object. 'P.False' if the toggle
    --  reference was the last reference and there are now other
    --  references.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ToggleNotify`@.
noToggleNotify :: Maybe ToggleNotify
noToggleNotify = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ToggleNotify :: MonadIO m => ToggleNotify -> m (GClosure C_ToggleNotify)
genClosure_ToggleNotify cb = liftIO $ do
    let cb' = wrap_ToggleNotify Nothing cb
    mk_ToggleNotify cb' >>= B.GClosure.newGClosure


-- | Wrap a `ToggleNotify` into a `C_ToggleNotify`.
wrap_ToggleNotify :: 
    Maybe (Ptr (FunPtr C_ToggleNotify)) ->
    ToggleNotify ->
    C_ToggleNotify
wrap_ToggleNotify gi'funptrptr gi'cb data_ object isLastRef = do
    object' <- (newObject GObject.Object.Object) object
    let isLastRef' = (/= 0) isLastRef
    gi'cb  data_ object' isLastRef'
    maybeReleaseFunPtr gi'funptrptr


-- callback SignalEmissionHook
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "whether it wants to stay connected. If it returns %FALSE, the signal\n hook is disconnected (and destroyed)."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ihint"
          , argType =
              TInterface
                Name { namespace = "GObject" , name = "SignalInvocationHint" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Signal invocation hint, see #GSignalInvocationHint."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_param_values"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the number of parameters to the function, including\n the instance on which the signal was emitted."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "param_values"
          , argType = TCArray False (-1) 1 TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the instance on which\n the signal was emitted, followed by the parameters of the emission."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data associated with the hook."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A simple function pointer to get invoked when the signal is emitted.\n\nEmission hooks allow you to tie a hook to the signal type, so that it will\ntrap all emissions of that signal, from any object.\n\nYou may not attach these to signals created with the %G_SIGNAL_NO_HOOKS flag."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SignalEmissionHook =
    Ptr GObject.SignalInvocationHint.SignalInvocationHint ->
    Word32 ->
    Ptr B.GValue.GValue ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "ihint"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalInvocationHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal invocation hint, see #GSignalInvocationHint."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of parameters to the function, including\n the instance on which the signal was emitted."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TCArray False (-1) 1 TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the instance on which\n the signal was emitted, followed by the parameters of the emission."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data associated with the hook."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_param_values"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the number of parameters to the function, including\n the instance on which the signal was emitted."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SignalEmissionHook :: FunPtr C_SignalEmissionHook -> C_SignalEmissionHook

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SignalEmissionHook ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SignalEmissionHook
    -> GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: Signal invocation hint, see t'GI.GObject.Structs.SignalInvocationHint.SignalInvocationHint'.
    -> [GValue]
    -- ^ /@paramValues@/: the instance on which
    --  the signal was emitted, followed by the parameters of the emission.
    -> Ptr ()
    -- ^ /@data@/: user data associated with the hook.
    -> m Bool
    -- ^ __Returns:__ whether it wants to stay connected. If it returns 'P.False', the signal
    --  hook is disconnected (and destroyed).
dynamic_SignalEmissionHook __funPtr ihint paramValues data_ = liftIO $ do
    let nParamValues = fromIntegral $ P.length paramValues
    ihint' <- unsafeManagedPtrGetPtr ihint
    paramValues' <- B.GValue.packGValueArray paramValues
    result <- (__dynamic_C_SignalEmissionHook __funPtr) ihint' nParamValues paramValues' data_
    let result' = (/= 0) result
    touchManagedPtr ihint
    mapM_ touchManagedPtr paramValues
    freeMem paramValues'
    return result'

-- | Generate a function pointer callable from C code, from a `C_SignalEmissionHook`.
foreign import ccall "wrapper"
    mk_SignalEmissionHook :: C_SignalEmissionHook -> IO (FunPtr C_SignalEmissionHook)

-- | A simple function pointer to get invoked when the signal is emitted.
-- 
-- Emission hooks allow you to tie a hook to the signal type, so that it will
-- trap all emissions of that signal, from any object.
-- 
-- You may not attach these to signals created with the 'GI.GObject.Flags.SignalFlagsNoHooks' flag.
type SignalEmissionHook =
    GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: Signal invocation hint, see t'GI.GObject.Structs.SignalInvocationHint.SignalInvocationHint'.
    -> [GValue]
    -- ^ /@paramValues@/: the instance on which
    --  the signal was emitted, followed by the parameters of the emission.
    -> Ptr ()
    -- ^ /@data@/: user data associated with the hook.
    -> IO Bool
    -- ^ __Returns:__ whether it wants to stay connected. If it returns 'P.False', the signal
    --  hook is disconnected (and destroyed).

-- | A convenience synonym for @`Nothing` :: `Maybe` `SignalEmissionHook`@.
noSignalEmissionHook :: Maybe SignalEmissionHook
noSignalEmissionHook = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SignalEmissionHook :: MonadIO m => SignalEmissionHook -> m (GClosure C_SignalEmissionHook)
genClosure_SignalEmissionHook cb = liftIO $ do
    let cb' = wrap_SignalEmissionHook Nothing cb
    mk_SignalEmissionHook cb' >>= B.GClosure.newGClosure


-- | Wrap a `SignalEmissionHook` into a `C_SignalEmissionHook`.
wrap_SignalEmissionHook :: 
    Maybe (Ptr (FunPtr C_SignalEmissionHook)) ->
    SignalEmissionHook ->
    C_SignalEmissionHook
wrap_SignalEmissionHook gi'funptrptr gi'cb ihint nParamValues paramValues data_ = do
    ihint' <- (newPtr GObject.SignalInvocationHint.SignalInvocationHint) ihint
    paramValues' <- (B.GValue.unpackGValueArrayWithLength nParamValues) paramValues
    result <- gi'cb  ihint' paramValues' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SignalAccumulator
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "The accumulator function returns whether the signal emission\n should be aborted. Returning %TRUE will continue with\n the signal emission. Returning %FALSE will abort the current emission.\n Since 2.62, returning %FALSE will skip to the CLEANUP stage. In this case,\n emission will occur as normal in the CLEANUP stage and the handler's\n return value will be accumulated."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ihint"
          , argType =
              TInterface
                Name { namespace = "GObject" , name = "SignalInvocationHint" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Signal invocation hint, see #GSignalInvocationHint."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "return_accu"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Accumulator to collect callback return values in, this\n is the return value of the current signal emission."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "handler_return"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "A #GValue holding the return value of the signal handler."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Callback data that was specified when creating the signal."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The signal accumulator is a special callback function that can be used\nto collect return values of the various callbacks that are called\nduring a signal emission.\n\nThe signal accumulator is specified at signal creation time, if it is\nleft %NULL, no accumulation of callback return values is performed.\nThe return value of signal emissions is then the value returned by the\nlast callback."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SignalAccumulator =
    Ptr GObject.SignalInvocationHint.SignalInvocationHint ->
    Ptr GValue ->
    Ptr GValue ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "ihint"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalInvocationHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal invocation hint, see #GSignalInvocationHint."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_accu"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Accumulator to collect callback return values in, this\n is the return value of the current signal emission."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_return"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A #GValue holding the return value of the signal handler."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Callback data that was specified when creating the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SignalAccumulator :: FunPtr C_SignalAccumulator -> C_SignalAccumulator

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SignalAccumulator ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SignalAccumulator
    -> GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: Signal invocation hint, see t'GI.GObject.Structs.SignalInvocationHint.SignalInvocationHint'.
    -> GValue
    -- ^ /@returnAccu@/: Accumulator to collect callback return values in, this
    --  is the return value of the current signal emission.
    -> GValue
    -- ^ /@handlerReturn@/: A t'GI.GObject.Structs.Value.Value' holding the return value of the signal handler.
    -> Ptr ()
    -- ^ /@data@/: Callback data that was specified when creating the signal.
    -> m Bool
    -- ^ __Returns:__ The accumulator function returns whether the signal emission
    --  should be aborted. Returning 'P.True' will continue with
    --  the signal emission. Returning 'P.False' will abort the current emission.
    --  Since 2.62, returning 'P.False' will skip to the CLEANUP stage. In this case,
    --  emission will occur as normal in the CLEANUP stage and the handler\'s
    --  return value will be accumulated.
dynamic_SignalAccumulator __funPtr ihint returnAccu handlerReturn data_ = liftIO $ do
    ihint' <- unsafeManagedPtrGetPtr ihint
    returnAccu' <- unsafeManagedPtrGetPtr returnAccu
    handlerReturn' <- unsafeManagedPtrGetPtr handlerReturn
    result <- (__dynamic_C_SignalAccumulator __funPtr) ihint' returnAccu' handlerReturn' data_
    let result' = (/= 0) result
    touchManagedPtr ihint
    touchManagedPtr returnAccu
    touchManagedPtr handlerReturn
    return result'

-- | Generate a function pointer callable from C code, from a `C_SignalAccumulator`.
foreign import ccall "wrapper"
    mk_SignalAccumulator :: C_SignalAccumulator -> IO (FunPtr C_SignalAccumulator)

-- | The signal accumulator is a special callback function that can be used
-- to collect return values of the various callbacks that are called
-- during a signal emission.
-- 
-- The signal accumulator is specified at signal creation time, if it is
-- left 'P.Nothing', no accumulation of callback return values is performed.
-- The return value of signal emissions is then the value returned by the
-- last callback.
type SignalAccumulator =
    GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: Signal invocation hint, see t'GI.GObject.Structs.SignalInvocationHint.SignalInvocationHint'.
    -> GValue
    -- ^ /@returnAccu@/: Accumulator to collect callback return values in, this
    --  is the return value of the current signal emission.
    -> GValue
    -- ^ /@handlerReturn@/: A t'GI.GObject.Structs.Value.Value' holding the return value of the signal handler.
    -> Ptr ()
    -- ^ /@data@/: Callback data that was specified when creating the signal.
    -> IO Bool
    -- ^ __Returns:__ The accumulator function returns whether the signal emission
    --  should be aborted. Returning 'P.True' will continue with
    --  the signal emission. Returning 'P.False' will abort the current emission.
    --  Since 2.62, returning 'P.False' will skip to the CLEANUP stage. In this case,
    --  emission will occur as normal in the CLEANUP stage and the handler\'s
    --  return value will be accumulated.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SignalAccumulator`@.
noSignalAccumulator :: Maybe SignalAccumulator
noSignalAccumulator = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SignalAccumulator :: MonadIO m => SignalAccumulator -> m (GClosure C_SignalAccumulator)
genClosure_SignalAccumulator cb = liftIO $ do
    let cb' = wrap_SignalAccumulator Nothing cb
    mk_SignalAccumulator cb' >>= B.GClosure.newGClosure


-- | Wrap a `SignalAccumulator` into a `C_SignalAccumulator`.
wrap_SignalAccumulator :: 
    Maybe (Ptr (FunPtr C_SignalAccumulator)) ->
    SignalAccumulator ->
    C_SignalAccumulator
wrap_SignalAccumulator gi'funptrptr gi'cb ihint returnAccu handlerReturn data_ = do
    ihint' <- (newPtr GObject.SignalInvocationHint.SignalInvocationHint) ihint
    returnAccu' <- B.GValue.newGValueFromPtr returnAccu
    handlerReturn' <- B.GValue.newGValueFromPtr handlerReturn
    result <- gi'cb  ihint' returnAccu' handlerReturn' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ParamSpecTypeInfoValuesCmpFieldCallback
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value1"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value2"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParamSpecTypeInfoValuesCmpFieldCallback =
    Ptr GParamSpec ->
    Ptr GValue ->
    Ptr GValue ->
    IO Int32

-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value1"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value2"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParamSpecTypeInfoValuesCmpFieldCallback :: FunPtr C_ParamSpecTypeInfoValuesCmpFieldCallback -> C_ParamSpecTypeInfoValuesCmpFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParamSpecTypeInfoValuesCmpFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParamSpecTypeInfoValuesCmpFieldCallback
    -> GParamSpec
    -> GValue
    -> GValue
    -> m Int32
dynamic_ParamSpecTypeInfoValuesCmpFieldCallback __funPtr pspec value1 value2 = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value1' <- unsafeManagedPtrGetPtr value1
    value2' <- unsafeManagedPtrGetPtr value2
    result <- (__dynamic_C_ParamSpecTypeInfoValuesCmpFieldCallback __funPtr) pspec' value1' value2'
    touchManagedPtr pspec
    touchManagedPtr value1
    touchManagedPtr value2
    return result

-- | Generate a function pointer callable from C code, from a `C_ParamSpecTypeInfoValuesCmpFieldCallback`.
foreign import ccall "wrapper"
    mk_ParamSpecTypeInfoValuesCmpFieldCallback :: C_ParamSpecTypeInfoValuesCmpFieldCallback -> IO (FunPtr C_ParamSpecTypeInfoValuesCmpFieldCallback)

-- | /No description available in the introspection data./
type ParamSpecTypeInfoValuesCmpFieldCallback =
    GParamSpec
    -> GValue
    -> GValue
    -> IO Int32

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParamSpecTypeInfoValuesCmpFieldCallback`@.
noParamSpecTypeInfoValuesCmpFieldCallback :: Maybe ParamSpecTypeInfoValuesCmpFieldCallback
noParamSpecTypeInfoValuesCmpFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ParamSpecTypeInfoValuesCmpFieldCallback :: MonadIO m => ParamSpecTypeInfoValuesCmpFieldCallback -> m (GClosure C_ParamSpecTypeInfoValuesCmpFieldCallback)
genClosure_ParamSpecTypeInfoValuesCmpFieldCallback cb = liftIO $ do
    let cb' = wrap_ParamSpecTypeInfoValuesCmpFieldCallback Nothing cb
    mk_ParamSpecTypeInfoValuesCmpFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ParamSpecTypeInfoValuesCmpFieldCallback` into a `C_ParamSpecTypeInfoValuesCmpFieldCallback`.
wrap_ParamSpecTypeInfoValuesCmpFieldCallback :: 
    Maybe (Ptr (FunPtr C_ParamSpecTypeInfoValuesCmpFieldCallback)) ->
    ParamSpecTypeInfoValuesCmpFieldCallback ->
    C_ParamSpecTypeInfoValuesCmpFieldCallback
wrap_ParamSpecTypeInfoValuesCmpFieldCallback gi'funptrptr gi'cb pspec value1 value2 = do
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    value1' <- B.GValue.newGValueFromPtr value1
    value2' <- B.GValue.newGValueFromPtr value2
    result <- gi'cb  pspec' value1' value2'
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback ParamSpecTypeInfoValueValidateFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParamSpecTypeInfoValueValidateFieldCallback =
    Ptr GParamSpec ->
    Ptr GValue ->
    IO CInt

-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParamSpecTypeInfoValueValidateFieldCallback :: FunPtr C_ParamSpecTypeInfoValueValidateFieldCallback -> C_ParamSpecTypeInfoValueValidateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParamSpecTypeInfoValueValidateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParamSpecTypeInfoValueValidateFieldCallback
    -> GParamSpec
    -> GValue
    -> m Bool
dynamic_ParamSpecTypeInfoValueValidateFieldCallback __funPtr pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    result <- (__dynamic_C_ParamSpecTypeInfoValueValidateFieldCallback __funPtr) pspec' value'
    let result' = (/= 0) result
    touchManagedPtr pspec
    touchManagedPtr value
    return result'

-- | Generate a function pointer callable from C code, from a `C_ParamSpecTypeInfoValueValidateFieldCallback`.
foreign import ccall "wrapper"
    mk_ParamSpecTypeInfoValueValidateFieldCallback :: C_ParamSpecTypeInfoValueValidateFieldCallback -> IO (FunPtr C_ParamSpecTypeInfoValueValidateFieldCallback)

-- | /No description available in the introspection data./
type ParamSpecTypeInfoValueValidateFieldCallback =
    GParamSpec
    -> GValue
    -> IO Bool

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParamSpecTypeInfoValueValidateFieldCallback`@.
noParamSpecTypeInfoValueValidateFieldCallback :: Maybe ParamSpecTypeInfoValueValidateFieldCallback
noParamSpecTypeInfoValueValidateFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ParamSpecTypeInfoValueValidateFieldCallback :: MonadIO m => ParamSpecTypeInfoValueValidateFieldCallback -> m (GClosure C_ParamSpecTypeInfoValueValidateFieldCallback)
genClosure_ParamSpecTypeInfoValueValidateFieldCallback cb = liftIO $ do
    let cb' = wrap_ParamSpecTypeInfoValueValidateFieldCallback Nothing cb
    mk_ParamSpecTypeInfoValueValidateFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ParamSpecTypeInfoValueValidateFieldCallback` into a `C_ParamSpecTypeInfoValueValidateFieldCallback`.
wrap_ParamSpecTypeInfoValueValidateFieldCallback :: 
    Maybe (Ptr (FunPtr C_ParamSpecTypeInfoValueValidateFieldCallback)) ->
    ParamSpecTypeInfoValueValidateFieldCallback ->
    C_ParamSpecTypeInfoValueValidateFieldCallback
wrap_ParamSpecTypeInfoValueValidateFieldCallback gi'funptrptr gi'cb pspec value = do
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    value' <- B.GValue.newGValueFromPtr value
    result <- gi'cb  pspec' value'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ParamSpecTypeInfoValueSetDefaultFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParamSpecTypeInfoValueSetDefaultFieldCallback =
    Ptr GParamSpec ->
    Ptr GValue ->
    IO ()

-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParamSpecTypeInfoValueSetDefaultFieldCallback :: FunPtr C_ParamSpecTypeInfoValueSetDefaultFieldCallback -> C_ParamSpecTypeInfoValueSetDefaultFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParamSpecTypeInfoValueSetDefaultFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParamSpecTypeInfoValueSetDefaultFieldCallback
    -> GParamSpec
    -> GValue
    -> m ()
dynamic_ParamSpecTypeInfoValueSetDefaultFieldCallback __funPtr pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    (__dynamic_C_ParamSpecTypeInfoValueSetDefaultFieldCallback __funPtr) pspec' value'
    touchManagedPtr pspec
    touchManagedPtr value
    return ()

-- | Generate a function pointer callable from C code, from a `C_ParamSpecTypeInfoValueSetDefaultFieldCallback`.
foreign import ccall "wrapper"
    mk_ParamSpecTypeInfoValueSetDefaultFieldCallback :: C_ParamSpecTypeInfoValueSetDefaultFieldCallback -> IO (FunPtr C_ParamSpecTypeInfoValueSetDefaultFieldCallback)

-- | /No description available in the introspection data./
type ParamSpecTypeInfoValueSetDefaultFieldCallback =
    GParamSpec
    -> GValue
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParamSpecTypeInfoValueSetDefaultFieldCallback`@.
noParamSpecTypeInfoValueSetDefaultFieldCallback :: Maybe ParamSpecTypeInfoValueSetDefaultFieldCallback
noParamSpecTypeInfoValueSetDefaultFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ParamSpecTypeInfoValueSetDefaultFieldCallback :: MonadIO m => ParamSpecTypeInfoValueSetDefaultFieldCallback -> m (GClosure C_ParamSpecTypeInfoValueSetDefaultFieldCallback)
genClosure_ParamSpecTypeInfoValueSetDefaultFieldCallback cb = liftIO $ do
    let cb' = wrap_ParamSpecTypeInfoValueSetDefaultFieldCallback Nothing cb
    mk_ParamSpecTypeInfoValueSetDefaultFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ParamSpecTypeInfoValueSetDefaultFieldCallback` into a `C_ParamSpecTypeInfoValueSetDefaultFieldCallback`.
wrap_ParamSpecTypeInfoValueSetDefaultFieldCallback :: 
    Maybe (Ptr (FunPtr C_ParamSpecTypeInfoValueSetDefaultFieldCallback)) ->
    ParamSpecTypeInfoValueSetDefaultFieldCallback ->
    C_ParamSpecTypeInfoValueSetDefaultFieldCallback
wrap_ParamSpecTypeInfoValueSetDefaultFieldCallback gi'funptrptr gi'cb pspec value = do
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    value' <- B.GValue.newGValueFromPtr value
    gi'cb  pspec' value'
    maybeReleaseFunPtr gi'funptrptr


-- callback ParamSpecTypeInfoInstanceInitFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParamSpecTypeInfoInstanceInitFieldCallback =
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParamSpecTypeInfoInstanceInitFieldCallback :: FunPtr C_ParamSpecTypeInfoInstanceInitFieldCallback -> C_ParamSpecTypeInfoInstanceInitFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParamSpecTypeInfoInstanceInitFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParamSpecTypeInfoInstanceInitFieldCallback
    -> GParamSpec
    -> m ()
dynamic_ParamSpecTypeInfoInstanceInitFieldCallback __funPtr pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ParamSpecTypeInfoInstanceInitFieldCallback __funPtr) pspec'
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ParamSpecTypeInfoInstanceInitFieldCallback`.
foreign import ccall "wrapper"
    mk_ParamSpecTypeInfoInstanceInitFieldCallback :: C_ParamSpecTypeInfoInstanceInitFieldCallback -> IO (FunPtr C_ParamSpecTypeInfoInstanceInitFieldCallback)

-- | /No description available in the introspection data./
type ParamSpecTypeInfoInstanceInitFieldCallback =
    GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParamSpecTypeInfoInstanceInitFieldCallback`@.
noParamSpecTypeInfoInstanceInitFieldCallback :: Maybe ParamSpecTypeInfoInstanceInitFieldCallback
noParamSpecTypeInfoInstanceInitFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ParamSpecTypeInfoInstanceInitFieldCallback :: MonadIO m => ParamSpecTypeInfoInstanceInitFieldCallback -> m (GClosure C_ParamSpecTypeInfoInstanceInitFieldCallback)
genClosure_ParamSpecTypeInfoInstanceInitFieldCallback cb = liftIO $ do
    let cb' = wrap_ParamSpecTypeInfoInstanceInitFieldCallback Nothing cb
    mk_ParamSpecTypeInfoInstanceInitFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ParamSpecTypeInfoInstanceInitFieldCallback` into a `C_ParamSpecTypeInfoInstanceInitFieldCallback`.
wrap_ParamSpecTypeInfoInstanceInitFieldCallback :: 
    Maybe (Ptr (FunPtr C_ParamSpecTypeInfoInstanceInitFieldCallback)) ->
    ParamSpecTypeInfoInstanceInitFieldCallback ->
    C_ParamSpecTypeInfoInstanceInitFieldCallback
wrap_ParamSpecTypeInfoInstanceInitFieldCallback gi'funptrptr gi'cb pspec = do
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ParamSpecTypeInfoFinalizeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParamSpecTypeInfoFinalizeFieldCallback =
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParamSpecTypeInfoFinalizeFieldCallback :: FunPtr C_ParamSpecTypeInfoFinalizeFieldCallback -> C_ParamSpecTypeInfoFinalizeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParamSpecTypeInfoFinalizeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParamSpecTypeInfoFinalizeFieldCallback
    -> GParamSpec
    -> m ()
dynamic_ParamSpecTypeInfoFinalizeFieldCallback __funPtr pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ParamSpecTypeInfoFinalizeFieldCallback __funPtr) pspec'
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ParamSpecTypeInfoFinalizeFieldCallback`.
foreign import ccall "wrapper"
    mk_ParamSpecTypeInfoFinalizeFieldCallback :: C_ParamSpecTypeInfoFinalizeFieldCallback -> IO (FunPtr C_ParamSpecTypeInfoFinalizeFieldCallback)

-- | /No description available in the introspection data./
type ParamSpecTypeInfoFinalizeFieldCallback =
    GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParamSpecTypeInfoFinalizeFieldCallback`@.
noParamSpecTypeInfoFinalizeFieldCallback :: Maybe ParamSpecTypeInfoFinalizeFieldCallback
noParamSpecTypeInfoFinalizeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ParamSpecTypeInfoFinalizeFieldCallback :: MonadIO m => ParamSpecTypeInfoFinalizeFieldCallback -> m (GClosure C_ParamSpecTypeInfoFinalizeFieldCallback)
genClosure_ParamSpecTypeInfoFinalizeFieldCallback cb = liftIO $ do
    let cb' = wrap_ParamSpecTypeInfoFinalizeFieldCallback Nothing cb
    mk_ParamSpecTypeInfoFinalizeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ParamSpecTypeInfoFinalizeFieldCallback` into a `C_ParamSpecTypeInfoFinalizeFieldCallback`.
wrap_ParamSpecTypeInfoFinalizeFieldCallback :: 
    Maybe (Ptr (FunPtr C_ParamSpecTypeInfoFinalizeFieldCallback)) ->
    ParamSpecTypeInfoFinalizeFieldCallback ->
    C_ParamSpecTypeInfoFinalizeFieldCallback
wrap_ParamSpecTypeInfoFinalizeFieldCallback gi'funptrptr gi'cb pspec = do
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectSetPropertyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the numeric id under which the property was registered with\n g_object_class_install_property()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the new value for the property"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GParamSpec describing the property"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "The type of the @set_property function of #GObjectClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectSetPropertyFunc =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the numeric id under which the property was registered with\n g_object_class_install_property()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GParamSpec describing the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectSetPropertyFunc :: FunPtr C_ObjectSetPropertyFunc -> C_ObjectSetPropertyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectSetPropertyFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectSetPropertyFunc
    -> a
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> Word32
    -- ^ /@propertyId@/: the numeric id under which the property was registered with
    --  'GI.GObject.Structs.ObjectClass.objectClassInstallProperty'.
    -> GValue
    -- ^ /@value@/: the new value for the property
    -> GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' describing the property
    -> m ()
dynamic_ObjectSetPropertyFunc __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ObjectSetPropertyFunc __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectSetPropertyFunc`.
foreign import ccall "wrapper"
    mk_ObjectSetPropertyFunc :: C_ObjectSetPropertyFunc -> IO (FunPtr C_ObjectSetPropertyFunc)

-- | The type of the /@setProperty@/ function of t'GI.GObject.Structs.ObjectClass.ObjectClass'.
type ObjectSetPropertyFunc =
    GObject.Object.Object
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> Word32
    -- ^ /@propertyId@/: the numeric id under which the property was registered with
    --  'GI.GObject.Structs.ObjectClass.objectClassInstallProperty'.
    -> GValue
    -- ^ /@value@/: the new value for the property
    -> GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' describing the property
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectSetPropertyFunc`@.
noObjectSetPropertyFunc :: Maybe ObjectSetPropertyFunc
noObjectSetPropertyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectSetPropertyFunc :: MonadIO m => ObjectSetPropertyFunc -> m (GClosure C_ObjectSetPropertyFunc)
genClosure_ObjectSetPropertyFunc cb = liftIO $ do
    let cb' = wrap_ObjectSetPropertyFunc Nothing cb
    mk_ObjectSetPropertyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectSetPropertyFunc` into a `C_ObjectSetPropertyFunc`.
wrap_ObjectSetPropertyFunc :: 
    Maybe (Ptr (FunPtr C_ObjectSetPropertyFunc)) ->
    ObjectSetPropertyFunc ->
    C_ObjectSetPropertyFunc
wrap_ObjectSetPropertyFunc gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectGetPropertyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the numeric id under which the property was registered with\n g_object_class_install_property()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GValue to return the property value in"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GParamSpec describing the property"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "The type of the @get_property function of #GObjectClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectGetPropertyFunc =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the numeric id under which the property was registered with\n g_object_class_install_property()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue to return the property value in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GParamSpec describing the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectGetPropertyFunc :: FunPtr C_ObjectGetPropertyFunc -> C_ObjectGetPropertyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectGetPropertyFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectGetPropertyFunc
    -> a
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> Word32
    -- ^ /@propertyId@/: the numeric id under which the property was registered with
    --  'GI.GObject.Structs.ObjectClass.objectClassInstallProperty'.
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' to return the property value in
    -> GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' describing the property
    -> m ()
dynamic_ObjectGetPropertyFunc __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ObjectGetPropertyFunc __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectGetPropertyFunc`.
foreign import ccall "wrapper"
    mk_ObjectGetPropertyFunc :: C_ObjectGetPropertyFunc -> IO (FunPtr C_ObjectGetPropertyFunc)

-- | The type of the /@getProperty@/ function of t'GI.GObject.Structs.ObjectClass.ObjectClass'.
type ObjectGetPropertyFunc =
    GObject.Object.Object
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> Word32
    -- ^ /@propertyId@/: the numeric id under which the property was registered with
    --  'GI.GObject.Structs.ObjectClass.objectClassInstallProperty'.
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' to return the property value in
    -> GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' describing the property
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectGetPropertyFunc`@.
noObjectGetPropertyFunc :: Maybe ObjectGetPropertyFunc
noObjectGetPropertyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectGetPropertyFunc :: MonadIO m => ObjectGetPropertyFunc -> m (GClosure C_ObjectGetPropertyFunc)
genClosure_ObjectGetPropertyFunc cb = liftIO $ do
    let cb' = wrap_ObjectGetPropertyFunc Nothing cb
    mk_ObjectGetPropertyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectGetPropertyFunc` into a `C_ObjectGetPropertyFunc`.
wrap_ObjectGetPropertyFunc :: 
    Maybe (Ptr (FunPtr C_ObjectGetPropertyFunc)) ->
    ObjectGetPropertyFunc ->
    C_ObjectGetPropertyFunc
wrap_ObjectGetPropertyFunc gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GObject being finalized"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "The type of the @finalize function of #GObjectClass."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectFinalizeFunc =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GObject being finalized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectFinalizeFunc :: FunPtr C_ObjectFinalizeFunc -> C_ObjectFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectFinalizeFunc
    -> a
    -- ^ /@object@/: the t'GI.GObject.Objects.Object.Object' being finalized
    -> m ()
dynamic_ObjectFinalizeFunc __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_ObjectFinalizeFunc __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectFinalizeFunc`.
foreign import ccall "wrapper"
    mk_ObjectFinalizeFunc :: C_ObjectFinalizeFunc -> IO (FunPtr C_ObjectFinalizeFunc)

-- | The type of the /@finalize@/ function of t'GI.GObject.Structs.ObjectClass.ObjectClass'.
type ObjectFinalizeFunc =
    GObject.Object.Object
    -- ^ /@object@/: the t'GI.GObject.Objects.Object.Object' being finalized
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectFinalizeFunc`@.
noObjectFinalizeFunc :: Maybe ObjectFinalizeFunc
noObjectFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectFinalizeFunc :: MonadIO m => ObjectFinalizeFunc -> m (GClosure C_ObjectFinalizeFunc)
genClosure_ObjectFinalizeFunc cb = liftIO $ do
    let cb' = wrap_ObjectFinalizeFunc Nothing cb
    mk_ObjectFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectFinalizeFunc` into a `C_ObjectFinalizeFunc`.
wrap_ObjectFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_ObjectFinalizeFunc)) ->
    ObjectFinalizeFunc ->
    C_ObjectFinalizeFunc
wrap_ObjectFinalizeFunc gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassSetPropertyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassSetPropertyFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassSetPropertyFieldCallback :: FunPtr C_ObjectClassSetPropertyFieldCallback -> C_ObjectClassSetPropertyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassSetPropertyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassSetPropertyFieldCallback
    -> a
    -> Word32
    -> GValue
    -> GParamSpec
    -> m ()
dynamic_ObjectClassSetPropertyFieldCallback __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ObjectClassSetPropertyFieldCallback __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassSetPropertyFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassSetPropertyFieldCallback :: C_ObjectClassSetPropertyFieldCallback -> IO (FunPtr C_ObjectClassSetPropertyFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassSetPropertyFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GValue
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassSetPropertyFieldCallback`@.
noObjectClassSetPropertyFieldCallback :: Maybe ObjectClassSetPropertyFieldCallback
noObjectClassSetPropertyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassSetPropertyFieldCallback :: MonadIO m => ObjectClassSetPropertyFieldCallback -> m (GClosure C_ObjectClassSetPropertyFieldCallback)
genClosure_ObjectClassSetPropertyFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassSetPropertyFieldCallback Nothing cb
    mk_ObjectClassSetPropertyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassSetPropertyFieldCallback` into a `C_ObjectClassSetPropertyFieldCallback`.
wrap_ObjectClassSetPropertyFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassSetPropertyFieldCallback)) ->
    ObjectClassSetPropertyFieldCallback ->
    C_ObjectClassSetPropertyFieldCallback
wrap_ObjectClassSetPropertyFieldCallback gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassNotifyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassNotifyFieldCallback =
    Ptr GObject.Object.Object ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassNotifyFieldCallback :: FunPtr C_ObjectClassNotifyFieldCallback -> C_ObjectClassNotifyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassNotifyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassNotifyFieldCallback
    -> a
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> GParamSpec
    -> m ()
dynamic_ObjectClassNotifyFieldCallback __funPtr object pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ObjectClassNotifyFieldCallback __funPtr) object' pspec'
    touchManagedPtr object
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassNotifyFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassNotifyFieldCallback :: C_ObjectClassNotifyFieldCallback -> IO (FunPtr C_ObjectClassNotifyFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassNotifyFieldCallback =
    GObject.Object.Object
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassNotifyFieldCallback`@.
noObjectClassNotifyFieldCallback :: Maybe ObjectClassNotifyFieldCallback
noObjectClassNotifyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassNotifyFieldCallback :: MonadIO m => ObjectClassNotifyFieldCallback -> m (GClosure C_ObjectClassNotifyFieldCallback)
genClosure_ObjectClassNotifyFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassNotifyFieldCallback Nothing cb
    mk_ObjectClassNotifyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassNotifyFieldCallback` into a `C_ObjectClassNotifyFieldCallback`.
wrap_ObjectClassNotifyFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassNotifyFieldCallback)) ->
    ObjectClassNotifyFieldCallback ->
    C_ObjectClassNotifyFieldCallback
wrap_ObjectClassNotifyFieldCallback gi'funptrptr gi'cb object pspec = do
    object' <- (newObject GObject.Object.Object) object
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassGetPropertyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassGetPropertyFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassGetPropertyFieldCallback :: FunPtr C_ObjectClassGetPropertyFieldCallback -> C_ObjectClassGetPropertyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassGetPropertyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassGetPropertyFieldCallback
    -> a
    -> Word32
    -> GValue
    -> GParamSpec
    -> m ()
dynamic_ObjectClassGetPropertyFieldCallback __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_ObjectClassGetPropertyFieldCallback __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassGetPropertyFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassGetPropertyFieldCallback :: C_ObjectClassGetPropertyFieldCallback -> IO (FunPtr C_ObjectClassGetPropertyFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassGetPropertyFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GValue
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassGetPropertyFieldCallback`@.
noObjectClassGetPropertyFieldCallback :: Maybe ObjectClassGetPropertyFieldCallback
noObjectClassGetPropertyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassGetPropertyFieldCallback :: MonadIO m => ObjectClassGetPropertyFieldCallback -> m (GClosure C_ObjectClassGetPropertyFieldCallback)
genClosure_ObjectClassGetPropertyFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassGetPropertyFieldCallback Nothing cb
    mk_ObjectClassGetPropertyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassGetPropertyFieldCallback` into a `C_ObjectClassGetPropertyFieldCallback`.
wrap_ObjectClassGetPropertyFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassGetPropertyFieldCallback)) ->
    ObjectClassGetPropertyFieldCallback ->
    C_ObjectClassGetPropertyFieldCallback
wrap_ObjectClassGetPropertyFieldCallback gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassFinalizeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassFinalizeFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassFinalizeFieldCallback :: FunPtr C_ObjectClassFinalizeFieldCallback -> C_ObjectClassFinalizeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassFinalizeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassFinalizeFieldCallback
    -> a
    -> m ()
dynamic_ObjectClassFinalizeFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_ObjectClassFinalizeFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassFinalizeFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassFinalizeFieldCallback :: C_ObjectClassFinalizeFieldCallback -> IO (FunPtr C_ObjectClassFinalizeFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassFinalizeFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassFinalizeFieldCallback`@.
noObjectClassFinalizeFieldCallback :: Maybe ObjectClassFinalizeFieldCallback
noObjectClassFinalizeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassFinalizeFieldCallback :: MonadIO m => ObjectClassFinalizeFieldCallback -> m (GClosure C_ObjectClassFinalizeFieldCallback)
genClosure_ObjectClassFinalizeFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassFinalizeFieldCallback Nothing cb
    mk_ObjectClassFinalizeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassFinalizeFieldCallback` into a `C_ObjectClassFinalizeFieldCallback`.
wrap_ObjectClassFinalizeFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassFinalizeFieldCallback)) ->
    ObjectClassFinalizeFieldCallback ->
    C_ObjectClassFinalizeFieldCallback
wrap_ObjectClassFinalizeFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassDisposeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassDisposeFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassDisposeFieldCallback :: FunPtr C_ObjectClassDisposeFieldCallback -> C_ObjectClassDisposeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassDisposeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassDisposeFieldCallback
    -> a
    -> m ()
dynamic_ObjectClassDisposeFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_ObjectClassDisposeFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassDisposeFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassDisposeFieldCallback :: C_ObjectClassDisposeFieldCallback -> IO (FunPtr C_ObjectClassDisposeFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassDisposeFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassDisposeFieldCallback`@.
noObjectClassDisposeFieldCallback :: Maybe ObjectClassDisposeFieldCallback
noObjectClassDisposeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassDisposeFieldCallback :: MonadIO m => ObjectClassDisposeFieldCallback -> m (GClosure C_ObjectClassDisposeFieldCallback)
genClosure_ObjectClassDisposeFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassDisposeFieldCallback Nothing cb
    mk_ObjectClassDisposeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassDisposeFieldCallback` into a `C_ObjectClassDisposeFieldCallback`.
wrap_ObjectClassDisposeFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassDisposeFieldCallback)) ->
    ObjectClassDisposeFieldCallback ->
    C_ObjectClassDisposeFieldCallback
wrap_ObjectClassDisposeFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassDispatchPropertiesChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_pspecs"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspecs"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassDispatchPropertiesChangedFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_pspecs"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspecs"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassDispatchPropertiesChangedFieldCallback :: FunPtr C_ObjectClassDispatchPropertiesChangedFieldCallback -> C_ObjectClassDispatchPropertiesChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassDispatchPropertiesChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassDispatchPropertiesChangedFieldCallback
    -> a
    -> Word32
    -> GParamSpec
    -> m ()
dynamic_ObjectClassDispatchPropertiesChangedFieldCallback __funPtr object nPspecs pspecs = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    pspecs' <- unsafeManagedPtrGetPtr pspecs
    (__dynamic_C_ObjectClassDispatchPropertiesChangedFieldCallback __funPtr) object' nPspecs pspecs'
    touchManagedPtr object
    touchManagedPtr pspecs
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassDispatchPropertiesChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassDispatchPropertiesChangedFieldCallback :: C_ObjectClassDispatchPropertiesChangedFieldCallback -> IO (FunPtr C_ObjectClassDispatchPropertiesChangedFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassDispatchPropertiesChangedFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassDispatchPropertiesChangedFieldCallback`@.
noObjectClassDispatchPropertiesChangedFieldCallback :: Maybe ObjectClassDispatchPropertiesChangedFieldCallback
noObjectClassDispatchPropertiesChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassDispatchPropertiesChangedFieldCallback :: MonadIO m => ObjectClassDispatchPropertiesChangedFieldCallback -> m (GClosure C_ObjectClassDispatchPropertiesChangedFieldCallback)
genClosure_ObjectClassDispatchPropertiesChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassDispatchPropertiesChangedFieldCallback Nothing cb
    mk_ObjectClassDispatchPropertiesChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassDispatchPropertiesChangedFieldCallback` into a `C_ObjectClassDispatchPropertiesChangedFieldCallback`.
wrap_ObjectClassDispatchPropertiesChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassDispatchPropertiesChangedFieldCallback)) ->
    ObjectClassDispatchPropertiesChangedFieldCallback ->
    C_ObjectClassDispatchPropertiesChangedFieldCallback
wrap_ObjectClassDispatchPropertiesChangedFieldCallback gi'funptrptr gi'cb object nPspecs pspecs = do
    object' <- (newObject GObject.Object.Object) object
    pspecs' <- B.GParamSpec.newGParamSpecFromPtr pspecs
    gi'cb  object' nPspecs pspecs'
    maybeReleaseFunPtr gi'funptrptr


-- callback ObjectClassConstructedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ObjectClassConstructedFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ObjectClassConstructedFieldCallback :: FunPtr C_ObjectClassConstructedFieldCallback -> C_ObjectClassConstructedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ObjectClassConstructedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ObjectClassConstructedFieldCallback
    -> a
    -> m ()
dynamic_ObjectClassConstructedFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_ObjectClassConstructedFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_ObjectClassConstructedFieldCallback`.
foreign import ccall "wrapper"
    mk_ObjectClassConstructedFieldCallback :: C_ObjectClassConstructedFieldCallback -> IO (FunPtr C_ObjectClassConstructedFieldCallback)

-- | /No description available in the introspection data./
type ObjectClassConstructedFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ObjectClassConstructedFieldCallback`@.
noObjectClassConstructedFieldCallback :: Maybe ObjectClassConstructedFieldCallback
noObjectClassConstructedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ObjectClassConstructedFieldCallback :: MonadIO m => ObjectClassConstructedFieldCallback -> m (GClosure C_ObjectClassConstructedFieldCallback)
genClosure_ObjectClassConstructedFieldCallback cb = liftIO $ do
    let cb' = wrap_ObjectClassConstructedFieldCallback Nothing cb
    mk_ObjectClassConstructedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ObjectClassConstructedFieldCallback` into a `C_ObjectClassConstructedFieldCallback`.
wrap_ObjectClassConstructedFieldCallback :: 
    Maybe (Ptr (FunPtr C_ObjectClassConstructedFieldCallback)) ->
    ObjectClassConstructedFieldCallback ->
    C_ObjectClassConstructedFieldCallback
wrap_ObjectClassConstructedFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback InterfaceInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_iface"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeInterface" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The interface structure to initialize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iface_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @interface_data supplied via the #GInterfaceInfo structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to initialize a new\ninterface.\n\nThis function should initialize all internal data and* allocate any\nresources required by the interface.\n\nThe members of @iface_data are guaranteed to have been filled with\nzeros before this function is called."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InterfaceInitFunc =
    Ptr GObject.TypeInterface.TypeInterface ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_iface"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The interface structure to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iface_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @interface_data supplied via the #GInterfaceInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InterfaceInitFunc :: FunPtr C_InterfaceInitFunc -> C_InterfaceInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InterfaceInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_InterfaceInitFunc
    -> GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: The interface structure to initialize
    -> Ptr ()
    -- ^ /@ifaceData@/: The /@interfaceData@/ supplied via the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure
    -> m ()
dynamic_InterfaceInitFunc __funPtr gIface ifaceData = liftIO $ do
    gIface' <- unsafeManagedPtrGetPtr gIface
    (__dynamic_C_InterfaceInitFunc __funPtr) gIface' ifaceData
    touchManagedPtr gIface
    return ()

-- | Generate a function pointer callable from C code, from a `C_InterfaceInitFunc`.
foreign import ccall "wrapper"
    mk_InterfaceInitFunc :: C_InterfaceInitFunc -> IO (FunPtr C_InterfaceInitFunc)

-- | A callback function used by the type system to initialize a new
-- interface.
-- 
-- This function should initialize all internal data and* allocate any
-- resources required by the interface.
-- 
-- The members of /@ifaceData@/ are guaranteed to have been filled with
-- zeros before this function is called.
type InterfaceInitFunc =
    GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: The interface structure to initialize
    -> Ptr ()
    -- ^ /@ifaceData@/: The /@interfaceData@/ supplied via the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InterfaceInitFunc`@.
noInterfaceInitFunc :: Maybe InterfaceInitFunc
noInterfaceInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InterfaceInitFunc :: MonadIO m => InterfaceInitFunc -> m (GClosure C_InterfaceInitFunc)
genClosure_InterfaceInitFunc cb = liftIO $ do
    let cb' = wrap_InterfaceInitFunc Nothing cb
    mk_InterfaceInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `InterfaceInitFunc` into a `C_InterfaceInitFunc`.
wrap_InterfaceInitFunc :: 
    Maybe (Ptr (FunPtr C_InterfaceInitFunc)) ->
    InterfaceInitFunc ->
    C_InterfaceInitFunc
wrap_InterfaceInitFunc gi'funptrptr gi'cb gIface ifaceData = do
    gIface' <- (newPtr GObject.TypeInterface.TypeInterface) gIface
    gi'cb  gIface' ifaceData
    maybeReleaseFunPtr gi'funptrptr


-- callback InterfaceFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_iface"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeInterface" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The interface structure to finalize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iface_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @interface_data supplied via the #GInterfaceInfo structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to finalize an interface.\n\nThis function should destroy any internal data and release any resources\nallocated by the corresponding GInterfaceInitFunc() function."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InterfaceFinalizeFunc =
    Ptr GObject.TypeInterface.TypeInterface ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_iface"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The interface structure to finalize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iface_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @interface_data supplied via the #GInterfaceInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InterfaceFinalizeFunc :: FunPtr C_InterfaceFinalizeFunc -> C_InterfaceFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InterfaceFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_InterfaceFinalizeFunc
    -> GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: The interface structure to finalize
    -> Ptr ()
    -- ^ /@ifaceData@/: The /@interfaceData@/ supplied via the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure
    -> m ()
dynamic_InterfaceFinalizeFunc __funPtr gIface ifaceData = liftIO $ do
    gIface' <- unsafeManagedPtrGetPtr gIface
    (__dynamic_C_InterfaceFinalizeFunc __funPtr) gIface' ifaceData
    touchManagedPtr gIface
    return ()

-- | Generate a function pointer callable from C code, from a `C_InterfaceFinalizeFunc`.
foreign import ccall "wrapper"
    mk_InterfaceFinalizeFunc :: C_InterfaceFinalizeFunc -> IO (FunPtr C_InterfaceFinalizeFunc)

-- | A callback function used by the type system to finalize an interface.
-- 
-- This function should destroy any internal data and release any resources
-- allocated by the corresponding @/GInterfaceInitFunc()/@ function.
type InterfaceFinalizeFunc =
    GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: The interface structure to finalize
    -> Ptr ()
    -- ^ /@ifaceData@/: The /@interfaceData@/ supplied via the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InterfaceFinalizeFunc`@.
noInterfaceFinalizeFunc :: Maybe InterfaceFinalizeFunc
noInterfaceFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InterfaceFinalizeFunc :: MonadIO m => InterfaceFinalizeFunc -> m (GClosure C_InterfaceFinalizeFunc)
genClosure_InterfaceFinalizeFunc cb = liftIO $ do
    let cb' = wrap_InterfaceFinalizeFunc Nothing cb
    mk_InterfaceFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `InterfaceFinalizeFunc` into a `C_InterfaceFinalizeFunc`.
wrap_InterfaceFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_InterfaceFinalizeFunc)) ->
    InterfaceFinalizeFunc ->
    C_InterfaceFinalizeFunc
wrap_InterfaceFinalizeFunc gi'funptrptr gi'cb gIface ifaceData = do
    gIface' <- (newPtr GObject.TypeInterface.TypeInterface) gIface
    gi'cb  gIface' ifaceData
    maybeReleaseFunPtr gi'funptrptr


-- callback InstanceInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "instance"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeInstance" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The instance to initialize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The class of the type the instance is\n   created for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to initialize a new\ninstance of a type.\n\nThis function initializes all instance members and allocates any resources\nrequired by it.\n\nInitialization of a derived instance involves calling all its parent\ntypes instance initializers, so the class member of the instance\nis altered during its initialization to always point to the class that\nbelongs to the type the current initializer was introduced for.\n\nThe extended members of @instance are guaranteed to have been filled with\nzeros before this function is called."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InstanceInitFunc =
    Ptr GObject.TypeInstance.TypeInstance ->
    Ptr GObject.TypeClass.TypeClass ->
    IO ()

-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The instance to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The class of the type the instance is\n   created for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InstanceInitFunc :: FunPtr C_InstanceInitFunc -> C_InstanceInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InstanceInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_InstanceInitFunc
    -> GObject.TypeInstance.TypeInstance
    -- ^ /@instance@/: The instance to initialize
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The class of the type the instance is
    --    created for
    -> m ()
dynamic_InstanceInitFunc __funPtr instance_ gClass = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    gClass' <- unsafeManagedPtrGetPtr gClass
    (__dynamic_C_InstanceInitFunc __funPtr) instance_' gClass'
    touchManagedPtr instance_
    touchManagedPtr gClass
    return ()

-- | Generate a function pointer callable from C code, from a `C_InstanceInitFunc`.
foreign import ccall "wrapper"
    mk_InstanceInitFunc :: C_InstanceInitFunc -> IO (FunPtr C_InstanceInitFunc)

-- | A callback function used by the type system to initialize a new
-- instance of a type.
-- 
-- This function initializes all instance members and allocates any resources
-- required by it.
-- 
-- Initialization of a derived instance involves calling all its parent
-- types instance initializers, so the class member of the instance
-- is altered during its initialization to always point to the class that
-- belongs to the type the current initializer was introduced for.
-- 
-- The extended members of /@instance@/ are guaranteed to have been filled with
-- zeros before this function is called.
type InstanceInitFunc =
    GObject.TypeInstance.TypeInstance
    -- ^ /@instance@/: The instance to initialize
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The class of the type the instance is
    --    created for
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InstanceInitFunc`@.
noInstanceInitFunc :: Maybe InstanceInitFunc
noInstanceInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InstanceInitFunc :: MonadIO m => InstanceInitFunc -> m (GClosure C_InstanceInitFunc)
genClosure_InstanceInitFunc cb = liftIO $ do
    let cb' = wrap_InstanceInitFunc Nothing cb
    mk_InstanceInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `InstanceInitFunc` into a `C_InstanceInitFunc`.
wrap_InstanceInitFunc :: 
    Maybe (Ptr (FunPtr C_InstanceInitFunc)) ->
    InstanceInitFunc ->
    C_InstanceInitFunc
wrap_InstanceInitFunc gi'funptrptr gi'cb instance_ gClass = do
    instance_' <- (newPtr GObject.TypeInstance.TypeInstance) instance_
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    gi'cb  instance_' gClass'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassSetPropertyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassSetPropertyFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassSetPropertyFieldCallback :: FunPtr C_InitiallyUnownedClassSetPropertyFieldCallback -> C_InitiallyUnownedClassSetPropertyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassSetPropertyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassSetPropertyFieldCallback
    -> a
    -> Word32
    -> GValue
    -> GParamSpec
    -> m ()
dynamic_InitiallyUnownedClassSetPropertyFieldCallback __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_InitiallyUnownedClassSetPropertyFieldCallback __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassSetPropertyFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassSetPropertyFieldCallback :: C_InitiallyUnownedClassSetPropertyFieldCallback -> IO (FunPtr C_InitiallyUnownedClassSetPropertyFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassSetPropertyFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GValue
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassSetPropertyFieldCallback`@.
noInitiallyUnownedClassSetPropertyFieldCallback :: Maybe InitiallyUnownedClassSetPropertyFieldCallback
noInitiallyUnownedClassSetPropertyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassSetPropertyFieldCallback :: MonadIO m => InitiallyUnownedClassSetPropertyFieldCallback -> m (GClosure C_InitiallyUnownedClassSetPropertyFieldCallback)
genClosure_InitiallyUnownedClassSetPropertyFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassSetPropertyFieldCallback Nothing cb
    mk_InitiallyUnownedClassSetPropertyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassSetPropertyFieldCallback` into a `C_InitiallyUnownedClassSetPropertyFieldCallback`.
wrap_InitiallyUnownedClassSetPropertyFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassSetPropertyFieldCallback)) ->
    InitiallyUnownedClassSetPropertyFieldCallback ->
    C_InitiallyUnownedClassSetPropertyFieldCallback
wrap_InitiallyUnownedClassSetPropertyFieldCallback gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassNotifyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassNotifyFieldCallback =
    Ptr GObject.Object.Object ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassNotifyFieldCallback :: FunPtr C_InitiallyUnownedClassNotifyFieldCallback -> C_InitiallyUnownedClassNotifyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassNotifyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassNotifyFieldCallback
    -> a
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> GParamSpec
    -> m ()
dynamic_InitiallyUnownedClassNotifyFieldCallback __funPtr object pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_InitiallyUnownedClassNotifyFieldCallback __funPtr) object' pspec'
    touchManagedPtr object
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassNotifyFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassNotifyFieldCallback :: C_InitiallyUnownedClassNotifyFieldCallback -> IO (FunPtr C_InitiallyUnownedClassNotifyFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassNotifyFieldCallback =
    GObject.Object.Object
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassNotifyFieldCallback`@.
noInitiallyUnownedClassNotifyFieldCallback :: Maybe InitiallyUnownedClassNotifyFieldCallback
noInitiallyUnownedClassNotifyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassNotifyFieldCallback :: MonadIO m => InitiallyUnownedClassNotifyFieldCallback -> m (GClosure C_InitiallyUnownedClassNotifyFieldCallback)
genClosure_InitiallyUnownedClassNotifyFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassNotifyFieldCallback Nothing cb
    mk_InitiallyUnownedClassNotifyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassNotifyFieldCallback` into a `C_InitiallyUnownedClassNotifyFieldCallback`.
wrap_InitiallyUnownedClassNotifyFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassNotifyFieldCallback)) ->
    InitiallyUnownedClassNotifyFieldCallback ->
    C_InitiallyUnownedClassNotifyFieldCallback
wrap_InitiallyUnownedClassNotifyFieldCallback gi'funptrptr gi'cb object pspec = do
    object' <- (newObject GObject.Object.Object) object
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassGetPropertyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspec"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassGetPropertyFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GValue ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassGetPropertyFieldCallback :: FunPtr C_InitiallyUnownedClassGetPropertyFieldCallback -> C_InitiallyUnownedClassGetPropertyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassGetPropertyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassGetPropertyFieldCallback
    -> a
    -> Word32
    -> GValue
    -> GParamSpec
    -> m ()
dynamic_InitiallyUnownedClassGetPropertyFieldCallback __funPtr object propertyId value pspec = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    value' <- unsafeManagedPtrGetPtr value
    pspec' <- unsafeManagedPtrGetPtr pspec
    (__dynamic_C_InitiallyUnownedClassGetPropertyFieldCallback __funPtr) object' propertyId value' pspec'
    touchManagedPtr object
    touchManagedPtr value
    touchManagedPtr pspec
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassGetPropertyFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassGetPropertyFieldCallback :: C_InitiallyUnownedClassGetPropertyFieldCallback -> IO (FunPtr C_InitiallyUnownedClassGetPropertyFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassGetPropertyFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GValue
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassGetPropertyFieldCallback`@.
noInitiallyUnownedClassGetPropertyFieldCallback :: Maybe InitiallyUnownedClassGetPropertyFieldCallback
noInitiallyUnownedClassGetPropertyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassGetPropertyFieldCallback :: MonadIO m => InitiallyUnownedClassGetPropertyFieldCallback -> m (GClosure C_InitiallyUnownedClassGetPropertyFieldCallback)
genClosure_InitiallyUnownedClassGetPropertyFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassGetPropertyFieldCallback Nothing cb
    mk_InitiallyUnownedClassGetPropertyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassGetPropertyFieldCallback` into a `C_InitiallyUnownedClassGetPropertyFieldCallback`.
wrap_InitiallyUnownedClassGetPropertyFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassGetPropertyFieldCallback)) ->
    InitiallyUnownedClassGetPropertyFieldCallback ->
    C_InitiallyUnownedClassGetPropertyFieldCallback
wrap_InitiallyUnownedClassGetPropertyFieldCallback gi'funptrptr gi'cb object propertyId value pspec = do
    object' <- (newObject GObject.Object.Object) object
    value' <- B.GValue.newGValueFromPtr value
    pspec' <- B.GParamSpec.newGParamSpecFromPtr pspec
    gi'cb  object' propertyId value' pspec'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassFinalizeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassFinalizeFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassFinalizeFieldCallback :: FunPtr C_InitiallyUnownedClassFinalizeFieldCallback -> C_InitiallyUnownedClassFinalizeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassFinalizeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassFinalizeFieldCallback
    -> a
    -> m ()
dynamic_InitiallyUnownedClassFinalizeFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_InitiallyUnownedClassFinalizeFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassFinalizeFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassFinalizeFieldCallback :: C_InitiallyUnownedClassFinalizeFieldCallback -> IO (FunPtr C_InitiallyUnownedClassFinalizeFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassFinalizeFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassFinalizeFieldCallback`@.
noInitiallyUnownedClassFinalizeFieldCallback :: Maybe InitiallyUnownedClassFinalizeFieldCallback
noInitiallyUnownedClassFinalizeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassFinalizeFieldCallback :: MonadIO m => InitiallyUnownedClassFinalizeFieldCallback -> m (GClosure C_InitiallyUnownedClassFinalizeFieldCallback)
genClosure_InitiallyUnownedClassFinalizeFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassFinalizeFieldCallback Nothing cb
    mk_InitiallyUnownedClassFinalizeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassFinalizeFieldCallback` into a `C_InitiallyUnownedClassFinalizeFieldCallback`.
wrap_InitiallyUnownedClassFinalizeFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassFinalizeFieldCallback)) ->
    InitiallyUnownedClassFinalizeFieldCallback ->
    C_InitiallyUnownedClassFinalizeFieldCallback
wrap_InitiallyUnownedClassFinalizeFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassDisposeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassDisposeFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassDisposeFieldCallback :: FunPtr C_InitiallyUnownedClassDisposeFieldCallback -> C_InitiallyUnownedClassDisposeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassDisposeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassDisposeFieldCallback
    -> a
    -> m ()
dynamic_InitiallyUnownedClassDisposeFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_InitiallyUnownedClassDisposeFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassDisposeFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassDisposeFieldCallback :: C_InitiallyUnownedClassDisposeFieldCallback -> IO (FunPtr C_InitiallyUnownedClassDisposeFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassDisposeFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassDisposeFieldCallback`@.
noInitiallyUnownedClassDisposeFieldCallback :: Maybe InitiallyUnownedClassDisposeFieldCallback
noInitiallyUnownedClassDisposeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassDisposeFieldCallback :: MonadIO m => InitiallyUnownedClassDisposeFieldCallback -> m (GClosure C_InitiallyUnownedClassDisposeFieldCallback)
genClosure_InitiallyUnownedClassDisposeFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassDisposeFieldCallback Nothing cb
    mk_InitiallyUnownedClassDisposeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassDisposeFieldCallback` into a `C_InitiallyUnownedClassDisposeFieldCallback`.
wrap_InitiallyUnownedClassDisposeFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassDisposeFieldCallback)) ->
    InitiallyUnownedClassDisposeFieldCallback ->
    C_InitiallyUnownedClassDisposeFieldCallback
wrap_InitiallyUnownedClassDisposeFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_pspecs"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pspecs"
          , argType = TParamSpec
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback =
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr GParamSpec ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_pspecs"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspecs"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback :: FunPtr C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback -> C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
    -> a
    -> Word32
    -> GParamSpec
    -> m ()
dynamic_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback __funPtr object nPspecs pspecs = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    pspecs' <- unsafeManagedPtrGetPtr pspecs
    (__dynamic_C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback __funPtr) object' nPspecs pspecs'
    touchManagedPtr object
    touchManagedPtr pspecs
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback :: C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback -> IO (FunPtr C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassDispatchPropertiesChangedFieldCallback =
    GObject.Object.Object
    -> Word32
    -> GParamSpec
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassDispatchPropertiesChangedFieldCallback`@.
noInitiallyUnownedClassDispatchPropertiesChangedFieldCallback :: Maybe InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
noInitiallyUnownedClassDispatchPropertiesChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback :: MonadIO m => InitiallyUnownedClassDispatchPropertiesChangedFieldCallback -> m (GClosure C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)
genClosure_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback Nothing cb
    mk_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassDispatchPropertiesChangedFieldCallback` into a `C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback`.
wrap_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)) ->
    InitiallyUnownedClassDispatchPropertiesChangedFieldCallback ->
    C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
wrap_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback gi'funptrptr gi'cb object nPspecs pspecs = do
    object' <- (newObject GObject.Object.Object) object
    pspecs' <- B.GParamSpec.newGParamSpecFromPtr pspecs
    gi'cb  object' nPspecs pspecs'
    maybeReleaseFunPtr gi'funptrptr


-- callback InitiallyUnownedClassConstructedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InitiallyUnownedClassConstructedFieldCallback =
    Ptr GObject.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InitiallyUnownedClassConstructedFieldCallback :: FunPtr C_InitiallyUnownedClassConstructedFieldCallback -> C_InitiallyUnownedClassConstructedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InitiallyUnownedClassConstructedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_InitiallyUnownedClassConstructedFieldCallback
    -> a
    -> m ()
dynamic_InitiallyUnownedClassConstructedFieldCallback __funPtr object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    (__dynamic_C_InitiallyUnownedClassConstructedFieldCallback __funPtr) object'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_InitiallyUnownedClassConstructedFieldCallback`.
foreign import ccall "wrapper"
    mk_InitiallyUnownedClassConstructedFieldCallback :: C_InitiallyUnownedClassConstructedFieldCallback -> IO (FunPtr C_InitiallyUnownedClassConstructedFieldCallback)

-- | /No description available in the introspection data./
type InitiallyUnownedClassConstructedFieldCallback =
    GObject.Object.Object
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InitiallyUnownedClassConstructedFieldCallback`@.
noInitiallyUnownedClassConstructedFieldCallback :: Maybe InitiallyUnownedClassConstructedFieldCallback
noInitiallyUnownedClassConstructedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_InitiallyUnownedClassConstructedFieldCallback :: MonadIO m => InitiallyUnownedClassConstructedFieldCallback -> m (GClosure C_InitiallyUnownedClassConstructedFieldCallback)
genClosure_InitiallyUnownedClassConstructedFieldCallback cb = liftIO $ do
    let cb' = wrap_InitiallyUnownedClassConstructedFieldCallback Nothing cb
    mk_InitiallyUnownedClassConstructedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `InitiallyUnownedClassConstructedFieldCallback` into a `C_InitiallyUnownedClassConstructedFieldCallback`.
wrap_InitiallyUnownedClassConstructedFieldCallback :: 
    Maybe (Ptr (FunPtr C_InitiallyUnownedClassConstructedFieldCallback)) ->
    InitiallyUnownedClassConstructedFieldCallback ->
    C_InitiallyUnownedClassConstructedFieldCallback
wrap_InitiallyUnownedClassConstructedFieldCallback gi'funptrptr gi'cb object = do
    object' <- (newObject GObject.Object.Object) object
    gi'cb  object'
    maybeReleaseFunPtr gi'funptrptr


-- callback ClosureNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "data specified when registering the notification callback"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "closure"
          , argType = TGClosure Nothing
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GClosure on which the notification is emitted"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type used for the various notification callbacks which can be registered\non closures."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClosureNotify =
    Ptr () ->
    Ptr (GClosure ()) ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "data specified when registering the notification callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GClosure on which the notification is emitted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClosureNotify :: FunPtr C_ClosureNotify -> C_ClosureNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClosureNotify ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClosureNotify
    -> Ptr ()
    -- ^ /@data@/: data specified when registering the notification callback
    -> GClosure a
    -- ^ /@closure@/: the t'GI.GObject.Structs.Closure.Closure' on which the notification is emitted
    -> m ()
dynamic_ClosureNotify __funPtr data_ closure = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    (__dynamic_C_ClosureNotify __funPtr) data_ closure'
    touchManagedPtr closure
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClosureNotify`.
foreign import ccall "wrapper"
    mk_ClosureNotify :: C_ClosureNotify -> IO (FunPtr C_ClosureNotify)

-- | The type used for the various notification callbacks which can be registered
-- on closures.
type ClosureNotify =
    Ptr ()
    -- ^ /@data@/: data specified when registering the notification callback
    -> GClosure ()
    -- ^ /@closure@/: the t'GI.GObject.Structs.Closure.Closure' on which the notification is emitted
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClosureNotify`@.
noClosureNotify :: Maybe ClosureNotify
noClosureNotify = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClosureNotify :: MonadIO m => ClosureNotify -> m (GClosure C_ClosureNotify)
genClosure_ClosureNotify cb = liftIO $ do
    let cb' = wrap_ClosureNotify Nothing cb
    mk_ClosureNotify cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClosureNotify` into a `C_ClosureNotify`.
wrap_ClosureNotify :: 
    Maybe (Ptr (FunPtr C_ClosureNotify)) ->
    ClosureNotify ->
    C_ClosureNotify
wrap_ClosureNotify gi'funptrptr gi'cb data_ closure = do
    closure' <- (B.GClosure.newGClosureFromPtr . FP.castPtr) closure
    gi'cb  data_ closure'
    maybeReleaseFunPtr gi'funptrptr


-- callback ClosureMarshalFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "closure"
          , argType = TGClosure Nothing
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "return_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_param_values"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "param_values"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "invocation_hint"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "marshal_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClosureMarshalFieldCallback =
    Ptr (GClosure ()) ->
    Ptr GValue ->
    Word32 ->
    Ptr GValue ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClosureMarshalFieldCallback :: FunPtr C_ClosureMarshalFieldCallback -> C_ClosureMarshalFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClosureMarshalFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClosureMarshalFieldCallback
    -> GClosure a
    -> GValue
    -> Word32
    -> GValue
    -> Ptr ()
    -> Ptr ()
    -> m ()
dynamic_ClosureMarshalFieldCallback __funPtr closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    (__dynamic_C_ClosureMarshalFieldCallback __funPtr) closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClosureMarshalFieldCallback`.
foreign import ccall "wrapper"
    mk_ClosureMarshalFieldCallback :: C_ClosureMarshalFieldCallback -> IO (FunPtr C_ClosureMarshalFieldCallback)

-- | /No description available in the introspection data./
type ClosureMarshalFieldCallback =
    GClosure ()
    -> GValue
    -> Word32
    -> GValue
    -> Ptr ()
    -> Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClosureMarshalFieldCallback`@.
noClosureMarshalFieldCallback :: Maybe ClosureMarshalFieldCallback
noClosureMarshalFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClosureMarshalFieldCallback :: MonadIO m => ClosureMarshalFieldCallback -> m (GClosure C_ClosureMarshalFieldCallback)
genClosure_ClosureMarshalFieldCallback cb = liftIO $ do
    let cb' = wrap_ClosureMarshalFieldCallback Nothing cb
    mk_ClosureMarshalFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClosureMarshalFieldCallback` into a `C_ClosureMarshalFieldCallback`.
wrap_ClosureMarshalFieldCallback :: 
    Maybe (Ptr (FunPtr C_ClosureMarshalFieldCallback)) ->
    ClosureMarshalFieldCallback ->
    C_ClosureMarshalFieldCallback
wrap_ClosureMarshalFieldCallback gi'funptrptr gi'cb closure returnValue nParamValues paramValues invocationHint marshalData = do
    closure' <- (B.GClosure.newGClosureFromPtr . FP.castPtr) closure
    returnValue' <- B.GValue.newGValueFromPtr returnValue
    paramValues' <- B.GValue.newGValueFromPtr paramValues
    gi'cb  closure' returnValue' nParamValues paramValues' invocationHint marshalData
    maybeReleaseFunPtr gi'funptrptr


-- callback ClosureMarshal
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "closure"
          , argType = TGClosure Nothing
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GClosure to which the marshaller belongs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "return_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a #GValue to store the return\n value. May be %NULL if the callback of @closure doesn't return a\n value."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_param_values"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the length of the @param_values array"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "param_values"
          , argType = TCArray False (-1) 2 TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "an array of\n #GValues holding the arguments on which to invoke the\n callback of @closure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "invocation_hint"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the invocation hint given as the\n last argument to g_closure_invoke()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "marshal_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "additional data specified when\n registering the marshaller, see g_closure_set_marshal() and\n g_closure_set_meta_marshal()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText = Just "The type used for marshaller functions."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClosureMarshal =
    Ptr (GClosure ()) ->
    Ptr GValue ->
    Word32 ->
    Ptr B.GValue.GValue ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GClosure to which the marshaller belongs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GValue to store the return\n value. May be %NULL if the callback of @closure doesn't return a\n value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the @param_values array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TCArray False (-1) 2 TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an array of\n #GValues holding the arguments on which to invoke the\n callback of @closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the invocation hint given as the\n last argument to g_closure_invoke()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "additional data specified when\n registering the marshaller, see g_closure_set_marshal() and\n g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_param_values"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of the @param_values array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClosureMarshal :: FunPtr C_ClosureMarshal -> C_ClosureMarshal

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClosureMarshal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClosureMarshal
    -> GClosure a
    -- ^ /@closure@/: the t'GI.GObject.Structs.Closure.Closure' to which the marshaller belongs
    -> Maybe (GValue)
    -- ^ /@returnValue@/: a t'GI.GObject.Structs.Value.Value' to store the return
    --  value. May be 'P.Nothing' if the callback of /@closure@/ doesn\'t return a
    --  value.
    -> [GValue]
    -- ^ /@paramValues@/: an array of
    --  @/GValues/@ holding the arguments on which to invoke the
    --  callback of /@closure@/
    -> Ptr ()
    -- ^ /@invocationHint@/: the invocation hint given as the
    --  last argument to 'GI.GObject.Structs.Closure.closureInvoke'
    -> Ptr ()
    -- ^ /@marshalData@/: additional data specified when
    --  registering the marshaller, see @/g_closure_set_marshal()/@ and
    --  @/g_closure_set_meta_marshal()/@
    -> m ()
dynamic_ClosureMarshal __funPtr closure returnValue paramValues invocationHint marshalData = liftIO $ do
    let nParamValues = fromIntegral $ P.length paramValues
    closure' <- unsafeManagedPtrCastPtr closure
    maybeReturnValue <- case returnValue of
        Nothing -> return FP.nullPtr
        Just jReturnValue -> do
            jReturnValue' <- unsafeManagedPtrGetPtr jReturnValue
            return jReturnValue'
    paramValues' <- B.GValue.packGValueArray paramValues
    (__dynamic_C_ClosureMarshal __funPtr) closure' maybeReturnValue nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    whenJust returnValue touchManagedPtr
    mapM_ touchManagedPtr paramValues
    freeMem paramValues'
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClosureMarshal`.
foreign import ccall "wrapper"
    mk_ClosureMarshal :: C_ClosureMarshal -> IO (FunPtr C_ClosureMarshal)

-- | The type used for marshaller functions.
type ClosureMarshal =
    GClosure ()
    -- ^ /@closure@/: the t'GI.GObject.Structs.Closure.Closure' to which the marshaller belongs
    -> Maybe GValue
    -- ^ /@returnValue@/: a t'GI.GObject.Structs.Value.Value' to store the return
    --  value. May be 'P.Nothing' if the callback of /@closure@/ doesn\'t return a
    --  value.
    -> [GValue]
    -- ^ /@paramValues@/: an array of
    --  @/GValues/@ holding the arguments on which to invoke the
    --  callback of /@closure@/
    -> Ptr ()
    -- ^ /@invocationHint@/: the invocation hint given as the
    --  last argument to 'GI.GObject.Structs.Closure.closureInvoke'
    -> Ptr ()
    -- ^ /@marshalData@/: additional data specified when
    --  registering the marshaller, see @/g_closure_set_marshal()/@ and
    --  @/g_closure_set_meta_marshal()/@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClosureMarshal`@.
noClosureMarshal :: Maybe ClosureMarshal
noClosureMarshal = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClosureMarshal :: MonadIO m => ClosureMarshal -> m (GClosure C_ClosureMarshal)
genClosure_ClosureMarshal cb = liftIO $ do
    let cb' = wrap_ClosureMarshal Nothing cb
    mk_ClosureMarshal cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClosureMarshal` into a `C_ClosureMarshal`.
wrap_ClosureMarshal :: 
    Maybe (Ptr (FunPtr C_ClosureMarshal)) ->
    ClosureMarshal ->
    C_ClosureMarshal
wrap_ClosureMarshal gi'funptrptr gi'cb closure returnValue nParamValues paramValues invocationHint marshalData = do
    closure' <- (B.GClosure.newGClosureFromPtr . FP.castPtr) closure
    maybeReturnValue <-
        if returnValue == FP.nullPtr
        then return Nothing
        else do
            returnValue' <- B.GValue.newGValueFromPtr returnValue
            return $ Just returnValue'
    paramValues' <- (B.GValue.unpackGValueArrayWithLength nParamValues) paramValues
    gi'cb  closure' maybeReturnValue paramValues' invocationHint marshalData
    maybeReleaseFunPtr gi'funptrptr


-- callback ClassInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GTypeClass structure to initialize."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "class_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @class_data member supplied via the #GTypeInfo structure."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to initialize the class\nof a specific type.\n\nThis function should initialize all static class members.\n\nThe initialization process of a class involves:\n\n- Copying common members from the parent class over to the\n  derived class structure.\n- Zero initialization of the remaining members not copied\n  over from the parent class.\n- Invocation of the GBaseInitFunc() initializers of all parent\n  types and the class' type.\n- Invocation of the class' GClassInitFunc() initializer.\n\nSince derived classes are partially initialized through a memory copy\nof the parent class, the general rule is that GBaseInitFunc() and\nGBaseFinalizeFunc() should take care of necessary reinitialization\nand release of those class members that were introduced by the type\nthat specified these GBaseInitFunc()/GBaseFinalizeFunc().\nGClassInitFunc() should only care about initializing static\nclass members, while dynamic class members (such as allocated strings\nor reference counted resources) are better handled by a GBaseInitFunc()\nfor this type, so proper initialization of the dynamic class members\nis performed for class initialization of derived types as well.\n\nAn example may help to correspond the intend of the different class\ninitializers:\n\n|[<!-- language=\"C\" -->\ntypedef struct {\n  GObjectClass parent_class;\n  gint         static_integer;\n  gchar       *dynamic_string;\n} TypeAClass;\nstatic void\ntype_a_base_class_init (TypeAClass *class)\n{\n  class->dynamic_string = g_strdup (\"some string\");\n}\nstatic void\ntype_a_base_class_finalize (TypeAClass *class)\n{\n  g_free (class->dynamic_string);\n}\nstatic void\ntype_a_class_init (TypeAClass *class)\n{\n  class->static_integer = 42;\n}\n\ntypedef struct {\n  TypeAClass   parent_class;\n  gfloat       static_float;\n  GString     *dynamic_gstring;\n} TypeBClass;\nstatic void\ntype_b_base_class_init (TypeBClass *class)\n{\n  class->dynamic_gstring = g_string_new (\"some other string\");\n}\nstatic void\ntype_b_base_class_finalize (TypeBClass *class)\n{\n  g_string_free (class->dynamic_gstring);\n}\nstatic void\ntype_b_class_init (TypeBClass *class)\n{\n  class->static_float = 3.14159265358979323846;\n}\n]|\n\nInitialization of TypeBClass will first cause initialization of\nTypeAClass (derived classes reference their parent classes, see\ng_type_class_ref() on this).\n\nInitialization of TypeAClass roughly involves zero-initializing its fields,\nthen calling its GBaseInitFunc() type_a_base_class_init() to allocate\nits dynamic members (dynamic_string), and finally calling its GClassInitFunc()\ntype_a_class_init() to initialize its static members (static_integer).\nThe first step in the initialization process of TypeBClass is then\na plain memory copy of the contents of TypeAClass into TypeBClass and\nzero-initialization of the remaining fields in TypeBClass.\nThe dynamic members of TypeAClass within TypeBClass now need\nreinitialization which is performed by calling type_a_base_class_init()\nwith an argument of TypeBClass.\n\nAfter that, the GBaseInitFunc() of TypeBClass, type_b_base_class_init()\nis called to allocate the dynamic members of TypeBClass (dynamic_gstring),\nand finally the GClassInitFunc() of TypeBClass, type_b_class_init(),\nis called to complete the initialization process with the static members\n(static_float).\n\nCorresponding finalization counter parts to the GBaseInitFunc() functions\nhave to be provided to release allocated resources at class finalization\ntime."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClassInitFunc =
    Ptr GObject.TypeClass.TypeClass ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GTypeClass structure to initialize."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @class_data member supplied via the #GTypeInfo structure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClassInitFunc :: FunPtr C_ClassInitFunc -> C_ClassInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClassInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClassInitFunc
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to initialize.
    -> Ptr ()
    -- ^ /@classData@/: The /@classData@/ member supplied via the t'GI.GObject.Structs.TypeInfo.TypeInfo' structure.
    -> m ()
dynamic_ClassInitFunc __funPtr gClass classData = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    (__dynamic_C_ClassInitFunc __funPtr) gClass' classData
    touchManagedPtr gClass
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClassInitFunc`.
foreign import ccall "wrapper"
    mk_ClassInitFunc :: C_ClassInitFunc -> IO (FunPtr C_ClassInitFunc)

-- | A callback function used by the type system to initialize the class
-- of a specific type.
-- 
-- This function should initialize all static class members.
-- 
-- The initialization process of a class involves:
-- 
-- * Copying common members from the parent class over to the
--   derived class structure.
-- * Zero initialization of the remaining members not copied
--   over from the parent class.
-- * Invocation of the @/GBaseInitFunc()/@ initializers of all parent
--   types and the class\' type.
-- * Invocation of the class\' @/GClassInitFunc()/@ initializer.
-- 
-- 
-- Since derived classes are partially initialized through a memory copy
-- of the parent class, the general rule is that @/GBaseInitFunc()/@ and
-- @/GBaseFinalizeFunc()/@ should take care of necessary reinitialization
-- and release of those class members that were introduced by the type
-- that specified these @/GBaseInitFunc()/@\/@/GBaseFinalizeFunc()/@.
-- @/GClassInitFunc()/@ should only care about initializing static
-- class members, while dynamic class members (such as allocated strings
-- or reference counted resources) are better handled by a @/GBaseInitFunc()/@
-- for this type, so proper initialization of the dynamic class members
-- is performed for class initialization of derived types as well.
-- 
-- An example may help to correspond the intend of the different class
-- initializers:
-- 
-- 
-- === /C code/
-- >
-- >typedef struct {
-- >  GObjectClass parent_class;
-- >  gint         static_integer;
-- >  gchar       *dynamic_string;
-- >} TypeAClass;
-- >static void
-- >type_a_base_class_init (TypeAClass *class)
-- >{
-- >  class->dynamic_string = g_strdup ("some string");
-- >}
-- >static void
-- >type_a_base_class_finalize (TypeAClass *class)
-- >{
-- >  g_free (class->dynamic_string);
-- >}
-- >static void
-- >type_a_class_init (TypeAClass *class)
-- >{
-- >  class->static_integer = 42;
-- >}
-- >
-- >typedef struct {
-- >  TypeAClass   parent_class;
-- >  gfloat       static_float;
-- >  GString     *dynamic_gstring;
-- >} TypeBClass;
-- >static void
-- >type_b_base_class_init (TypeBClass *class)
-- >{
-- >  class->dynamic_gstring = g_string_new ("some other string");
-- >}
-- >static void
-- >type_b_base_class_finalize (TypeBClass *class)
-- >{
-- >  g_string_free (class->dynamic_gstring);
-- >}
-- >static void
-- >type_b_class_init (TypeBClass *class)
-- >{
-- >  class->static_float = 3.14159265358979323846;
-- >}
-- 
-- 
-- Initialization of TypeBClass will first cause initialization of
-- TypeAClass (derived classes reference their parent classes, see
-- 'GI.GObject.Functions.typeClassRef' on this).
-- 
-- Initialization of TypeAClass roughly involves zero-initializing its fields,
-- then calling its @/GBaseInitFunc()/@ @/type_a_base_class_init()/@ to allocate
-- its dynamic members (dynamic_string), and finally calling its @/GClassInitFunc()/@
-- @/type_a_class_init()/@ to initialize its static members (static_integer).
-- The first step in the initialization process of TypeBClass is then
-- a plain memory copy of the contents of TypeAClass into TypeBClass and
-- zero-initialization of the remaining fields in TypeBClass.
-- The dynamic members of TypeAClass within TypeBClass now need
-- reinitialization which is performed by calling @/type_a_base_class_init()/@
-- with an argument of TypeBClass.
-- 
-- After that, the @/GBaseInitFunc()/@ of TypeBClass, @/type_b_base_class_init()/@
-- is called to allocate the dynamic members of TypeBClass (dynamic_gstring),
-- and finally the @/GClassInitFunc()/@ of TypeBClass, @/type_b_class_init()/@,
-- is called to complete the initialization process with the static members
-- (static_float).
-- 
-- Corresponding finalization counter parts to the @/GBaseInitFunc()/@ functions
-- have to be provided to release allocated resources at class finalization
-- time.
type ClassInitFunc =
    GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to initialize.
    -> Ptr ()
    -- ^ /@classData@/: The /@classData@/ member supplied via the t'GI.GObject.Structs.TypeInfo.TypeInfo' structure.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClassInitFunc`@.
noClassInitFunc :: Maybe ClassInitFunc
noClassInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClassInitFunc :: MonadIO m => ClassInitFunc -> m (GClosure C_ClassInitFunc)
genClosure_ClassInitFunc cb = liftIO $ do
    let cb' = wrap_ClassInitFunc Nothing cb
    mk_ClassInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClassInitFunc` into a `C_ClassInitFunc`.
wrap_ClassInitFunc :: 
    Maybe (Ptr (FunPtr C_ClassInitFunc)) ->
    ClassInitFunc ->
    C_ClassInitFunc
wrap_ClassInitFunc gi'funptrptr gi'cb gClass classData = do
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    gi'cb  gClass' classData
    maybeReleaseFunPtr gi'funptrptr


-- callback ClassFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GTypeClass structure to finalize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "class_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The @class_data member supplied via the #GTypeInfo structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to finalize a class.\n\nThis function is rarely needed, as dynamically allocated class resources\nshould be handled by GBaseInitFunc() and GBaseFinalizeFunc().\n\nAlso, specification of a GClassFinalizeFunc() in the #GTypeInfo\nstructure of a static type is invalid, because classes of static types\nwill never be finalized (they are artificially kept alive when their\nreference count drops to zero)."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClassFinalizeFunc =
    Ptr GObject.TypeClass.TypeClass ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GTypeClass structure to finalize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The @class_data member supplied via the #GTypeInfo structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClassFinalizeFunc :: FunPtr C_ClassFinalizeFunc -> C_ClassFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClassFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClassFinalizeFunc
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to finalize
    -> Ptr ()
    -- ^ /@classData@/: The /@classData@/ member supplied via the t'GI.GObject.Structs.TypeInfo.TypeInfo' structure
    -> m ()
dynamic_ClassFinalizeFunc __funPtr gClass classData = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    (__dynamic_C_ClassFinalizeFunc __funPtr) gClass' classData
    touchManagedPtr gClass
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClassFinalizeFunc`.
foreign import ccall "wrapper"
    mk_ClassFinalizeFunc :: C_ClassFinalizeFunc -> IO (FunPtr C_ClassFinalizeFunc)

-- | A callback function used by the type system to finalize a class.
-- 
-- This function is rarely needed, as dynamically allocated class resources
-- should be handled by @/GBaseInitFunc()/@ and @/GBaseFinalizeFunc()/@.
-- 
-- Also, specification of a @/GClassFinalizeFunc()/@ in the t'GI.GObject.Structs.TypeInfo.TypeInfo'
-- structure of a static type is invalid, because classes of static types
-- will never be finalized (they are artificially kept alive when their
-- reference count drops to zero).
type ClassFinalizeFunc =
    GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to finalize
    -> Ptr ()
    -- ^ /@classData@/: The /@classData@/ member supplied via the t'GI.GObject.Structs.TypeInfo.TypeInfo' structure
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClassFinalizeFunc`@.
noClassFinalizeFunc :: Maybe ClassFinalizeFunc
noClassFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClassFinalizeFunc :: MonadIO m => ClassFinalizeFunc -> m (GClosure C_ClassFinalizeFunc)
genClosure_ClassFinalizeFunc cb = liftIO $ do
    let cb' = wrap_ClassFinalizeFunc Nothing cb
    mk_ClassFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClassFinalizeFunc` into a `C_ClassFinalizeFunc`.
wrap_ClassFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_ClassFinalizeFunc)) ->
    ClassFinalizeFunc ->
    C_ClassFinalizeFunc
wrap_ClassFinalizeFunc gi'funptrptr gi'cb gClass classData = do
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    gi'cb  gClass' classData
    maybeReleaseFunPtr gi'funptrptr


-- callback Callback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args = []
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type used for callback functions in structure definitions and function\nsignatures.\n\nThis doesn't mean that all callback functions must take no  parameters and\nreturn void. The required signature of a callback function is determined by\nthe context in which is used (e.g. the signal to which it is connected).\n\nUse G_CALLBACK() to cast the callback function to a #GCallback."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_Callback =
    IO ()

-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_Callback :: FunPtr C_Callback -> C_Callback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_Callback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_Callback
    -> m ()
dynamic_Callback __funPtr = liftIO $ do
    (__dynamic_C_Callback __funPtr)
    return ()

-- | Generate a function pointer callable from C code, from a `C_Callback`.
foreign import ccall "wrapper"
    mk_Callback :: C_Callback -> IO (FunPtr C_Callback)

-- | The type used for callback functions in structure definitions and function
-- signatures.
-- 
-- This doesn\'t mean that all callback functions must take no  parameters and
-- return void. The required signature of a callback function is determined by
-- the context in which is used (e.g. the signal to which it is connected).
-- 
-- Use @/G_CALLBACK()/@ to cast the callback function to a t'GI.GObject.Callbacks.Callback'.
type Callback =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `Callback`@.
noCallback :: Maybe Callback
noCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_Callback :: MonadIO m => Callback -> m (GClosure C_Callback)
genClosure_Callback cb = liftIO $ do
    let cb' = wrap_Callback Nothing cb
    mk_Callback cb' >>= B.GClosure.newGClosure


-- | Wrap a `Callback` into a `C_Callback`.
wrap_Callback :: 
    Maybe (Ptr (FunPtr C_Callback)) ->
    Callback ->
    C_Callback
wrap_Callback gi'funptrptr gi'cb = do
    gi'cb 
    maybeReleaseFunPtr gi'funptrptr


-- callback BoxedFreeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "boxed"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The boxed structure to be freed."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This function is provided by the user and should free the boxed\nstructure passed."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BoxedFreeFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "boxed"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The boxed structure to be freed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BoxedFreeFunc :: FunPtr C_BoxedFreeFunc -> C_BoxedFreeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BoxedFreeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BoxedFreeFunc
    -> Ptr ()
    -- ^ /@boxed@/: The boxed structure to be freed.
    -> m ()
dynamic_BoxedFreeFunc __funPtr boxed = liftIO $ do
    (__dynamic_C_BoxedFreeFunc __funPtr) boxed
    return ()

-- | Generate a function pointer callable from C code, from a `C_BoxedFreeFunc`.
foreign import ccall "wrapper"
    mk_BoxedFreeFunc :: C_BoxedFreeFunc -> IO (FunPtr C_BoxedFreeFunc)

-- | This function is provided by the user and should free the boxed
-- structure passed.
type BoxedFreeFunc =
    Ptr ()
    -- ^ /@boxed@/: The boxed structure to be freed.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BoxedFreeFunc`@.
noBoxedFreeFunc :: Maybe BoxedFreeFunc
noBoxedFreeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_BoxedFreeFunc :: MonadIO m => BoxedFreeFunc -> m (GClosure C_BoxedFreeFunc)
genClosure_BoxedFreeFunc cb = liftIO $ do
    let cb' = wrap_BoxedFreeFunc Nothing cb
    mk_BoxedFreeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `BoxedFreeFunc` into a `C_BoxedFreeFunc`.
wrap_BoxedFreeFunc :: 
    Maybe (Ptr (FunPtr C_BoxedFreeFunc)) ->
    BoxedFreeFunc ->
    C_BoxedFreeFunc
wrap_BoxedFreeFunc gi'funptrptr gi'cb boxed = do
    gi'cb  boxed
    maybeReleaseFunPtr gi'funptrptr


-- callback BoxedCopyFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "The newly created copy of the boxed structure."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "boxed"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The boxed structure to be copied."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This function is provided by the user and should produce a copy\nof the passed in boxed structure."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BoxedCopyFunc =
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "boxed"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The boxed structure to be copied."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BoxedCopyFunc :: FunPtr C_BoxedCopyFunc -> C_BoxedCopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BoxedCopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BoxedCopyFunc
    -> Ptr ()
    -- ^ /@boxed@/: The boxed structure to be copied.
    -> m (Ptr ())
    -- ^ __Returns:__ The newly created copy of the boxed structure.
dynamic_BoxedCopyFunc __funPtr boxed = liftIO $ do
    result <- (__dynamic_C_BoxedCopyFunc __funPtr) boxed
    return result

-- | Generate a function pointer callable from C code, from a `C_BoxedCopyFunc`.
foreign import ccall "wrapper"
    mk_BoxedCopyFunc :: C_BoxedCopyFunc -> IO (FunPtr C_BoxedCopyFunc)

-- | This function is provided by the user and should produce a copy
-- of the passed in boxed structure.
type BoxedCopyFunc =
    Ptr ()
    -- ^ /@boxed@/: The boxed structure to be copied.
    -> IO (Ptr ())
    -- ^ __Returns:__ The newly created copy of the boxed structure.

-- | A convenience synonym for @`Nothing` :: `Maybe` `BoxedCopyFunc`@.
noBoxedCopyFunc :: Maybe BoxedCopyFunc
noBoxedCopyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_BoxedCopyFunc :: MonadIO m => BoxedCopyFunc -> m (GClosure C_BoxedCopyFunc)
genClosure_BoxedCopyFunc cb = liftIO $ do
    let cb' = wrap_BoxedCopyFunc Nothing cb
    mk_BoxedCopyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `BoxedCopyFunc` into a `C_BoxedCopyFunc`.
wrap_BoxedCopyFunc :: 
    Maybe (Ptr (FunPtr C_BoxedCopyFunc)) ->
    BoxedCopyFunc ->
    C_BoxedCopyFunc
wrap_BoxedCopyFunc gi'funptrptr gi'cb boxed = do
    result <- gi'cb  boxed
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback BindingTransformFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the transformation was successful, and %FALSE\n  otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "binding"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Binding" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GBinding" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "from_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GValue containing the value to transform"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GValue in which to store the transformed value"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to the transform function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function to be called to transform @from_value to @to_value.\n\nIf this is the @transform_to function of a binding, then @from_value\nis the @source_property on the @source object, and @to_value is the\n@target_property on the @target object. If this is the\n@transform_from function of a %G_BINDING_BIDIRECTIONAL binding,\nthen those roles are reversed."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BindingTransformFunc =
    Ptr GObject.Binding.Binding ->
    Ptr GValue ->
    Ptr GValue ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "binding"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Binding" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GBinding" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "from_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GValue containing the value to transform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GValue in which to store the transformed value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the transform function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BindingTransformFunc :: FunPtr C_BindingTransformFunc -> C_BindingTransformFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BindingTransformFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Binding.IsBinding a) =>
    FunPtr C_BindingTransformFunc
    -> a
    -- ^ /@binding@/: a t'GI.GObject.Objects.Binding.Binding'
    -> GValue
    -- ^ /@fromValue@/: the t'GI.GObject.Structs.Value.Value' containing the value to transform
    -> GValue
    -- ^ /@toValue@/: the t'GI.GObject.Structs.Value.Value' in which to store the transformed value
    -> Ptr ()
    -- ^ /@userData@/: data passed to the transform function
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the transformation was successful, and 'P.False'
    --   otherwise
dynamic_BindingTransformFunc __funPtr binding fromValue toValue userData = liftIO $ do
    binding' <- unsafeManagedPtrCastPtr binding
    fromValue' <- unsafeManagedPtrGetPtr fromValue
    toValue' <- unsafeManagedPtrGetPtr toValue
    result <- (__dynamic_C_BindingTransformFunc __funPtr) binding' fromValue' toValue' userData
    let result' = (/= 0) result
    touchManagedPtr binding
    touchManagedPtr fromValue
    touchManagedPtr toValue
    return result'

-- | Generate a function pointer callable from C code, from a `C_BindingTransformFunc`.
foreign import ccall "wrapper"
    mk_BindingTransformFunc :: C_BindingTransformFunc -> IO (FunPtr C_BindingTransformFunc)

-- | A function to be called to transform /@fromValue@/ to /@toValue@/.
-- 
-- If this is the /@transformTo@/ function of a binding, then /@fromValue@/
-- is the /@sourceProperty@/ on the /@source@/ object, and /@toValue@/ is the
-- /@targetProperty@/ on the /@target@/ object. If this is the
-- /@transformFrom@/ function of a 'GI.GObject.Flags.BindingFlagsBidirectional' binding,
-- then those roles are reversed.
-- 
-- /Since: 2.26/
type BindingTransformFunc =
    GObject.Binding.Binding
    -- ^ /@binding@/: a t'GI.GObject.Objects.Binding.Binding'
    -> GValue
    -- ^ /@fromValue@/: the t'GI.GObject.Structs.Value.Value' containing the value to transform
    -> GValue
    -- ^ /@toValue@/: the t'GI.GObject.Structs.Value.Value' in which to store the transformed value
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the transformation was successful, and 'P.False'
    --   otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `BindingTransformFunc`@.
noBindingTransformFunc :: Maybe BindingTransformFunc
noBindingTransformFunc = Nothing

-- | A function to be called to transform /@fromValue@/ to /@toValue@/.
-- 
-- If this is the /@transformTo@/ function of a binding, then /@fromValue@/
-- is the /@sourceProperty@/ on the /@source@/ object, and /@toValue@/ is the
-- /@targetProperty@/ on the /@target@/ object. If this is the
-- /@transformFrom@/ function of a 'GI.GObject.Flags.BindingFlagsBidirectional' binding,
-- then those roles are reversed.
-- 
-- /Since: 2.26/
type BindingTransformFunc_WithClosures =
    GObject.Binding.Binding
    -- ^ /@binding@/: a t'GI.GObject.Objects.Binding.Binding'
    -> GValue
    -- ^ /@fromValue@/: the t'GI.GObject.Structs.Value.Value' containing the value to transform
    -> GValue
    -- ^ /@toValue@/: the t'GI.GObject.Structs.Value.Value' in which to store the transformed value
    -> Ptr ()
    -- ^ /@userData@/: data passed to the transform function
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the transformation was successful, and 'P.False'
    --   otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `BindingTransformFunc_WithClosures`@.
noBindingTransformFunc_WithClosures :: Maybe BindingTransformFunc_WithClosures
noBindingTransformFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BindingTransformFunc :: BindingTransformFunc -> BindingTransformFunc_WithClosures
drop_closures_BindingTransformFunc _f binding fromValue toValue _ = _f binding fromValue toValue

-- | Wrap the callback into a `GClosure`.
genClosure_BindingTransformFunc :: MonadIO m => BindingTransformFunc -> m (GClosure C_BindingTransformFunc)
genClosure_BindingTransformFunc cb = liftIO $ do
    let cb' = drop_closures_BindingTransformFunc cb
    let cb'' = wrap_BindingTransformFunc Nothing cb'
    mk_BindingTransformFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BindingTransformFunc` into a `C_BindingTransformFunc`.
wrap_BindingTransformFunc :: 
    Maybe (Ptr (FunPtr C_BindingTransformFunc)) ->
    BindingTransformFunc_WithClosures ->
    C_BindingTransformFunc
wrap_BindingTransformFunc gi'funptrptr gi'cb binding fromValue toValue userData = do
    binding' <- (newObject GObject.Binding.Binding) binding
    fromValue' <- B.GValue.newGValueFromPtr fromValue
    toValue' <- B.GValue.newGValueFromPtr toValue
    result <- gi'cb  binding' fromValue' toValue' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback BaseInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GTypeClass structure to initialize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to do base initialization\nof the class structures of derived types.\n\nThis function is called as part of the initialization process of all derived\nclasses and should reallocate or reset all dynamic class members copied over\nfrom the parent class.\n\nFor example, class members (such as strings) that are not sufficiently\nhandled by a plain memory copy of the parent class into the derived class\nhave to be altered. See GClassInitFunc() for a discussion of the class\ninitialization process."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BaseInitFunc =
    Ptr GObject.TypeClass.TypeClass ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GTypeClass structure to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BaseInitFunc :: FunPtr C_BaseInitFunc -> C_BaseInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BaseInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BaseInitFunc
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to initialize
    -> m ()
dynamic_BaseInitFunc __funPtr gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    (__dynamic_C_BaseInitFunc __funPtr) gClass'
    touchManagedPtr gClass
    return ()

-- | Generate a function pointer callable from C code, from a `C_BaseInitFunc`.
foreign import ccall "wrapper"
    mk_BaseInitFunc :: C_BaseInitFunc -> IO (FunPtr C_BaseInitFunc)

-- | A callback function used by the type system to do base initialization
-- of the class structures of derived types.
-- 
-- This function is called as part of the initialization process of all derived
-- classes and should reallocate or reset all dynamic class members copied over
-- from the parent class.
-- 
-- For example, class members (such as strings) that are not sufficiently
-- handled by a plain memory copy of the parent class into the derived class
-- have to be altered. See @/GClassInitFunc()/@ for a discussion of the class
-- initialization process.
type BaseInitFunc =
    GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to initialize
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BaseInitFunc`@.
noBaseInitFunc :: Maybe BaseInitFunc
noBaseInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_BaseInitFunc :: MonadIO m => BaseInitFunc -> m (GClosure C_BaseInitFunc)
genClosure_BaseInitFunc cb = liftIO $ do
    let cb' = wrap_BaseInitFunc Nothing cb
    mk_BaseInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `BaseInitFunc` into a `C_BaseInitFunc`.
wrap_BaseInitFunc :: 
    Maybe (Ptr (FunPtr C_BaseInitFunc)) ->
    BaseInitFunc ->
    C_BaseInitFunc
wrap_BaseInitFunc gi'funptrptr gi'cb gClass = do
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    gi'cb  gClass'
    maybeReleaseFunPtr gi'funptrptr


-- callback BaseFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "g_class"
          , argType =
              TInterface Name { namespace = "GObject" , name = "TypeClass" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GTypeClass structure to finalize"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback function used by the type system to finalize those portions\nof a derived types class structure that were setup from the corresponding\nGBaseInitFunc() function.\n\nClass finalization basically works the inverse way in which class\ninitialization is performed.\n\nSee GClassInitFunc() for a discussion of the class initialization process."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BaseFinalizeFunc =
    Ptr GObject.TypeClass.TypeClass ->
    IO ()

-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GTypeClass structure to finalize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BaseFinalizeFunc :: FunPtr C_BaseFinalizeFunc -> C_BaseFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BaseFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BaseFinalizeFunc
    -> GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to finalize
    -> m ()
dynamic_BaseFinalizeFunc __funPtr gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    (__dynamic_C_BaseFinalizeFunc __funPtr) gClass'
    touchManagedPtr gClass
    return ()

-- | Generate a function pointer callable from C code, from a `C_BaseFinalizeFunc`.
foreign import ccall "wrapper"
    mk_BaseFinalizeFunc :: C_BaseFinalizeFunc -> IO (FunPtr C_BaseFinalizeFunc)

-- | A callback function used by the type system to finalize those portions
-- of a derived types class structure that were setup from the corresponding
-- @/GBaseInitFunc()/@ function.
-- 
-- Class finalization basically works the inverse way in which class
-- initialization is performed.
-- 
-- See @/GClassInitFunc()/@ for a discussion of the class initialization process.
type BaseFinalizeFunc =
    GObject.TypeClass.TypeClass
    -- ^ /@gClass@/: The t'GI.GObject.Structs.TypeClass.TypeClass' structure to finalize
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BaseFinalizeFunc`@.
noBaseFinalizeFunc :: Maybe BaseFinalizeFunc
noBaseFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_BaseFinalizeFunc :: MonadIO m => BaseFinalizeFunc -> m (GClosure C_BaseFinalizeFunc)
genClosure_BaseFinalizeFunc cb = liftIO $ do
    let cb' = wrap_BaseFinalizeFunc Nothing cb
    mk_BaseFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `BaseFinalizeFunc` into a `C_BaseFinalizeFunc`.
wrap_BaseFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_BaseFinalizeFunc)) ->
    BaseFinalizeFunc ->
    C_BaseFinalizeFunc
wrap_BaseFinalizeFunc gi'funptrptr gi'cb gClass = do
    gClass' <- (newPtr GObject.TypeClass.TypeClass) gClass
    gi'cb  gClass'
    maybeReleaseFunPtr gi'funptrptr



