{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a gesture on a touchpad device.
-- 
-- Unlike touchscreens, where the windowing system sends basic
-- sequences of begin, update, end events, and leaves gesture
-- recognition to the clients, touchpad gestures are typically
-- processed by the system, resulting in these events.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.TouchpadEvent
    ( 

-- * Exported types
    TouchpadEvent(..)                       ,
    IsTouchpadEvent                         ,
    toTouchpadEvent                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDeltas]("GI.Gdk.Objects.TouchpadEvent#g:method:getDeltas"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getGesturePhase]("GI.Gdk.Objects.TouchpadEvent#g:method:getGesturePhase"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getNFingers]("GI.Gdk.Objects.TouchpadEvent#g:method:getNFingers"), [getPinchAngleDelta]("GI.Gdk.Objects.TouchpadEvent#g:method:getPinchAngleDelta"), [getPinchScale]("GI.Gdk.Objects.TouchpadEvent#g:method:getPinchScale"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTouchpadEventMethod              ,
#endif

-- ** getDeltas #method:getDeltas#

#if defined(ENABLE_OVERLOADING)
    TouchpadEventGetDeltasMethodInfo        ,
#endif
    touchpadEventGetDeltas                  ,


-- ** getGesturePhase #method:getGesturePhase#

#if defined(ENABLE_OVERLOADING)
    TouchpadEventGetGesturePhaseMethodInfo  ,
#endif
    touchpadEventGetGesturePhase            ,


-- ** getNFingers #method:getNFingers#

#if defined(ENABLE_OVERLOADING)
    TouchpadEventGetNFingersMethodInfo      ,
#endif
    touchpadEventGetNFingers                ,


-- ** getPinchAngleDelta #method:getPinchAngleDelta#

#if defined(ENABLE_OVERLOADING)
    TouchpadEventGetPinchAngleDeltaMethodInfo,
#endif
    touchpadEventGetPinchAngleDelta         ,


-- ** getPinchScale #method:getPinchScale#

#if defined(ENABLE_OVERLOADING)
    TouchpadEventGetPinchScaleMethodInfo    ,
#endif
    touchpadEventGetPinchScale              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype TouchpadEvent = TouchpadEvent (SP.ManagedPtr TouchpadEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype TouchpadEvent where
    toManagedPtr (TouchpadEvent p) = p

foreign import ccall "gdk_touchpad_event_get_type"
    c_gdk_touchpad_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject TouchpadEvent where
    glibType = c_gdk_touchpad_event_get_type

-- | Type class for types which can be safely cast to t'TouchpadEvent', for instance with `toTouchpadEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TouchpadEvent o) => IsTouchpadEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TouchpadEvent o) => IsTouchpadEvent o

instance O.HasParentTypes TouchpadEvent
type instance O.ParentTypes TouchpadEvent = '[Gdk.Event.Event]

-- | Cast to t'TouchpadEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTouchpadEvent :: (MIO.MonadIO m, IsTouchpadEvent o) => o -> m TouchpadEvent
toTouchpadEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo TouchpadEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveTouchpadEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTouchpadEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveTouchpadEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveTouchpadEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveTouchpadEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveTouchpadEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveTouchpadEventMethod "getDeltas" o = TouchpadEventGetDeltasMethodInfo
    ResolveTouchpadEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveTouchpadEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveTouchpadEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveTouchpadEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveTouchpadEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveTouchpadEventMethod "getGesturePhase" o = TouchpadEventGetGesturePhaseMethodInfo
    ResolveTouchpadEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveTouchpadEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveTouchpadEventMethod "getNFingers" o = TouchpadEventGetNFingersMethodInfo
    ResolveTouchpadEventMethod "getPinchAngleDelta" o = TouchpadEventGetPinchAngleDeltaMethodInfo
    ResolveTouchpadEventMethod "getPinchScale" o = TouchpadEventGetPinchScaleMethodInfo
    ResolveTouchpadEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveTouchpadEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveTouchpadEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveTouchpadEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveTouchpadEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveTouchpadEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTouchpadEventMethod t TouchpadEvent, O.OverloadedMethod info TouchpadEvent p) => OL.IsLabel t (TouchpadEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTouchpadEventMethod t TouchpadEvent, O.OverloadedMethod info TouchpadEvent p, R.HasField t TouchpadEvent p) => R.HasField t TouchpadEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTouchpadEventMethod t TouchpadEvent, O.OverloadedMethodInfo info TouchpadEvent) => OL.IsLabel t (O.MethodProxy info TouchpadEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TouchpadEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method TouchpadEvent::get_deltas
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchpadEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touchpad event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for x"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for y"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touchpad_event_get_deltas" gdk_touchpad_event_get_deltas :: 
    Ptr TouchpadEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "TouchpadEvent"})
    Ptr CDouble ->                          -- dx : TBasicType TDouble
    Ptr CDouble ->                          -- dy : TBasicType TDouble
    IO ()

-- | Extracts delta information from a touchpad event.
touchpadEventGetDeltas ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchpadEvent a) =>
    a
    -- ^ /@event@/: a touchpad event
    -> m ((Double, Double))
touchpadEventGetDeltas event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    dx <- allocMem :: IO (Ptr CDouble)
    dy <- allocMem :: IO (Ptr CDouble)
    gdk_touchpad_event_get_deltas event' dx dy
    dx' <- peek dx
    let dx'' = realToFrac dx'
    dy' <- peek dy
    let dy'' = realToFrac dy'
    touchManagedPtr event
    freeMem dx
    freeMem dy
    return (dx'', dy'')

#if defined(ENABLE_OVERLOADING)
data TouchpadEventGetDeltasMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsTouchpadEvent a) => O.OverloadedMethod TouchpadEventGetDeltasMethodInfo a signature where
    overloadedMethod = touchpadEventGetDeltas

instance O.OverloadedMethodInfo TouchpadEventGetDeltasMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchpadEvent.touchpadEventGetDeltas",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchpadEvent.html#v:touchpadEventGetDeltas"
        })


#endif

-- method TouchpadEvent::get_gesture_phase
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchpadEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touchpad event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gdk" , name = "TouchpadGesturePhase" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touchpad_event_get_gesture_phase" gdk_touchpad_event_get_gesture_phase :: 
    Ptr TouchpadEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "TouchpadEvent"})
    IO CUInt

-- | Extracts the touchpad gesture phase from a touchpad event.
touchpadEventGetGesturePhase ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchpadEvent a) =>
    a
    -- ^ /@event@/: a touchpad event
    -> m Gdk.Enums.TouchpadGesturePhase
    -- ^ __Returns:__ the gesture phase of /@event@/
touchpadEventGetGesturePhase event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_touchpad_event_get_gesture_phase event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data TouchpadEventGetGesturePhaseMethodInfo
instance (signature ~ (m Gdk.Enums.TouchpadGesturePhase), MonadIO m, IsTouchpadEvent a) => O.OverloadedMethod TouchpadEventGetGesturePhaseMethodInfo a signature where
    overloadedMethod = touchpadEventGetGesturePhase

instance O.OverloadedMethodInfo TouchpadEventGetGesturePhaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchpadEvent.touchpadEventGetGesturePhase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchpadEvent.html#v:touchpadEventGetGesturePhase"
        })


#endif

-- method TouchpadEvent::get_n_fingers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchpadEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touchpad event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touchpad_event_get_n_fingers" gdk_touchpad_event_get_n_fingers :: 
    Ptr TouchpadEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "TouchpadEvent"})
    IO Word32

-- | Extracts the number of fingers from a touchpad event.
touchpadEventGetNFingers ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchpadEvent a) =>
    a
    -- ^ /@event@/: a touchpad event
    -> m Word32
    -- ^ __Returns:__ the number of fingers for /@event@/
touchpadEventGetNFingers event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_touchpad_event_get_n_fingers event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data TouchpadEventGetNFingersMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsTouchpadEvent a) => O.OverloadedMethod TouchpadEventGetNFingersMethodInfo a signature where
    overloadedMethod = touchpadEventGetNFingers

instance O.OverloadedMethodInfo TouchpadEventGetNFingersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchpadEvent.touchpadEventGetNFingers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchpadEvent.html#v:touchpadEventGetNFingers"
        })


#endif

-- method TouchpadEvent::get_pinch_angle_delta
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchpadEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touchpad pinch event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touchpad_event_get_pinch_angle_delta" gdk_touchpad_event_get_pinch_angle_delta :: 
    Ptr TouchpadEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "TouchpadEvent"})
    IO CDouble

-- | Extracts the angle delta from a touchpad pinch event.
touchpadEventGetPinchAngleDelta ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchpadEvent a) =>
    a
    -- ^ /@event@/: a touchpad pinch event
    -> m Double
    -- ^ __Returns:__ the angle delta of /@event@/
touchpadEventGetPinchAngleDelta event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_touchpad_event_get_pinch_angle_delta event'
    let result' = realToFrac result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data TouchpadEventGetPinchAngleDeltaMethodInfo
instance (signature ~ (m Double), MonadIO m, IsTouchpadEvent a) => O.OverloadedMethod TouchpadEventGetPinchAngleDeltaMethodInfo a signature where
    overloadedMethod = touchpadEventGetPinchAngleDelta

instance O.OverloadedMethodInfo TouchpadEventGetPinchAngleDeltaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchpadEvent.touchpadEventGetPinchAngleDelta",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchpadEvent.html#v:touchpadEventGetPinchAngleDelta"
        })


#endif

-- method TouchpadEvent::get_pinch_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchpadEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touchpad pinch event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touchpad_event_get_pinch_scale" gdk_touchpad_event_get_pinch_scale :: 
    Ptr TouchpadEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "TouchpadEvent"})
    IO CDouble

-- | Extracts the scale from a touchpad pinch event.
touchpadEventGetPinchScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchpadEvent a) =>
    a
    -- ^ /@event@/: a touchpad pinch event
    -> m Double
    -- ^ __Returns:__ the scale of /@event@/
touchpadEventGetPinchScale event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_touchpad_event_get_pinch_scale event'
    let result' = realToFrac result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data TouchpadEventGetPinchScaleMethodInfo
instance (signature ~ (m Double), MonadIO m, IsTouchpadEvent a) => O.OverloadedMethod TouchpadEventGetPinchScaleMethodInfo a signature where
    overloadedMethod = touchpadEventGetPinchScale

instance O.OverloadedMethodInfo TouchpadEventGetPinchScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchpadEvent.touchpadEventGetPinchScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchpadEvent.html#v:touchpadEventGetPinchScale"
        })


#endif


