// -*- mode: Rust -*-
// vim: set ft=rust :

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

// AUTOGENERATED BY toolkit/components/gecko_trace/scripts/codegen.py DO NOT EDIT.

mod generated {
    use crate::proto::opentelemetry::proto::common::v1::any_value::Value;
    #[allow(unused_imports)]
    use crate::proto::opentelemetry::proto::common::v1::{AnyValue, ArrayValue, KeyValue};

    pub use firefox_on_glean::metrics::gecko_trace::{
        TracesDataObjectItemResourceSpansItemItemScopeSpansItemItemSpansItemItemEventsItem as SpanEvent,
        TracesDataObjectItemResourceSpansItemItemScopeSpansItemItemSpansItemItemEventsItemItemAttributesObject as EventAttributesObject,
    };

    pub(crate) fn inject_event_attributes(
        mut span_event: SpanEvent,
        attributes: Vec<KeyValue>,
    ) -> SpanEvent {
        let mut event_attributes = EventAttributesObject {
            source_file: None,
            source_line: None,
            frame_id: None,
            result: None,
            severity: None,
        };

        for KeyValue { key, value } in attributes {
            match (key.as_ref(), value) {
                (
                    "source.file",
                    Some(AnyValue {
                        value: Some(Value::StringValue(value)),
                    }),
                ) => event_attributes.source_file = Some(value),
                ("source.file", value) => {
                    log::error!(
                        "Unexpected attribute source.file of type {}, expected string",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
                (
                    "source.line",
                    Some(AnyValue {
                        value: Some(Value::IntValue(value)),
                    }),
                ) => event_attributes.source_line = Some(value),
                ("source.line", value) => {
                    log::error!(
                        "Unexpected attribute source.line of type {}, expected integer",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
                (
                    "frame_id",
                    Some(AnyValue {
                        value: Some(Value::StringValue(value)),
                    }),
                ) => event_attributes.frame_id = Some(value),
                ("frame_id", value) => {
                    log::error!(
                        "Unexpected attribute frame_id of type {}, expected string",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
                (
                    "result",
                    Some(AnyValue {
                        value: Some(Value::StringValue(value)),
                    }),
                ) => event_attributes.result = Some(value),
                ("result", value) => {
                    log::error!(
                        "Unexpected attribute result of type {}, expected string",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
                (
                    "severity",
                    Some(AnyValue {
                        value: Some(Value::StringValue(value)),
                    }),
                ) => event_attributes.severity = Some(value),
                ("severity", value) => {
                    log::error!(
                        "Unexpected attribute severity of type {}, expected string",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
                (_, value) => {
                    log::error!(
                        "Unexpected attribute  of type {}",
                        std::any::type_name_of_val(&value)
                    );
                    continue;
                }
            }
        }

        span_event.attributes = Some(event_attributes);
        span_event
    }
}