//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBVersionChangeTransactionParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBCursorParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseFileParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBVersionChangeTransactionParent::RecvPBackgroundIDBCursorConstructor(
        PBackgroundIDBCursorParent* actor,
        const int64_t& requestId,
        const OpenCursorParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundIDBVersionChangeTransactionParent::RecvPBackgroundIDBRequestConstructor(
        PBackgroundIDBRequestParent* actor,
        const int64_t& requestId,
        const RequestParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBVersionChangeTransactionParent::PBackgroundIDBVersionChangeTransactionParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBVersionChangeTransactionParent);
}

PBackgroundIDBVersionChangeTransactionParent::~PBackgroundIDBVersionChangeTransactionParent()
{
    MOZ_COUNT_DTOR(PBackgroundIDBVersionChangeTransactionParent);
}

auto PBackgroundIDBVersionChangeTransactionParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBVersionChangeTransactionParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBVersionChangeTransactionParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBVersionChangeTransactionParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBVersionChangeTransactionParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBVersionChangeTransactionParent::Manager() const -> PBackgroundIDBDatabaseParent*
{
    return static_cast<PBackgroundIDBDatabaseParent*>(IProtocol::Manager());
}

auto PBackgroundIDBVersionChangeTransactionParent::ManagedPBackgroundIDBCursorParent(nsTArray<PBackgroundIDBCursorParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBCursorParent.ToArray(aArr);
}

auto PBackgroundIDBVersionChangeTransactionParent::ManagedPBackgroundIDBCursorParent() const -> const ManagedContainer<PBackgroundIDBCursorParent>&
{
    return mManagedPBackgroundIDBCursorParent;
}

auto PBackgroundIDBVersionChangeTransactionParent::ManagedPBackgroundIDBRequestParent(nsTArray<PBackgroundIDBRequestParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBRequestParent.ToArray(aArr);
}

auto PBackgroundIDBVersionChangeTransactionParent::ManagedPBackgroundIDBRequestParent() const -> const ManagedContainer<PBackgroundIDBRequestParent>&
{
    return mManagedPBackgroundIDBRequestParent;
}

auto PBackgroundIDBVersionChangeTransactionParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBCursorMsgStart,
        PBackgroundIDBRequestMsgStart
    };
    return sIds;
}

auto PBackgroundIDBVersionChangeTransactionParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBCursorMsgStart:
        return (&(mManagedPBackgroundIDBCursorParent));
    case PBackgroundIDBRequestMsgStart:
        return (&(mManagedPBackgroundIDBRequestParent));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBVersionChangeTransactionParent::OpenPBackgroundIDBCursorEndpoint(PBackgroundIDBCursorParent* aActor) -> ManagedEndpoint<PBackgroundIDBCursorChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBCursorParent actor");
        return ManagedEndpoint<PBackgroundIDBCursorChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBCursorParent actor");
        return ManagedEndpoint<PBackgroundIDBCursorChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBCursorChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBVersionChangeTransactionParent::BindPBackgroundIDBCursorEndpoint(
        ManagedEndpoint<PBackgroundIDBCursorParent> aEndpoint,
        PBackgroundIDBCursorParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBVersionChangeTransactionParent::OpenPBackgroundIDBRequestEndpoint(PBackgroundIDBRequestParent* aActor) -> ManagedEndpoint<PBackgroundIDBRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBVersionChangeTransactionParent::BindPBackgroundIDBRequestEndpoint(
        ManagedEndpoint<PBackgroundIDBRequestParent> aEndpoint,
        PBackgroundIDBRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBVersionChangeTransactionParent::Send__delete__(PBackgroundIDBVersionChangeTransactionParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBVersionChangeTransaction::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBVersionChangeTransactionParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIDBVersionChangeTransactionParent::SendComplete(const nsresult& result) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBVersionChangeTransaction::Msg_Complete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), result);
    // Sentinel = 'result'
    ((&(writer__)))->WriteSentinel(153223840);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBVersionChangeTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_Complete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBVersionChangeTransactionParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBRequestMsgStart:
        this->DeallocPBackgroundIDBRequestParent(static_cast<PBackgroundIDBRequestParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBVersionChangeTransactionParent::OnMessageReceived(const Message& msg__) -> PBackgroundIDBVersionChangeTransactionParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_Commit__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_Commit", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__lastRequest = IPC::ReadParam<mozilla::Maybe<int64_t>>((&(reader__)));
            if (!maybe__lastRequest) {
                FatalError("Error deserializing 'int64_t?'");
                return MsgValueError;

            }
            auto& lastRequest = *maybe__lastRequest;
            // Sentinel = 'lastRequest'
            if ((!(((&(reader__)))->ReadSentinel(458359966)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCommit(std::move(lastRequest));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_Abort__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_Abort", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__resultCode = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__resultCode) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& resultCode = *maybe__resultCode;
            // Sentinel = 'resultCode'
            if ((!(((&(reader__)))->ReadSentinel(388498459)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAbort(std::move(resultCode));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_CreateObjectStore__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_CreateObjectStore", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__metadata = IPC::ReadParam<ObjectStoreMetadata>((&(reader__)));
            if (!maybe__metadata) {
                FatalError("Error deserializing 'ObjectStoreMetadata'");
                return MsgValueError;

            }
            auto& metadata = *maybe__metadata;
            // Sentinel = 'metadata'
            if ((!(((&(reader__)))->ReadSentinel(248251202)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ObjectStoreMetadata'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCreateObjectStore(std::move(metadata));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_DeleteObjectStore__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_DeleteObjectStore", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__objectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__objectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& objectStoreId = *maybe__objectStoreId;
            // Sentinel = 'objectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(620234034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteObjectStore(std::move(objectStoreId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_RenameObjectStore__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_RenameObjectStore", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__objectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__objectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& objectStoreId = *maybe__objectStoreId;
            // Sentinel = 'objectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(620234034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__name = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__name) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& name = *maybe__name;
            // Sentinel = 'name'
            if ((!(((&(reader__)))->ReadSentinel(69075362)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRenameObjectStore(std::move(objectStoreId), std::move(name));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_CreateIndex__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_CreateIndex", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__objectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__objectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& objectStoreId = *maybe__objectStoreId;
            // Sentinel = 'objectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(620234034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__metadata = IPC::ReadParam<IndexMetadata>((&(reader__)));
            if (!maybe__metadata) {
                FatalError("Error deserializing 'IndexMetadata'");
                return MsgValueError;

            }
            auto& metadata = *maybe__metadata;
            // Sentinel = 'metadata'
            if ((!(((&(reader__)))->ReadSentinel(248251202)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IndexMetadata'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCreateIndex(std::move(objectStoreId), std::move(metadata));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_DeleteIndex__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_DeleteIndex", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__objectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__objectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& objectStoreId = *maybe__objectStoreId;
            // Sentinel = 'objectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(620234034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__indexId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__indexId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& indexId = *maybe__indexId;
            // Sentinel = 'indexId'
            if ((!(((&(reader__)))->ReadSentinel(190841542)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteIndex(std::move(objectStoreId), std::move(indexId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_RenameIndex__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_RenameIndex", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__objectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__objectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& objectStoreId = *maybe__objectStoreId;
            // Sentinel = 'objectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(620234034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__indexId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__indexId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& indexId = *maybe__indexId;
            // Sentinel = 'indexId'
            if ((!(((&(reader__)))->ReadSentinel(190841542)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__name = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__name) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& name = *maybe__name;
            // Sentinel = 'name'
            if ((!(((&(reader__)))->ReadSentinel(69075362)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRenameIndex(std::move(objectStoreId), std::move(indexId), std::move(name));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_PBackgroundIDBCursorConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_PBackgroundIDBCursorConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__requestId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__requestId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& requestId = *maybe__requestId;
            // Sentinel = 'requestId'
            if ((!(((&(reader__)))->ReadSentinel(320799671)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<OpenCursorParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'OpenCursorParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpenCursorParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PBackgroundIDBCursorParent> actor = (this)->AllocPBackgroundIDBCursorParent(requestId, params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBCursorParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PBackgroundIDBCursorParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBCursorConstructor(actor, std::move(requestId), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Msg_PBackgroundIDBRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBVersionChangeTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBVersionChangeTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBVersionChangeTransaction::Msg_PBackgroundIDBRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__requestId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__requestId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& requestId = *maybe__requestId;
            // Sentinel = 'requestId'
            if ((!(((&(reader__)))->ReadSentinel(320799671)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<RequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'RequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RequestParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            PBackgroundIDBRequestParent* actor = (this)->AllocPBackgroundIDBRequestParent(requestId, params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PBackgroundIDBRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBRequestConstructor(std::move(actor), std::move(requestId), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBVersionChangeTransaction::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBVersionChangeTransactionParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBVersionChangeTransactionParent::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBVersionChangeTransactionParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBVersionChangeTransaction'
    (aWriter)->WriteSentinel(434441938);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBVersionChangeTransactionParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBVersionChangeTransaction actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBVersionChangeTransaction'
    if ((!((aReader)->ReadSentinel(434441938)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBVersionChangeTransaction actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBVersionChangeTransactionMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBVersionChangeTransaction)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBVersionChangeTransactionParent*>(actor);
}

} // namespace IPC
