#include "AbortControllerBinding.h"
#include "AbortSignalBinding.h"
#include "AudioDataBinding.h"
#include "AudioDecoderBinding.h"
#include "AudioEncoderBinding.h"
#include "BlobBinding.h"
#include "BroadcastChannelBinding.h"
#include "CSSColorBinding.h"
#include "CSSColorValueBinding.h"
#include "CSSHSLBinding.h"
#include "CSSHWBBinding.h"
#include "CSSImageValueBinding.h"
#include "CSSKeywordValueBinding.h"
#include "CSSLCHBinding.h"
#include "CSSLabBinding.h"
#include "CSSMathClampBinding.h"
#include "CSSMathInvertBinding.h"
#include "CSSMathMaxBinding.h"
#include "CSSMathMinBinding.h"
#include "CSSMathNegateBinding.h"
#include "CSSMathProductBinding.h"
#include "CSSMathSumBinding.h"
#include "CSSMathValueBinding.h"
#include "CSSMatrixComponentBinding.h"
#include "CSSNumericArrayBinding.h"
#include "CSSNumericValueBinding.h"
#include "CSSOKLCHBinding.h"
#include "CSSOKLabBinding.h"
#include "CSSPerspectiveBinding.h"
#include "CSSRGBBinding.h"
#include "CSSRotateBinding.h"
#include "CSSScaleBinding.h"
#include "CSSSkewBinding.h"
#include "CSSSkewXBinding.h"
#include "CSSSkewYBinding.h"
#include "CSSStyleValueBinding.h"
#include "CSSTransformComponentBinding.h"
#include "CSSTransformValueBinding.h"
#include "CSSTranslateBinding.h"
#include "CSSUnitValueBinding.h"
#include "CSSUnparsedValueBinding.h"
#include "CSSVariableReferenceValueBinding.h"
#include "CacheBinding.h"
#include "CacheStorageBinding.h"
#include "CanvasRenderingContext2DBinding.h"
#include "ChromeUtilsBinding.h"
#include "ClientBinding.h"
#include "ClientsBinding.h"
#include "ClonedErrorHolderBinding.h"
#include "CloseEventBinding.h"
#include "CompressionStreamBinding.h"
#include "ConsoleBinding.h"
#include "ConsoleInstanceBinding.h"
#include "CookieStoreBinding.h"
#include "CookieStoreManagerBinding.h"
#include "CryptoBinding.h"
#include "CustomEventBinding.h"
#include "DOMExceptionBinding.h"
#include "DOMMatrixBinding.h"
#include "DOMPointBinding.h"
#include "DOMQuadBinding.h"
#include "DOMRectBinding.h"
#include "DOMStringListBinding.h"
#include "DebuggerNotificationObserverBinding.h"
#include "DecompressionStreamBinding.h"
#include "DedicatedWorkerGlobalScopeBinding.h"
#include "DirectoryBinding.h"
#include "DominatorTreeBinding.h"
#include "EncodedAudioChunkBinding.h"
#include "EncodedVideoChunkBinding.h"
#include "ErrorEventBinding.h"
#include "EventBinding.h"
#include "EventSourceBinding.h"
#include "EventTargetBinding.h"
#include "ExtendableCookieChangeEventBinding.h"
#include "ExtendableEventBinding.h"
#include "ExtendableMessageEventBinding.h"
#include "FetchEventBinding.h"
#include "FetchObserverBinding.h"
#include "FileBinding.h"
#include "FileListBinding.h"
#include "FileReaderBinding.h"
#include "FileReaderSyncBinding.h"
#include "FileSystemDirectoryHandleBinding.h"
#include "FileSystemFileHandleBinding.h"
#include "FileSystemHandleBinding.h"
#include "FileSystemSyncAccessHandleBinding.h"
#include "FileSystemWritableFileStreamBinding.h"
#include "FontFaceBinding.h"
#include "FontFaceSetBinding.h"
#include "FontFaceSetLoadEventBinding.h"
#include "FormDataBinding.h"
#include "GPUUncapturedErrorEventBinding.h"
#include "HeadersBinding.h"
#include "HeapSnapshotBinding.h"
#include "IDBCursorBinding.h"
#include "IDBDatabaseBinding.h"
#include "IDBFactoryBinding.h"
#include "IDBIndexBinding.h"
#include "IDBKeyRangeBinding.h"
#include "IDBObjectStoreBinding.h"
#include "IDBOpenDBRequestBinding.h"
#include "IDBRequestBinding.h"
#include "IDBTransactionBinding.h"
#include "IDBVersionChangeEventBinding.h"
#include "IOUtilsBinding.h"
#include "ImageBitmapBinding.h"
#include "ImageBitmapRenderingContextBinding.h"
#include "ImageDataBinding.h"
#include "ImageDecoderBinding.h"
#include "LlamaRunnerBinding.h"
#include "LockBinding.h"
#include "LockManagerBinding.h"
#include "MLSBinding.h"
#include "MediaCapabilitiesBinding.h"
#include "MessageChannelBinding.h"
#include "MessageEventBinding.h"
#include "MessagePortBinding.h"
#include "NavigationPreloadManagerBinding.h"
#include "NetworkInformationBinding.h"
#include "NotificationBinding.h"
#include "NotificationEventBinding.h"
#include "ONNXBinding.h"
#include "OffscreenCanvasBinding.h"
#include "OffscreenCanvasRenderingContext2DBinding.h"
#include "PathUtilsBinding.h"
#include "PerformanceBinding.h"
#include "PerformanceEntryBinding.h"
#include "PerformanceMarkBinding.h"
#include "PerformanceMeasureBinding.h"
#include "PerformanceObserverBinding.h"
#include "PerformanceObserverEntryListBinding.h"
#include "PerformanceResourceTimingBinding.h"
#include "PerformanceServerTimingBinding.h"
#include "PermissionStatusBinding.h"
#include "PermissionsBinding.h"
#include "ProgressEventBinding.h"
#include "PromiseRejectionEventBinding.h"
#include "PushEventBinding.h"
#include "PushManagerBinding.h"
#include "PushMessageDataBinding.h"
#include "PushSubscriptionBinding.h"
#include "PushSubscriptionChangeEventBinding.h"
#include "PushSubscriptionOptionsBinding.h"
#include "QueuingStrategyBinding.h"
#include "RTCDataChannelBinding.h"
#include "RTCEncodedAudioFrameBinding.h"
#include "RTCEncodedVideoFrameBinding.h"
#include "RTCRtpScriptTransformerBinding.h"
#include "RTCTransformEventBinding.h"
#include "ReadableByteStreamControllerBinding.h"
#include "ReadableStreamBYOBReaderBinding.h"
#include "ReadableStreamBYOBRequestBinding.h"
#include "ReadableStreamBinding.h"
#include "ReadableStreamDefaultControllerBinding.h"
#include "ReadableStreamDefaultReaderBinding.h"
#include "ReportingBinding.h"
#include "RequestBinding.h"
#include "ResponseBinding.h"
#include "ServiceWorkerBinding.h"
#include "ServiceWorkerContainerBinding.h"
#include "ServiceWorkerGlobalScopeBinding.h"
#include "ServiceWorkerRegistrationBinding.h"
#include "SharedWorkerGlobalScopeBinding.h"
#include "StorageManagerBinding.h"
#include "StructuredCloneHolderBinding.h"
#include "StructuredCloneTesterBinding.h"
#include "StylePropertyMapReadOnlyBinding.h"
#include "SubtleCryptoBinding.h"
#include "TaskPriorityChangeEventBinding.h"
#include "TestUtilsBinding.h"
#include "TextDecoderBinding.h"
#include "TextDecoderStreamBinding.h"
#include "TextEncoderBinding.h"
#include "TextEncoderStreamBinding.h"
#include "TransformStreamBinding.h"
#include "TransformStreamDefaultControllerBinding.h"
#include "TrustedTypesBinding.h"
#include "URLBinding.h"
#include "URLPatternBinding.h"
#include "URLSearchParamsBinding.h"
#include "VideoColorSpaceBinding.h"
#include "VideoDecoderBinding.h"
#include "VideoEncoderBinding.h"
#include "VideoFrameBinding.h"
#include "WebGL2RenderingContextBinding.h"
#include "WebGLContextEventBinding.h"
#include "WebGLRenderingContextBinding.h"
#include "WebGPUBinding.h"
#include "WebSocketBinding.h"
#include "WebTaskSchedulingBinding.h"
#include "WebTransportBinding.h"
#include "WebTransportDatagramDuplexStreamBinding.h"
#include "WebTransportErrorBinding.h"
#include "WebTransportSendReceiveStreamBinding.h"
#include "WorkerBinding.h"
#include "WorkerGlobalScopeBinding.h"
#include "WorkerLocationBinding.h"
#include "WorkerNavigatorBinding.h"
#include "WorkerTestUtilsBinding.h"
#include "WritableStreamBinding.h"
#include "WritableStreamDefaultControllerBinding.h"
#include "WritableStreamDefaultWriterBinding.h"
#include "XMLHttpRequestBinding.h"
#include "XMLHttpRequestEventTargetBinding.h"
#include "XMLHttpRequestUploadBinding.h"

namespace mozilla::dom {
bool
RegisterWorkerBindings(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!AbortController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!AbortSignal_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (AudioData_Binding::ConstructorEnabled(aCx, aObj) && !AudioData_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (AudioDecoder_Binding::ConstructorEnabled(aCx, aObj) && !AudioDecoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (AudioEncoder_Binding::ConstructorEnabled(aCx, aObj) && !AudioEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Blob_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!BroadcastChannel_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ByteLengthQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSColor_Binding::ConstructorEnabled(aCx, aObj) && !CSSColor_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSColorValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSColorValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSHSL_Binding::ConstructorEnabled(aCx, aObj) && !CSSHSL_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSHWB_Binding::ConstructorEnabled(aCx, aObj) && !CSSHWB_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSImageValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSImageValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSKeywordValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSKeywordValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSLCH_Binding::ConstructorEnabled(aCx, aObj) && !CSSLCH_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSLab_Binding::ConstructorEnabled(aCx, aObj) && !CSSLab_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathClamp_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathClamp_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathInvert_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathInvert_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathMax_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathMax_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathMin_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathMin_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathNegate_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathNegate_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathProduct_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathProduct_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathSum_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathSum_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMathValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSMathValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSMatrixComponent_Binding::ConstructorEnabled(aCx, aObj) && !CSSMatrixComponent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSNumericArray_Binding::ConstructorEnabled(aCx, aObj) && !CSSNumericArray_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSNumericValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSNumericValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSOKLCH_Binding::ConstructorEnabled(aCx, aObj) && !CSSOKLCH_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSOKLab_Binding::ConstructorEnabled(aCx, aObj) && !CSSOKLab_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSPerspective_Binding::ConstructorEnabled(aCx, aObj) && !CSSPerspective_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSRGB_Binding::ConstructorEnabled(aCx, aObj) && !CSSRGB_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSRotate_Binding::ConstructorEnabled(aCx, aObj) && !CSSRotate_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSScale_Binding::ConstructorEnabled(aCx, aObj) && !CSSScale_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSSkew_Binding::ConstructorEnabled(aCx, aObj) && !CSSSkew_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSSkewX_Binding::ConstructorEnabled(aCx, aObj) && !CSSSkewX_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSSkewY_Binding::ConstructorEnabled(aCx, aObj) && !CSSSkewY_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSStyleValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSStyleValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSTransformComponent_Binding::ConstructorEnabled(aCx, aObj) && !CSSTransformComponent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSTransformValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSTransformValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSTranslate_Binding::ConstructorEnabled(aCx, aObj) && !CSSTranslate_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSUnitValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSUnitValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSUnparsedValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSUnparsedValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CSSVariableReferenceValue_Binding::ConstructorEnabled(aCx, aObj) && !CSSVariableReferenceValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Cache_Binding::ConstructorEnabled(aCx, aObj) && !Cache_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CacheStorage_Binding::ConstructorEnabled(aCx, aObj) && !CacheStorage_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CanvasGradient_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CanvasPattern_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ChromeUtils_Binding::ConstructorEnabled(aCx, aObj) && !ChromeUtils_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ChromeWorker_Binding::ConstructorEnabled(aCx, aObj) && !ChromeWorker_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Client_Binding::ConstructorEnabled(aCx, aObj) && !Client_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Clients_Binding::ConstructorEnabled(aCx, aObj) && !Clients_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ClonedErrorHolder_Binding::ConstructorEnabled(aCx, aObj) && !ClonedErrorHolder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CloseEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ConsoleInstance_Binding::ConstructorEnabled(aCx, aObj) && !ConsoleInstance_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CookieStore_Binding::ConstructorEnabled(aCx, aObj) && !CookieStore_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CookieStoreManager_Binding::ConstructorEnabled(aCx, aObj) && !CookieStoreManager_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CountQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Crypto_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (CryptoKey_Binding::ConstructorEnabled(aCx, aObj) && !CryptoKey_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CustomEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMException_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMMatrix_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMMatrixReadOnly_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMPoint_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMPointReadOnly_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMQuad_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMRect_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMRectReadOnly_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DOMStringList_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (DebuggerNotificationObserver_Binding::ConstructorEnabled(aCx, aObj) && !DebuggerNotificationObserver_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DecompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (DedicatedWorkerGlobalScope_Binding::ConstructorEnabled(aCx, aObj) && !DedicatedWorkerGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Directory_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (DominatorTree_Binding::ConstructorEnabled(aCx, aObj) && !DominatorTree_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (EncodedAudioChunk_Binding::ConstructorEnabled(aCx, aObj) && !EncodedAudioChunk_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (EncodedVideoChunk_Binding::ConstructorEnabled(aCx, aObj) && !EncodedVideoChunk_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ErrorEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Event_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!EventSource_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!EventTarget_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ExtendableCookieChangeEvent_Binding::ConstructorEnabled(aCx, aObj) && !ExtendableCookieChangeEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ExtendableEvent_Binding::ConstructorEnabled(aCx, aObj) && !ExtendableEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ExtendableMessageEvent_Binding::ConstructorEnabled(aCx, aObj) && !ExtendableMessageEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FetchEvent_Binding::ConstructorEnabled(aCx, aObj) && !FetchEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FetchObserver_Binding::ConstructorEnabled(aCx, aObj) && !FetchObserver_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!File_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FileList_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FileReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileReaderSync_Binding::ConstructorEnabled(aCx, aObj) && !FileReaderSync_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileSystemDirectoryHandle_Binding::ConstructorEnabled(aCx, aObj) && !FileSystemDirectoryHandle_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileSystemFileHandle_Binding::ConstructorEnabled(aCx, aObj) && !FileSystemFileHandle_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileSystemHandle_Binding::ConstructorEnabled(aCx, aObj) && !FileSystemHandle_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileSystemSyncAccessHandle_Binding::ConstructorEnabled(aCx, aObj) && !FileSystemSyncAccessHandle_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (FileSystemWritableFileStream_Binding::ConstructorEnabled(aCx, aObj) && !FileSystemWritableFileStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FontFace_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FontFaceSet_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FontFaceSetLoadEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!FormData_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPU_Binding::ConstructorEnabled(aCx, aObj) && !GPU_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUAdapter_Binding::ConstructorEnabled(aCx, aObj) && !GPUAdapter_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUAdapterInfo_Binding::ConstructorEnabled(aCx, aObj) && !GPUAdapterInfo_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUBindGroup_Binding::ConstructorEnabled(aCx, aObj) && !GPUBindGroup_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUBindGroupLayout_Binding::ConstructorEnabled(aCx, aObj) && !GPUBindGroupLayout_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUBuffer_Binding::ConstructorEnabled(aCx, aObj) && !GPUBuffer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUBufferUsage_Binding::ConstructorEnabled(aCx, aObj) && !GPUBufferUsage_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUCanvasContext_Binding::ConstructorEnabled(aCx, aObj) && !GPUCanvasContext_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUColorWrite_Binding::ConstructorEnabled(aCx, aObj) && !GPUColorWrite_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUCommandBuffer_Binding::ConstructorEnabled(aCx, aObj) && !GPUCommandBuffer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUCommandEncoder_Binding::ConstructorEnabled(aCx, aObj) && !GPUCommandEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUCompilationInfo_Binding::ConstructorEnabled(aCx, aObj) && !GPUCompilationInfo_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUCompilationMessage_Binding::ConstructorEnabled(aCx, aObj) && !GPUCompilationMessage_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUComputePassEncoder_Binding::ConstructorEnabled(aCx, aObj) && !GPUComputePassEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUComputePipeline_Binding::ConstructorEnabled(aCx, aObj) && !GPUComputePipeline_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUDevice_Binding::ConstructorEnabled(aCx, aObj) && !GPUDevice_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUDeviceLostInfo_Binding::ConstructorEnabled(aCx, aObj) && !GPUDeviceLostInfo_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUError_Binding::ConstructorEnabled(aCx, aObj) && !GPUError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUExternalTexture_Binding::ConstructorEnabled(aCx, aObj) && !GPUExternalTexture_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUInternalError_Binding::ConstructorEnabled(aCx, aObj) && !GPUInternalError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUMapMode_Binding::ConstructorEnabled(aCx, aObj) && !GPUMapMode_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUOutOfMemoryError_Binding::ConstructorEnabled(aCx, aObj) && !GPUOutOfMemoryError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUPipelineError_Binding::ConstructorEnabled(aCx, aObj) && !GPUPipelineError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUPipelineLayout_Binding::ConstructorEnabled(aCx, aObj) && !GPUPipelineLayout_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUQuerySet_Binding::ConstructorEnabled(aCx, aObj) && !GPUQuerySet_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUQueue_Binding::ConstructorEnabled(aCx, aObj) && !GPUQueue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPURenderBundle_Binding::ConstructorEnabled(aCx, aObj) && !GPURenderBundle_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPURenderBundleEncoder_Binding::ConstructorEnabled(aCx, aObj) && !GPURenderBundleEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPURenderPassEncoder_Binding::ConstructorEnabled(aCx, aObj) && !GPURenderPassEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPURenderPipeline_Binding::ConstructorEnabled(aCx, aObj) && !GPURenderPipeline_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUSampler_Binding::ConstructorEnabled(aCx, aObj) && !GPUSampler_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUShaderModule_Binding::ConstructorEnabled(aCx, aObj) && !GPUShaderModule_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUShaderStage_Binding::ConstructorEnabled(aCx, aObj) && !GPUShaderStage_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUSupportedFeatures_Binding::ConstructorEnabled(aCx, aObj) && !GPUSupportedFeatures_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUSupportedLimits_Binding::ConstructorEnabled(aCx, aObj) && !GPUSupportedLimits_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUTexture_Binding::ConstructorEnabled(aCx, aObj) && !GPUTexture_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUTextureUsage_Binding::ConstructorEnabled(aCx, aObj) && !GPUTextureUsage_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUTextureView_Binding::ConstructorEnabled(aCx, aObj) && !GPUTextureView_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUUncapturedErrorEvent_Binding::ConstructorEnabled(aCx, aObj) && !GPUUncapturedErrorEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (GPUValidationError_Binding::ConstructorEnabled(aCx, aObj) && !GPUValidationError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Headers_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (HeapSnapshot_Binding::ConstructorEnabled(aCx, aObj) && !HeapSnapshot_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBCursor_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBCursorWithValue_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBDatabase_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBFactory_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBIndex_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBKeyRange_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBObjectStore_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBOpenDBRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBTransaction_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!IDBVersionChangeEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (IOUtils_Binding::ConstructorEnabled(aCx, aObj) && !IOUtils_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ImageBitmap_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ImageBitmapRenderingContext_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ImageData_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ImageDecoder_Binding::ConstructorEnabled(aCx, aObj) && !ImageDecoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ImageTrack_Binding::ConstructorEnabled(aCx, aObj) && !ImageTrack_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ImageTrackList_Binding::ConstructorEnabled(aCx, aObj) && !ImageTrackList_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (InferenceSession_Binding::ConstructorEnabled(aCx, aObj) && !InferenceSession_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (LlamaRunner_Binding::ConstructorEnabled(aCx, aObj) && !LlamaRunner_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Lock_Binding::ConstructorEnabled(aCx, aObj) && !Lock_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (LockManager_Binding::ConstructorEnabled(aCx, aObj) && !LockManager_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (MLS_Binding::ConstructorEnabled(aCx, aObj) && !MLS_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (MLSGroupView_Binding::ConstructorEnabled(aCx, aObj) && !MLSGroupView_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MediaCapabilities_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MessageChannel_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MessageEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!MessagePort_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (NavigationPreloadManager_Binding::ConstructorEnabled(aCx, aObj) && !NavigationPreloadManager_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (NetworkInformation_Binding::ConstructorEnabled(aCx, aObj) && !NetworkInformation_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Notification_Binding::ConstructorEnabled(aCx, aObj) && !Notification_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (NotificationEvent_Binding::ConstructorEnabled(aCx, aObj) && !NotificationEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!OffscreenCanvas_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!OffscreenCanvasRenderingContext2D_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Path2D_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PathUtils_Binding::ConstructorEnabled(aCx, aObj) && !PathUtils_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Performance_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PerformanceEntry_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PerformanceMark_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PerformanceMeasure_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PerformanceObserver_Binding::ConstructorEnabled(aCx, aObj) && !PerformanceObserver_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PerformanceObserverEntryList_Binding::ConstructorEnabled(aCx, aObj) && !PerformanceObserverEntryList_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PerformanceResourceTiming_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PerformanceServerTiming_Binding::ConstructorEnabled(aCx, aObj) && !PerformanceServerTiming_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PermissionStatus_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Permissions_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ProgressEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!PromiseRejectionEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushEvent_Binding::ConstructorEnabled(aCx, aObj) && !PushEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushManager_Binding::ConstructorEnabled(aCx, aObj) && !PushManager_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushMessageData_Binding::ConstructorEnabled(aCx, aObj) && !PushMessageData_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushSubscription_Binding::ConstructorEnabled(aCx, aObj) && !PushSubscription_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushSubscriptionChangeEvent_Binding::ConstructorEnabled(aCx, aObj) && !PushSubscriptionChangeEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (PushSubscriptionOptions_Binding::ConstructorEnabled(aCx, aObj) && !PushSubscriptionOptions_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (RTCDataChannel_Binding::ConstructorEnabled(aCx, aObj) && !RTCDataChannel_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (RTCEncodedAudioFrame_Binding::ConstructorEnabled(aCx, aObj) && !RTCEncodedAudioFrame_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (RTCEncodedVideoFrame_Binding::ConstructorEnabled(aCx, aObj) && !RTCEncodedVideoFrame_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (RTCRtpScriptTransformer_Binding::ConstructorEnabled(aCx, aObj) && !RTCRtpScriptTransformer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (RTCTransformEvent_Binding::ConstructorEnabled(aCx, aObj) && !RTCTransformEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableByteStreamController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Report_Binding::ConstructorEnabled(aCx, aObj) && !Report_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ReportBody_Binding::ConstructorEnabled(aCx, aObj) && !ReportBody_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ReportingObserver_Binding::ConstructorEnabled(aCx, aObj) && !ReportingObserver_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Request_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!Response_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Scheduler_Binding::ConstructorEnabled(aCx, aObj) && !Scheduler_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ServiceWorker_Binding::ConstructorEnabled(aCx, aObj) && !ServiceWorker_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ServiceWorkerContainer_Binding::ConstructorEnabled(aCx, aObj) && !ServiceWorkerContainer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ServiceWorkerGlobalScope_Binding::ConstructorEnabled(aCx, aObj) && !ServiceWorkerGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (ServiceWorkerRegistration_Binding::ConstructorEnabled(aCx, aObj) && !ServiceWorkerRegistration_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (SharedWorkerGlobalScope_Binding::ConstructorEnabled(aCx, aObj) && !SharedWorkerGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StorageManager_Binding::ConstructorEnabled(aCx, aObj) && !StorageManager_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StructuredCloneHolder_Binding::ConstructorEnabled(aCx, aObj) && !StructuredCloneHolder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StructuredCloneTester_Binding::ConstructorEnabled(aCx, aObj) && !StructuredCloneTester_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StylePropertyMapReadOnly_Binding::ConstructorEnabled(aCx, aObj) && !StylePropertyMapReadOnly_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (SubtleCrypto_Binding::ConstructorEnabled(aCx, aObj) && !SubtleCrypto_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (SyncReadFile_Binding::ConstructorEnabled(aCx, aObj) && !SyncReadFile_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TaskController_Binding::ConstructorEnabled(aCx, aObj) && !TaskController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TaskPriorityChangeEvent_Binding::ConstructorEnabled(aCx, aObj) && !TaskPriorityChangeEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TaskSignal_Binding::ConstructorEnabled(aCx, aObj) && !TaskSignal_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Tensor_Binding::ConstructorEnabled(aCx, aObj) && !Tensor_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TestUtils_Binding::ConstructorEnabled(aCx, aObj) && !TestUtils_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TestingDeprecatedInterface_Binding::ConstructorEnabled(aCx, aObj) && !TestingDeprecatedInterface_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextDecoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextDecoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextEncoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextMetrics_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TrustedHTML_Binding::ConstructorEnabled(aCx, aObj) && !TrustedHTML_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TrustedScript_Binding::ConstructorEnabled(aCx, aObj) && !TrustedScript_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TrustedScriptURL_Binding::ConstructorEnabled(aCx, aObj) && !TrustedScriptURL_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TrustedTypePolicy_Binding::ConstructorEnabled(aCx, aObj) && !TrustedTypePolicy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (TrustedTypePolicyFactory_Binding::ConstructorEnabled(aCx, aObj) && !TrustedTypePolicyFactory_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!URL_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (URLPattern_Binding::ConstructorEnabled(aCx, aObj) && !URLPattern_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!URLSearchParams_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (VideoColorSpace_Binding::ConstructorEnabled(aCx, aObj) && !VideoColorSpace_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (VideoDecoder_Binding::ConstructorEnabled(aCx, aObj) && !VideoDecoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (VideoEncoder_Binding::ConstructorEnabled(aCx, aObj) && !VideoEncoder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (VideoFrame_Binding::ConstructorEnabled(aCx, aObj) && !VideoFrame_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WGSLLanguageFeatures_Binding::ConstructorEnabled(aCx, aObj) && !WGSLLanguageFeatures_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebGL2RenderingContext_Binding::ConstructorEnabled(aCx, aObj) && !WebGL2RenderingContext_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLActiveInfo_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLBuffer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLContextEvent_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLFramebuffer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLProgram_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLQuery_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLRenderbuffer_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLRenderingContext_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebGLSampler_Binding::ConstructorEnabled(aCx, aObj) && !WebGLSampler_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLShader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLShaderPrecisionFormat_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebGLSync_Binding::ConstructorEnabled(aCx, aObj) && !WebGLSync_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLTexture_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebGLTransformFeedback_Binding::ConstructorEnabled(aCx, aObj) && !WebGLTransformFeedback_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLUniformLocation_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebGLVertexArrayObject_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WebSocket_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransport_Binding::ConstructorEnabled(aCx, aObj) && !WebTransport_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransportBidirectionalStream_Binding::ConstructorEnabled(aCx, aObj) && !WebTransportBidirectionalStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransportDatagramDuplexStream_Binding::ConstructorEnabled(aCx, aObj) && !WebTransportDatagramDuplexStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransportError_Binding::ConstructorEnabled(aCx, aObj) && !WebTransportError_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransportReceiveStream_Binding::ConstructorEnabled(aCx, aObj) && !WebTransportReceiveStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WebTransportSendStream_Binding::ConstructorEnabled(aCx, aObj) && !WebTransportSendStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WindowClient_Binding::ConstructorEnabled(aCx, aObj) && !WindowClient_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (Worker_Binding::ConstructorEnabled(aCx, aObj) && !Worker_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WorkerGlobalScope_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WorkerLocation_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WorkerNavigator_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (WorkerTestUtils_Binding::ConstructorEnabled(aCx, aObj) && !WorkerTestUtils_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultWriter_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (XMLHttpRequest_Binding::ConstructorEnabled(aCx, aObj) && !XMLHttpRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (XMLHttpRequestEventTarget_Binding::ConstructorEnabled(aCx, aObj) && !XMLHttpRequestEventTarget_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (XMLHttpRequestUpload_Binding::ConstructorEnabled(aCx, aObj) && !XMLHttpRequestUpload_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!console_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  return true;
}

} // namespace mozilla::dom

