/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef crash_helper_ffi_generated_h
#define crash_helper_ffi_generated_h

/* Generated with cbindgen:0.29.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

#if defined(XP_WIN)
using Pid = uint32_t;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
using Pid = pid_t;
#endif

#if defined(XP_MACOSX)
using Pid = pid_t;
#endif

#if defined(XP_WIN)
using BreakpadRawData = const uint16_t*;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
using BreakpadRawData = int;
#endif

#if defined(XP_MACOSX)
using BreakpadRawData = const char*;
#endif

extern "C" {

#if !defined(MOZ_WIDGET_ANDROID)
/// Runs the crash generator process logic, this includes the IPC used by
/// processes to signal that they crashed, the IPC used to retrieve crash
/// reports from the crash helper process and the logic used to generate the
/// actual minidumps. This function will return when the main process has
/// disconnected from the crash helper.
///
/// # Safety
///
/// `minidump_data`, `listener` and `pipe` must point to valid,
/// nul-terminated C strings. `breakpad_data` must be a valid file descriptor
/// (Linux) or point to a nul-terminated C string using either byte (macOS)
/// or wide characters (Windows).
int32_t crash_generator_logic_desktop(Pid client_pid,
                                      BreakpadRawData breakpad_data,
                                      const char *minidump_path,
                                      const char *listener,
                                      const char *pipe);
#endif

#if defined(MOZ_WIDGET_ANDROID)
/// Runs the crash generator process logic, this includes the IPC used by
/// processes to signal that they crashed, the IPC used to retrieve crash
/// reports from the crash helper process and the logic used to generate the
/// actual minidumps. The logic will run in a separate thread and this
/// function will return immediately after launching it.
///
/// # Safety
///
/// `minidump_data` must point to valid, nul-terminated C strings. `server_pipe`
/// must be a valid file descriptor and `breakpad_data` must also be a valid
/// file descriptor compatible with Breakpad's crash generation server.
void crash_generator_logic_android(BreakpadRawData breakpad_data,
                                   const char *minidump_path,
                                   int pipe);
#endif

}  // extern "C"

#endif  // crash_helper_ffi_generated_h
