
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "lineedit_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "squeezelabelv2_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_LineEdit_Type = nullptr;
static PyTypeObject *Sbk_LineEdit_TypeF(void)
{
    return _Sbk_LineEdit_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void LineEditWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::LineEdit::WidgetPosition >("LineEdit::WidgetPosition");
    qRegisterMetaType< ::LineEdit::EditAction >("LineEdit::EditAction");
}

void LineEditWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

LineEditWrapper::LineEditWrapper(::QWidget * parent) : LineEdit(parent)
{
}

void LineEditWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("LineEdit", funcName, gil, pyOverride, signal);
}

void LineEditWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::contextMenuEvent(arg__1);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("LineEdit", funcName, gil, pyOverride, event);
}

int LineEditWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("LineEdit", funcName, gil, pyOverride);
}

void LineEditWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("LineEdit", funcName, gil, pyOverride, signal);
}

void LineEditWrapper::dragEnterEvent(::QDragEnterEvent * arg__1)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragEnterEvent(arg__1);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::dragLeaveEvent(::QDragLeaveEvent * e)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragLeaveEvent(e);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("LineEdit", funcName, gil, pyOverride, e);
}

void LineEditWrapper::dragMoveEvent(::QDragMoveEvent * e)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragMoveEvent(e);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("LineEdit", funcName, gil, pyOverride, e);
}

void LineEditWrapper::dropEvent(::QDropEvent * arg__1)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dropEvent(arg__1);
    }
    WebViewWrapper::sbk_o_dropEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("LineEdit", funcName, gil, pyOverride, event);
}

bool LineEditWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::event(event);
    }
    return WebViewWrapper::sbk_o_event("LineEdit", funcName, gil, pyOverride, event);
}

bool LineEditWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("LineEdit", funcName, gil, pyOverride, watched, event);
}

void LineEditWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("LineEdit", funcName, gil, pyOverride, event);
}

bool LineEditWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("LineEdit", funcName, gil, pyOverride, next);
}

void LineEditWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::focusOutEvent(arg__1);
    }
    WebViewWrapper::sbk_o_focusOutEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

bool LineEditWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("LineEdit", funcName, gil, pyOverride);
}

int LineEditWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("LineEdit", funcName, gil, pyOverride, painter);
}

void LineEditWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::initStyleOption(option);
    }
    SqueezeLabelV2Wrapper::sbk_o_initStyleOption("LineEdit", funcName, gil, pyOverride, option);
}

void LineEditWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::inputMethodEvent(arg__1);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

::QVariant LineEditWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::keyPressEvent(arg__1);
    }
    WebViewWrapper::sbk_o_keyPressEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::keyReleaseEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::keyReleaseEvent(arg__1);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("LineEdit", funcName, gil, pyOverride, event);
}

int LineEditWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("LineEdit", funcName, gil, pyOverride, arg__1);
}

::QSize LineEditWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("LineEdit", funcName, gil, pyOverride);
}

void LineEditWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::mouseMoveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("LineEdit", funcName, gil, pyOverride, event);
}

bool LineEditWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("LineEdit", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * LineEditWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("LineEdit", funcName, gil, pyOverride);
}

void LineEditWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::paintEvent(arg__1);
    }
    WebViewWrapper::sbk_o_paintEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * LineEditWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("LineEdit", funcName, gil, pyOverride, offset);
}

void LineEditWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("LineEdit", funcName, gil, pyOverride, visible);
}

::QPainter * LineEditWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("LineEdit", funcName, gil, pyOverride);
}

void LineEditWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("LineEdit", funcName, gil, pyOverride, event);
}

::QSize LineEditWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("LineEdit", funcName, gil, pyOverride);
}

void LineEditWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("LineEdit", funcName, gil, pyOverride, event);
}

void LineEditWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::timerEvent(arg__1);
    }
    WebViewWrapper::sbk_o_timerEvent("LineEdit", funcName, gil, pyOverride, arg__1);
}

void LineEditWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LineEdit_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("LineEdit", funcName, gil, pyOverride, event);
}

const QMetaObject *LineEditWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return LineEdit::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int LineEditWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = LineEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *LineEditWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< LineEditWrapper *>(this));
    }
    return LineEdit::qt_metacast(_clname);
}

LineEditWrapper::~LineEditWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_LineEdit_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LineEdit_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LineEdit >()))
        return -1;

    LineEditWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:LineEdit", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: LineEdit::LineEdit(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // LineEdit(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // LineEdit(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // LineEdit(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) LineEditWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new LineEditWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< LineEdit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);
    };


    return 1;
}

static PyObject *Sbk_LineEditFunc_addWidget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addWidget", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: LineEdit::addWidget(QWidget*,LineEdit::WidgetPosition)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_WidgetPosition_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // addWidget(QWidget*,LineEdit::WidgetPosition)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addWidget", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::LineEdit::WidgetPosition cppArg1{LineEdit::LeftSide};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addWidget(QWidget*,LineEdit::WidgetPosition)
            cppSelf->addWidget(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_clearTextFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearTextFormat()
        cppSelf->clearTextFormat();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_createContextMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // createContextMenu()
        QMenu * cppResult = static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::createContextMenu_protected();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_editAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::editAction(LineEdit::EditAction)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_EditAction_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // editAction(LineEdit::EditAction)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "editAction", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        ::LineEdit::EditAction cppArg0{LineEdit::Undo};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // editAction(LineEdit::EditAction)const
            QAction * cppResult = const_cast<const LineEditWrapper *>(cppSelf)->editAction(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::event_protected(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusInEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusInEvent(QFocusEvent*)
            static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::focusInEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_leftMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // leftMargin()const
        int cppResult = const_cast<const LineEditWrapper *>(cppSelf)->leftMargin();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_minHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minHeight()const
        int cppResult = const_cast<const LineEditWrapper *>(cppSelf)->minHeight();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseDoubleClickEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseDoubleClickEvent(QMouseEvent*)
            static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::mouseDoubleClickEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePressEvent(QMouseEvent*)
            static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::mousePressEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseReleaseEvent(QMouseEvent*)
            static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::mouseReleaseEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_removeWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::removeWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // removeWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeWidget", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeWidget(QWidget*)
            cppSelf->removeWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            static_cast<LineEditWrapper *>(cppSelf)->LineEditWrapper::resizeEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_setLeftMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::setLeftMargin(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLeftMargin(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLeftMargin", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLeftMargin(int)
            cppSelf->setLeftMargin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_setMinHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::setMinHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMinHeight", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinHeight(int)
            cppSelf->setMinHeight(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_setTextFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::setTextFormat(QList<QTextLayout::FormatRange>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QTextLayout_FormatRange_IDX], (pyArg)))) {
        overloadId = 0; // setTextFormat(QList<QTextLayout::FormatRange>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTextFormat", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        ::QList<QTextLayout::FormatRange> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTextFormat(QList<QTextLayout::FormatRange>)
            cppSelf->setTextFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_setWidgetSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LineEdit::setWidgetSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWidgetSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWidgetSpacing", errInfo, SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWidgetSpacing(int)
            cppSelf->setWidgetSpacing(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const LineEditWrapper *>(cppSelf)->::LineEdit::sizeHint()
            : const_cast<const LineEditWrapper *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LineEditFunc_updateTextMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateTextMargins()
        cppSelf->updateTextMargins();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LineEditFunc_widgetSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LineEditWrapper *>(reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // widgetSpacing()const
        int cppResult = const_cast<const LineEditWrapper *>(cppSelf)->widgetSpacing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_LineEdit_PropertyStrings[] = {
    "fixedheight:height:setFixedHeight",
    "fixedsize:size:setFixedSize",
    "fixedwidth:width:setFixedWidth",
    "leftMargin::",
    "minHeight::",
    nullptr // Sentinel
};

static const char *Sbk_LineEdit_EnumFlagInfo[] = {
    "EditAction:IntEnum",
    "WidgetPosition:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_LineEdit_methods[] = {
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_addWidget), METH_VARARGS, nullptr},
    {"clearTextFormat", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_clearTextFormat), METH_NOARGS, nullptr},
    {"createContextMenu", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_createContextMenu), METH_NOARGS, nullptr},
    {"editAction", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_editAction), METH_O, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_event), METH_O, nullptr},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_focusInEvent), METH_O, nullptr},
    {"leftMargin", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_leftMargin), METH_NOARGS, nullptr},
    {"minHeight", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_minHeight), METH_NOARGS, nullptr},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_mouseDoubleClickEvent), METH_O, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_mousePressEvent), METH_O, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_mouseReleaseEvent), METH_O, nullptr},
    {"removeWidget", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_removeWidget), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_resizeEvent), METH_O, nullptr},
    {"setLeftMargin", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_setLeftMargin), METH_O, nullptr},
    {"setMinHeight", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_setMinHeight), METH_O, nullptr},
    {"setTextFormat", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_setTextFormat), METH_O, nullptr},
    {"setWidgetSpacing", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_setWidgetSpacing), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_sizeHint), METH_NOARGS, nullptr},
    {"updateTextMargins", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_updateTextMargins), METH_NOARGS, nullptr},
    {"widgetSpacing", reinterpret_cast<PyCFunction>(Sbk_LineEditFunc_widgetSpacing), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_LineEdit_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::LineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<LineEditWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_LineEdit_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_LineEdit_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_LineEditSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::LineEdit *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_IDX]))
        return static_cast< ::QLineEdit *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_LineEdit_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_LineEdit_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LineEdit_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LineEdit_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LineEdit_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LineEdit_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_LineEdit_spec = {
    "1:PyFalkon.LineEdit",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_LineEdit_slots
};

} //extern "C"

static void *Sbk_LineEdit_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::LineEdit *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::LineEdit *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::LineEdit *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_LineEdit_WidgetPosition(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::LineEdit::WidgetPosition>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::LineEdit::WidgetPosition *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_LineEdit_WidgetPosition_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_WidgetPosition_IDX])))
        return Enum_PythonToCpp_LineEdit_WidgetPosition;
    return {};
}

static PyObject *LineEdit_WidgetPosition_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::LineEdit::WidgetPosition>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::LineEdit::WidgetPosition *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_LineEdit_EditAction(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::LineEdit::EditAction>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::LineEdit::EditAction *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_LineEdit_EditAction_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_EditAction_IDX])))
        return Enum_PythonToCpp_LineEdit_EditAction;
    return {};
}

static PyObject *LineEdit_EditAction_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::LineEdit::EditAction>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::LineEdit::EditAction *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LineEdit_PythonToCpp_LineEdit_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_LineEdit_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LineEdit_PythonToCpp_LineEdit_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_LineEdit_TypeF()))
        return LineEdit_PythonToCpp_LineEdit_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LineEdit_PTR_CppToPython_LineEdit(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::LineEdit *>(const_cast<void *>(cppIn)), Sbk_LineEdit_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *LineEdit_SignatureStrings[] = {
    "PyFalkon.LineEdit(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,fixedsize:QSize=None,leftMargin:int=None,fixedwidth:int=None,fixedheight:int=None,minHeight:int=None)",
    "PyFalkon.LineEdit.addWidget(self,widget:PySide6.QtWidgets.QWidget,position:PyFalkon.LineEdit.WidgetPosition)",
    "PyFalkon.LineEdit.clearTextFormat(self)",
    "PyFalkon.LineEdit.createContextMenu(self)->PySide6.QtWidgets.QMenu",
    "PyFalkon.LineEdit.editAction(self,action:PyFalkon.LineEdit.EditAction)->PySide6.QtGui.QAction",
    "PyFalkon.LineEdit.event(self,event:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.LineEdit.focusInEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "PyFalkon.LineEdit.leftMargin(self)->int",
    "PyFalkon.LineEdit.minHeight(self)->int",
    "PyFalkon.LineEdit.mouseDoubleClickEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.LineEdit.mousePressEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.LineEdit.mouseReleaseEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.LineEdit.removeWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "PyFalkon.LineEdit.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "PyFalkon.LineEdit.setLeftMargin(self,margin:int)",
    "PyFalkon.LineEdit.setMinHeight(self,height:int)",
    "PyFalkon.LineEdit.setTextFormat(self,format:QList[PySide6.QtGui.QTextLayout.FormatRange])",
    "PyFalkon.LineEdit.setWidgetSpacing(self,spacing:int)",
    "PyFalkon.LineEdit.sizeHint(self)->PySide6.QtCore.QSize",
    "PyFalkon.LineEdit.updateTextMargins(self)",
    "PyFalkon.LineEdit.widgetSpacing(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t LineEdit_SignatureByteSize = 432;
static constexpr uint8_t LineEdit_SignatureBytes[432] = {
    0x78, 0xda, 0xad, 0x94, 0xc1, 0x6e, 0xdb, 0x30, 0x0c, 0x86, 0xef, 0x7b, 0x92, 0xae, 0xf0, 0x7c,
    0xdc, 0xc1, 0x40, 0x0b, 0x0c, 0x59, 0xb2, 0x16, 0x4b, 0x36, 0x3b, 0x19, 0xb0, 0xc3, 0xb0, 0x83,
    0x6a, 0xd1, 0x0e, 0x51, 0x45, 0x32, 0x24, 0xba, 0xa9, 0xf7, 0xf4, 0x93, 0xcc, 0x2c, 0x69, 0x12,
    0x09, 0xc1, 0x8a, 0x5e, 0x04, 0x99, 0xfe, 0xf5, 0xe9, 0x17, 0x45, 0xaa, 0x1c, 0x66, 0x42, 0x3d,
    0x1a, 0x9d, 0xcf, 0x51, 0xc3, 0x54, 0x22, 0x5d, 0x39, 0x50, 0x4d, 0xd6, 0x09, 0x0b, 0x9a, 0x8a,
    0x72, 0x58, 0xa1, 0x84, 0x8f, 0x79, 0x45, 0x3f, 0x51, 0xb6, 0x40, 0x2e, 0xaf, 0x78, 0x72, 0xa3,
    0x7b, 0xa5, 0x3a, 0xb2, 0xd9, 0x75, 0xf1, 0x15, 0x86, 0xad, 0xb1, 0xf2, 0xbb, 0x56, 0xc3, 0xcd,
    0x37, 0xa3, 0x21, 0x6b, 0xf0, 0x19, 0xa4, 0xc3, 0x3f, 0x50, 0x54, 0x2b, 0x3f, 0x72, 0x50, 0x41,
    0x43, 0x0b, 0x61, 0x5b, 0xd4, 0x05, 0x6a, 0x7a, 0x21, 0xdc, 0xa2, 0xa4, 0xf5, 0x49, 0x6c, 0x0d,
    0xd8, 0xae, 0xe9, 0x10, 0xdc, 0xa0, 0xbe, 0x3b, 0x0e, 0xbd, 0x7f, 0x57, 0x9e, 0x1a, 0xcf, 0x85,
    0x94, 0x6c, 0x8e, 0x8f, 0xb0, 0x1d, 0xe7, 0xe9, 0x23, 0x64, 0x9d, 0x71, 0x48, 0x68, 0x74, 0x71,
    0x8e, 0x62, 0x45, 0xb9, 0x13, 0xc4, 0x36, 0xab, 0x15, 0x08, 0xfb, 0x03, 0x9e, 0x69, 0x66, 0xec,
    0x46, 0xf0, 0x96, 0x51, 0x9d, 0x05, 0x41, 0x30, 0x31, 0x9a, 0xbc, 0x76, 0x01, 0xba, 0x67, 0xe5,
    0x87, 0xdb, 0x88, 0xaf, 0xf0, 0x3b, 0x82, 0x00, 0x3f, 0x7c, 0xaa, 0x83, 0x11, 0x3e, 0x98, 0xa8,
    0x13, 0xae, 0xa7, 0x7b, 0xe1, 0x11, 0xff, 0x4b, 0x8f, 0x79, 0xc5, 0xf1, 0x18, 0xfd, 0xc9, 0x5f,
    0x34, 0x83, 0xc7, 0xe9, 0x8b, 0x84, 0x4d, 0x8c, 0x85, 0xbc, 0x9a, 0x86, 0xa8, 0x07, 0x3e, 0x18,
    0xa3, 0x22, 0xeb, 0x1b, 0x53, 0xf7, 0xee, 0x5e, 0x4f, 0xd3, 0x98, 0x71, 0xff, 0x59, 0x90, 0x31,
    0x2a, 0x02, 0x39, 0x54, 0xc7, 0xbf, 0xf4, 0xf8, 0x8b, 0x8e, 0xe8, 0xf6, 0x85, 0x70, 0x41, 0x66,
    0x7a, 0x07, 0x9f, 0x4d, 0xff, 0xa0, 0x60, 0xa2, 0xb0, 0x7e, 0xbc, 0x64, 0x6e, 0x11, 0xf4, 0x49,
    0x73, 0x23, 0xad, 0xb4, 0xe0, 0xdc, 0x1b, 0x70, 0x96, 0xe0, 0x0b, 0x67, 0x27, 0x7a, 0x35, 0xc9,
    0xc2, 0xc6, 0x3c, 0xc1, 0xff, 0x14, 0x7b, 0x9c, 0x12, 0x9a, 0xf4, 0x92, 0x93, 0xe5, 0x41, 0x15,
    0x83, 0x38, 0xa0, 0xf9, 0xf1, 0xe5, 0x65, 0x9b, 0x7d, 0x9b, 0x27, 0x16, 0x2c, 0x8e, 0x6e, 0x31,
    0x3b, 0x74, 0x7b, 0x42, 0x7f, 0xd2, 0x66, 0x59, 0x33, 0xce, 0x8b, 0x6a, 0x8e, 0x8e, 0x7e, 0x9d,
    0xd8, 0x0d, 0xda, 0xb9, 0x18, 0x4c, 0x4f, 0x39, 0x2f, 0x59, 0x0a, 0xdd, 0xc2, 0xef, 0x04, 0x99,
    0x93, 0xb3, 0xea, 0x44, 0x8d, 0xba, 0x65, 0xb8, 0xe3, 0x8f, 0xa4, 0x1d, 0x9f, 0x8c, 0x3b, 0xd4,
    0x74, 0xde, 0xc6, 0xdc, 0x2d, 0xe1, 0xc5, 0x8b, 0x2c, 0xeb, 0x3b, 0xe9, 0x9f, 0x81, 0x60, 0x8e,
    0x33, 0xe5, 0x92, 0x0f, 0xc6, 0xf6, 0xcc, 0xd2, 0xae, 0xcc, 0xff, 0x02, 0x7c, 0xf4, 0x12, 0x6d
};
#endif

PyTypeObject *init_LineEdit(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_LineEdit_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_LineEdit_IDX].type;

    Shiboken::AutoDecRef Sbk_LineEdit_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_IDX]))));

    _Sbk_LineEdit_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "LineEdit",
        "LineEdit*",
        &Sbk_LineEdit_spec,
        &Shiboken::callCppDestructor< LineEdit >,
        Sbk_LineEdit_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_LineEdit_TypeF(); // references _Sbk_LineEdit_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, LineEdit_SignatureStrings);
#else
    InitSignatureBytes(pyType, LineEdit_SignatureBytes, LineEdit_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_LineEdit_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_LineEdit_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        LineEdit_PythonToCpp_LineEdit_PTR,
        is_LineEdit_PythonToCpp_LineEdit_PTR_Convertible,
        LineEdit_PTR_CppToPython_LineEdit);

    Shiboken::Conversions::registerConverterName(converter, "LineEdit");
    Shiboken::Conversions::registerConverterName(converter, "LineEdit*");
    Shiboken::Conversions::registerConverterName(converter, "LineEdit&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LineEdit).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(LineEditWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_LineEdit_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_LineEdit_TypeF(), &Sbk_LineEditSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_LineEdit_TypeF(), &Sbk_LineEdit_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_LineEdit_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'WidgetPosition'.
    const char *WidgetPosition_Initializer[] = {
        "LeftSide",
        "RightSide",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t WidgetPosition_InitializerValues[] = {
        uint8_t(LineEdit::WidgetPosition::LeftSide), //  0x00  0
        uint8_t(LineEdit::WidgetPosition::RightSide) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_LineEdit_TypeF(),
        "1:PyFalkon.LineEdit.WidgetPosition",
        WidgetPosition_Initializer, WidgetPosition_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_LineEdit_WidgetPosition_IDX].type = EType;
    // Register converter for enum 'LineEdit::WidgetPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            LineEdit_WidgetPosition_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_LineEdit_WidgetPosition,
            is_Enum_PythonToCpp_LineEdit_WidgetPosition_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "LineEdit::WidgetPosition");
        Shiboken::Conversions::registerConverterAlias(converter, "WidgetPosition");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'WidgetPosition' enum.

    // Initialization of enum 'EditAction'.
    const char *EditAction_Initializer[] = {
        "Undo",
        "Redo",
        "Cut",
        "Copy",
        "Paste",
        "PasteAndGo",
        "Delete",
        "ClearAll",
        "SelectAll",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t EditAction_InitializerValues[] = {
        uint8_t(LineEdit::EditAction::Undo),       //  0x00  0
        uint8_t(LineEdit::EditAction::Redo),       //  0x01  1
        uint8_t(LineEdit::EditAction::Cut),        //  0x02  2
        uint8_t(LineEdit::EditAction::Copy),       //  0x03  3
        uint8_t(LineEdit::EditAction::Paste),      //  0x04  4
        uint8_t(LineEdit::EditAction::PasteAndGo), //  0x05  5
        uint8_t(LineEdit::EditAction::Delete),     //  0x06  6
        uint8_t(LineEdit::EditAction::ClearAll),   //  0x07  7
        uint8_t(LineEdit::EditAction::SelectAll)   //  0x08  8
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_LineEdit_TypeF(),
        "1:PyFalkon.LineEdit.EditAction",
        EditAction_Initializer, EditAction_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_LineEdit_EditAction_IDX].type = EType;
    // Register converter for enum 'LineEdit::EditAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            LineEdit_EditAction_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_LineEdit_EditAction,
            is_Enum_PythonToCpp_LineEdit_EditAction_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "LineEdit::EditAction");
        Shiboken::Conversions::registerConverterAlias(converter, "EditAction");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'EditAction' enum.

    LineEditWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::LineEdit::staticMetaObject, sizeof(LineEditWrapper));

    return pyType;
}
