// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "IconProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::IconPropertyPrivate
{
public:
    std::optional<AlignmentProperty> alignment;
    std::optional<qreal> width;
    std::optional<qreal> height;
    std::optional<QString> name;
    std::optional<QUrl> source;
    std::optional<Union::Color> color;
};

IconProperty::IconProperty()
    : d(std::make_unique<IconPropertyPrivate>())
{
}

IconProperty::IconProperty(const IconProperty &other)
    : d(std::make_unique<IconPropertyPrivate>())
{
    d->alignment = other.d->alignment;
    d->width = other.d->width;
    d->height = other.d->height;
    d->name = other.d->name;
    d->source = other.d->source;
    d->color = other.d->color;
}

IconProperty::IconProperty(IconProperty &&other)
    : d(std::move(other.d))
{
}

IconProperty::~IconProperty() = default;

IconProperty &IconProperty::operator=(const IconProperty &other)
{
    if (this != &other) {
        d->alignment = other.d->alignment;
        d->width = other.d->width;
        d->height = other.d->height;
        d->name = other.d->name;
        d->source = other.d->source;
        d->color = other.d->color;
    }
    return *this;
}

IconProperty &IconProperty::operator=(IconProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<AlignmentProperty> IconProperty::alignment() const
{
    return d->alignment;
}

AlignmentProperty IconProperty::alignment_or_new() const
{
    return d->alignment.value_or(AlignmentProperty{});
}

void IconProperty::setAlignment(const std::optional<AlignmentProperty> &newValue)
{
    if (newValue == d->alignment) {
        return;
    }

    d->alignment = newValue;
}
std::optional<qreal> IconProperty::width() const
{
    return d->width;
}

void IconProperty::setWidth(const std::optional<qreal> &newValue)
{
    if (newValue == d->width) {
        return;
    }

    d->width = newValue;
}
std::optional<qreal> IconProperty::height() const
{
    return d->height;
}

void IconProperty::setHeight(const std::optional<qreal> &newValue)
{
    if (newValue == d->height) {
        return;
    }

    d->height = newValue;
}
std::optional<QString> IconProperty::name() const
{
    return d->name;
}

void IconProperty::setName(const std::optional<QString> &newValue)
{
    if (newValue == d->name) {
        return;
    }

    d->name = newValue;
}
std::optional<QUrl> IconProperty::source() const
{
    return d->source;
}

void IconProperty::setSource(const std::optional<QUrl> &newValue)
{
    if (newValue == d->source) {
        return;
    }

    d->source = newValue;
}
std::optional<Union::Color> IconProperty::color() const
{
    return d->color;
}

void IconProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

bool IconProperty::hasAnyValue() const
{
    if (d->alignment.has_value() && d->alignment->hasAnyValue()) {
        return true;
    }
    if (d->width.has_value()) {
        return true;
    }
    if (d->height.has_value()) {
        return true;
    }
    if (d->name.has_value()) {
        return true;
    }
    if (d->source.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    return false;
}

void IconProperty::resolveProperties(const IconProperty &source, IconProperty &destination)
{
    if (source.d->alignment.has_value()) {
        AlignmentProperty property;
        if (destination.d->alignment.has_value()) {
            property = destination.d->alignment.value();
        }
        AlignmentProperty::resolveProperties(source.d->alignment.value(), property);
        if (property.hasAnyValue()) {
            destination.d->alignment = property;
        }
    }
    if (!destination.d->width.has_value()) {
        destination.d->width = source.d->width;
    }
    if (!destination.d->height.has_value()) {
        destination.d->height = source.d->height;
    }
    if (!destination.d->name.has_value()) {
        destination.d->name = source.d->name;
    }
    if (!destination.d->source.has_value()) {
        destination.d->source = source.d->source;
    }
    if (!destination.d->color.has_value()) {
        destination.d->color = source.d->color;
    }
}

IconProperty IconProperty::empty()
{
    IconProperty result;
    result.d->alignment = emptyValue<AlignmentProperty>();
    result.d->width = emptyValue<qreal>();
    result.d->height = emptyValue<qreal>();
    result.d->name = emptyValue<QString>();
    result.d->source = emptyValue<QUrl>();
    result.d->color = emptyValue<Union::Color>();
    return result;
}

bool Union::Properties::operator==(const IconProperty &left, const IconProperty &right)
{
    if (left.alignment() != right.alignment()) {
        return false;
    }
    if (left.width() != right.width()) {
        return false;
    }
    if (left.height() != right.height()) {
        return false;
    }
    if (left.name() != right.name()) {
        return false;
    }
    if (left.source() != right.source()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::IconProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "IconProperty(" //
                    << "alignment: " << type.alignment() //
                    << ", width: " << type.width() //
                    << ", height: " << type.height() //
                    << ", name: " << type.name() //
                    << ", source: " << type.source() //
                    << ", color: " << type.color() //
                    << ")";
    return debug;
}