
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sidebarmanager_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SideBarManager_Type = nullptr;
static PyTypeObject *Sbk_SideBarManager_TypeF(void)
{
    return _Sbk_SideBarManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SideBarManagerWrapper::pysideInitQtMetaTypes()
{
}

void SideBarManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SideBarManagerWrapper::SideBarManagerWrapper(::BrowserWindow * parent) : SideBarManager(parent)
{
}

void SideBarManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SideBarManager", funcName, gil, pyOverride, event);
}

void SideBarManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SideBarManager", funcName, gil, pyOverride, signal);
}

void SideBarManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SideBarManager", funcName, gil, pyOverride, event);
}

void SideBarManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SideBarManager", funcName, gil, pyOverride, signal);
}

bool SideBarManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SideBarManager", funcName, gil, pyOverride, event);
}

bool SideBarManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SideBarManager", funcName, gil, pyOverride, watched, event);
}

void SideBarManagerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SideBarManager", funcName, gil, pyOverride, event);
}

const QMetaObject *SideBarManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SideBarManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SideBarManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SideBarManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SideBarManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SideBarManagerWrapper *>(this));
    }
    return SideBarManager::qt_metacast(_clname);
}

SideBarManagerWrapper::~SideBarManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SideBarManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SideBarManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SideBarManager >()))
        return -1;

    SideBarManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "SideBarManager", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SideBarManager::SideBarManager(BrowserWindow*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SideBarManager(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SideBarManager(BrowserWindow*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SideBarManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SideBarManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SideBarManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SideBarManagerFunc_activeSideBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarManagerWrapper *>(reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeSideBar()const
        QString cppResult = const_cast<const SideBarManagerWrapper *>(cppSelf)->activeSideBar();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SideBarManagerFunc_addSidebar(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addSidebar", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static SideBarManager::addSidebar(QString,SideBarInterface*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addSidebar(QString,SideBarInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addSidebar", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::SideBarInterface *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addSidebar(QString,SideBarInterface*)
            ::SideBarManager::addSidebar(cppArg0, cppArg1);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArgs[1]);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SideBarManagerFunc_closeSideBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarManagerWrapper *>(reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeSideBar()
        cppSelf->closeSideBar();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SideBarManagerFunc_createMenu(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarManagerWrapper *>(reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "createMenu", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    if (PyArg_ParseTuple(args, "|OO:createMenu", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SideBarManager::createMenu(QMenu*,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createMenu(QMenu*,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // createMenu(QMenu*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createMenu", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"mainMenu", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "createMenu", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createMenu(QMenu*,bool)
            cppSelf->createMenu(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SideBarManagerFunc_removeSidebar(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static SideBarManager::removeSidebar(SideBarInterface*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), (pyArg)))) {
        overloadId = 0; // removeSidebar(SideBarInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeSidebar", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SideBarInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeSidebar(SideBarInterface*)
            ::SideBarManager::removeSidebar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SideBarManagerFunc_showSideBar(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarManagerWrapper *>(reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showSideBar", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    if (PyArg_ParseTuple(args, "|OO:showSideBar", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SideBarManager::showSideBar(QString,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // showSideBar(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // showSideBar(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showSideBar", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"toggle", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showSideBar", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showSideBar(QString,bool)
            cppSelf->showSideBar(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SideBarManagerFunc_sideBarRemoved(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarManagerWrapper *>(reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SideBarManager::sideBarRemoved(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // sideBarRemoved(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sideBarRemoved", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sideBarRemoved(QString)
            cppSelf->sideBarRemoved(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_SideBarManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SideBarManager_methods[] = {
    {"activeSideBar", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_activeSideBar), METH_NOARGS, nullptr},
    {"addSidebar", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_addSidebar), METH_VARARGS|METH_STATIC, nullptr},
    {"closeSideBar", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_closeSideBar), METH_NOARGS, nullptr},
    {"createMenu", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_createMenu), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"removeSidebar", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_removeSidebar), METH_O|METH_STATIC, nullptr},
    {"showSideBar", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_showSideBar), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"sideBarRemoved", reinterpret_cast<PyCFunction>(Sbk_SideBarManagerFunc_sideBarRemoved), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SideBarManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SideBarManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SideBarManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SideBarManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SideBarManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SideBarManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SideBarManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SideBarManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SideBarManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SideBarManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SideBarManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SideBarManager_spec = {
    "1:PyFalkon.SideBarManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SideBarManager_slots
};

} //extern "C"

static void *Sbk_SideBarManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SideBarManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SideBarManager_PythonToCpp_SideBarManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SideBarManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SideBarManager_PythonToCpp_SideBarManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SideBarManager_TypeF()))
        return SideBarManager_PythonToCpp_SideBarManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SideBarManager_PTR_CppToPython_SideBarManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SideBarManager *>(const_cast<void *>(cppIn)), Sbk_SideBarManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SideBarManager_SignatureStrings[] = {
    "PyFalkon.SideBarManager(self,parent:PyFalkon.BrowserWindow)",
    "PyFalkon.SideBarManager.activeSideBar(self)->QString",
    "PyFalkon.SideBarManager.addSidebar(id:QString,interface:PyFalkon.SideBarInterface)",
    "PyFalkon.SideBarManager.closeSideBar(self)",
    "PyFalkon.SideBarManager.createMenu(self,menu:PySide6.QtWidgets.QMenu,mainMenu:bool=true)",
    "PyFalkon.SideBarManager.removeSidebar(interface:PyFalkon.SideBarInterface)",
    "PyFalkon.SideBarManager.showSideBar(self,id:QString,toggle:bool=true)",
    "PyFalkon.SideBarManager.sideBarRemoved(self,id:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t SideBarManager_SignatureByteSize = 205;
static constexpr uint8_t SideBarManager_SignatureBytes[205] = {
    0x78, 0xda, 0xa5, 0x90, 0x3f, 0x0b, 0xc2, 0x40, 0x0c, 0xc5, 0x77, 0x3f, 0x89, 0x85, 0xda, 0xd1,
    0xa1, 0xa0, 0x83, 0x83, 0xe0, 0x20, 0xb4, 0x76, 0xe8, 0x9c, 0xf6, 0xe2, 0x79, 0x78, 0xbd, 0x48,
    0x2e, 0xb5, 0xf8, 0xed, 0xed, 0x1f, 0x0b, 0x2a, 0x56, 0x04, 0xb7, 0x5c, 0xee, 0xbd, 0xe4, 0xf7,
    0x92, 0xdc, 0xb6, 0x60, 0xcf, 0xe4, 0xa2, 0xcc, 0x28, 0xdc, 0x00, 0xef, 0xc1, 0x81, 0x46, 0x9e,
    0x7b, 0xb4, 0xc7, 0xf0, 0x02, 0x8c, 0x4e, 0xe2, 0x64, 0xd4, 0x6c, 0x98, 0x1a, 0x8f, 0x9c, 0x1b,
    0xa7, 0xa8, 0x09, 0x66, 0xc9, 0x67, 0x6f, 0x04, 0xa5, 0x98, 0x2b, 0x3e, 0x9a, 0xfd, 0xa4, 0x60,
    0xb1, 0x4e, 0x33, 0x61, 0xe3, 0xf4, 0xb4, 0x49, 0xa9, 0xae, 0x53, 0xb4, 0x0e, 0xa3, 0xe2, 0x87,
    0x3a, 0x34, 0x4e, 0x90, 0x8f, 0x50, 0x62, 0xfc, 0xee, 0xdb, 0x8d, 0x3f, 0xd3, 0x1c, 0xa5, 0x25,
    0xff, 0x8a, 0x31, 0x2d, 0x65, 0x04, 0xc1, 0x3d, 0xba, 0x7a, 0x48, 0x5e, 0xb5, 0x55, 0xbb, 0xb2,
    0x53, 0x2d, 0xa3, 0x54, 0x72, 0xa3, 0x34, 0x8a, 0x8f, 0xd2, 0x4e, 0x11, 0x56, 0x60, 0x5c, 0x57,
    0xc4, 0x05, 0x91, 0x5d, 0x09, 0xd7, 0x5f, 0x18, 0x18, 0x2b, 0x1a, 0x6e, 0xd1, 0x27, 0xfb, 0x27,
    0x8e, 0x3f, 0x51, 0xf3, 0x9c, 0x26, 0x7c, 0xba, 0x93, 0x90, 0xd6, 0x16, 0x7f, 0x01, 0xf2, 0xc3,
    0xf3, 0xd0, 0x73, 0xa9, 0xf7, 0x41, 0xc1, 0xec, 0x0e, 0x4c, 0xb9, 0xc2, 0x19
};
#endif

PyTypeObject *init_SideBarManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX].type;

    Shiboken::AutoDecRef Sbk_SideBarManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SideBarManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SideBarManager",
        "SideBarManager*",
        &Sbk_SideBarManager_spec,
        &Shiboken::callCppDestructor< SideBarManager >,
        Sbk_SideBarManager_Type_bases.object(),
        0);
    auto *pyType = Sbk_SideBarManager_TypeF(); // references _Sbk_SideBarManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SideBarManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, SideBarManager_SignatureBytes, SideBarManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SideBarManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SideBarManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SideBarManager_PythonToCpp_SideBarManager_PTR,
        is_SideBarManager_PythonToCpp_SideBarManager_PTR_Convertible,
        SideBarManager_PTR_CppToPython_SideBarManager);

    Shiboken::Conversions::registerConverterName(converter, "SideBarManager");
    Shiboken::Conversions::registerConverterName(converter, "SideBarManager*");
    Shiboken::Conversions::registerConverterName(converter, "SideBarManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SideBarManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SideBarManagerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SideBarManager_TypeF(), &Sbk_SideBarManager_typeDiscovery);

    SideBarManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SideBarManager::staticMetaObject, sizeof(SideBarManagerWrapper));

    return pyType;
}
