struct debug_color_common {
struct Samplers {
 bool set_slot(int index, int value) {
  switch (index) {
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aColor = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aColor", name) == 0) { aColor = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aColor", name) == 0) { return aColor != NULL_ATTRIB ? aColor : -1; }
  return -1;
 }
} attrib_locations;
mat4_scalar uTransform;
void bind_textures() {
}
};
struct debug_color_vert : VertexShaderImpl, debug_color_common {
private:
typedef debug_color_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
vec4 vColor;
vec4 aColor;
ALWAYS_INLINE void main(void) {
 vColor = make_vec4(((aColor).sel(R,G,B))*((aColor).w), (aColor).w);
 vec4 pos = make_vec4(aPosition, 0.f, 1.f);
 (pos).lsel(X,Y) = floor(((pos).sel(X,Y))+(0.5f));
 gl_Position = (uTransform)*(pos);
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_attrib(self->aColor, attribs[self->attrib_locations.aColor], start, instance, count);
}
public:
struct InterpOutputs {
vec4_scalar vColor;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vColor = get_nth(vColor, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
debug_color_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct debug_color_frag : FragmentShaderImpl, debug_color_vert {
private:
typedef debug_color_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
vec4 vColor;
ALWAYS_INLINE void main(void) {
 oFragColor = vColor;
}
typedef debug_color_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec4 vColor;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vColor = init_interp(init->vColor, step->vColor);
  self->interp_step.vColor = step->vColor * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vColor = init_interp(init->vColor, step->vColor);
  self->vColor = self->interp_perspective.vColor * w;
  self->interp_step.vColor = step->vColor * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vColor += interp_step.vColor * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vColor += interp_step.vColor * chunks;
  vColor = w * interp_perspective.vColor;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
debug_color_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct debug_color_program : ProgramImpl, debug_color_frag {
int get_uniform(const char *name) const override {
 if (strcmp("uTransform", name) == 0) { return 1; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "debug_color"; }
static ProgramImpl* loader() { return new debug_color_program; }
};

